import math
from math import sqrt # non automatique
# import pylab as pl # semble fonctionner moins bien...
import matplotlib
import matplotlib.pyplot as plt
import numpy as np # pourquoi 'matplotlib.numpy' n'est il pas exigé ?
from matplotlib import patches # pourquoi exigé alors que matplotlib est chargé ?
# certains imports sont automatiques et d'autres non... c'est perturbant !

def barycentre(PA, PB, PC, PD):
    BX = 0.25 * (PA[0]+PB[0]+PC[0]+PD[0])
    BY = 0.25 * (PA[1]+PB[1]+PC[1]+PD[1])
    return (BX, BY)

def distance(PA, PB):
    distance=sqrt((PB[0]-PA[0])**2+(PB[1]-PA[1])**2)
    return distance

L = 61 # dimension des images
H = 41

centre=(0.6 * L, 0.5 * H) # centre de l'aura, volontairement un peu décalé

for nn in range(40): # limité pour test ; on crée 400 images pour le film complet
    X = np.zeros((H,L)) # abscisses des points de la grille (changent à chaque image)
    # rappel : convention spéciale pour python... suite de H lignes de longueur L
    Y = np.zeros((H,L))  # ordonnées des points de la grille
    for i in range(L):
        for j in range(H):
            X[j][i] = i
            Y[j][i] = j

    DX = np.random.randint(51, size=(H,L)) # décalages aléatoires
    DY = np.random.randint(51, size=(H,L))
    for i in range(L): # sans fluctuations aux bords
        for j in range(H):
            DX[0][i] = 0
            DX[H-1][i] = 0
            DX[j][0] = 0
            DX[j][L-1] = 0
            DY[0][i] = 0
            DY[H-1][i] = 0
            DY[j][0] = 0
            DY[j][L-1] = 0
    DX = 0.01 * DX - 0.25 # décimales et centrage
    DY = 0.01 * DY - 0.25

    XX = X + DX # coordonnées décalées
    YY = Y + DY

    fig = plt.figure()

    r0 = 0.15 * nn # rayon croissant
    r1 = r0 - L/15
    r2 = r1 - 2 * L/15

    for i in range(L-1):
        for j in range(H-1):
            QA = (XX[j,i],YY[j,i])
            QB = (XX[j+1,i],YY[j+1,i])
            QC = (XX[j+1,i+1],YY[j+1,i+1])
            QD = (XX[j,i+1],YY[j,i+1])
            ax = fig.add_subplot()
            C=np.random.choice(['black','darkgrey','grey','lightgrey','white','yellow'], 1, replace = True, p = [0.35, 0.1, 0.1, 0.1, 0.33, 0.02])
            dd = distance(barycentre(QA,QB,QC,QD),centre)
            myColor = 'green' # fond
            if dd < r0 :
                if dd > r1 :
                    myColor = C[0]
                elif dd > r2 :
                    color0=matplotlib.colors.colorConverter.to_rgb(myColor)
                    color1=matplotlib.colors.colorConverter.to_rgb('lightgrey')
                    coef=(r1 - dd)/(r1 - r2)
                    myColor = (coef*color0[0]+(1-coef)*color1[0],coef*color0[1]+(1-coef)*color1[1],coef*color0[2]+(1-coef)*color1[2])
            # polygon=patches.Polygon([QA,QB,QC,QD],color=C[0])
            polygon=patches.Polygon([QA,QB,QC,QD],edgecolor='none', facecolor=myColor)
            # évite une surépaisseur et évite un fond trop uniforme
            ax.add_patch(polygon)

    plt.axis('equal')
    plt.axis('off') # on veut juste le dessin
        
    # plt.show()
    theName = 'image' + '000'[0:3-len(str(nn))] + str(nn)
    plt.savefig(theName,dpi=300)
