import math
from math import sqrt,trunc # non automatique
# import pylab as pl # semble fonctionner moins bien...
import matplotlib
import matplotlib.pyplot as plt
import numpy as np # pourquoi 'matplotlib.numpy' n'est il pas exigé ?
from matplotlib import patches # pourquoi exigé alors que matplotlib est chargé ?
# certains imports sont automatiques et d'autres non... c'est perturbant !

def barycentre(PA, PB, PC, PD):
    BX = 0.25 * (PA[0]+PB[0]+PC[0]+PD[0])
    BY = 0.25 * (PA[1]+PB[1]+PC[1]+PD[1])
    return (BX, BY)

def distance(PA, PB):
    distance=sqrt((PB[0]-PA[0])**2+(PB[1]-PA[1])**2)
    return distance

L = 61 # taille des images
H = 41

nnmax = 40 # à limiter pour test ; on crée 400 images pour le film complet
nn1b = trunc(nnmax * 0.014) # dates de début d'apparition des zones noires (simultanées)
nn2b = trunc(nnmax * 0.05) # dates de fin d'apparition des zones noires
nn3b = nnmax - trunc(nnmax * 0.06) # dates de début de disparition des zones noires
nn4b = nnmax - trunc(nnmax * 0.014) # dates de fin de disparition des zones noires

CX = np.zeros(7) # abscisses des centres des zones (communs à toutes les images)
CY = np.zeros(7) # ordonnées des centres des zones
r0 = np.zeros(7) # rayons des zones

CX[0] = 0.6 * L # zone noire 1
CY[0] = 0.5 * H
r0[0] = 2 * L/15

CX[1] = 0.35 * L # zone noire 2
CY[1] = 0.7 * H
r0[1] = 3 * L/15

CX[2] = 0.3 * L # zone noire 3
CY[2] = 0.15 * H
r0[2] = 6 * L/15

CX[3] = 0.8 * L # zone noire 4
CY[3] = 0.1 * H
r0[3] = 2 * L/15

CX[4] = 0.8 * L # zone blanche 1
CY[4] = 0.15 * H
r0[4] = 1.5 * L/15
nn1w1 = nn2b + trunc((nn3b - nn2b) * 0.014) # dates de début d'apparition de la zone blanche
nn2w1 = nn2b + trunc((nn3b - nn2b) * 0.15) # dates de fin d'apparition de la zone blanche
nn3w1 = nn3b - trunc((nn3b - nn2b) * 0.4) # dates de début de disparition de la zone blanche
nn4w1 = nn3b - trunc((nn3b - nn2b) * 0.044) # dates de fin de disparition de la zone blanche

CX[5] = 0.3 * L # zone blanche 2
CY[5] = 0.25 * H
r0[5] = 4 * L/15
nn1w2 = nn2b + trunc((nn3b - nn2b) * 0.064)
nn2w2 = nn2b + trunc((nn3b - nn2b) * 0.4)
nn3w2 = nn3b - trunc((nn3b - nn2b) * 0.45)
nn4w2 = nn3b - trunc((nn3b - nn2b) * 0.074)

CX[6] = 0.3 * L # zone blanche 3
CY[6] = 0.6 * H
r0[6] = 2.5 * L/15
nn1w3 = nn2b + trunc((nn3b - nn2b) * 0.034)
nn2w3 = nn2b + trunc((nn3b - nn2b) * 0.25)
nn3w3 = nn3b - trunc((nn3b - nn2b) * 0.15)
nn4w3 = nn3b - trunc((nn3b - nn2b) * 0.014)

for nn in range(nnmax): # à limiter pour test ; on crée 400 images pour le film complet
    X = np.zeros((H,L)) # abscisses des points de la grille (changés à chaque image)
    # rappel : convention spéciale pour python... suite de H lignes de longueur L
    Y = np.zeros((H,L))  # ordonnées des points de la grille
    for i in range(L):
        for j in range(H):
            X[j][i] = i
            Y[j][i] = j

    DX = np.random.randint(51, size=(H,L)) # décalages aléatoires
    DY = np.random.randint(51, size=(H,L))
    for i in range(L): # sans fluctuations aux bords
        for j in range(H):
            DX[0][i] = 0
            DX[H-1][i] = 0
            DX[j][0] = 0
            DX[j][L-1] = 0
            DY[0][i] = 0
            DY[H-1][i] = 0
            DY[j][0] = 0
            DY[j][L-1] = 0
    DX = 0.01 * DX - 0.25 # décimales et centrage
    DY = 0.01 * DY - 0.25

    XX = X + DX # coordonnées décalées
    YY = Y + DY

    fig = plt.figure()

    for i in range(L-1):
        for j in range(H-1):
            QA = (XX[j,i],YY[j,i])
            QB = (XX[j+1,i],YY[j+1,i])
            QC = (XX[j+1,i+1],YY[j+1,i+1])
            QD = (XX[j,i+1],YY[j,i+1])
            ax = fig.add_subplot()
            dd1 = distance(barycentre(QA,QB,QC,QD),(CX[0],CY[0]))/r0[0]
            dd2 = distance(barycentre(QA,QB,QC,QD),(CX[1],CY[1]))/r0[1]
            dd3 = distance(barycentre(QA,QB,QC,QD),(CX[2],CY[2]))/r0[2]
            dd4 = distance(barycentre(QA,QB,QC,QD),(CX[3],CY[3]))/r0[3]
            dd = min(dd1,dd2,dd3,dd4)
            myColor = 'green' # fond
            theColor = 'black'
            if dd < 1 :
                color0=matplotlib.colors.colorConverter.to_rgb(myColor)
                color1=matplotlib.colors.colorConverter.to_rgb(theColor)
                coef = min(max(0,(nn - nn3b) / (nn4b - nn3b)),1) + min(max(0,(nn2b - nn) / (nn2b - nn1b)),1)
                myColor = (coef*color0[0]+(1-coef)*color1[0],coef*color0[1]+(1-coef)*color1[1],coef*color0[2]+(1-coef)*color1[2])
            theColor = 'white'
            dd = distance(barycentre(QA,QB,QC,QD),(CX[4],CY[4]))/r0[4]
            if dd < 1 :
                color0=matplotlib.colors.colorConverter.to_rgb(myColor)
                color1=matplotlib.colors.colorConverter.to_rgb(theColor)
                coef = min(max(0,(nn - nn3w1) / (nn4w1 - nn3w1)),1) + min(max(0,(nn2w1 - nn) / (nn2w1 - nn1w1)),1)
                myColor = (coef*color0[0]+(1-coef)*color1[0],coef*color0[1]+(1-coef)*color1[1],coef*color0[2]+(1-coef)*color1[2])            
            dd = distance(barycentre(QA,QB,QC,QD),(CX[5],CY[5]))/r0[5]
            if dd < 1 :
                color0=matplotlib.colors.colorConverter.to_rgb(myColor)
                color1=matplotlib.colors.colorConverter.to_rgb(theColor)
                coef = min(max(0,(nn - nn3w2) / (nn4w2 - nn3w2)),1) + min(max(0,(nn2w2 - nn) / (nn2w2 - nn1w2)),1)
                myColor = (coef*color0[0]+(1-coef)*color1[0],coef*color0[1]+(1-coef)*color1[1],coef*color0[2]+(1-coef)*color1[2])            
            dd = distance(barycentre(QA,QB,QC,QD),(CX[6],CY[6]))/r0[6]
            if dd < 1 :
                color0=matplotlib.colors.colorConverter.to_rgb(myColor)
                color1=matplotlib.colors.colorConverter.to_rgb(theColor)
                coef = min(max(0,(nn - nn3w3) / (nn4w3 - nn3w3)),1) + min(max(0,(nn2w3 - nn) / (nn2w3 - nn1w3)),1)
                myColor = (coef*color0[0]+(1-coef)*color1[0],coef*color0[1]+(1-coef)*color1[1],coef*color0[2]+(1-coef)*color1[2])            
            polygon=patches.Polygon([QA,QB,QC,QD],edgecolor='none', facecolor=myColor)
            ax.add_patch(polygon)

    plt.axis('equal')
    plt.axis('off') # on veut juste le dessin
        
    # plt.show()
    theName = 'image' + '000'[0:3-len(str(nn))] + str(nn)
    plt.savefig(theName,dpi=300)
