// circuit RLC sortie R ; influence de R0  ==================================
R0=50.;
L=70e-3;
r=10;
C=0.5e-6;
wl=[2:0.005:5];  // abscisse pour l'échelle log de w
w=(10).^wl;
H=R0./sqrt((R0+r)^2+(L.*w-1./(C.*w)).^2);
L2=4*L;
H2=R0./sqrt((R0+r)^2+(L2.*w-1./(C.*w)).^2);
L3=5*L2;
H3=R0./sqrt((R0+r)^2+(L3.*w-1./(C.*w)).^2);
L4=0.2*L;
H4=R0./sqrt((R0+r)^2+(L4.*w-1./(C.*w)).^2);

scf(1); // pour dessiner dans la fenêtre n°1
clf(); // on efface au cas où...

g1=get("current_axes"); // get the handle on axes model to view and edit the fields

xTitreLatex="$\textit{\mathbf{\omega}} \; \; \mathbf{[rad.s^{-1}]} \\_{-----} \\retour $";
//il faut un retour à la ligne forcé sinon un bug tronque le cadrage du titre

yTitreLatex="$\textit{\mathbf{H}}$"

g1.font_size = 2.8;
g1.y_label.text=yTitreLatex;
g1.y_label.font_size = 4;

g1.x_label.text=xTitreLatex;
g1.x_label.font_size = 4;

//tracer l'arrière en premier

plot2d("ll",w,H4,rect=[1.e2,1.e-3,1.e5,2],style=[22],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

H4TitreLatex="$\mathbf{\textit{L}=14} \: \mathbf{mH}$";
xstring(2.1e4,2e-1,H4TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=22;

plot2d("ll",w,H3,rect=[1.e2,1.e-3,1.e5,2],style=[color("scilabgreen3")],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

H3TitreLatex="$\mathbf{1.4} \: \mathbf{H}$";
xstring(2.3e3,1.8e-2,H3TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=color("scilabgreen3");

plot2d("ll",w,H2,rect=[1.e2,1.e-3,1.e5,2],style=[2],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

H2TitreLatex="$\mathbf{280} \: \mathbf{mH}$";
xstring(5.6e3,3e-2,H2TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=2;

plot2d("ll",w,H,rect=[1.e2,1.e-3,1.e5,2],style=[1],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

HTitreLatex="$\mathbf{70} \: \mathbf{mH}$";
xstring(1.2e4,6.5e-2,HTitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=1;

