// circuit RLC sortie R ; influence de R0  ==================================
R0=50.;
L=70e-3;
r=10;
C=0.5e-6;
wl=[2:0.01:5];  // abscisse pour l'échelle log de w
w=(10).^wl;
phi=-atan((L.*w-1./(C.*w))./(R0+r));
L2=4*L;
phi2=-atan((L2.*w-1./(C.*w))./(R0+r));
L3=5*L2;
phi3=-atan((L3.*w-1./(C.*w))./(R0+r));
L4=0.2*L;
phi4=-atan((L4.*w-1./(C.*w))./(R0+r));

scf(1); // pour dessiner dans la fenêtre n°1
clf(); // on efface au cas où...

g1=get("current_axes"); // get the handle on axes model to view and edit the fields

xTitreLatex="$\textit{\mathbf{\omega}} \; \; \mathbf{[rad.s^{-1}]} \\_{-----} \\retour $";
//il faut un retour à la ligne forcé sinon un bug tronque le cadrage du titre

yTitreLatex="$\textit{\mathbf{\phi}} \; \; \mathbf{[rad]}$"

g1.font_size = 2.8;
g1.y_label.text=yTitreLatex;
g1.y_label.font_size = 4;

g1.x_label.text=xTitreLatex;
g1.x_label.font_size = 4;

//tracer l'arrière en premier

plot2d("ln",w,phi4,rect=[1.e2,-2,1.e5,2],style=[22],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phi4TitreLatex="$\mathbf{\textit{L}=14} \: \mathbf{mH}$";
xstring(1.3e4,-0.6,phi4TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=22;

plot2d("ln",w,phi3,rect=[1.e2,-2,1.e5,2],style=[color("scilabgreen3")],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phi3TitreLatex="$\mathbf{1.4} \: \mathbf{H}$";
xstring(5.2e2,-1.4,phi3TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=color("scilabgreen3");

plot2d("ln",w,phi2,rect=[1.e2,-2,1.e5,2],style=[2],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phi2TitreLatex="$\mathbf{280} \:\: \mathbf{mH}$";
xstring(1.6e3,-1.3,phi2TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=2;

plot2d("ln",w,phi,rect=[1.e2,-2,1.e5,2],style=[1],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phiTitreLatex="$\mathbf{70} \: \mathbf{mH}$";
xstring(5.6e3,-1.1,phiTitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=1;

