// circuit RLC sortie R ; influence de R0  ==================================
R0=50.;
L=70e-3;
r=10;
C=0.5e-6;
wl=[2:0.01:5];  // abscisse pour l'échelle log de w
w=(10).^wl;
phi=-atan((L.*w-1./(C.*w))./(R0+r));
R02=5*R0;
phi2=-atan((L.*w-1./(C.*w))./(R02+r));
R03=4*R02;
phi3=-atan((L.*w-1./(C.*w))./(R03+r));
R04=5*R03;
phi4=-atan((L.*w-1./(C.*w))./(R04+r));

scf(1); // pour dessiner dans la fenêtre n°1
clf(); // on efface au cas où...

g1=get("current_axes"); // get the handle on axes model to view and edit the fields

xTitreLatex="$\textit{\mathbf{\omega}} \; \; \mathbf{[rad.s^{-1}]} \\_{-----} \\retour $";
//il faut un retour à la ligne forcé sinon un bug tronque le cadrage du titre

yTitreLatex="$\textit{\mathbf{\phi}} \; \; \mathbf{[rad]}$"

g1.font_size = 2.8;
g1.y_label.text=yTitreLatex;
g1.y_label.font_size = 4;

g1.x_label.text=xTitreLatex;
g1.x_label.font_size = 4;

//tracer l'arrière en premier

plot2d("ln",w,phi4,rect=[1.e2,-2,1.e5,2],style=[5],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phi4TitreLatex="$\mathbf{5} \: \mathbf{k\Omega}$";
xstring(5e2,0.1,phi4TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=5;

plot2d("ln",w,phi3,rect=[1.e2,-2,1.e5,2],style=[color("scilabgreen3")],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phi3TitreLatex="$\mathbf{1} \: \mathbf{k\Omega}$";
xstring(7e2,0.65,phi3TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=color("scilabgreen3");

plot2d("ln",w,phi2,rect=[1.e2,-2,1.e5,2],style=[2],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phi2TitreLatex="$\mathbf{250} \: \mathbf{\Omega}$";
xstring(1.2e3,0.91,phi2TitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=2;

plot2d("ln",w,phi,rect=[1.e2,-2,1.e5,2],style=[1],axesflag=1);

poly1= g1.children(1).children(1); //après avoir tracé
poly1.thickness = 2;

phiTitreLatex="$\mathbf{\textit{R}_0=50} \: \mathbf{\Omega}$";
xstring(4.5e3,1,phiTitreLatex);
e=gce();
e.font_size=4;
e.font_foreground=1;

