// Diagramme de phase d'un circuit RLC (SCILAB)

L=0.1
C=5e-6

R_c=2*sqrt(L/C)
R=R_c/8

al=R/(2*L)
tau=R*C
om=1/sqrt(L*C) // non utilisé ici


function dUdt=circuitRLC(t,U)
    // pour résoudre une équation différentielle du 2e ordre en u_C
    // on peut souhaiter éviter l'usage d'un objet [u_C,du_C/dt]
    // dont les deux composantes ont des unités différentes
    // on peut alors choisir les variables tension U=[u_C,u_R]
    
    // générateur
    Em=5
    f=10
    e=Em*(sign(sin(2*%pi*f*t))+1) // bidouille pour obtenir une fonction en créneaux

    dUdt(1)=U(2)/tau // du_C/dt = u_R/tau
    dUdt(2)=2*al*(e-U(2)-U(1)) // du_R/dt = 2*al*u_L  ;  u_L=e-u_R-u_C
endfunction

t0=0
U0=[0;0]

t=[0:0.0001:0.1]
U=ode(U0,t0,t,circuitRLC)

// il peut être plus "parlant" de renommer certaines quantités
u_C=U(1,:)
u_R=U(2,:)
i=u_R/R

scf(1) // pour dessiner dans la fenêtre n°1
clf(1) // on efface au cas où...

subplot(3,1,1)
a11=get("current_axes") // get the handle on axes model to view and edit the fields
a11.x_label.text="t [[s]]";
a11.x_label.font_style = 8;
a11.x_label.font_size = 3;

yTitreLatex="$\mathbf{\mathsf{{\large{u}}_C\ \ [[V]]}}$"


a11.y_label.text=yTitreLatex;
a11.y_label.font_size = 3;
plot2d(t,u_C)

subplot(3,1,2);
a12=gca() // raccourci pour a=get("current_axes")
a12.x_label.text="t [[s]]";
a12.x_label.font_style = 8;
a12.x_label.font_size = 3;

a12.y_label.text="i [[mA]]";
a12.y_label.font_style = 8;
a12.y_label.font_size = 3;
plot2d(t,1000*i)

scf(2) // pour dessiner dans la fenêtre n°2
clf(2) // on efface au cas où...

xTitreLatex="$\mathbf{\mathsf{{\large{u}}_C\ \ [[V]]}}$"

a2=gca()
a2.x_label.text=xTitreLatex;
a2.x_label.font_size = 3;

//yTitreMathml="<msub>u<mrow>R</mrow></msub> <mrow>[[V]]</mrow>" //ne fonctionne pas
yTitreLatex="$\mathbf{\mathsf{{\large{u}}_R\ \ [[V]]}}$"
a2.y_label.text=yTitreLatex;
a2.y_label.font_size = 3;
plot2d(u_C,u_R)
a2.children(1).children(1).thickness = 2;//épaisseur de la courbe 1 (dans le bloc 1)
