/* MG_R.r */

#include "USLib_U1.r"

Type 'MG01' as 'STR ';

Resource 'MG01' (0) {"J.M. Laffaille   MinGraph 2.5   aot 1999"};

Resource 'ICN#' (128, "MG01 APPL", purgeable) {
	{$"00000000	00000000	00000000	00000000"
	$"00000000	FFFFFFFE	84210842	80000002"
	$"C0000006	80000402	80000402	C0008406"
	$"90008A02	EC014402	D0888406	81548402"
	$"80880082	C0000086	80000362	80000082"
	$"C88E0086	8D900012	8A93006E	C88F0016"
	$"80000002	84210842	FFFFFFFE	00000000"
	$"00000000	00000000	00000000	00000000",
	/* puis le masque */
	$"00000000	00000000	00000000	00000000"
	$"00000000	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	00000000"
	$"00000000	00000000	00000000	00000000"}};

Resource 'ICN#' (129, "MG01 TEXT", purgeable) {
	{$"00000000	00000000	00000000	00000000"
	$"00000000	FFFFFFFE	80200802	80200802"
	$"AAAAAAAA	80200802	80200802	AAAAAAAA"
	$"80200802	80200802	AAAAAAAA	80200802"
	$"80200802	AABFFFFE	80200002	80200002"
	$"AAA221C2	80236202	8022A262	AAA221E2"
	$"80200002	80200002	FFFFFFFE	00000000"
	$"00000000	00000000	00000000	00000000",
	/* puis le masque */
	$"00000000	00000000	00000000	00000000"
	$"00000000	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	FFFFFFFE"
	$"FFFFFFFE	FFFFFFFE	FFFFFFFE	00000000"
	$"00000000	00000000	00000000	00000000"}};

data 'icl8' (128, "MG01 APPL", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFF00"
	$"FF000000	00FF0000	0000FF00	000000FF"
	$"00000000	FF000000	00FF0000	0000FF00"
	$"FF000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	0000FF00"
	$"FFFF0000	00000000	00000000	00000000"
	$"000000C0	00000000	00000000	00FFFF00"
	$"FF000000	00000000	00000000	00000000"
	$"0000C0C0	C0FF0000	00000000	0000FF00"
	$"FF000000	00000000	00000000	00000000"
	$"0000C000	C0FF0000	00000000	0000FF00"
	$"FFFF0000	00000000	00000000	00000000"
	$"FFC0C000	C0FF0000	00000000	00FFFF00"
	$"FFC0C0FF	00000000	00000000	00000000"
	$"FFC00000	FFD8FF00	00000000	0000FF00"
	$"FFFFFFD8	FFFF0000	00000000	000000FF"
	$"D8FF0000	00FFC000	00000000	0000FF00"
	$"FFFF00FF	C0C0C0C0	FF000000	FF00C0C0"
	$"FF000000	00FFC000	00000000	00FFFF00"
	$"FF000000	0000C0FF	D8FFC0FF	D8FFC000"
	$"FF000000	00FFC000	00000000	0000FF00"
	$"FF000000	00000000	FFC0C0C0	FF000000"
	$"00000000	0000C0C0	FF000000	0000FF00"
	$"FFFF0000	00000000	00000000	00000000"
	$"00000000	000000C0	FF000000	00FFFF00"
	$"FF000000	00000000	00000000	00000000"
	$"00000000	0000FFFF	D8FFFF00	0000FF00"
	$"FF000000	00000000	00000000	00000000"
	$"00000000	00000000	FFC00000	0000FF00"
	$"FFFF0000	9F000000	9F000000	9F9F9F00"
	$"00000000	00000000	FFC0C000	00FFFF00"
	$"FF000000	9F9F009F	9F00009F	00000000"
	$"00000000	00000000	0000C0FF	0000FF00"
	$"FF000000	9F009F00	9F00009F	00009F9F"
	$"00000000	00000000	00FFFFD8	FFFFFF00"
	$"FFFF0000	9F000000	9F000000	9F9F9F9F"
	$"00000000	00000000	000000FF	C0FFFF00"
	$"FF000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00C0FF00"
	$"FF000000	00FF0000	0000FF00	000000FF"
	$"00000000	FF000000	00FF0000	0000FF00"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFF00"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
};

data 'icl8' (129, "MG01 TEXT", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFF00"
	$"FF000000	00000000	0000C000	00000000"
	$"00000000	C0000000	00000000	0000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	FF000000	00000000	0000FF00"
	$"FF00C000	C000C000	C000C000	C000C000"
	$"C000C000	C000C000	C000C000	C000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	FF000000	00000000	0000FF00"
	$"FF000000	00000000	0000C000	00000000"
	$"00000000	C0000000	00000000	0000FF00"
	$"FF00C000	C000C000	C000FF00	C000C000"
	$"C000C000	FF00C000	C000C000	C000FF00"
	$"FF000000	00000000	0000C000	00000000"
	$"00000000	C0000000	00000000	0000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	FF000000	00000000	0000FF00"
	$"FF00C000	C000C000	C000C000	C000C000"
	$"C000C000	C000C000	C000C000	C000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	FF000000	00000000	0000FF00"
	$"FF000000	00000000	0000C000	00000000"
	$"00000000	C0000000	00000000	0000FF00"
	$"FF00C000	C000C000	C000FFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	00000000	00000000	0000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	00000000	00000000	0000FF00"
	$"FF00C000	C000C000	C000FF00	00009F00"
	$"00009F00	0000009F	9F9F0000	0000FF00"
	$"FF000000	00000000	0000FF00	00009F9F"
	$"009F9F00	00009F00	00000000	0000FF00"
	$"FF000000	00000000	0000FF00	00009F00"
	$"9F009F00	00009F00	009F9F00	0000FF00"
	$"FF00C000	C000C000	C000FF00	00009F00"
	$"00009F00	0000009F	9F9F9F00	0000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	00000000	00000000	0000FF00"
	$"FF000000	00000000	0000FF00	00000000"
	$"00000000	00000000	00000000	0000FF00"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFF00"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
};

data 'icl4' (128, "MG01 APPL", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFF0"
	$"F0000F00	00F0000F	0000F000	0F0000F0"
	$"F0000000	00000000	00000000	000000F0"
	$"FF000000	00000000	00070000	00000FF0"
	$"F0000000	00000000	00777F00	000000F0"
	$"F0000000	00000000	00707F00	000000F0"
	$"FF000000	00000000	F7707F00	00000FF0"
	$"F77F0000	00000000	F700F3F0	000000F0"
	$"FFF3FF00	0000000F	3F000F70	000000F0"
	$"FF0F7777	F000F077	F0000F70	00000FF0"
	$"F000007F	3F7F3F70	F0000F70	000000F0"
	$"F0000000	F777F000	00000077	F00000F0"
	$"FF000000	00000000	00000007	F0000FF0"
	$"F0000000	00000000	000000FF	3FF000F0"
	$"F0000000	00000000	00000000	F70000F0"
	$"FF00D000	D000DDD0	00000000	F7700FF0"
	$"F000DD0D	D00D0000	00000000	007F00F0"
	$"F000D0D0	D00D00DD	00000000	0FF3FFF0"
	$"FF00D000	D000DDDD	00000000	000F7FF0"
	$"F0000000	00000000	00000000	000007F0"
	$"F0000F00	00F0000F	0000F000	0F0000F0"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFF0"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
};

data 'icl4' (129, "MG01 TEXT", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFF0"
	$"F0000000	00700000	00007000	000000F0"
	$"F0000000	00F00000	0000F000	000000F0"
	$"F0707070	70707070	70707070	707070F0"
	$"F0000000	00F00000	0000F000	000000F0"
	$"F0000000	00700000	00007000	000000F0"
	$"F0707070	70F07070	7070F070	707070F0"
	$"F0000000	00700000	00007000	000000F0"
	$"F0000000	00F00000	0000F000	000000F0"
	$"F0707070	70707070	70707070	707070F0"
	$"F0000000	00F00000	0000F000	000000F0"
	$"F0000000	00700000	00007000	000000F0"
	$"F0707070	70FFFFFF	FFFFFFFF	FFFFFFF0"
	$"F0000000	00F00000	00000000	000000F0"
	$"F0000000	00F00000	00000000	000000F0"
	$"F0707070	70F000D0	00D0000D	DD0000F0"
	$"F0000000	00F000DD	0DD000D0	000000F0"
	$"F0000000	00F000D0	D0D000D0	0DD000F0"
	$"F0707070	70F000D0	00D0000D	DDD000F0"
	$"F0000000	00F00000	00000000	000000F0"
	$"F0000000	00F00000	00000000	000000F0"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFF0"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
};

data 'ics#'  (128, "MG01 APPL", purgeable) {
	$"00000000	FFFF8001	A221D521	A2518025"
	$"A9A5BA0B	AA85A985	8001FFFF	00000000"
	$"00000000	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	00000000"
};

data 'ics#' (129, "MG01 TEXT", purgeable) {
	$"00000000	FFFF8421	D6B58421	D7FF8401"
	$"D54D85D1	D555854D	D401FFFF	00000000"
	$"00000000	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	00000000"
};

data 'ics8'  (128, "MG01 APPL", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FF000000	00000000	00000000	000000FF"
	$"FFC0FF00	0000FF00	0000FF00	000000FF"
	$"FFFFD8FF	C0FFD8FF	C000FF00	000000FF"
	$"FF00FF00	0000FF00	C0FFD8FF	000000FF"
	$"FF000000	00000000	0000FFC0	00FF00FF"
	$"FF009F00	9F00009F	9F00FFC0	C0FF00FF"
	$"FF009F9F	9F009F00	00000000	FFD8FFFF"
	$"FF009F00	9F009F00	9F000000	00FFC0FF"
	$"FF009F00	9F00009F	9F000000	00FFC0FF"
	$"FF000000	00000000	00000000	000000FF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
};

data 'ics8' (129, "MG01 TEXT", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"FF000000	00C00000	0000C000	000000FF"
	$"FFC000C0	00FFC000	C000FFC0	00C000FF"
	$"FF000000	00C00000	0000C000	000000FF"
	$"FFC000C0	00FFFFFF	FFFFFFFF	FFFFFFFF"
	$"FF000000	00FF0000	00000000	000000FF"
	$"FFC000C0	00FF009F	009F0000	9F9F00FF"
	$"FF000000	00FF009F	9F9F009F	000000FF"
	$"FFC000C0	00FF009F	009F009F	009F00FF"
	$"FF000000	00FF009F	009F0000	9F9F00FF"
	$"FFC000C0	00FF0000	00000000	000000FF"
	$"FFFFFFFF	FFFFFFFF	FFFFFFFF	FFFFFFFF"
	$"00000000	00000000	00000000	00000000"
	$"00000000	00000000	00000000	00000000"
};

data 'ics4'  (128, "MG01 APPL", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	F0000000	0000000F"
	$"F7F000F0	00F0000F	FF3F7F3F	70F0000F"
	$"F0F000F0	7F3F000F	F0000000	00F70F0F"
	$"F0D0D00D	D0F77F0F	F0DDD0D0	0000F3FF"
	$"F0D0D0D0	D0000F7F	F0D0D00D	D0000F7F"
	$"F0000000	0000000F	FFFFFFFF	FFFFFFFF"
	$"00000000	00000000	00000000	00000000"
};

data 'ics4' (129, "MG01 TEXT", purgeable) {
	$"00000000	00000000	00000000	00000000"
	$"FFFFFFFF	FFFFFFFF	F0000700	0070000F"
	$"F7070F70	70F7070F	F0000700	0070000F"
	$"F7070FFF	FFFFFFFF	F0000F00	0000000F"
	$"F7070F0D	0D00DD0F	F0000F0D	DD0D000F"
	$"F7070F0D	0D0D0D0F	F0000F0D	0D00DD0F"
	$"F7070F00	0000000F	FFFFFFFF	FFFFFFFF"
	$"00000000	00000000	00000000	00000000"
};

Resource 'ICON' (261, "JML1", purgeable) {
	$"7FFFFFFF		40000001	40000001	40000001"
	$"40000001	40000001	40000001	407FFF01"
	$"40436101	4042A101	5C42211D	54422115"
	$"4FFE3FFD		40600301	40400101	40C41181"
	$"40841081	40808081	4091C481	40B00681"
	$"408C1881	40CBE981	40441101	4063E301"
	$"40300601	401C1C01	4007F001	40000001"
	$"40000001	40000001	40000001	7FFFFFFF"};

Resource 'ICON' (262, "JML2", purgeable) {
	$"7FFFFFFF		40000001	407FFF01		40400101"
	$"40400101	5C40011D	544FF915		4FF227FD"
	$"40036001	4002A001	40022001	400E3801"
	$"40380E01	40600301	40400101	40C41181"
	$"40841081	40808081	4091C481	40B00681"
	$"408C1881	40CBE981	40463101	40622301"
	$"40322601	401D5C01	4007F001	40000001"
	$"40000001	40000001	40000001	7FFFFFFF"};

data 'cicn' (261, "JML1", purgeable) {
	$"0000 0000 8010 0000 0000 0020 0020 0000"            /* .......... . .. */
	$"0000 0000 0000 0048 0000 0048 0000 0000"            /* .......H...H.... */
	$"0004 0001 0004 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0004 0000 0000 0020 0020"            /* ............. .  */
	$"0000 0000 0004 0000 0000 0020 0020 0000"            /* ........... . .. */
	$"0000 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 4000 0001 4000 0001 4000"            /* ......@...@...@. */
	$"0001 4000 0001 4000 0001 4000 0001 407F"            /* ..@...@...@...@. */
	$"FF01 4043 6101 4042 A101 5C42 211D 5442"            /* ..@Ca.@B.\B!.TB */
	$"2115 4FFE 3FFD 4060 0301 4040 0101 40C4"            /* !.O.?.@`..@@..@ */
	$"1181 4084 1081 4080 8081 4091 C481 40B0"            /* .@.@@ā@ */
	$"0681 408C 1881 40CB E981 4044 1101 4063"            /* .@.@.@D..@c */
	$"E301 4030 0601 401C 1C01 4007 F001 4000"            /* ..@0..@...@...@. */
	$"0001 4000 0001 4000 0001 4000 0001 7FFF"            /* ..@...@...@..... */
	$"FFFF 0000 0000 0000 0008 0000 FFFF FFFF"            /* ................ */
	$"FFFF 0001 0000 BBBB 0000 0002 FFFF 6666"            /* ............ff */
	$"3333 0003 FFFF FFFF 0000 0004 3333 9999"            /* 33..........33 */
	$"6666 0005 DDDD 0000 0000 0006 FFFF CCCC"            /* ff............ */
	$"9999 0007 6666 6666 CCCC 000F 0000 0000"            /* ..ffff...... */
	$"0000 0777 7777 7777 7777 7777 7777 7777"            /* ...wwwwwwwwwwwww */
	$"7777 0700 0000 0000 0000 0000 0000 0000"            /* ww.............. */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0111 1111 1111 1111 0000"            /* ................ */
	$"0007 0700 0000 0144 4411 4114 4441 0000"            /* .......DD.A.DA.. */
	$"0007 0700 0000 0144 4416 1614 4441 0000"            /* .......DD...DA.. */
	$"0007 0701 1100 0144 4416 6614 4441 0001"            /* .......DD.f.DA.. */
	$"1107 0701 4100 0144 4416 6614 4441 0001"            /* ....A..DD.f.DA.. */
	$"4107 0700 1111 1111 1116 6611 1111 1111"            /* A.........f..... */
	$"1107 0700 0000 0223 3333 3333 3322 0000"            /* .......#33333".. */
	$"0007 0700 0000 0233 3333 3333 3332 0000"            /* .......3333332.. */
	$"0007 0700 0000 2233 3F33 333F 3332 2000"            /* ......"3?33?32 . */
	$"0007 0700 0000 2333 3F33 333F 3333 2000"            /* ......#3?33?33 . */
	$"0007 0700 0000 2333 3333 F333 3333 2000"            /* ......#333.333 . */
	$"0007 0700 0000 233F 333F FF33 3F33 2000"            /* ......#?3?.3?3 . */
	$"0007 0700 0000 23FF 3333 3333 3FF3 2000"            /* ......#.3333?. . */
	$"0007 0700 0000 2333 FF33 333F F333 2000"            /* ......#3.33?.3 . */
	$"0007 0700 0000 2233 F5FF FFF5 F332 2000"            /* ......"3.....2 . */
	$"0007 0700 0000 0233 3F55 555F 3332 0000"            /* .......3?UU_32.. */
	$"0007 0700 0000 0223 33FF FFF3 3322 0000"            /* .......#3...3".. */
	$"0007 0700 0000 0022 3333 3333 3220 0000"            /* ......."33332 .. */
	$"0007 0700 0000 0002 2233 3332 2200 0000"            /* ........"332"... */
	$"0007 0700 0000 0000 0222 2222 0000 0000"            /* .........""".... */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0700 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0007 0777 7777 7777 7777 7777 7777 7777"            /* ...wwwwwwwwwwwww */
	$"7777"                                               /* ww */
};

data 'cicn' (262, "JML2", purgeable) {
	$"0000 0000 8010 0000 0000 0020 0020 0000"            /* .......... . .. */
	$"0000 0000 0000 0048 0000 0048 0000 0000"            /* .......H...H.... */
	$"0004 0001 0004 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0004 0000 0000 0020 0020"            /* ............. .  */
	$"0000 0000 0004 0000 0000 0020 0020 0000"            /* ........... . .. */
	$"0000 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 7FFF FFFF 7FFF FFFF 7FFF"            /* ................ */
	$"FFFF 7FFF FFFF 4000 0001 407F FF01 4040"            /* ......@...@...@@ */
	$"0101 4040 0101 5C40 011D 544F F915 4FF2"            /* ..@@..\@..TO..O. */
	$"27FD 4003 6001 4002 A001 4002 2001 400E"            /* '.@.`.@..@. .@. */
	$"3801 4038 0E01 4060 0301 4040 0101 40C4"            /* 8.@8..@`..@@..@ */
	$"1181 4084 1081 4080 8081 4091 C481 40B0"            /* .@.@@ā@ */
	$"0681 408C 1881 40CB E981 4046 3101 4062"            /* .@.@.@F1.@b */
	$"2301 4032 2601 401D 5C01 4007 F001 4000"            /* #.@2&.@.\.@...@. */
	$"0001 4000 0001 4000 0001 4000 0001 7FFF"            /* ..@...@...@..... */
	$"FFFF 0000 0000 0000 000A 0000 FFFF FFFF"            /* ................ */
	$"FFFF 0001 FFFF FFFF 0000 0002 FFFF 6666"            /* ..............ff */
	$"3333 0003 0000 BBBB 0000 0004 3333 9999"            /* 33........33 */
	$"6666 0005 CCCC 9999 6666 0006 FFFF CCCC"            /* ff..̙ff.... */
	$"9999 0007 DDDD 0000 0000 0008 FFFF 6666"            /* ............ff */
	$"CCCC 0009 6666 6666 CCCC 000F 0000 0000"            /* .ffff...... */
	$"0000 0999 9999 9999 9999 9999 9999 9999"            /* ..ƙ */
	$"9999 0900 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"0009 0900 0000 0333 3333 3333 3333 0000"            /* .....3333333.. */
	$"0009 0900 0000 0344 4444 4444 4443 0000"            /* .....DDDDDDC.. */
	$"0009 0900 0000 0344 4444 4444 4443 0000"            /* .....DDDDDDC.. */
	$"0009 0903 3300 0344 4444 4444 4443 0003"            /* ..3..DDDDDDC.. */
	$"3309 0903 4300 0344 3333 3333 3443 0003"            /* 3.C..D33334C.. */
	$"4309 0900 3333 3333 0050 0050 0333 3333"            /* C.3333.P.P.333 */
	$"3309 0900 0000 0000 0055 0550 0000 0000"            /* 3......U.P.... */
	$"0009 0900 0000 0000 0056 5650 0000 0000"            /* .......VVP.... */
	$"0009 0900 0000 0000 0056 6650 0000 0000"            /* .......VfP.... */
	$"0009 0900 0000 0000 2226 6622 2000 0000"            /* ......"&f" ... */
	$"0009 0900 0000 0022 2111 1111 2220 0000"            /* ....."!..." .. */
	$"0009 0900 0000 0221 1111 1111 1122 0000"            /* .....!.....".. */
	$"0009 0900 0000 0211 1111 1111 1112 0000"            /* .............. */
	$"0009 0900 0000 2211 1F11 111F 1112 2000"            /* ...."....... . */
	$"0009 0900 0000 2111 1F11 111F 1111 2000"            /* ....!....... . */
	$"0009 0900 0000 2111 1111 F111 1111 2000"            /* ....!....... . */
	$"0009 0900 0000 211F 111F FF11 1F11 2000"            /* ....!....... . */
	$"0009 0900 0000 21FF 1111 1111 1FF1 2000"            /* ....!....... . */
	$"0009 0900 0000 2111 FF11 111F F111 2000"            /* ....!....... . */
	$"0009 0900 0000 2211 F7FF FFF7 F112 2000"            /* ...."....... . */
	$"0009 0900 0000 0211 1F78 887F 1112 0000"            /* .......x..... */
	$"0009 0900 0000 0221 1178 8871 1122 0000"            /* .....!.xq.".. */
	$"0009 0900 0000 0022 1178 8871 1220 0000"            /* .....".xq. .. */
	$"0009 0900 0000 0002 2217 8712 2200 0000"            /* ......".."... */
	$"0009 0900 0000 0000 0222 2222 0000 0000"            /* .......""".... */
	$"0009 0900 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0009 0900 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0009 0900 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0009 0900 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0009 0999 9999 9999 9999 9999 9999 9999"            /* .ƙ */
	$"9999"                                               /*  */
};

Resource 'FREF' (128) {'APPL', 0, ""};

Resource 'FREF' (129) {'TEXT', 1, ""};

Resource 'BNDL' (128) {'MG01', 0, {'ICN#', {0, 128, 1, 129}, 'FREF', {0, 128, 1, 129}}};

Resource 'MENU' (59, "TypeCoor") {59, textMenuProc, $FFFFFFFF, enabled,
	"TypeCoor",	{"Cartsiennes", noIcon, "", "\0x12", plain,
				"Polaires {provisoire}", noIcon, "", "", italic}};

Resource 'MENU' (256) {256, textMenuProc, $FFFFFFFD, enabled,
	/* apple identifie \0x14 : menu pomme, 14 est le symbole pomme en HEX */
	apple,	{"A propos de MinGraph...", noIcon, "", "", plain,
				"-", noIcon, "", "", plain}};

Resource 'MENU' (257) {257, textMenuProc, $FFFFF877, enabled,
	"Fichier",	{"Donnes exprimentales...", noIcon, "", "", plain,
					"Rglages des donnes...", noIcon, "", "", plain,
					"Purge des donnes", noIcon, "", "", plain,
					"-", noIcon, "", "", plain,
					"Modle thorique...", noIcon, "", "", plain,
					"Paramtres...", noIcon, "", "", plain,
					"Purge du modle", noIcon, "", "", plain,
					"-", noIcon, "", "", plain,
					"Enregistrer...", noIcon, "S", "", plain,
					"Imprimer...", noIcon, "P", "", plain,
					"-", noIcon, "", "", plain,
					"Fermer", noIcon, "", "", plain,
					"Quitter", noIcon, "Q", "", plain}};

Resource 'MENU' (258) {258, textMenuProc, $FFFFFFC8, enabled,
	"dition",	{"Annuler", noIcon, "Z", "", plain,
						"-", noIcon, "", "", plain,
						"Couper", noIcon, "X", "", plain,
						"Copier", noIcon, "C", "", plain,
						"Coller", noIcon, "V", "", plain,
						"Effacer", noIcon, "B", "", plain}};

Resource 'MENU' (259) {259, textMenuProc, $FFFFFFC4, enabled,
	"MinGraph",	{"Ajuster le modle", noIcon, "", "", plain,
						"Rglages de l'ajustement...", noIcon, "", "", plain,
						"Crateur de la liste...", noIcon, "", "", plain,
						"-", noIcon, "", "", plain,
						"Tracer le graphique", noIcon, "", "", plain,
						"Rglages du graphique...", noIcon, "", "", plain,
						"Format du graphique...", noIcon, "", "", plain,
						"Type de coordonnes", noIcon, "\$1B", "\0d059", plain,		/* sous menu */
						"Crateur du graphique...", noIcon, "", "", plain}};

Resource 'MENU' (260, "Formes", purgeable) {260, textMenuProc, $FFFFFFFF, enabled,
	"Formes",	{"ronds", noIcon, "", "", plain,
					"carrs", noIcon, "", "", plain,
					"triangles en haut", noIcon, "", "", plain,
					"triangles en bas", noIcon, "", "", plain}};

Resource 'MENU' (261, "Couleurs", purgeable) {261, textMenuProc, $FFFFFFFF, enabled,
	"Couleurs",	{"noir", noIcon, "", "", plain,
					"blanc", noIcon, "", "", plain,
					"rouge (orange)", noIcon, "", "", plain,
					"vert", noIcon, "", "", plain,
					"bleu (pourpre)", noIcon, "", "", plain,
					"cyan", noIcon, "", "", plain,
					"magenta", noIcon, "", "", plain,
					"jaune", noIcon, "", "", plain}};

Resource 'MENU' (262, "xBarres", purgeable) {262, textMenuProc, $FFFFFFFF, enabled,
	"xBarres",	{"sans", noIcon, "", "", plain,
					"variables", noIcon, "", "", plain,
					"sqrt(nombre+1)", noIcon, "", "", plain,
					"pourcentage :", noIcon, "", "", plain,
					"+ pourcentage :", noIcon, "", "", plain,
					"constante :", noIcon, "", "", plain,
					"+ constante :", noIcon, "", "", plain,
					"* constante :", noIcon, "", "", plain}};

Resource 'MENU' (263, "yBarres", purgeable) {263, textMenuProc, $FFFFFFFF, enabled,
	"yBarres",	{"sans", noIcon, "", "", plain,
					"variables", noIcon, "", "", plain,
					"sqrt(nombre+1)", noIcon, "", "", plain,
					"pourcentage :", noIcon, "", "", plain,
					"+ pourcentage :", noIcon, "", "", plain,
					"constante :", noIcon, "", "", plain,
					"+ constante :", noIcon, "", "", plain,
					"* constante :", noIcon, "", "", plain}};

Resource 'MENU' (264, "variable", purgeable) {264, textMenuProc, $FFFFFFFF, enabled,
	"variable",	{"Variable...", noIcon, "", "", plain}};

Resource 'MENU' (265, "paramtres", purgeable) {265, textMenuProc, $FFFFFFFF, enabled,
	"paramtres",	{"Paramtres...", noIcon, "", "", plain}};

Resource 'MENU' (266, "fonctions", purgeable) {266, textMenuProc, $FFFFFFFF, enabled,
	"fonctions",	{"+ - * / ", noIcon, "", "", bold+italic,
					"$", noIcon, "", "", plain,
					"", noIcon, "", "", plain,
					"signe", noIcon, "", "", italic,
					"abs", noIcon, "", "", plain,
					"inf", noIcon, "", "", italic,
					"sup", noIcon, "", "", italic,
					"ent", noIcon, "", "", plain,
					"mod", noIcon, "", "", plain,
					"exp", noIcon, "", "", plain,
					"ln", noIcon, "", "", plain,
					"log", noIcon, "", "", plain,
					"sin", noIcon, "", "", plain,
					"cos", noIcon, "", "", plain,
					"tan", noIcon, "", "", plain,
					"asin", noIcon, "", "", plain,
					"acos", noIcon, "", "", plain,
					"atan", noIcon, "", "", plain,
					"pH{ca';cb'}", noIcon, "", "", plain,
					"pHaK{ca';pKa;cb'}", noIcon, "", "", plain,
					"pHbK{ca';cb';pKa}", noIcon, "", "", plain}};

Resource 'MENU' (267, "modle", purgeable) {267, textMenuProc, $FFFFFFFF, enabled,
	"modle",	{"Modle...", noIcon, "", "", plain}};

Resource 'MENU' (268, "formats", purgeable) {268, textMenuProc, $FFFFFFFF, enabled,
	"format",	{"usuel", noIcon, "", "", plain,
					"standard", noIcon, "", "", plain,
					"A4-portrait", noIcon, "", "", plain,
					"A4-paysage", noIcon, "", "", plain}};

Resource 'MENU' (269, "LsCrateur", purgeable) {269, textMenuProc, $FFFFFFFF, enabled,
	"ListTypes",	{"usuel", noIcon, "", "", plain,
					"SimpleText", noIcon, "", "", plain,
					"MacWritePro", noIcon, "", "", plain,
					"MacWrite", noIcon, "", "", plain}};

Resource 'MENU' (270, "GrCrateur", purgeable) {270, textMenuProc, $FFFFFFFF, enabled,
	"ListTypes",	{"usuel", noIcon, "", "", plain,
					"SuperPaint", noIcon, "", "", plain,
					"ClarisDraw", noIcon, "", "", plain,
					"MacDraw", noIcon, "", "", plain}};

Resource 'STR#' (256, "Entres Sorties", purgeable) {{
					"Quelle liste ?",
					"Sous quel nom ?",
					"Ecriture interdite",
					"Volume satur",
					"Erreur numro ",
					"Quel modle ?",
					"nom",
					"valeur",
					"incertitude"}};

Resource 'STR#' (257, "Liste", purgeable) {{
					"Paramtres pour le pas numro : ^0 (Min = ^1)",
					"*****     JMLMIN     (minimisation sans drives) *****",
					"La minimisation est interrompue, Min = ",
					"Pas n ^0, arrt par l'utilisateur...",
					"La minimisation est termine, Min = ",
					"Ce minimum n'a pas pu tre amlior  la dernire tape",
					"Le minimum n'a pas t amlior de ^0 aprs chacune des ^1 dernires tapes",
					"Avant le calcul d'incertitudes, la plus faible valeur est :  Min = ",
					"Le calcul d'incertitudes est interrompu",
					"Nombre de paramtres : ",													/* 10 */
					"Nombre de paramtres effectifs : ",
					"Taille des pas : ",
					"Prcision : ",
					"Analyse des incertitudes pour un chi2",
					"Pas relatif",
					"Valeurs initiales",
					"Premier calcul de la quantit minimise, Min = "}};

Resource 'STR#' (258, "ListeRes", purgeable) {{
					"*****     JMLMIN     (rsultats) *****",
					"La plus faible valeur est :  Min= ^0  pour l'entre ",
					"Paramtres :",
					"   (pas de calcul d'incertitudes car la minimisation a t interrompue)",
					"   (pas assez de pas pour calculer les incertitudes)",
					"Dviations standard :",
					". . . . . . . . . . . . . . . . . . . . Corrlation [^0,^1] : ",
					"Statistique de la minimisation :  nombre d'entres = ^0  ;  nombre de pas = "}};

Resource 'STR#' (259, "ListeFcn", purgeable) {{
					"Modle ajust :  ^0 = ",
					"*****  degrs de libert : ^0  *****",
					"  *****  probabilit = ",
					"*Ajust*",
					"*chi2*"}};

Resource 'STR#' (264, "fonctions", purgeable) {{"^", /* seul oprateur binaire, utiliser "$" si ncessaire */
	"", "", "abs()", "<(;)", ">(;)", "ent()", "mod(;)", "exp()", "ln()", "log()", "sin()",
	"cos()", "tan()", "asin()", "acos()", "atan()", "pH(;)", "pHaK(;;)", "pHbK(;;)"}};

Resource 'STR#' (269, "LsCrateur", purgeable) {{"ttxt", "MWPR", "MACA"}};

Resource 'STR#' (270, "GrCrateur", purgeable) {{"SPNT", "CDrw", "MDRW"}};

Resource 'STR#' (1003, "SetUpGraphique", purgeable) {{"angulaire", "radiale"}};

Resource 'STR ' (269, "LsCrateur", purgeable) {"ttxt"};

Resource 'STR ' (270, "GrCrateur", purgeable) {"SPNT"};

Resource 'ALRT' (262, "Minimiser sans y", purgeable) {{100, 50, 260, 450},
	262,	{OK, visible, sound3,
			OK, visible, sound3,
			OK, visible, sound2,
			OK, visible, sound1}};

Resource 'ALRT' (263, "Rfrences sans x-y", purgeable) {{100, 50, 260, 450},
	263,	{OK, visible, sound3,
			OK, visible, sound3,
			OK, visible, sound2,
			OK, visible, sound1}};

Resource 'ALRT' (1100, "SauvePictError", purgeable) {{170, 90, 260, 410},
	1100,	{OK, visible, sound3,
				OK, visible, sound3,
				OK, visible, sound2,
				OK, visible, sound1}};

Resource 'ALRT' (1101, "Fichier de valeurs", purgeable) {{140, 90, 260, 410},
	1101,	{OK, visible, silent,
				OK, visible, silent,
				OK, visible, silent,
				OK, visible, silent}};

Resource 'ALRT' (1102, "Quit sans save", purgeable) {{110, 80, 250, 420},
	1102,	{Cancel, visible, sound1,
				Cancel, visible, sound1,
				Cancel, visible, sound1,
				Cancel, visible, sound1}};

Resource 'ALRT' (1103, "Noms interdits", purgeable) {{110, 50, 240, 450},
	1103,	{OK, visible, sound1,
			OK, visible, sound1,
			OK, visible, sound1,
			OK, visible, sound1}};

Resource 'ALRT' (1104, "mmoire sature", purgeable) {{110, 50, 240, 450},
	1104,	{OK, visible, sound1,
			OK, visible, sound1,
			OK, visible, sound1,
			OK, visible, sound1}};

Resource 'ALRT' (1105, "InfSup", purgeable) {{100, 90, 220, 410},
	1105,	{OK, visible, sound3,
			OK, visible, sound3,
			OK, visible, sound2,
			OK, visible, sound1}};

Resource 'DLOG' (261, "About MinGraph", purgeable) {
	{50, 50, 330, 450}, DBoxProc, visible, noGoAway, 0x0, 261, ""};

Resource 'DLOG' (1000, "SetUpMinW", purgeable) {
	{30, 10, 330, 500}, DBoxProc, visible, noGoAway, 0x0, 1000, ""};

Resource 'DLOG' (1001, "SetUpMinimi", purgeable) {
	{75, 35, 280, 475}, DBoxProc, visible, noGoAway, 0x0, 1001, ""};

Resource 'DLOG' (1002, "SetUpGraphFormat", purgeable) {
	{75, 125, 225, 375}, DBoxProc, visible, noGoAway, 0x0, 1002, ""};

Resource 'DLOG' (1003, "SetUpGraphique", purgeable) {
	{30, 10, 330, 500}, DBoxProc, visible, noGoAway, 0x0, 1003, ""};

Resource 'DLOG' (1004, "SetUpPoints", purgeable) {
	{70, 10, 290, 500}, DBoxProc, visible, noGoAway, 0x0, 1004, ""};

Resource 'DLOG' (1005, "SetUpFonc", purgeable) {
	{30, 10, 330, 500}, DBoxProc, visible, noGoAway, 0x0, 1005, ""};

Resource 'DLOG' (1006, "Liste des valeurs", purgeable) {
	{30, 10, 330, 500}, DBoxProc, visible, noGoAway, 0x0, 1006, ""};

Resource 'DLOG' (1007, "Stop Minimi", purgeable) {
	{50, 65, 80, 435}, movableDBoxProc, visible, noGoAway, 0x0, 1007, "minimisation en cours..."};

Resource 'DLOG' (1008, "Liste des params", purgeable) {
	{30, 80, 330, 417}, DBoxProc, visible, noGoAway, 0x0, 1008, ""};

Resource 'DLOG' (1009, "Variable", purgeable) {
	{100, 130, 220, 370}, DBoxProc, visible, noGoAway, 0x0, 1009, ""};

Resource 'DLOG' (1010, "Modle", purgeable) {
	{100, 130, 220, 370}, DBoxProc, visible, noGoAway, 0x0, 1010, ""};

Resource 'DLOG' (1011, "Crateur", purgeable) {
	{100, 120, 180, 380}, DBoxProc, visible, noGoAway, 0x0, 1011, ""};

Resource 'DLOG' (1012, "SetUpPolGr", purgeable) {
	{100, 30, 225, 475}, DBoxProc, visible, noGoAway, 0x0, 1012, ""};

Resource 'DITL' (261, "About MinGraph", purgeable) {
	{{16, 155, 36, 255}, Button {enabled, "OK"},
	{10, 20, 42, 52}, Icon {enabled, 261},
	{55, 10, 73, 395}, StaticText {disabled, "^0   87-99"},
	{82, 10, 98, 395}, StaticText {disabled, "mmoire disponible : ^1 K..."},
	{107, 10, 159, 395}, StaticText {disabled, "Si ce logiciel vous semble utile, toutes copies, "
		"traductions... et autres manipulations sont autorises pourvu qu'elles soient sans but lucratif..."},
	{169, 10, 272, 395}, StaticText {disabled, "Pour tous renseignements ou suggestions :\n"
		"15 rue Colette - 49000 Angers\n" "(Laffaille.J-M.edu@wanadoo.fr)\n"
		"(pour une documentation complte et le suivi des mises  jour, je serai srement "
		"plus efficace si vous joignez quelques dizaines d'euros...)"}}};

Resource 'DITL' (262, "Minimiser sans y", purgeable) {
	{{25, 150, 45, 250}, Button {enabled, "OK"},
	{70, 10, 150, 395}, StaticText {disabled,
		"Cette version de MinGraph s'attend  minimiser une quantit ressemblant  un chi2...\n"
		"Il faut pour cela dfinir des valeurs ^0 non nulles (utiliser au besoin  ^0 = 1)."}}};

Resource 'DITL' (263, "Rfrences sans x-y", purgeable) {
	{{25, 150, 45, 250}, Button {enabled, "OK"},
	{70, 10, 150, 395}, StaticText {disabled,
		"Il n'est pas possible de crer de nouveaux points\n"
		"(dont les ^0 et ^1 sont inconnus...)\n"
		"quand on fait rfrence aux ^0 ou ^1 censs prexister!"}}};

Resource 'DITL' (1000, "SetUpMinW", purgeable) {
	{{10, 120, 30, 220}, Button {enabled, "Enregistrer"},		/* OK */
	{10, 230, 30, 330}, Button {enabled, "Fermer"},		/* cancel */
	{10, 10, 30, 110}, Button {enabled, "Imprimer"},
	{40, 470, 295, 486}, UserItem {enabled}}};			/* scroll bar */

Resource 'DITL' (1001, "SetUpMinimi", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "Minimiser"},		/* OK */
	{10, 280, 30, 380}, Button {enabled, "Annuler"},
	{10, 120, 30, 270}, Button {enabled, "Paramtres standard"},
	{50, 10, 65, 215}, StaticText {disabled, "Taille globale des pas : "},
	{50, 220, 65, 305}, EditText {enabled, ""},
	{75, 10, 90, 95}, StaticText {disabled, "Prcision : "},
	{75, 100, 90, 185}, EditText {enabled, ""},
	{100, 10, 115, 335}, StaticText {disabled, "Nombre de pas entre rsultats intermdiaires : "},
	{100, 340, 115, 425}, EditText {enabled, ""},
	{130, 10, 145, 335}, StaticText {disabled, "La quantit minimise est un chi2 : "},
	{155, 10, 170, 85}, RadioButton {enabled, "non"},
	{155, 110, 170, 255}, RadioButton {enabled, "chi2 sur ordonne"},
	{145, 280, 180, 415}, RadioButton {enabled, "chi2 sur abscisse\n  et ordonne"},
	{180, 10, 195, 335}, CheckBox {enabled, "Calcul des incertitudes"}}};
	
Resource 'DITL' (1002, "SetUpGraphFormat", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "Formater"},		/* OK */
	{10, 140, 30, 240}, Button {enabled, "Annuler"},
	{52, 10, 68, 80}, StaticText {disabled, "Format : "},
	{52, 90, 68, 190}, StaticText {enabled, " usuel"},
	{80, 10, 95, 65}, StaticText {disabled, "Taille : "},
	{80, 75, 95, 165}, StaticText {disabled, "Horizontale : "},
	{80, 175, 95, 235}, EditText {enabled, "410"},
	{105, 75, 120, 165}, StaticText {disabled, "Verticale : "},
	{105, 175, 120, 235}, EditText {enabled, "235"},
	{130, 10, 145, 80}, StaticText {disabled, "Unit : "},
	{130, 90, 145, 160}, RadioButton {enabled, "pixel"},
	{130, 170, 145, 240}, RadioButton {enabled, "cm"}}};
	
Resource 'DITL' (1003, "SetUpGraphique", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "Tracer"},		/* OK */
	{10, 360, 30, 460}, Button {enabled, "Annuler"},	/* cancel */
	{10, 160, 30, 310}, Button {enabled, "Paramtres Standard"},
	{40, 10, 55, 150}, StaticText {disabled, "Cadrage des points : "},
	{60, 10, 75, 105}, StaticText {disabled, "horizontal : "},
	{60, 115, 75, 285}, RadioButton {enabled, "automatique"},
	{80, 115, 95, 205}, RadioButton {enabled, "manuel : "},
	{80, 220, 95, 250}, StaticText {disabled, "inf : "},
	{80, 255, 95, 340}, EditText {enabled, "0"},
	{80, 355, 95, 390}, StaticText {disabled, "sup : "},
	{80, 395, 95, 480}, EditText {enabled, "100"},
	{105, 10, 120, 105}, StaticText {disabled, "vertical : "},
	{105, 115, 120, 285}, RadioButton {enabled, "automatique"},
	{125, 115, 140, 205}, RadioButton {enabled, "manuel : "},
	{125, 220, 140, 250}, StaticText {disabled, "inf : "},
	{125, 255, 140, 340}, EditText {enabled, "0"},
	{125, 355, 140, 390}, StaticText {disabled, "sup : "},
	{125, 395, 140, 480}, EditText {enabled, "100"},
	{155, 10, 170, 200}, StaticText {disabled, "Incertitudes horizontales : "},
	{155, 210, 170, 320}, CheckBox {enabled, "traces"},
	{155, 330, 170, 440}, CheckBox {enabled, "cadres"},
	{175, 10, 190, 200}, StaticText {disabled, "Incertitudes verticales : "},
	{175, 210, 190, 320}, CheckBox {enabled, "traces"},
	{175, 330, 190, 440}, CheckBox {enabled, "cadres"},
	{207, 10, 223, 100}, StaticText {disabled, "Symboles : "},
	{207, 105, 223, 240}, StaticText {enabled, "  ronds"},
	{207, 305, 223, 440}, StaticText {enabled, "  blanc"},
	{240, 10, 255, 200}, StaticText {disabled, "Echelle logarithmique : "},
	{240, 210, 255, 320}, CheckBox {enabled, "horizontale"},
	{240, 330, 255, 440}, CheckBox {enabled, "verticale"},
	{260, 10, 275, 200}, StaticText {disabled, "Cadrage du zro : "},
	{260, 210, 275, 320}, CheckBox {enabled, "horizontal"},
	{260, 330, 275, 440}, CheckBox {enabled, "vertical"},
	{280, 10, 295, 200}, StaticText {disabled, "Courbe calcule : "},
	{280, 210, 295, 320}, CheckBox {enabled, "trace"},
	{280, 330, 295, 440}, CheckBox {enabled, "cadre"},
	{280, 450, 295, 480}, Button {enabled, "..."}}};

Resource 'DITL' (1004, "SetUpPoints", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "Liste..."},		/* OK */	
	{10, 160, 30, 260}, Button {enabled, "Annuler"},	/* cancel */
	{50, 10, 65, 215}, StaticText {disabled, "Entres pr-initialises :"},
	{75, 10, 90, 155}, StaticText {disabled, "Nombre de points :"},
	{75, 160, 90, 230}, EditText {enabled, ""},
	{105, 10, 120, 190}, CheckBox {enabled, "abscisse en squence :"},
	{105, 195, 120, 250}, StaticText {disabled, "dbut :"},
	{105, 255, 120, 335}, EditText {enabled, "0"},
	{105, 355, 120, 395}, StaticText {disabled, "pas :"},
	{105, 400, 120, 480}, EditText {enabled, "1"},
	{130, 10, 145, 190}, CheckBox {enabled, "ordonne en squence :"},
	{130, 195, 145, 250}, StaticText {disabled, "dbut :"},
	{130, 255, 145, 335}, EditText {enabled, "0"},
	{130, 355, 145, 395}, StaticText {disabled, "pas :"},
	{130, 400, 145, 480}, EditText {enabled, "1"},
	{160, 10, 175, 205}, StaticText {disabled, "Incertitudes horizontales :"},
	{160, 210, 175, 345}, StaticText {enabled, "  variables"},
	{160, 400, 175, 480}, EditText {enabled, "1"},
	{185, 10, 200, 205}, StaticText {disabled, "Incertitudes verticales :"},
	{185, 210, 200, 345}, StaticText {enabled, "  variables"},
	{185, 400, 200, 480}, EditText {enabled, "1"}}};

Resource 'DITL' (1005, "SetUpFonc", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "OK"},
	{10, 130, 30, 230}, Button {enabled, "Annuler"},
	{52, 10, 68, 110}, StaticText {enabled, " Variable..."},
	{52, 130, 68, 230}, StaticText {enabled, " Modle..."},
	{52, 250, 68, 350}, StaticText {enabled, " Fonctions"},
	{52, 370, 68, 470}, StaticText {enabled, " Paramtres..."},
	{97, 10, 115, 80}, StaticText {disabled, "Modle :"},
	{95, 250, 115, 350}, Button {enabled, "Ouvrir"},
	{95, 370, 115, 470}, Button {enabled, "Enregistrer"},
	{125, 10, 175, 480}, EditText {enabled, ""},
	{192, 10, 210, 240}, StaticText {disabled, "Commentaires de l'interprteur :"},
	{190, 370, 210, 470}, Button {enabled, "Tester"},
	{220, 10, 290, 480}, EditText {enabled, ""}}};

Resource 'DITL' (1006, "Liste des valeurs", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "OK"},				/* OK */
	{10, 370, 30, 470}, Button {enabled, "Annuler"},		/* cancel */
	{43, 6, 59, 484}, EditText {enabled, ""},
	{94, 3, 297, 487}, UserItem {enabled},						/* liste et sa scroll bar */
	{10, 130, 30, 230}, Button {enabled, "Ouvrir"},			/* fin pour liste des valeurs */
	{10, 250, 30, 350}, Button {enabled, "Enregistrer"}}};

Resource 'DITL' (1007, "Stop Minimi", purgeable) {
	{{5, 10, 25, 115}, Button {enabled, "Annuler"},
	{5, 125, 25, 245}, Button {enabled, "Interrompre"},
	{5, 255, 25, 360}, Button {enabled, "Continuer"}}};

Resource 'DITL' (1008, "Liste des params", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "OK"},				/* OK */
	{10, 130, 30, 230}, Button {enabled, "Annuler"},		/* cancel */
	{43, 6, 59, 331}, EditText {enabled, ""},
	{94, 3, 297, 334}, UserItem {enabled}}};					/* liste et sa scroll bar */

Resource 'DITL' (1009, "Variable", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "OK"},				/* OK */
	{10, 130, 30, 230}, Button {enabled, "Annuler"},		/* cancel */
	{60, 10, 80, 220}, StaticText {disabled, "Nom de la variable ?"},
	{90, 10, 110, 220}, EditText {enabled, ""}}};

Resource 'DITL' (1010, "Fonction", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "OK"},				/* OK */
	{10, 130, 30, 230}, Button {enabled, "Annuler"},		/* cancel */
	{60, 10, 80, 220}, StaticText {disabled, "Nom de la fonction ?"},
	{90, 10, 110, 220}, EditText {enabled, ""}}};

Resource 'DITL' (1011, "Crateur", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "Formater"},				/* OK */
	{10, 140, 30, 240}, Button {enabled, "Annuler"},		/* cancel */
	{52, 10, 68, 80}, StaticText {disabled, "Crateur : "},
	{52, 90, 68, 190}, StaticText {enabled, " usuel : "},
	{52, 200, 68, 250}, EditText {enabled, "1234"}}};

Resource 'DITL' (1012, "SetUpPolGr", purgeable) {
	{{10, 10, 30, 110}, Button {enabled, "OK"},				/* OK */
	{10, 160, 30, 260}, Button {enabled, "Annuler"},		/* cancel */
	{40, 10, 55, 290}, StaticText {disabled, "tendue angulaire de la courbe : "},
	{60, 65, 75, 235}, RadioButton {enabled, "automatique"},
	{80, 65, 95, 155}, RadioButton {enabled, "manuel : "},
	{80, 170, 95, 200}, StaticText {disabled, "inf : "},
	{80, 205, 95, 290}, EditText {enabled, "-3,1416"},
	{80, 305, 95, 340}, StaticText {disabled, "sup : "},
	{80, 345, 95, 430}, EditText {enabled, "3,1416"},
	{105, 10, 120, 200}, StaticText {disabled, "Cadrage de la courbe : "},
	{105, 200, 120, 310}, CheckBox {enabled, "horizontal"},
	{105, 340, 120, 450}, CheckBox {enabled, "vertical"}}};

Resource 'DITL' (1100, "SauvePictError", purgeable) {
	{{15, 150, 35, 250}, Button {enabled, "OK"},
	{60, 10, 80, 290}, StaticText {disabled, "^0"}}};

Resource 'DITL' (1101, "Fichier de valeurs", purgeable) {
	{{15, 40, 35, 140}, Button {enabled, "Annexer"},
	{50, 180, 70, 280}, Button {enabled, "Annuler"},
	{50, 40, 70, 140}, Button {enabled, "Insrer"},
	{85, 40, 105, 140}, Button {enabled, "Remplacer"}}};

Resource 'DITL' (1102, "QuitSansSave", purgeable) {
	{{96, 70, 116, 160}, Button {enabled, "Fermer"},
	{66, 70, 86, 160}, Button {enabled, "Enregistrer"},
	{96, 236, 116, 326}, Button {enabled, "Annuler"},
	{12, 70, 47, 335}, StaticText {disabled, "Voulez vous fermer ce module...\n"
																	"SANS ENREGISTRER son rsultat ?"}}};

Resource 'DITL' (1103, "Noms interdits", purgeable) {
	{{25, 150, 45, 250}, Button {enabled, "OK"},
	{70, 10, 150, 395}, StaticText {disabled,
		"Il n'est pas possible de rutiliser le nom '^0'... \n"
		"c'est un caractre rserv ou un nom dja utilis comme variable, fonction ou paramtre !"}}};

Resource 'DITL' (1104, "mmoire sature", purgeable) {
	{{25, 150, 45, 250}, Button {enabled, "OK"},
	{70, 10, 150, 395}, StaticText {disabled,
		"** ^0 ** mmoire sature : erreur ^1... \n"
		"mmoire thorique : ^2 K..."}}};

Resource 'DITL' (1105, "InfSup", purgeable) {
	{{25, 150, 45, 250}, Button {enabled, "OK"},
	{70, 10, 110, 310}, StaticText {disabled,
		"Le graphique ne peut pas tre trac...\n"
		"xinf  xsup  ou  yinf  ysup"}}};
		
Resource 'RECT' (1002, "GraphFormat", purgeable) {
	{0, 0, 235, 410}};

Resource 'WIND' (1002, "SetUpGraphW", purgeable) {
	{45, 5, 335, 505}, ZoomDocProc, visible, GoAway, 0x0, ""};

data 'snd ' (256, "CopyGraph", purgeable) {
	$"0001 0001 0005 0000 00A0 0001 8051 0000"            /* ...........Q.. */
	$"0000 0014 0000 0000 0000 0FC6 2600 0000"            /* ...........&... */
	$"0000 0FC4 0000 0FC5 003C 807F 7F7F 7F7B"            /* .......<....{ */
	$"7B7D 7F7C 7A85 7C78 709D 6097 5D91 5996"            /* {}.|z|xp`]Y */
	$"8A51 B57A 5A7A 9F56 A643 9122 60FF F959"            /* QzZzVC"`..Y */
	$"7349 8A77 FE00 9500 83FB 7D9F 9A6A E769"            /* sIw....}j.i */
	$"848A 2ECB 4FAB 3681 81C0 8E7D 7885 A64C"            /* .O6}xL */
	$"A267 8A73 A38D 7286 70A6 7B70 9B74 6FB7"            /* gsrp{pto */
	$"49E0 00CD 4CEC 0ABA 8369 A36B 8943 FF37"            /* I..L..ikC.7 */
	$"7B96 3985 7BAC 1567 9EFF C231 60A2 9D70"            /* {9{.g.1`p */
	$"5585 8462 91BC 00D4 8E5A 8E70 6F78 726A"            /* Ub.ԎZpoxrj */
	$"5C7F 6B9A 8074 729E 6580 727F 74A6 4476"            /* \.ktrer.tDv */
	$"738A 7373 7480 6F84 7D63 7370 8870 7A96"            /* sssto}csppz */
	$"5193 5877 747D 706F 6D83 8077 6F6F 8667"            /* QXwt}pomwoog */
	$"8C6E 7C7B 7D7B 6E76 7388 6E78 6685 7A84"            /* n|{}{nvsnxfz */
	$"6F73 736E 786A 815A 856F 8C72 599E 6A7A"            /* ossnxjZorYjz */
	$"748A 606F 845E 866D 924F B862 956F 8080"            /* t`o^mObo */
	$"8974 7C6E 7F7D 8580 6B76 7292 6790 7885"            /* t|n.}kvrgx */
	$"7B81 7C89 8E6E 8C70 9083 7D97 6E85 837C"            /* {|np}n| */
	$"866F 8D76 9F6A 62FF 00E1 26E9 36C2 837B"            /* ovjb...&.6{ */
	$"6D59 7C97 7A6D BC77 8390 6E9D 49B1 537A"            /* mY|zmwnISz */
	$"6990 6E8A 9781 9B96 8D9E 837F 69A2 53A2"            /* in.iS */
	$"736E 707A 8E6B AC5D 9E69 A266 8184 8A84"            /* snpzk]if */
	$"7F95 608E 83A4 6AAA 6985 7788 7777 8474"            /* .`jiwwwt */
	$"8D8D 8986 8092 8595 8983 7B76 9D73 7D81"            /* {vs} */
	$"7B8D 7A8E 8C7D 8A84 9684 8185 9080 8A93"            /* {z} */
	$"80A2 7396 8381 8995 8690 7D8E 8588 8396"            /* s} */
	$"8D86 8889 8A85 997F 9676 9085 9273 9D7B"            /* .vs{ */
	$"9B84 958A 9690 8A7A 937B 8390 8D89 9189"            /* z{ */
	$"8590 7C8E 8D84 8C91 9181 8986 8D8A 9596"            /* | */
	$"7785 8485 9690 AA65 9F62 B77A A089 8473"            /* webzs */
	$"8691 9E89 8885 6181 869B 976B 7D76 7093"            /* ak}vp */
	$"7DC5 5356 C11C FF28 B886 33C9 24FF 00FF"            /* }SV..(3$... */
	$"00FB 07E0 7283 7F89 25E5 2FD4 5491 5893"            /* ....r.%./TX */
	$"67BC 5AA0 55B5 26DA 1CDF 605C 8961 8388"            /* gZU&...`\a */
	$"7F78 8432 AC51 9F5A 9A59 6E61 9978 856A"            /* .x2QZYnaxj */
	$"812F BC58 849D 5E66 7366 A75C A758 7A4D"            /* /X^fsf\XzM */
	$"9369 8C74 6B63 7A65 855D 939B 00CE 33BD"            /* itkcze].3 */
	$"728D 7719 85BE 378A 9346 736B 88A8 5E74"            /* rw.7Fsk^t */
	$"C20E AB53 8DA0 4B99 3A62 C747 AD95 2F83"            /* .SK:bG/ */
	$"7A61 AD6A 8170 1CEC 15BA AD65 7489 48B8"            /* zajp...etH */
	$"B055 C029 859B 53A6 86AB 289F 7495 7ACB"            /* U)S(tz */
	$"5047 8A70 B19B 7691 3F8E 9093 7CBD 428A"            /* PGpv?|B */
	$"866F A283 977C 5577 959B 8392 9750 A778"            /* o|UwPx */
	$"9081 AB92 5599 69AA 74AA AA65 5678 8DAB"            /* UiteVx */
	$"6590 9649 7BA0 B353 9B91 616F 7DA8 7795"            /* eI{Sao}w */
	$"59BC 656D 81BC 658A 7292 7277 888D 9084"            /* Yemerrw */
	$"7C74 6E93 69A0 6962 8C6B 9A67 8376 7D7F"            /* |tniibkgv}. */
	$"7D80 8086 7A73 837B 7380 7D7C 6F83 737F"            /* }zs{s}|os. */
	$"777F 7B7A 6D85 7770 7D7F 7478 897B 7777"            /* w.{zmwp}.tx{ww */
	$"8076 7A7B 7C7C 6F7B 8878 7A89 7D6E BC25"            /* vz{||o{xz}n% */
	$"92A3 8412 FA2D 7DD3 3A7F 8D43 D649 8C81"            /* ..-}:.CI */
	$"58B8 748C 6E69 7F99 7C7F 6D89 9B70 7F84"            /* Xtni.|.mp. */
	$"887D 7289 6F78 8181 897A 8480 8877 8483"            /* }roxzw */
	$"7D84 838D 838E 7A8D 8684 818D 7F91 7F83"            /* }z.. */
	$"8D7B 8985 8D8A 8A86 848C 868C 8986 8080"            /* { */
	$"837F 8C80 837D 8376 897B 8181 8676 8088"            /* .}v{v */
	$"7C81 837F 7D77 7B7D 8080 807A 7C7D 787D"            /* |.}w{}z|}x} */
	$"767F 7B76 7F77 866E 8176 8077 7D76 7F74"            /* v.{v.wnvw}v.t */
	$"7F7D 897B 8083 7B74 896B 8076 787C 7D78"            /* .}{{tkvx|}x */
	$"8180 807D 7A85 7B89 817D 7680 7785 7780"            /* }z{}vww */
	$"787F 7D7D 817C 897D 7F88 7D7F 8477 7D80"            /* x.}}|}.}.w} */
	$"887A 847A 7B7F 7C7F 7F77 897B 7F80 857F"            /* zz{.|..w{.. */
	$"8083 8583 8184 8581 7F85 8185 8581 8481"            /* . */
	$"8186 8484 8085 8383 847D 7F80 8083 8881"            /* }. */
	$"8185 8485 8386 8485 8686 8686 8486 8585"            /*  */
	$"8586 8384 8483 8481 8583 8485 8581 8384"            /*  */
	$"8584 8584 8481 8484 8585 8685 8086 8081"            /*  */
	$"8181 8180 8381 7F83 8180 7F80 8381 7F7D"            /* ...} */
	$"7D7C 7C7C 7C7D 7B7D 7C7B 7D7C 7B78 7D78"            /* }||||}{}|{}|{x}x */
	$"7C7A 7C7A 7B7A 7A78 787B 7C78 787A 767B"            /* |z|z{zzxx{|xxzv{ */
	$"767B 7C78 7A77 7877 7C7A 7B7B 7B7A 7C7A"            /* v{|xzwxw|z{{{z|z */
	$"777A 777A 777A 7878 777B 7878 7778 7476"            /* wzwzwzxxw{xxwxtv */
	$"7678 7878 787A 787A 7A76 7877 7776 7876"            /* vxxxxzxzzvxwwvxv */
	$"7676 7676 7878 777B 787B 7B7B 7A7A 7B7C"            /* vvvvxxw{x{{{zz{| */
	$"7C80 7D7D 7C7D 7C7C 7D7D 7D7B 7C7A 7C7C"            /* |}}|}||}}}{|z|| */
	$"7B7D 7B7C 7D7B 7F7C 7D7D 7F7F 7F80 7D80"            /* {}{|}{.|}}...} */
	$"7D81 8081 8081 8481 8383 8383 8483 8484"            /* } */
	$"8384 8484 8684 8585 8583 8483 8481 8583"            /*  */
	$"8481 8583 8185 8481 8081 8380 8383 8183"            /*  */
	$"8383 8381 8380 8180 7F80 7F7F 807F 7D7C"            /* ....}| */
	$"7C7D 7D7D 7F7B 7D7D 7D80 8080 8180 7F7D"            /* |}}}.{}}}.} */
	$"7D7F 7F7D 7D7C 7C7A 7B7A 7B7B 7F7B 7F84"            /* }..}}||z{z{{.{. */
	$"7880 807D 7D83 7B81 7D7F 7F80 8374 9572"            /* x}}{}..tr */
	$"8196 5973 7D92 4FAA 9681 6F8E 707A 7F73"            /* Ys}Oopz.s */
	$"8962 9976 8C85 7C7D 7772 8174 6691 737F"            /* bv|}wrtfs. */
	$"8E7A 8893 8395 9377 7D7A 788D 6D7A 8E84"            /* zw}zxmz */
	$"838E 8388 788C 887F 7889 8D8A 8185 8184"            /* x.x */
	$"8686 8081 8083 8886 867D 8585 7D7D 8A84"            /* }}} */
	$"8D8C 8E8C 8D85 8588 7A86 8480 8589 8A86"            /* z */
	$"8386 868D 898D 888C 888A 888E 808A 7F8A"            /* . */
	$"8385 7D8A 7F88 8886 8188 808C 8586 7D8A"            /* }.} */
	$"8389 8189 8484 8A86 8D83 868A 8489 848C"            /*  */
	$"8885 8989 8886 8689 8388 818A 838A 848A"            /*  */
	$"8588 8E84 8D91 7092 9167 9A89 7895 9963"            /* pgxc */
	$"AB77 909D 7497 738D 867F 7A83 8381 7B92"            /* wts.z{ */
	$"77A0 7A6D 8467 7F6F A35E AF5C B485 B85E"            /* wzmg.o^\^ */
	$"A24B C518 BA40 E700 FF44 BE6D 72AD 6061"            /* K.@...Dmr`a */
	$"966B 5585 A28A 8DB1 6D96 4997 8C85 8D6B"            /* kUmIk */
	$"A074 AF48 C631 9E36 8866 9D6D 8CB8 7B80"            /* tH16fm{ */
	$"BC6A 894F 9A77 2E8C 9659 39DA 69A3 4D99"            /* jOw.Y9.iM */
	$"5E6B CF13 CE47 AD42 9D42 A470 B872 5897"            /* ^k.GBBprX */
	$"7D56 C06A 7084 7B70 6696 8D6E 8A9F 7465"            /* }Vjp{pfnte */
	$"908D 617D 9A6F 6277 9544 9E70 9D42 B33F"            /* a}obwDpB? */
	$"9E6E 936A A05A 9A74 8A8A 6D80 7783 619A"            /* njZtmwa */
	$"9E55 8A8D 5DA8 6E7A 69A2 6E9F 3AAD 7A84"            /* U]nzin:z */
	$"7A6B 997B 8376 6389 A05C 9B6A 8176 967A"            /* zk{vc\jvz */
	$"8E5E 817D 847B 8C77 7780 8D81 8C65 7C84"            /* ^}{wwe| */
	$"8189 806B 845E A688 857D 8C7F 9173 817C"            /* k^}.s| */
	$"7B7F 9376 856D 977F 8386 7A73 8081 868A"            /* {.vm.zs */
	$"7B85 8C77 9284 8876 887D 7C88 7F88 7F84"            /* {wv}|.. */
	$"7490 7892 7D86 7A86 7F86 7788 7C83 817C"            /* tx}z.w|| */
	$"8678 8083 777B 8078 7870 8478 7F84 7786"            /* xw{xxpx.w */
	$"7F84 8573 8876 8078 8A74 7A80 7C7C 807A"            /* .svxtz||z */
	$"837A 7D78 856F 7A7C 7A80 7880 7C7B 7D7D"            /* z}xoz|zx|{}} */
	$"7B76 7B77 7C76 7A77 7A7D 767D 787A 7A78"            /* {v{w|vzwz}v}xzzx */
	$"7876 7678 7778 747B 787A 7677 7776 727A"            /* xvvxwxt{xzvwwvrz */
	$"7776 7876 767A 7A7F 7C83 7A80 787B 7D7A"            /* wvxvvzz.|zx{}z */
	$"867C 7D7B 8374 7F7B 777D 7A7A 7F7D 7B7D"            /* |}{t.{w}zz.}{} */
	$"7D78 7F80 7B7B 7D7F 7A85 7B85 8384 8381"            /* }x.{{}.z{ */
	$"8380 8681 8080 857D 8180 8481 8080 8480"            /* } */
	$"8183 7C83 8385 7F88 8181 8381 817C 867F"            /* |.|. */
	$"8683 8586 8885 8C85 858A 8583 8183 8485"            /*  */
	$"8183 8583 817F 8380 8480 7D88 8083 8584"            /* .} */
	$"7F88 8185 8581 8486 8884 8685 8585 8685"            /* . */
	$"8183 8681 8683 8583 8581 8684 8086 7F89"            /* . */
	$"8180 7D88 7C7F 807D 8180 7D83 7884 7B84"            /* }|.}}x{ */
	$"837C 7F83 7C7F 7C7D 8180 7C80 7F7D 7F7D"            /* |.|.|}|.}.} */
	$"7F78 7D7C 7D7F 7C7B 7C7F 7B7D 7C7C 7F7A"            /* .x}|}.|{|.{}||.z */
	$"7C7B 7B7C 7A7F 7A7D 777D 7D78 7C7C 7481"            /* |{{|z.z}w}}x||t */
	$"7D78 7876 7C81 7C7D 817C 837C 8577 847D"            /* }xxv||}||w} */
	$"7D7C 817F 7C7F 7F81 7C84 7B7F 7A7D 7D7C"            /* }|.|..|{.z}}| */
	$"8181 8085 837F 8188 8684 8483 8484 8383"            /* . */
	$"8481 8584 8684 8884 8D84 8988 8689 858C"            /*  */
	$"848D 8685 8881 8983 8884 8689 858C 8488"            /*  */
	$"8684 8184 8484 8488 8A83 8686 8584 8A86"            /*  */
	$"8883 8886 8185 8584 8481 8880 8186 8483"            /*  */
	$"8584 8485 8483 817F 8384 8181 8081 857D"            /* .} */
	$"8381 8384 8381 7D80 7F7F 7F7F 7B7B 8377"            /* }....{{w */
	$"7D78 777A 787A 737D 7A76 8077 7A80 7F78"            /* }xwzxzs}zvwz.x */
	$"807B 7D7C 7F7F 847B 837D 7D80 817C 807A"            /* {}|..{}}|z */
	$"7A7A 777C 747C 7378 777B 777A 7778 7C74"            /* zzw|t|sxw{wzwx|t */
	$"7477 7A78 7A76 777D 7678 7C78 7B78 7B77"            /* twzxzvw}vx|x{x{w */
	$"777A 7878 7377 7878 7A6F 7673 7877 7777"            /* wzxxswxxzovsxwww */
	$"7773 7A6D 767B 7376 7377 707C 7477 6F76"            /* wszmv{svswp|twov */
	$"7478 6F7B 7476 7878 767B 7B77 7B80 7876"            /* txo{tvxxv{{w{xv */
	$"8A62 896B 905D 925C 9677 9077 906D 957C"            /* bk]\wwm| */
	$"7880 806F 8977 7F73 8477 7D7A 8180 7786"            /* xow.sw}zw */
	$"807F 8688 857C 8980 7D8C 7783 7C7D 7D86"            /* .|}w|}} */
	$"7D80 8D7F 9083 8889 8686 8189 7B88 7D7D"            /* }.{}} */
	$"7786 7C7D 7C80 7A80 847C 7B84 7788 7883"            /* w|}|z|{wx */
	$"7B7F 7A7F 7281 8867 8885 6785 9076 7C78"            /* {.z.rggv|x */
	$"8473 7C81 7F74 7A80 7370 807C 737B 7D86"            /* s|.tzsp|s{} */
	$"6B8A 6297 7080 7A85 7A86 7781 707D 738A"            /* kbpzzwp}s */
	$"707B 7D78 7D7F 8077 7F7F 7881 7B7D 787B"            /* p{}x}.w..x{}x{ */
	$"7C7A 787B 837A 7C80 777C 7F88 7386 7A78"            /* |zx{z|w|.szx */
	$"847F 837F 807C 8970 8A77 8683 9184 7D89"            /* ..|pw} */
	$"7884 8383 848D 8386 7483 907B 8990 8192"            /* xt{ */
	$"6192 9185 936E 9E7F 788C 8485 9574 8C78"            /* an.xtx */
	$"837D 9783 8E6D 9A78 8D85 8E81 9385 9B7A"            /* }mxz */
	$"7F90 8A92 858D 8D86 8096 849D 7D9F 6E96"            /* .}n */
	$"9088 9B8E 8C7D 9976 A778 9B77 916F 9384"            /* }vxwo */
	$"8C86 8A85 8685 848C 8A8C 9089 8892 8990"            /*  */
	$"8989 8C83 908C 8E84 8881 837A 8E90 8A84"            /* z */
	$"9084 9186 8E86 8885 8A86 8A8C 868C 858C"            /*  */
	$"848A 8685 8686 8486 888A 8688 8184 8189"            /*  */
	$"8586 8180 8181 8484 8184 807D 8683 8085"            /* } */
	$"837C 8480 8381 7F86 8180 8483 8183 7D7D"            /* |.}} */
	$"7B80 817C 7F7D 7A7D 7F7B 7F7A 7D80 7B81"            /* {|.}z}.{.z}{ */
	$"7D80 817F 7D7D 817D 8080 7D7F 8480 8181"            /* }.}}}}. */
	$"7D81 7A7C 7C7C 7A86 7A83 807D 8080 8581"            /* }z|||zz} */
	$"8081 807C 8084 8080 8380 8183 817C 817B"            /* ||{ */
	$"7B80 7B7D 7B7F 7A7D 787D 7B77 7D7A 7C7B"            /* {{}{.z}x}{w}z|{ */
	$"787C 7B7D 7D7D 7F7D 817C 837F 817F 7C7D"            /* x|{}}}.}|..|} */
	$"7C81 7D7D 7F7D 7C7B 7C7A 787B 777B 7A78"            /* |}}.}|{|zx{w{zx */
	$"7A7A 7A77 7A77 7874 7778 777A 7C7A 7B7C"            /* zzzwzwxtwxwz|z{| */
	$"7A7A 7B7C 7B7A 7B78 787A 787A 7877 7774"            /* zz{|{z{xxzxzxwwt */
	$"7A7B 7D78 7B77 777B 7C76 777B 7B78 7C7B"            /* z{}x{ww{|vw{{x|{ */
	$"7A77 777A 7777 777A 7A7A 7B7C 7C7A 7C7B"            /* zwwzwwwzzz{||z|{ */
	$"7A7A 787A 787A 7D7B 7C7A 7B7A 7A77 787A"            /* zzxzxz}{|z{zzwxz */
	$"7877 7877 7778 7778 7677 7677 7678 7478"            /* xwxwwxwxvwvwvxtx */
	$"7477 7674 7878 787A 7777 7777 7878 787B"            /* twvtxxxzwwwwxxx{ */
	$"7A7C 7F80 8081 8083 807F 7F7F 7D7F 7D80"            /* z|....}.} */
	$"7D7F 7D7F 8080 807D 7F7D 7D7D 7D7D 7F7F"            /* }.}.}.}}}}}.. */
	$"7F80 7F7F 807F 7D80 7F7F 8381 8483 8484"            /* ....}.. */
	$"8483 8484 8486 8586 8586 8688 8889 8686"            /*  */
	$"8585 8484 8384 8384 8483 8485 8584 8483"            /*  */
	$"8483 8483 8585 8485 8584 8585 8383 8484"            /*  */
	$"8384 8585 8586 8686 8586 8485 8585 8586"            /*  */
	$"8684 8685 8685 8685 8585 8689 8888 8886"            /*  */
	$"8888 8886 8585 8684 8484 8384 8383 8381"            /*  */
	$"8181 8081 817F 7F81 8080 8080 8183 8181"            /* .. */
	$"8180 807F 817D 807F 7F7F 7F7F 7F7D 807F"            /* .}......}. */
	$"7D7F 7F7D 7D80 7F7F 7F7F 8080 8081 8183"            /* }..}}.... */
	$"8383 8384 8485 8586 8384 8381 8181 8180"            /*  */
	$"8383 8383 8381 8180 8380 8081 8081 807F"            /* . */
	$"7F7F 7F81 8083 8483 8484 8383 8483 8583"            /* ... */
	$"8081 8380 8180 807D 7C7D 7D80 7C83 7B80"            /* }|}}|{ */
	$"7A84 7B83 7A85 7B81 7D83 7B80 7D7D 7A7D"            /* z{z{}{}}z} */
	$"7F7A 7D7C 7D7A 7F7C 7F7A 7D7A 7C78 7C7B"            /* .z}|}z.|.z}z|x|{ */
	$"7B7A 7D7B 807D 7D7C 807F 7F7F 8180 7F7D"            /* {z}{}}|....} */
	$"8684 857F 7F7D 8484 7C7B 817F 8584 817C"            /* ..}|{.| */
	$"8486 8483 8384 8384 847F 8080 7F7C 7D7D"            /* ..|}} */
	$"7C7D 7D7D 7C7C 7F7F 7D7C 7D7D 7D7C 7D7C"            /* |}}}||..}|}}}|}| */
	$"7C7C 7F7C 7B7A 7C7C 7F7B 7D7D 807D 807C"            /* ||.|{z||.{}}}| */
	$"7F7F 807F 7F7D 807F 807F 7F7F 807D 807F"            /* ....}....}. */
	$"807F 7F7D 7D7D 807F 807D 8081 8181 8183"            /* ..}}}.} */
	$"8383 8381 8181 8181 8180 8080 7F7F 7D7D"            /* ..}} */
	$"7F7D 7D7F 7F7F 8181 8081 8181 8181 8081"            /* .}}... */
	$"8181 8183 8384 8384 8384 8385 8585 8484"            /*  */
	$"8483 8483 8384 8485 8585 8586 8585 8585"            /*  */
	$"8584 8585 8586 8688 8889 8888 8888 8689"            /*  */
	$"8989 8889 888A 8589 8886 8884 8685 8585"            /*  */
	$"8384 8485 8488 8585 8886 8586 8384 8383"            /*  */
	$"8184 8183 8080 8380 8180 8381 8184 8484"            /*  */
	$"8384 8385 8181 7D80 8083 8084 8081 8083"            /* } */
	$"8080 807F 807F 7F7F 8081 8181 8180 7F7F"            /* ...... */
	$"7F7F 7F7D 7D7C 7C7C 7D7C 7D7C 7D7D 7F7C"            /* ...}}|||}|}|}}.| */
	$"7D7C 7D7C 7B7B 7C7B 7C7C 7D7C 7C7C 7C7D"            /* }|}|{{|{||}||||} */
	$"7C7B 7B7B 7A7B 7B7A 7B7B 7A78 7877 7777"            /* |{{{z{{z{{zxxwww */
	$"7676 7474 7474 7476 7674 7473 7372 7070"            /* vvtttttvvttssrpp */
	$"726F 6F6F 7072 7273 7474 7677 7676 7474"            /* roooprrsttvwvvtt */
	$"7374 7473 7473 7474 7373 7374 7374 7476"            /* sttststtssststtv */
	$"7677 7878 787A 7B7A 7A77 7A78 7878 7877"            /* vwxxxz{zzwzxxxxw */
	$"7773 7473 7472 7474 7473 7374 7473 7374"            /* wststrtttssttsst */
	$"7474 7677 7677 7878 7878 7878 7878 787A"            /* ttvwvwxxxxxxxxxz */
	$"7A78 7878 7A78 787A 7A7C 7C7C 7D7F 7F7D"            /* zxxxzxxzz|||}..} */
	$"7F80 7F7F 7D80 7D7D 7F7F 8080 8084 8283"            /* ...}}}.. */
	$"8384 8484 8282 8280 8080 8082 8080 8082"            /*  */
	$"8282 8282 8383 8284 8483 8485 8484 8485"            /*  */
	$"8484 8484 8484 8586 8787 8786 8684 8484"            /*  */
	$"8484 8484 8484 8484 8485 8685 8787 8787"            /*  */
	$"8787 8787 8787 8787 8787 8788 898A 8A8A"            /*  */
	$"8B8B 8B8A 8A8A 8A8A 8A8A 8A8A 8A8A 8A8A"            /*  */
	$"8A8A 8989 8888 8888 8888 8889 8888 8989"            /*  */
	$"8989 8989 898A 8A8B 8B8A 8A8A 8A89 8887"            /*  */
	$"8787 8787 8787 8787 8787 8686 8686 8686"            /*  */
	$"8686 8685 8585 8585 8484 8383 8383 8484"            /*  */
	$"8484 8484 8484 8382 8282 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8282 8281 8181 8181"            /*  */
	$"8181 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F"            /* ................ */
	$"7F7F 7F7E 7E7D 7C7C 7C7C 7B7B 7A7A 7A7A"            /* ...~~}||||{{zzzz */
	$"7B7B 7B7B 7B7B 7B7B 7B7B 7B7B 7B7B 7B7B"            /* {{{{{{{{{{{{{{{{ */
	$"7B7B 7B7A 797A 7A79 7979 7979 7878 7878"            /* {{{zyzzyyyyyxxxx */
	$"7878 7878 7878 7979 7979 7979 7979 797A"            /* xxxxxxyyyyyyyyyz */
	$"7A7A 7A7A 7A7A 7A7A 7A7A 7A7A 7A7A 7B7B"            /* zzzzzzzzzzzzzz{{ */
	$"7B7B 7B7B 7B7B 7A7A 7A7A 7A7A 7A7A 7A7A"            /* {{{{{{zzzzzzzzzz */
	$"7A7A 7A7A 7A7A 7A7A 7A7B 7B7B 7B7B 7B7C"            /* zzzzzzzzz{{{{{{| */
	$"7D7D 7D7D 7D7D 7D7D 7C7C 7C7C 7C7C 7C7C"            /* }}}}}}}}|||||||| */
	$"7C7C 7C7C 7C7D 7D7E 7E7E 7E7E 7E7E 7E7E"            /* |||||}}~~~~~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~~~~~~~~~~~~~~~~ */
	$"7E7E 8080 8080 8080 8080 8080 8080 8080"            /* ~~ */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
};

data 'snd ' (257, "bonjour_in", purgeable) {
	$"0001 0001 0005 0000 0080 0001 8051 0000"            /* ...........Q.. */
	$"0000 0014 0000 0000 0000 4739 56EE 8BA3"            /* ..........G9V. */
	$"0000 0000 0000 0000 003C 8080 8182 8180"            /* .........< */
	$"8080 8080 8181 8180 8080 8080 8181 8181"            /*  */
	$"8080 8080 8181 8181 8282 8181 8182 8383"            /*  */
	$"8382 8282 8181 8182 8181 8180 8080 8181"            /*  */
	$"8181 8181 8282 8180 8080 8181 8182 8281"            /*  */
	$"8080 8182 8282 8283 8282 8181 8282 8384"            /*  */
	$"8485 8484 8484 8584 8484 8484 8586 8584"            /*  */
	$"8485 8687 8685 8585 8687 8786 8585 8585"            /*  */
	$"8585 8586 8685 8585 8586 8584 8383 8586"            /*  */
	$"8787 8684 8484 8586 8786 8686 8585 8484"            /*  */
	$"8485 8585 8686 8584 8383 8384 8586 8584"            /*  */
	$"8282 8282 8383 8384 8382 8180 8081 8283"            /*  */
	$"8281 8180 8080 8080 8182 8281 8080 8080"            /*  */
	$"807F 7F80 8182 8180 7F80 8081 8283 8382"            /* ... */
	$"8281 8182 8283 8282 8283 8484 8382 8282"            /*  */
	$"8283 8483 8281 8183 8485 8483 8383 8484"            /*  */
	$"8484 8585 8685 8483 8383 8383 8484 8484"            /*  */
	$"8382 8282 8283 8382 8181 8283 8282 8282"            /*  */
	$"8283 8383 8383 8282 8282 8282 8282 8282"            /*  */
	$"8281 8080 8081 8181 8180 807F 8080 8180"            /* . */
	$"8080 8080 8080 8080 8182 8281 8181 8181"            /*  */
	$"8182 8383 8382 8282 8283 8484 8383 8383"            /*  */
	$"8383 8485 8586 8685 8585 8585 8586 8686"            /*  */
	$"8685 8484 8586 8787 8685 8585 8585 8685"            /*  */
	$"8585 8585 8483 8283 8485 8686 8584 8484"            /*  */
	$"8485 8483 8384 8585 8483 8384 8484 8485"            /*  */
	$"8685 8483 8384 8585 8585 8585 8484 8483"            /*  */
	$"8383 8484 8383 8282 8283 8485 8483 8181"            /*  */
	$"8282 8282 8282 8282 8281 8080 8081 8180"            /*  */
	$"8080 8080 8080 8080 8080 8081 8080 8080"            /*  */
	$"8081 8180 8080 807F 7E7F 8080 7F7E 7E7E"            /* .~..~~~ */
	$"7E7D 7E7E 7E7D 7D7D 7D7D 7D7D 7D7C 7C7D"            /* ~}~~~}}}}}}}}||} */
	$"7D7D 7C7C 7C7D 7D7C 7C7D 7D7D 7D7C 7C7D"            /* }}|||}}||}}}}||} */
	$"7E7E 7E7E 7D7C 7D7E 7E7E 7D7D 7D7D 7E7E"            /* ~~~~}|}~~~}}}}~~ */
	$"7E7F 7F80 8081 8181 8080 7F80 807F 8080"            /* ~.... */
	$"807F 7E7F 8080 8080 8080 7F7F 7E7D 7E7F"            /* .~...~}~. */
	$"7F7F 7F7E 7E7E 7D7D 7D7E 7E7E 7D7D 7D7D"            /* ...~~~}}}~~~}}}} */
	$"7D7D 7C7C 7D7F 7F7E 7D7D 7D7E 7E7E 7D7D"            /* }}||}..~}}}~~~}} */
	$"7D7D 7D7D 7C7C 7D7D 7D7C 7D7D 7E7E 7D7C"            /* }}}}||}}}|}}~~}| */
	$"7D7D 7E7E 7E7E 7D7D 7D7E 7F80 807F 7F7E"            /* }}~~~~}}}~...~ */
	$"7D7D 7D7D 7E7F 8080 7F7E 7E7D 7D7E 7F80"            /* }}}}~..~~}}~. */
	$"8080 7F7E 7E7F 8081 8181 8282 8180 8181"            /* .~~. */
	$"8283 8383 8281 8182 8282 8282 8382 8282"            /*  */
	$"8281 8180 8080 8283 8382 8180 8081 8384"            /*  */
	$"8382 8282 8282 8383 8383 8383 8384 8383"            /*  */
	$"8283 8485 8685 8483 8283 8586 8686 8686"            /*  */
	$"8686 8686 8788 8989 8887 8787 8787 8788"            /*  */
	$"8989 8989 8887 8788 8889 8989 8989 8988"            /*  */
	$"8889 8B8C 8C8B 8B8A 8A8A 8B8C 8C8C 8C8C"            /*  */
	$"8C8D 8D8D 8D8C 8C8E 8F8F 8E8D 8C8C 8D8F"            /*  */
	$"9090 8E8E 8E8F 8F90 8F8F 8F90 9090 8F8F"            /*  */
	$"8E8E 8E8F 9090 8F8E 8D8D 8D8E 8F90 8F8F"            /*  */
	$"8F8F 8F8F 8F90 9091 9292 9291 9191 9192"            /*  */
	$"9394 9595 9595 9597 9899 9897 9798 9999"            /*  */
	$"9998 9898 999A 9B9A 9999 9A9B 9C9B 9A9A"            /*  */
	$"9B9C 9D9E 9D9D 9D9D 9FA0 A09F 9FA0 A1A1"            /*  */
	$"A1A2 A2A2 A2A2 A2A3 A3A4 A3A3 A4A4 A5A5"            /*  */
	$"A4A4 A4A4 A4A3 A3A3 A3A2 A1A1 A1A2 A1A0"            /*  */
	$"9E9D 9D9D 9C9A 9998 9797 9695 9290 8F8F"            /*  */
	$"908E 8B88 8684 8483 8382 807D 7B7A 7977"            /* }{zyw */
	$"7573 7271 6F6D 6B68 6664 6260 5F5D 5B59"            /* usrqomkhfdb`_][Y */
	$"5756 5452 4F4E 4C4A 4746 4543 413E 3C3A"            /* WVTRONLJGFECA><: */
	$"3937 3634 3230 2F2D 2B29 2726 2523 2221"            /* 976420/-+)'&%#"! */
	$"1F1D 1B1A 1919 1816 1514 1313 1212 1211"            /* ................ */
	$"1111 1010 1010 1011 1212 1212 1111 1212"            /* ................ */
	$"1314 1515 1516 1719 191A 1B1D 1D1D 1D1E"            /* ................ */
	$"1F20 2123 2526 2728 292A 2B2C 2E2F 3031"            /* . !#%&'()*+,./01 */
	$"3334 3535 3536 383B 3D3D 3D3D 3E3F 4042"            /* 3455568;====>?@B */
	$"4343 4445 4648 4848 494A 4C4E 4F4F 5050"            /* CCDEFHHHIJLNOOPP */
	$"5051 5253 5557 5959 5958 5859 5B5D 5E5F"            /* PQRSUWYYYXXY[]^_ */
	$"5F5F 5E5F 6061 6162 6364 6565 6564 6566"            /* __^_`aabcdeeedef */
	$"6869 6A6A 6A69 6A6B 6C6C 6D6E 6F70 6F6E"            /* hijjjijkllmnopon */
	$"6F6F 6F70 7171 7272 7272 7272 7374 7576"            /* ooopqqrrrrrrstuv */
	$"7675 7475 7576 7676 7778 7979 7978 7878"            /* vutuuvvvwxyyyxxx */
	$"797B 7D7D 7C7B 7B7B 7C7D 7D7D 7D7E 7F80"            /* y{}}|{{{|}}}}~. */
	$"8080 8080 8182 8383 8383 8383 8586 8686"            /*  */
	$"8687 8889 898A 8A8A 8B8D 8E8F 8F8F 8F90"            /*  */
	$"9192 9394 9495 9595 9698 999A 9A9A 9B9C"            /*  */
	$"9C9C 9C9D 9EA0 A2A3 A3A2 A2A2 A4A5 A7A8"            /*  */
	$"A7A7 A7A8 A9AA ABAB ABAC ADAE AFB0 AFAF"            /*  */
	$"AFB1 B3B4 B3B3 B3B5 B6B7 B8B8 B8B8 B9BB"            /*  */
	$"BCBC BCBB BBBC BCBD BEBE BEBD BDBD BEBE"            /*  */
	$"BEBE BEBE BFBF BEBE BEBE BFC0 C0BF BEBE"            /*  */
	$"BEBE BFC0 BFBE BEBE BEBE BFC0 BFBD BDBD"            /*  */
	$"BDBC BBBB BBBB BBBC BCBB BAB9 B9BB BCBB"            /*  */
	$"BAB9 B8B8 B8B8 B8B7 B5B4 B4B5 B5B4 B2B1"            /*  */
	$"B1B2 B1B1 B1B0 AFAF AFAF AEAD ADAC ACAC"            /*  */
	$"ACAC ABAA A9A8 A8A9 AAA9 A8A7 A7A7 A8A8"            /*  */
	$"A9A8 A7A6 A6A7 A7A7 A6A5 A5A5 A6A5 A4A2"            /*  */
	$"A2A3 A4A4 A3A1 A0A0 A0A0 A1A1 A1A0 9F9E"            /*  */
	$"9E9E 9D9C 9C9C 9D9C 9B9A 9998 9897 9797"            /*  */
	$"9695 9494 9494 9393 9392 9191 9191 908F"            /*  */
	$"8E8C 8C8C 8C8C 8B89 8988 8887 8787 8787"            /*  */
	$"8686 8584 8383 8383 8483 8280 8080 8080"            /*  */
	$"8080 7E7D 7C7D 7E7E 7E7E 7F80 8080 8080"            /* ~}|}~~~~. */
	$"8181 8283 8483 8282 8282 8283 8384 8485"            /*  */
	$"8585 8585 8587 8889 8989 8A8A 8B8B 8B8B"            /*  */
	$"8B8A 8A8B 8C8C 8B8A 8A8C 8D8E 8F8F 8E8D"            /*  */
	$"8D8D 8E8D 8C8C 8D8C 8884 8285 8885 8181"            /*  */
	$"8483 817F 7D7D 7E80 8181 8180 7E7E 7E7E"            /* .}}~~~~~ */
	$"7E7E 7E7D 7C7C 7C7B 7978 7878 7675 7475"            /* ~~~}|||{yxxxvutu */
	$"7575 7677 7777 7675 7575 7573 7170 7172"            /* uuvwwwvuuuusqpqr */
	$"7272 7171 7172 7375 7574 7373 7372 706E"            /* rrqqqrsuutsssrpn */
	$"6E6E 6D6C 6B6C 6D6C 6A69 6A6B 6B6B 6B6B"            /* nnmlklmljijkkkkk */
	$"6A69 6869 6B6B 6A67 6564 6565 6564 6364"            /* jihikkjgedeeedcd */
	$"6668 6969 6767 696B 6C6C 6C6C 6C6B 6B6B"            /* fhiiggiklllllkkk */
	$"6B6A 6968 696B 6B6A 6A69 6A6B 6C6C 6C6B"            /* kjihikkjjijklllk */
	$"6B6C 6C6B 6B6B 6C6C 6C6C 6B6C 6C6D 6E6E"            /* kllkkkllllkllmnn */
	$"6F70 7171 7172 7272 7374 7472 7170 7070"            /* opqqqrrrsttrqppp */
	$"706F 6D6C 6B6A 6A69 6866 6565 6563 6261"            /* pomlkjjihfeeecba */
	$"605F 5E5D 5C5C 5B5A 5A5B 5C5B 5A5B 5B5B"            /* `_^]\\[ZZ[\[Z[[[ */
	$"5B5C 5D5D 5E5E 5E5E 5F61 6262 6263 6465"            /* [\]]^^^^_abbbcde */
	$"6667 6868 6768 6969 6867 6767 6767 6765"            /* fghhghiihgggggge */
	$"6362 6162 6465 6463 6262 6365 6768 6A6A"            /* cbabdedcbbceghjj */
	$"6A6A 6B6B 6C6C 6C6C 6D6E 6E6C 6A69 6A6B"            /* jjkkllllmnnljijk */
	$"6C6C 6C6C 6C6D 6F71 7477 797C 7F81 8485"            /* lllllmoqtwy|. */
	$"8586 8687 8788 8887 8482 8080 8080 8081"            /*  */
	$"8182 8487 8A8C 8F91 9599 9EA1 A2A2 A1A0"            /*  */
	$"A0A1 A19F 9B96 9391 8F8D 8B89 8787 898B"            /*  */
	$"8C8C 8C8F 9396 9798 999A 9A9B 9B9C 9D9C"            /*  */
	$"9997 9695 9493 9190 8F8E 8D8D 8D8C 8C8C"            /*  */
	$"8C8C 8D8E 8E8D 8C8B 8B8D 8E8D 8C8B 8C8D"            /*  */
	$"8D8C 8B89 8989 8988 8786 8482 807F 7E7D"            /* .~} */
	$"7C7B 7B7B 7B7A 7979 7A7B 7B7B 7A7A 7A7A"            /* |{{{{zyyz{{{zzzz */
	$"7A79 7877 7777 7674 7271 7171 706F 6E6D"            /* zyxwwwvtrqqqponm */
	$"6C6C 6C6C 6B6A 6A6B 6C6D 6D6C 6B6B 6C6E"            /* llllkjjklmmlkkln */
	$"6E6D 6C6B 6C6E 6E6E 6C6B 6A6A 6A6A 6865"            /* nmlklnnnlkjjjjhe */
	$"6362 6263 6363 6362 6163 6669 6B6C 6D6D"            /* cbbccccbacfiklmm */
	$"6E70 7274 7676 7677 797B 7B7A 797A 7B7B"            /* nprtvvvwy{{zyz{{ */
	$"7C7D 7E80 8283 8587 8A8D 9196 9A9D A1A5"            /* |}~ */
	$"A9AD B2B6 BBC0 C5C9 CED2 D5D8 DCE1 E5E6"            /* .... */
	$"E7E6 E6E6 E6E2 D9CB B9A4 9282 7463 4F37"            /* .......˹tcO7 */
	$"1F0D 0300 0000 0000 0000 0715 212B 3646"            /* ...........!+6F */
	$"5A6E 808C 949A A0A4 A6A3 9C93 8A81 7971"            /* Znyq */
	$"675B 4E43 3C3A 3939 393A 3C41 474F 5962"            /* g[NC<:999:<AGOYb */
	$"6A72 7B85 8E94 989B 9D9F A1A3 A3A2 A09D"            /* jr{ */
	$"9998 9898 9796 9697 989A 9C9E 9FA1 A3A6"            /*  */
	$"A7A9 ABAC ABAA AAAA AAA9 A7A4 A19E 9C9A"            /*  */
	$"9895 9290 8E8D 8D8C 8B8B 8B8C 8D8D 8C8B"            /*  */
	$"8B8C 8E91 9392 9191 9396 999C 9D9E 9FA1"            /*  */
	$"A3A6 A7A8 A8A8 AAAD B1B4 B7B9 BBBE C1C5"            /*  */
	$"C9CB CED2 D7DD E3E8 ECF1 FAFF FFFF FFFF"            /* ........... */
	$"FFFF FFFF FFFF FFFA EDDB C8B5 A597 8979"            /* ..........ȵy */
	$"6859 4E47 4441 3D3A 3A3C 4249 5158 6066"            /* hYNGDA=::<BIQX`f */
	$"6C6F 706F 6E6B 6660 584E 4234 2515 0600"            /* loponkf`XNB4%... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0003 0A10 161D"            /* ................ */
	$"2329 2D30 3336 393A 3C3C 3D3D 3E40 4244"            /* #)-0369:<<==>@BD */
	$"4749 4B4D 4E51 5457 5B5D 5F61 6468 6B6D"            /* GIKMNQTW[]_adhkm */
	$"6F70 7173 7577 7878 7778 797B 7D7E 7F81"            /* opqsuwxxwxy{}~. */
	$"8488 8D91 979D A5AD B5BD C5CE D8E3 EDF7"            /* ... */
	$"FEFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ................ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFF2 D8BF"            /* ..............ؿ */
	$"A68D 7256 3D29 1C13 0A03 0000 0005 101C"            /* rV=).......... */
	$"2834 404D 5962 6A70 7478 7A7B 7974 6E68"            /* (4@MYbjptxz{ytnh */
	$"625B 554D 4640 3B37 3431 3132 3335 373A"            /* b[UMF@;74112357: */
	$"3E42 4649 4B4D 4E4F 5050 504E 4C4B 4948"            /* >BFIKMNOPPPNLKIH */
	$"4644 4241 4041 4243 4444 4445 4647 4847"            /* FDBA@ABCDDDEFGHG */
	$"4440 3C37 332F 2923 1D17 100A 0401 0000"            /* D@<73/)#........ */
	$"0000 0000 050F 1A22 262A 313D 4A54 5859"            /* ......."&*1=JTXY */
	$"595D 6366 6460 5B57 5654 514B 4540 3D3C"            /* Y]cfd`[WVTQKE@=< */
	$"3D3D 3C3D 3F42 4548 4D52 565B 5F63 6669"            /* ==<=?BEHMRV[_cfi */
	$"6C6F 7171 7274 7678 7878 7778 797A 7C7F"            /* loqqrtvxxxwxyz|. */
	$"8183 878B 9095 9A9F A3A7 ACB0 B4B7 B8B9"            /*  */
	$"BABB BCBC BDBC BCBB BABA BABC BDBE BFC1"            /*  */
	$"C4C8 CDD2 D7DC E0E1 DFDA D3CA C2B9 AD9C"            /* .....¹ */
	$"8874 6254 483B 2E21 1611 1115 1B1F 242B"            /* tbTH;.!......$+ */
	$"3542 5262 6F7B 858F 99A1 A7AB ADAD ACAA"            /* 5BRbo{ */
	$"A7A2 9B94 8E88 8480 7D7A 7877 7779 7C7F"            /* }zxwwy|. */
	$"8387 8B8F 9396 999B 9D9E 9F9F 9E9E 9E9D"            /*  */
	$"9C9B 9B9B 9D9F A1A4 A8AC B0B4 BABF C2C5"            /*  */
	$"C6C8 CACB CAC6 C1BA B3AC A59D 958D 857F"            /* . */
	$"7973 6F6E 6E70 7275 797F 8891 989E A2A6"            /* ysonnpruy. */
	$"ACB2 B7B9 B8B6 B4B2 B1AE AAA6 A29F 9E9E"            /*  */
	$"9E9E 9EA0 A3A8 AEB4 BABF C4C9 CED4 D9DE"            /* .. */
	$"E1E4 E6E8 EBEC EDEE EFF1 F3F5 F8FC FEFF"            /* ................ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ................ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ................ */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ................ */
	$"F8EA DDD1 C5BA B0AA A7A8 AAAD AEB0 B3BA"            /* ...ź */
	$"C3CC D2D7 DCE2 E7EA EAE7 E2DE DBD8 D4CF"            /* ......... */
	$"C9C2 BCB7 B3AF ACAA A8A7 A6A4 A4A3 A2A0"            /* ¼ */
	$"9E9D 9B9A 9895 908C 8884 8280 7D7C 7B7B"            /* }|{{ */
	$"7C7C 7D80 8387 8C90 9498 9C9F A0A1 A2A3"            /* ||} */
	$"A2A1 A09D 9A96 938F 8C8A 8887 8786 8584"            /*  */
	$"8484 8587 8889 8989 8887 8684 817F 7C79"            /* .|y */
	$"7673 6F6B 6764 6261 605F 5E5E 5E5F 5F60"            /* vsokgdba`_^^^__` */
	$"6060 6161 6161 6160 5F5E 5D5C 5B5A 5959"            /* ``aaaaa`_^]\[ZYY */
	$"595A 5B5C 5E61 6467 6A6D 7174 787B 7D80"            /* YZ[\^adgjmqtx{} */
	$"8283 8587 898C 8E90 9295 989B 9EA0 A4A7"            /*  */
	$"ABAE B1B4 B6B8 B9BB BDBF C2C3 C4C6 C8CA"            /*  */
	$"CDD0 D2D1 CEC9 C2B9 B0A6 9C92 8679 6C5F"            /* ¹yl_ */
	$"534A 433E 3834 3233 373C 4146 4B52 5961"            /* SJC>84237<AFKRYa */
	$"686D 7175 7778 7876 7370 6C68 6461 5E5A"            /* hmquwxxvsplhda^Z */
	$"5754 5150 4F4F 5050 5050 504F 4F4E 4E4D"            /* WTQPOOPPPPPOONNM */
	$"4B49 4745 4340 3E3D 3C3C 3D40 4346 494C"            /* KIGEC@>=<<=@CFIL */
	$"5156 5A5E 6367 6A6C 6C6B 6967 6563 605C"            /* QVZ^cgjllkigec`\ */
	$"5854 514F 4D4C 4B4A 4B4D 4F51 5254 575A"            /* XTQOMLKJKMOQRTWZ */
	$"5D5F 6060 6061 6161 5F5D 5B59 5856 5554"            /* ]_```aaa_][YXVUT */
	$"5353 5353 5455 5658 5A5B 5C5D 5E60 6060"            /* SSSSTUVXZ[\]^``` */
	$"6060 6060 6161 6162 6364 6667 696B 6C6E"            /* ````aaabcdfgikln */
	$"7174 7679 7B7E 8082 8486 898B 8D8E 9092"            /* qtvy{~ */
	$"9496 989A 9C9F A3A6 A9AB AEB0 B2B4 B6B7"            /*  */
	$"B8B9 BABA BBBB BBBA BABB BDC1 C7CC D1D4"            /*  */
	$"D5D3 CEC5 BAAF A59C 9285 7563 5144 3B33"            /* źucQD;3 */
	$"2C25 201F 2328 2D30 3236 3D46 4D52 5456"            /* ,% .#(-026=FMRTV */
	$"5859 5754 4E47 423D 3934 302D 2926 2220"            /* XYWTNGB=940-)&"  */
	$"1F20 2224 2423 2120 1E1C 1A17 1412 1110"            /* . "$$#! ........ */
	$"0F0E 0E0F 1114 1A21 2930 373E 464E 565D"            /* .......!)07>FNV] */
	$"6367 6B6D 6E6E 6C6A 6864 605C 5855 5251"            /* cgkmnnljhd`\XURQ */
	$"504F 4E4E 4F52 5456 5655 5555 5553 4F4C"            /* PONNORTVVUUUUSOL */
	$"4A48 4541 3E3B 3836 3534 3537 393A 3B3C"            /* JHEA>;8654579:;< */
	$"3E40 4243 4445 4646 4748 4849 4A4C 4E51"            /* >@BCDEFFGHHIJLNQ */
	$"555A 5E63 676C 7177 7C82 878C 9093 9698"            /* UZ^cglqw| */
	$"9B9D A0A2 A4A6 A8AB AEB1 B5B9 BEC3 C9D0"            /*  */
	$"D6DC E1E4 E6E8 E9E9 E8E7 E5E4 E4E4 E3E2"            /* ............... */
	$"E2E2 E4E7 EAED EEF0 F2F6 FAFE FFFE FBF5"            /* ................ */
	$"EDE3 D7CB BFB5 AA9D 9083 7870 6C6A 6867"            /* ..˿xpljhg */
	$"696C 7176 7C80 8384 8586 8685 8380 7D79"            /* ilqv|}y */
	$"7570 6B68 6766 6566 6769 6B6D 6F70 7171"            /* upkhgfefgikmopqq */
	$"7171 6F6C 6864 605B 5752 4E4B 4A4A 4A4B"            /* qqolhd`[WRNKJJJK */
	$"4D50 5459 5E62 676C 7074 7678 7878 7775"            /* MPTY^bglptvxxxwu */
	$"7370 6D6A 6967 6665 6565 6668 6B6D 6F6F"            /* spmjigfeeefhkmoo */
	$"7071 7171 706E 6B67 6461 5E5C 5A59 5857"            /* pqqqpnkgda^\ZYXW */
	$"5859 5A5B 5D5F 6061 6264 6565 6563 6261"            /* XYZ[]_`abdeeecba */
	$"605F 5E5D 5C5C 5C5C 5D5F 6164 6669 6B6D"            /* `_^]\\\\]_adfikm */
	$"6F70 7172 7272 7272 7373 7475 7677 797C"            /* opqrrrrrsstuvwy| */
	$"8083 868A 8D90 9396 989B 9D9F A0A1 A1A1"            /*  */
	$"A2A2 A3A4 A5A7 A9AB AEB1 B3B5 B6B7 B8BA"            /*  */
	$"BBBC BDBC BBBB BCBE C0C3 C4C5 C4C2 BDB6"            /* ½ */
	$"AFA7 9F96 8D82 786E 655E 5954 504C 4949"            /* xne^YTPLII */
	$"4A4D 5054 5658 5A5A 5B5B 5B5B 5B5A 5958"            /* JMPTVXZZ[[[[[ZYX */
	$"5758 5859 5A5C 5F62 6569 6C6F 7274 7474"            /* WXXYZ\_beilorttt */
	$"7372 706F 6D69 6663 6261 605F 5E5F 6164"            /* srpomifcba`_^_ad */
	$"676A 6D70 7376 797B 7D7E 8080 8080 7E7D"            /* gjmpsvy{}~~} */
	$"7C7B 7B7A 7979 7879 7B7C 7D7F 8081 8180"            /* |{{zyyxy{|}. */
	$"7F7E 7C79 7775 7370 6E6C 6B6A 6A69 6969"            /* .~|ywuspnlkjjiii */
	$"696A 6B6C 6D6D 6D6D 6D6D 6C6B 6A69 6969"            /* ijklmmmmmmlkjiii */
	$"6969 6A6B 6C6D 6F71 7374 7678 797B 7C7D"            /* iijklmoqstvxy{|} */
	$"7F80 8081 8183 8486 888B 8D90 9498 9C9F"            /* . */
	$"A2A5 A7AB AEB1 B3B5 B7B9 BABB BCBD BEBF"            /*  */
	$"BFC0 C2C3 C5C6 C7C8 C8C9 CBCC CED0 D3D4"            /*  */
	$"D6D7 D8D9 D9D9 DADC DEDF DEDD DAD6 D0C6"            /* .......... */
	$"BBB2 ABA5 9E97 9491 8C87 8587 8988 8481"            /*  */
	$"8081 807D 7B7A 7977 7371 7070 6E6D 6D70"            /* }{zywsqppnmmp */
	$"7375 787B 7E80 8183 8486 8786 837F 7E80"            /* sux{~.~ */
	$"817F 7A78 7673 6F6D 6C6C 6B6A 6B6E 6F6F"            /* .zxvsomllkjknoo */
	$"6D6D 6E6E 6C6B 6A6A 6A69 6867 6665 6463"            /* mmnnlkjjjihgfedc */
	$"6363 6263 6465 6666 6565 6463 6260 5F5D"            /* ccbcdeffeedcb`_] */
	$"5B59 5856 5554 5352 504F 4E4D 4C4C 4C4C"            /* [YXVUTSRPONMLLLL */
	$"4B4A 4948 4847 4747 4748 494A 4C4E 5052"            /* KJIHHGGGGHIJLNPR */
	$"5456 5859 5B5D 5F61 6264 6566 6667 6869"            /* TVXY[]_abdeffghi */
	$"6A6B 6D6F 7274 7677 7A7D 7F80 8183 8689"            /* jkmortvwz}. */
	$"8A8C 9095 9795 9293 9495 9495 9591 8D8F"            /*  */
	$"979B 9999 A2B1 BCBF BEBD BEBA B3AD ABAB"            /*  */
	$"AAAA AEB3 B7B9 BAC0 C6C5 BEBC C1C7 C5BC"            /* žż */
	$"B7B6 B6B1 AAA3 9E9B 9691 8C8B 8A89 8787"            /*  */
	$"8787 8786 8685 8380 7D7A 7875 716E 6C6C"            /* }zxuqnll */
	$"6B6A 6A6C 7174 7678 7C80 8181 8182 827F"            /* kjjlqtvx|. */
	$"7B78 7674 716F 6E6D 6D6D 6E6F 7070 7172"            /* {xvtqonmmmnoppqr */
	$"7373 7271 706F 6D6B 6A68 6664 6261 6061"            /* ssrqpomkjhfdba`a */
	$"6162 6364 6566 6869 6969 6969 6969 6969"            /* abcdefhiiiiiiiii */
	$"6968 6867 6767 6767 6869 696A 6A6A 6B6B"            /* ihhggggghiijjjkk */
	$"6B6B 6A69 6867 6768 6969 6A6C 6D6E 6F70"            /* kkjihgghiijlmnop */
	$"7172 7374 7473 7475 777B 7F81 7E77 7272"            /* qrsttstuw{.~wrr */
	$"777B 7A77 7982 8B8A 807A 8495 978A 8089"            /* w{zwyz */
	$"9BA1 9892 969A 9389 888B 8780 8598 A39C"            /*  */
	$"959E AFB6 B2AF B2AF A197 9BA2 A099 9AA1"            /*  */
	$"A3A0 9FA3 A9AF B3B4 B3B2 B2AF A9A6 A5A5"            /*  */
	$"A4A2 9C97 9698 9997 928C 8A8D 8F89 8282"            /*  */
	$"8686 7E73 7073 746F 6C6C 6E6E 6C6C 6D6C"            /* ~spstollnnllml */
	$"6A68 6A6F 7170 6E6E 7172 7170 7173 7576"            /* jhjoqpnnqrqpqsuv */
	$"7778 7878 797A 7A79 797B 7D7F 7F7E 7E7F"            /* wxxxyzzyy{}..~~. */
	$"8080 8080 807F 7E7D 7C7B 7978 7675 7473"            /* .~}|{yxvuts */
	$"7374 7677 7675 7678 7878 7879 7978 7574"            /* stvwvuvxxxxyyxut */
	$"7476 7777 7778 7979 7878 797C 7E7E 7D7D"            /* tvwwwxyyxxy|~~}} */
	$"7E7E 7D7E 8183 8281 8388 8986 8280 8184"            /* ~~}~ */
	$"8A91 938E 8582 888D 8B88 8D98 9F97 8885"            /*  */
	$"929B 9282 8397 A5A0 9599 A9B0 A495 98A7"            /*  */
	$"AEA7 A1A5 ADAD A398 98A3 B5BF BAAC A3A7"            /*  */
	$"B3B6 A99E A7BC C2B3 A4AF C6C8 A98A 8BA8"            /* ³ȩ */
	$"BBAE 9593 ADC2 BAA7 A8B8 BBA9 999E AEB0"            /* º */
	$"A297 9CA7 A598 9092 9796 918F 949A 9992"            /*  */
	$"8985 8481 7A71 6E72 7673 6E6C 6F71 6C67"            /* zqnrvsnloqlg */
	$"686E 7370 6967 696C 6B68 6869 6865 6262"            /* hnspigilkhhihebb */
	$"6261 6061 666C 6D69 686D 7371 6B69 6D70"            /* ba`aflmihmsqkimp */
	$"6E69 6767 6663 605F 5D5B 595C 6060 5D59"            /* niggfc`_][Y\``]Y */
	$"595B 5D5C 5856 575A 5A58 5552 5151 5255"            /* Y[]\XVWZZXURQQRU */
	$"595A 5957 565A 5F63 6361 6060 6265 6560"            /* YZYWVZ_cca``bee` */
	$"5A59 5F66 6A6A 6B71 7676 6E68 6C71 6B5E"            /* ZY_fjjkqvvnhlqk^ */
	$"5F73 827D 6D67 6E73 726E 6C6C 6F72 7375"            /* _s}mgnsrnllorsu */
	$"7B82 847A 6F73 8185 796E 778B 9288 899E"            /* {zosynw */
	$"A588 686A 8694 8576 8099 A297 9097 A09F"            /* hjv */
	$"9C9E 9F96 8F92 9791 8480 8C9A 998D 8EA1"            /*  */
	$"AEA5 9798 A5AB A296 969F A39B 9090 9796"            /*  */
	$"8B87 939F 9A90 929C 9B8E 858A 8F86 746B"            /* tk */
	$"6F72 695E 616F 7873 6D70 7877 6B61 636A"            /* ori^aoxsmpxwkacj */
	$"6659 5259 6463 5C5B 646B 6965 666D 706C"            /* fYRYdc\[dkiefmpl */
	$"6A6E 7371 6964 666A 6A67 676A 6D6D 6D70"            /* jnsqidfjjggjmmmp */
	$"7273 7270 6E6D 6B67 625D 5B5C 5D5C 5A59"            /* rsrpnmkgb][\]\ZY */
	$"595A 5855 5459 5F63 6260 6062 6361 5E5D"            /* YZXUTY_cb``bca^] */
	$"5F60 5E5D 6062 6263 696E 6F6E 7177 7871"            /* _`^]`bbcinonqwxq */
	$"6B6D 7375 706F 7880 7B6C 6875 8180 7470"            /* kmsupox{lhutp */
	$"7A82 7966 6173 8279 6567 7F8E 8270 7488"            /* zyfasyeg.pt */
	$"9082 7479 8588 7F74 7178 8186 8689 9196"            /* ty.tqx */
	$"9898 9894 8F8E 8F8F 9091 8F8B 8E9B A9AD"            /*  */
	$"A394 8E98 A5A4 9A96 9CA3 A29F A3AF B5A6"            /*  */
	$"908E A2B1 AA9E A5B8 BBA9 99A2 B3AD 907C"            /* | */
	$"889E 9F8B 7F87 9188 7776 8592 8D7E 7881"            /* .wv~x */
	$"8984 7972 7375 726C 696B 6D6E 6D6D 7178"            /* yrsurlikmnmmqx */
	$"7C7B 7675 7B82 837F 7B7E 807F 7976 7779"            /* |{vu{.{~.yvwy */
	$"7978 7A7E 807F 8083 8584 807D 7B78 746E"            /* yxz~.}{xtn */
	$"6966 6361 5F5E 5D5D 5E5F 6061 6160 5F60"            /* ifca_^]]^_`aa`_` */
	$"6363 5F5A 585B 5E5C 5A5E 6567 6363 6A71"            /* cc_ZX[^\Z^egccjq */
	$"6F67 656C 7473 6D6D 7477 7066 6469 6961"            /* ogeltsmmtwpfdiia */
	$"5B62 6F77 7677 7D80 7C75 6F64 5754 606E"            /* [bowvw}|uodWT`n */
	$"7069 666C 7471 6662 738B 9485 7374 848A"            /* pifltqfbsst */
	$"7B6D 7585 8679 7684 959D A0A8 AB9F 9095"            /* {muyv */
	$"A7AB 9B8F 99A8 A598 97A8 B6B5 B0BA CED6"            /*  */
	$"C7B3 B1BF C8BF B1B3 C1C5 B7A6 A7B5 BAAE"            /* ǳȿŷ */
	$"A1A7 B7BA A998 969D 9C91 8989 8A85 7E7D"            /* ~} */
	$"8186 8580 7A76 7573 6F6D 6D6F 7170 6E6E"            /* zvusommoqpnn */
	$"7174 736F 6D6F 7374 7475 7778 7676 797A"            /* qtsomosttuwxvvyz */
	$"7774 7477 7875 706F 7274 7069 6564 6360"            /* wttwxuportpiedc` */
	$"5B58 5756 514C 4A4A 4A46 403C 3D41 403C"            /* [XWVQLJJJF@<=A@< */
	$"3A3D 4345 4240 444A 4D4B 4848 4A4E 5050"            /* :=CEB@DJMKHHJNPP */
	$"5154 5859 5A5D 656E 7371 6F71 7372 6D67"            /* QTXYZ]ensqoqsrmg */
	$"676B 7073 797F 8180 7A70 6967 6E7D 8985"            /* gkpsy.zpign} */
	$"7571 849A 977F 7078 8686 7972 7C8A 908B"            /* uq.pxyr| */
	$"878C 969B 9897 9FAA AA9D 969B A3A3 9E9E"            /*  */
	$"A5AA A69F A0A8 AEAD A9AC B6BA B6B2 B6BE"            /*  */
	$"BEB3 A8A7 ACAA 9B8B 8993 9890 878A 9291"            /*  */
	$"8378 797D 786D 686B 6B63 5A5B 6368 655F"            /* xy}xmhkkcZ[che_ */
	$"5E61 6361 5F61 6362 5E5B 5D62 6666 6669"            /* ^aca_acb^[]bfffi */
	$"6D6E 6F73 777A 7976 7677 7878 7777 7979"            /* mnoswzyvvwxxwwyy */
	$"7878 797A 7773 706F 6E6A 6663 605B 5450"            /* xxyzwsponjfc`[TP */
	$"4F4F 4C47 4342 4447 4949 4A4B 4D4E 4D4E"            /* OOLGCBDGIIJKMNMN */
	$"5155 5655 5355 5654 4F4F 5865 6C6B 6C73"            /* QUVUSUVTOOXelkls */
	$"7C7D 7978 7E83 817B 7A7F 8382 8080 8286"            /* |}yx~{z. */
	$"8A8B 8986 8B97 A09F 9791 8E8A 888B 9190"            /*  */
	$"8A8B 96A0 9E9B A5B4 B8B2 B0B6 BAB6 B0B2"            /*  */
	$"B6B3 ACB1 C3CD C4B9 BFD1 D9CE C5CE E2EA"            /* Ĺ... */
	$"E4E0 E4E6 DFD2 CBCD CCC3 B6B1 B2AF A69D"            /* .....ö */
	$"9DA0 9C92 8A8C 918F 867E 7D7C 776F 6C6D"            /* ~}|wolm */
	$"6A63 5E61 6768 6464 6C76 7875 7378 7F80"            /* jc^aghddlvxusx. */
	$"7C7B 828B 8C87 868B 8F8E 8C8D 9295 9493"            /* |{ */
	$"9597 9795 9390 8D87 817C 7874 6F6A 6662"            /* |xtojfb */
	$"5E5A 5754 504B 4848 4848 4746 4747 4746"            /* ^ZWTPKHHHHGFGGGF */
	$"4649 4B4D 4F52 5659 5B5E 6366 6665 686F"            /* FIKMORVY[^cffeho */
	$"767B 7D81 8689 8A8B 8D8F 9295 979A 9FA4"            /* v{} */
	$"A7A7 A7A8 AAAB A59D 9AA0 A7A6 9F9B 9EA2"            /*  */
	$"A4A5 A5A0 958B 93AB BBB1 9D9C B1C0 BAB2"            /*  */
	$"BBCE D4C9 C2CB D6D4 C9C9 D9E9 E8DF E2F4"            /* ...... */
	$"FFFC F0E8 EDEE E1CF C9CD C9B7 A4A0 A5A2"            /* .......ɷ */
	$"9284 8287 857C 7779 7B75 6962 605C 5247"            /* |wy{uib`\RG */
	$"4447 4743 4147 4F54 5659 6169 6D70 757D"            /* DGGCAGOTVYaimpu} */
	$"8386 8687 898D 9091 9397 9BA0 A4A7 AAAE"            /*  */
	$"B2B4 B4B1 ADAA A7A2 9D97 918B 847D 7772"            /* }wr */
	$"6C64 5E5A 5856 5555 5656 5452 5254 5656"            /* ld^ZXVUUVVTRRTVV */
	$"5759 5B5D 5F62 666A 6D6F 7174 787B 7E81"            /* WY[]_bfjmoqtx{~ */
	$"8689 8B8C 8E8F 9193 9596 989A 9DA0 A09E"            /*  */
	$"9B9B 9D9F 9F9E 9FA0 9F9C 9A9A 9B9B 9997"            /*  */
	$"999E A2A3 A3A9 B4BB BAB6 B7BB C0C5 CACB"            /*  */
	$"C8C7 CFDD E8EA ECF4 FCFD F3E7 E1DF D8CB"            /* ........... */
	$"BEB5 AEA4 9A95 9490 857A 7372 716C 6764"            /* zsrqlgd */
	$"6059 4F46 413F 3A32 2B28 282B 2E33 393E"            /* `YOFA?:2+((+.39> */
	$"4042 464B 5158 5E64 686A 6D71 7375 7679"            /* @BFKQX^dhjmqsuvy */
	$"7E81 8489 8F95 9798 9A9B 9B99 9591 8C86"            /* ~ */
	$"807A 7772 6A60 5851 4A44 3E3B 3836 322F"            /* zwrj`XQJD>;862/ */
	$"2E2D 2D2D 2D2E 2F30 3237 3B3F 4144 474B"            /* .----./027;?ADGK */
	$"5054 5658 5B5F 6367 6A6D 6F71 706F 7074"            /* PTVX[_cgjmoqpopt */
	$"7879 7878 7B7D 7E7D 7E80 8282 8283 8280"            /* xyxx{}~}~ */
	$"7E7B 7A79 7878 797B 7E80 8387 8C91 959A"            /* ~{zyxxy{~ */
	$"9EA1 A4AB B4BB BEC1 C7D1 DBE1 E2DF D8CC"            /* .... */
	$"C1B9 B4AE A394 857A 736E 6861 574C 4440"            /* zsnhaWLD@ */
	$"3F3D 3A33 2B23 1B13 0D08 0401 0000 0000"            /* ?=:3+#......... */
	$"0307 0C11 1820 272E 353C 444A 4F54 585B"            /* ..... '.5<DJOTX[ */
	$"5D5F 6265 686B 7075 7B7F 8183 8485 8482"            /* ]_behkpu{. */
	$"7F7A 7671 6B64 5C52 483E 352C 2521 1E1C"            /* .zvqkd\RH>5,%!.. */
	$"1A17 1515 1617 1819 1A1C 2024 282C 3032"            /* .......... $(,02 */
	$"3437 3B40 4448 4B4F 5355 5758 5B5E 5F5F"            /* 47;@DHKOSUWX[^__ */
	$"6063 676B 6E70 7273 7476 797B 7C7F 8285"            /* `cgknprstvy{|. */
	$"8889 898B 8C8D 8E91 9599 9CA1 A8B0 B6BB"            /*  */
	$"C1C9 D1D8 E0E8 F2FB FFFF FFFF FFFF FCF4"            /* ............ */
	$"EBE5 DFD7 CCBF B4AD AAA7 A39B 9189 8584"            /* ...̿ */
	$"8482 7E77 6F66 5F59 5450 4B48 4749 4F56"            /* ~wof_YTPKHGIOV */
	$"5C61 666B 7077 7F86 8D92 979C A1A3 A4A4"            /* \afkpw. */
	$"A5A7 AAAD AFB2 B6BB BEBF BFBE BCB7 B2AD"            /*  */
	$"A8A2 9B93 8A80 7568 5C53 4C46 423F 3C38"            /* uh\SLFB?<8 */
	$"332F 2C2C 2C2D 2D2E 3134 393F 4345 4649"            /* 3/,,,--.149?CEFI */
	$"4D53 595F 6367 6B6E 7072 7474 7475 7779"            /* MSY_cgknprtttuwy */
	$"7C7F 8283 8382 8284 888B 8E90 9397 999A"            /* |. */
	$"9A99 9897 9798 9A9E A2A7 ABAF B5BB C2C9"            /*  */
	$"D1DA E4F0 FBFF FFFF FFFD F4E4 D7CE C5BA"            /* ...........ź */
	$"AC9E 938C 8985 7F77 6E67 6362 6260 5C55"            /* .wngcbb`\U */
	$"4B3F 342B 2520 1D1C 1C20 262D 353B 4045"            /* K?4+% ... &-5;@E */
	$"4C52 595F 666C 7174 7573 706E 6E70 7275"            /* LRY_flqtuspnnpru */
	$"787C 8187 8B8E 8F90 8F8D 8C8A 8783 7D75"            /* x|}u */
	$"6D65 5C54 4C44 3D38 3637 3939 3735 3436"            /* me\TLD=867997546 */
	$"393C 3F41 4447 4C51 575B 5F64 6970 7780"            /* 9<?ADGLQW[_dipw */
	$"888E 9396 999B 9EA0 A1A0 9F9F A1A3 A4A4"            /*  */
	$"A4A4 A4A6 A9AE B3B7 B9BA BBBB BABA BABA"            /*  */
	$"B9B9 BCC0 C5CA CED3 D9E1 EBF6 FDFF FFFF"            /* ........ */
	$"FFFF FFFD F2E3 D7CC C0B3 A69B 948F 8C87"            /* ...... */
	$"817B 7573 7476 7776 7065 584C 423C 3733"            /* {ustvwvpeXLB<73 */
	$"3030 3339 4149 5159 6068 737E 8892 9BA1"            /* 0039AIQY`hs~ */
	$"A4A4 A19E 9C9C 9C9E A0A4 A8AC B0B3 B5B6"            /*  */
	$"B6B5 B4B2 B0AC A69E 9388 7D71 665B 534D"            /* }qf[SM */
	$"4B4A 4846 4341 4245 494B 4D50 545A 6063"            /* KJHFCABEIKMPTZ`c */
	$"6567 6A6F 767D 858D 949B A1A6 A9AD B1B4"            /* egjov} */
	$"B7B8 B9BB BCBC BBB8 B5B5 B6B9 BCBF C1C2"            /*  */
	$"C3C5 C6C7 C8C8 C9CA CCCF D2D5 D8DB DEE3"            /* ... */
	$"EAF4 FCFF FFFF FFFF F9E9 D9CE C5BC B0A2"            /* ...........ż */
	$"9387 7F7A 746C 645D 5A5B 6064 6562 594D"            /* .ztld]Z[`debYM */
	$"4239 3533 3332 3133 373D 444A 5057 5F6A"            /* B95332137=DJPW_j */
	$"7784 919C A4A9 AAA8 A5A3 A3A5 A8AB ACAC"            /* w */
	$"ACAC ADAE ADAC ABAB ABAA A7A0 968A 7D71"            /* }q */
	$"655A 4F45 3B34 302D 2A26 2322 242A 3138"            /* eZOE;40-*&#"$*18 */
	$"3D41 454A 4F53 575A 5D62 686F 757B 7F82"            /* =AEJOSWZ]bhou{. */
	$"8589 8D93 999E A2A5 A7A8 A9AA AAA9 A9A9"            /*  */
	$"ABAE B1B2 B3B3 B5B8 BCC0 C3C7 CBD0 D6DC"            /* . */
	$"E1E7 EDF4 FBFF FFFF FBEC D8C9 C1BE BBB2"            /* .......... */
	$"A392 8580 807F 796F 655F 6065 6969 6256"            /* .yoe_`eiibV */
	$"493F 3836 3738 3838 393D 434A 5259 6069"            /* I?8678889=CJRY`i */
	$"737F 8A95 9FA7 ACAD ABA9 A9AC B2B7 BAB9"            /* s. */
	$"B6B4 B4B5 B6B7 B5B2 B0AF ADA9 A399 8C80"            /*  */
	$"756B 6258 4E44 3B35 312E 2B28 2729 2D32"            /* ukbXND;51.+(')-2 */
	$"383D 4043 464B 5157 5C60 6469 6F74 797D"            /* 8=@CFKQW\`dioty} */
	$"8083 878C 9196 999C 9D9E 9FA0 A2A4 A5A5"            /*  */
	$"A6A7 A9AB ACAD AEB0 B3B7 BDC3 C9CE D4DA"            /* . */
	$"E2EC F5FC FCF5 E7D3 C1B4 AEAB A69A 8A7A"            /* .......z */
	$"6F6B 6C6D 6961 5957 5B61 6562 594C 3F35"            /* oklmiaYW[aebYL?5 */
	$"3030 3131 302D 2D2F 343B 434B 545E 6974"            /* 00110--/4;CKT^it */
	$"7F89 9197 9A99 9796 989D A4A8 A8A4 A09F"            /* . */
	$"A0A4 A8AB ABAA A9A9 A7A2 998D 8074 6A62"            /* tjb */
	$"594E 4238 302B 2723 201F 2228 2F34 3739"            /* YNB80+'# ."(/479 */
	$"3C41 474C 5053 575C 6064 6769 6C70 757A"            /* <AGLPSW\`dgilpuz */
	$"7F84 8B90 9495 9698 9C9F A1A2 A2A2 A3A4"            /* . */
	$"A5A5 A5A7 A9AE B4BA BFC5 CCD3 DBE5 EEF3"            /* .... */
	$"F0E3 CEB7 A7A0 9E9A 8E7B 6758 5355 5654"            /* ..η{gXSUVT */
	$"4E47 4548 4F56 5751 4538 2D27 2627 2726"            /* NGEHOVWQE8-'&''& */
	$"221F 1F22 2830 3943 4E58 626C 7680 878B"            /* ".."(09CNXblv */
	$"8A86 8282 878E 9190 8A83 7F80 8489 8B8B"            /* . */
	$"8A89 898A 8984 7B6E 6056 4F4A 4338 2B1E"            /* {n`VOJC8+. */
	$"1411 1214 1617 191F 2830 373A 3B3E 444C"            /* ........(07:;>DL */
	$"545A 5D5E 5F61 656A 6E71 7478 7E84 8B90"            /* TZ]^_aejnqtx~ */
	$"9394 969A A0A5 A8A8 A7A6 A7A9 ABAC ADAF"            /*  */
	$"B2B8 BEC6 CED6 E0E8 EBE6 D7C3 B0A5 A2A3"            /* ....ð */
	$"9E8F 7963 5653 5658 544C 4647 505A 5F5D"            /* ycVSVXTLFGPZ_] */
	$"5449 403C 3C3F 4140 3D39 3535 373B 434C"            /* TI@<<?A@=9557;CL */
	$"5761 6B73 7C85 8E95 9795 9191 959B A1A0"            /* Waks| */
	$"998E 8684 888D 9190 8D8A 8989 8986 8077"            /* w */
	$"6C64 5F5C 5750 4539 2F2A 2829 2A2A 2B2D"            /* ld_\WPE9/*()**+- */
	$"3239 4044 474A 4F57 5F66 6A6B 6B6C 7075"            /* 29@DGJOW_fjkklpu */
	$"7A7E 8083 888E 9499 9C9E A1A6 ACB2 B6B7"            /* z~ */
	$"B6B6 B6B8 BABD C0C2 C6CB D3DB E4EC F1F0"            /* ..... */
	$"E6D4 BFAE A6A6 A59C 8971 5D54 5559 5852"            /* .Կq]TUYXR */
	$"4A47 4C56 6063 5E55 4B45 4549 4E51 4F4B"            /* JGLV`c^UKEEINQOK */
	$"4644 4449 5059 636C 747C 848C 959D A0A0"            /* FDDIPYclt| */
	$"9D9A 9CA2 A8A9 A397 8B85 8589 8D8C 8881"            /*  */
	$"7D7C 7C7B 776F 655D 5754 524E 4539 2F2A"            /* }||{woe]WTRNE9/* */
	$"2A2D 3031 3030 353D 454A 4D4F 545C 666E"            /* *-01005=EJMOT\fn */
	$"7171 7072 767C 8183 8587 8B91 969A 9D9F"            /* qqprv| */
	$"A3A8 AFB4 B8B9 B8B8 BABD C1C5 C8CB CFD6"            /*  */
	$"DFEA F2F5 EFE0 CCB7 A9A4 A5A3 967F 6554"            /* ......̷.eT */
	$"4E50 5351 4942 4148 525A 5A53 4941 3D40"            /* NPSQIBAHRZZSIA=@ */
	$"464C 4F4E 4B46 4548 505B 6772 7C85 8C94"            /* FLONKFEHP[gr| */
	$"9EA7 ADAF ADA9 A9AD B3B6 B3A9 9B90 8C8E"            /*  */
	$"9394 918A 837E 7C7A 756E 655B 524B 4640"            /* ~|zune[RKF@ */
	$"3931 2822 1F21 262B 2E2F 3238 414B 5257"            /* 91(".!&+./28AKRW */
	$"5B60 6871 787B 7A7A 7C81 888D 8F90 9398"            /* [`hqx{zz| */
	$"A0A7 ABAE B2B6 BCC1 C4C6 C6C5 C5C6 CACD"            /*  */
	$"D1D5 D9E0 E8F1 F5EF DEC7 B1A5 A3A5 A08F"            /* .......Ǳ */
	$"765E 4F4B 4C4B 463F 3A3C 444D 5250 4A43"            /* v^OKLKF?:<DMRPJC */
	$"3E3C 3E43 494D 4D4A 4644 464F 5C6B 7780"            /* ><>CIMMJFDFO\kw */
	$"878D 96A2 ADB4 B5B1 AEAF B6BC BCB3 A598"            /*  */
	$"908F 9293 908A 827C 7875 716A 625A 514A"            /* |xuqjbZQJ */
	$"453F 382F 261F 1B1C 1F23 2528 2B31 383F"            /* E?8/&....#%(+18? */
	$"464C 535A 626A 7074 7678 7B7F 8388 8D90"            /* FLSZbjptvx{. */
	$"9498 9EA4 A9AE B2B7 BDC3 C8CC CECE CFD2"            /*  */
	$"D6DB DFE2 E7ED F4F7 F1E0 CAB4 A5A2 A5A2"            /* .........ʴ */
	$"937C 6353 4E4F 4E49 413B 3C44 4C4F 4C45"            /* |cSNONIA;<DLOLE */
	$"3F3C 3C3F 454B 4E4F 4D4A 494C 5462 717F"            /* ?<<?EKNOMJILTbq. */
	$"888F 959D A6B1 B8BB B9B8 BAC0 C6C6 BDAF"            /* ƽ */
	$"A29A 999C 9E9B 938B 8480 7D78 7067 6059"            /* }xpg`Y */
	$"534D 463D 332A 2321 2125 292D 3033 373E"            /* SMF=3*#!!%)-037> */
	$"464E 555C 636C 747A 7D7E 7D7F 848A 8F92"            /* FNU\cltz}~}. */
	$"9498 9EA4 A9AE B3B7 BDC4 CBD0 D3D5 D8DC"            /* . */
	$"E0E4 E9EF F5FA FAF1 E0CB B7AB AAAC A797"            /* .........˷ */
	$"8069 5C5A 5C5B 544B 4548 4F56 5751 473F"            /* i\Z\[TKEHOVWQG? */
	$"3C3D 4147 4B4D 4C4A 4849 4F5A 6775 8089"            /* <=AGKMLJHIOZgu */
	$"9097 9FA9 B2B7 B7B6 B6BB C2C7 C4BA ABA0"            /* ĺ */
	$"9C9E A1A1 9C93 8B86 827E 776E 6660 5B57"            /* ~wnf`[W */
	$"5148 3E34 2C29 292B 2E30 3134 383D 444B"            /* QH>4,))+.0148=DK */
	$"5158 616A 7378 7A7B 7D81 878C 9195 979B"            /* QXajsxz{} */
	$"9FA4 A9AD B1B5 BCC3 C9CD D0D2 D4D9 E0E7"            /* ... */
	$"ECF1 F3F0 E4D1 BCA9 9F9F 9F96 846C 5A52"            /* .....ѼlZR */
	$"5254 534D 4542 4750 5656 4E44 3D3B 3D43"            /* RTSMEBGPVVND=;=C */
	$"494C 4B49 4646 4A52 5E6B 7780 878E 96A0"            /* ILKIFFJR^kw */
	$"A9AF B2B0 AEAF B3B9 BBB4 A89B 9291 9496"            /*  */
	$"938C 837C 7773 6F68 615A 5551 4C46 3E36"            /* |wsohaZUQLF>6 */
	$"2D28 282C 3033 3435 373C 444C 5359 6068"            /* -((,03457<DLSY`h */
	$"7178 7B7C 7E82 8991 9AA0 A4A7 ABB0 B5BA"            /* qx{|~ */
	$"BFC4 CAD1 D8DD E2E5 E8EC F2F8 FAF4 E5D0"            /* .......... */
	$"BBAD A8A7 A190 7860 5453 5658 544C 4748"            /* x`TSVXTLGH */
	$"4E56 5B58 514A 4646 484C 5051 4F4B 494B"            /* NV[XQJFFHLPQOKIK */
	$"535F 6D7A 848B 929B A7B4 BDC2 C2C0 BFC1"            /* S_mz */
	$"C6C8 C3B8 AAA0 9B9C 9D9A 9288 7F79 7775"            /* ø.ywu */
	$"7069 625D 5A57 534C 443C 3837 393B 3C3C"            /* pib]ZWSLD<879;<< */
	$"3B3D 4249 4F55 5B61 6871 787D 7F80 848B"            /* ;=BIOU[ahqx}. */
	$"949C A2A5 A8AC B1B8 BEC3 C8CE D4DC E3E8"            /* ... */
	$"ECF2 F8FD FDF3 E1CB B8AE ADAC A28C 705A"            /* .......˸pZ */
	$"5154 5857 5047 4449 5259 5953 4A44 4548"            /* QTXWPGDIRYYSJDEH */
	$"4C4F 504E 4A47 474B 5462 707C 848A 9099"            /* LOPNJGGKTbp| */
	$"A5B1 BABE BDBC BDC1 C6C6 BDAF A39C 9DA0"            /* ƽ */
	$"A099 8D82 7B79 7874 6B62 5C5B 5B57 4E44"            /* {yxtkb\[[WND */
	$"3C38 393C 3F3F 3E3D 3F45 4D54 595E 646C"            /* <89<??>=?EMTY^dl */
	$"747B 7F80 8084 8B94 9C9F A0A2 A7AE B6BD"            /* t{. */
	$"C2C7 CDD6 E0E9 F1F6 FAF9 EEDD C9B7 AEAF"            /* ........ɷ */
	$"AFA5 8E71 5950 545A 5A53 4A45 4A56 5F60"            /* qYPTZZSJEJV_` */
	$"574C 4546 4B51 5553 4D47 4345 4B55 606B"            /* WLEFKQUSMGCEKU`k */
	$"757E 848B 94A0 ABB3 B5B4 B2B3 B7BB B9AE"            /* u~ */
	$"9E91 8B8C 8F8F 877B 716D 7074 746E 6661"            /* {qmpttnfa */
	$"6162 625D 5349 4445 494C 4A46 4447 4E58"            /* abb]SIDEILJFDGNX */
	$"5F62 6367 6F79 8185 8689 8E95 9DA0 A0A0"            /* _bcgoy */
	$"A2A8 B1B9 BFC2 C7CF DAE6 EFF2 ECDD CCBD"            /* ......̽ */
	$"B3AE ADA6 9680 6A5A 5657 5855 4F4A 4B51"            /* jZVWXUOJKQ */
	$"595F 605A 5350 5052 5558 5752 4B46 474F"            /* Y_`ZSPPRUXWRKFGO */
	$"5A63 6A6F 757D 8895 A1A9 ACAD AEB0 B4B6"            /* Zcjou} */
	$"B5AD A093 8984 827F 776D 6561 6164 6665"            /* .wmeaadfe */
	$"615D 5D60 6362 5D57 5353 5455 5452 5051"            /* a]]`cb]WSSTUTRPQ */
	$"575F 666A 6C6F 757E 878E 9296 9AA0 A6AA"            /* W_fjlou~ */
	$"AAAA ACB1 B8BF C5CA D0D9 E2E8 E6DA C9BA"            /* .....ɺ */
	$"B0AD AFAA 9A82 6A5B 595D 5E57 4D46 464F"            /* j[Y]^WMFFO */
	$"585D 5B55 5052 575B 5C5B 5855 5352 5459"            /* X][UPRW[\[XUSRTY */
	$"6169 7176 787B 828D 9AA4 A8A7 A5A6 AAAE"            /* aiqvx{ */
	$"AEA6 9A8D 8582 817D 7264 5A57 5A5F 605D"            /* }rdZWZ_`] */
	$"5855 575C 5F5F 5A56 5559 5E5E 5B57 565A"            /* XUW\__ZVUY^^[WVZ */
	$"626B 7174 7477 7E88 9096 989B A0A8 AFB3"            /* bkqttw~ */
	$"B4B4 B6BC C5CE D5DA DEE1 DFD6 C7B7 ABA7"            /* ....Ƿ */
	$"A9A8 9B85 6C5B 585E 625E 544B 4950 5A60"            /* l[X^b^TKIPZ` */
	$"5D54 4C4C 545D 615F 5953 5254 5A61 686F"            /* ]TLLT]a_YSRTZaho */
	$"757A 7F82 878F 98A1 A6A6 A4A2 A3A4 A29C"            /* uz. */
	$"9084 7D79 7773 695C 5452 555A 5C59 5554"            /* }ywsi\TRUZ\YUT */
	$"5659 5D5D 5957 585C 6062 605E 6065 6D75"            /* VY]]YWX\`b`^`emu */
	$"7B7F 8185 8B93 9A9E A0A4 AAB1 B8BC BDBF"            /* {. */
	$"C4CB D5DF E5E6 E0D4 C5B7 ACA5 A4A0 937F"            /* ....ŷ. */
	$"6958 5356 5A5A 554F 4D53 5D64 655F 5754"            /* iXSVZZUOMS]de_WT */
	$"5961 6667 6159 5454 5961 6B73 777A 7F84"            /* YafgaYTTYakswz. */
	$"8C95 9DA3 A6A6 A5A5 A5A3 9D93 867A 716C"            /* zql */
	$"6963 5A50 4949 4D53 5655 5455 595D 605F"            /* icZPIIMSVUTUY]`_ */
	$"5C5B 5D61 6463 615F 626A 737B 8084 8990"            /* \[]adca_bjs{ */
	$"989F A4A7 AAB0 B8BF C3C4 C5C8 CFD8 E2E7"            /* .. */
	$"E5DB CBBA AEA6 A4A1 9784 6F5C 5353 5655"            /* ..˺o\SSVU */
	$"5049 474C 5760 6360 5A56 5A63 6A6F 6E69"            /* PIGLW`c`ZVZcjoni */
	$"6362 656B 747C 8082 8588 8F97 9DA2 A4A3"            /* cbekt| */
	$"A1A1 A19F 9990 8275 6C66 625C 544B 4443"            /* ulfb\TKDC */
	$"4549 4C4D 4C4D 5257 5C5D 5C5C 5E63 676A"            /* EILMLMRW\]\\^cgj */
	$"6A6A 6D73 7C85 8B90 949A A1A7 ACAF B3B9"            /* jjms| */
	$"BFC4 C8CB CED3 DAE2 E7E4 D8C6 B5A9 A3A2"            /* ....Ƶ */
	$"9E8F 7760 514E 5356 5149 4243 4D59 6061"            /* w`QNSVQIBCMY`a */
	$"5C56 575F 676C 6D6A 6766 6A71 7880 868B"            /* \VW_glmjgfjqx */
	$"8E92 979E A5AB AEAD A8A2 9E9B 9790 8375"            /* u */
	$"685F 5952 4A41 3A3A 3F45 4A4C 4B4C 5057"            /* h_YRJA::?EJLKLPW */
	$"5C5F 5E5E 6063 6667 6665 686F 7983 8C91"            /* \_^^`cfgfehoy */
	$"969B A2AB B3B9 BEC3 C9CE D3D7 DADE E2E7"            /* .... */
	$"E8E1 D1BD ADA2 9E9E 9683 6C59 5052 595B"            /* ..ѽlYPRY[ */
	$"554D 484C 5761 6460 5A56 5961 6768 6763"            /* UMHLWad`ZVYaghgc */
	$"6266 6D75 7E86 8B90 9599 9EA6 ADB1 B2AF"            /* bfmu~ */
	$"A8A1 9C97 9087 7A6C 615A 544D 453D 393C"            /* zlaZTME=9< */
	$"4147 4B4C 4C4F 5459 5D5F 6062 6569 6A6A"            /* AGKLLOTY]_`beijj */
	$"6A6C 7179 8189 9095 9AA0 A6AD B3BA BFC5"            /* jlqy */
	$"CBD1 D6DC E2E7 E9E6 D9C6 B4A6 9E9E 9A8B"            /* ......ƴ */
	$"745C 4C4A 5259 5952 4C4C 5663 6B6C 6760"            /* t\LJRYYRLLVcklg` */
	$"5F67 7074 746F 6867 6C75 7F87 8C8F 9296"            /* _gpttohglu. */
	$"9BA3 A9AD AEAC A69E 968E 857A 6E61 554D"            /* znaUM */
	$"4742 3C38 373A 4149 5054 5659 5D62 6567"            /* GB<87:AIPTVY]beg */
	$"6969 6B6D 6E6E 6E71 767F 8993 989B 9DA2"            /* iikmnnnqv. */
	$"AAB2 B8BE C4C9 CED2 D7DC DFE0 DBCC B9A7"            /* ....̹ */
	$"9A92 918E 7F68 5142 424D 585B 554F 4E58"            /* .hQBBMX[UONX */
	$"6670 7370 6968 6F78 7D7C 766F 6E74 7E8A"            /* fpspihox}|vont~ */
	$"9499 9A9A 9CA0 A8AF B2B2 AEA6 9B91 867B"            /* { */
	$"7064 574C 443D 3732 2E2D 3239 4148 4D50"            /* pdWLD=72.-29AHMP */
	$"5459 5E63 6769 6B6E 7173 7576 7A80 8891"            /* TY^cgiknqsuvz */
	$"999F A3A7 ACB3 BBC2 C7CC D0D5 DBE2 E6E7"            /* .... */
	$"E2D4 BFAB 9B91 8F8C 7E66 4C39 3640 4C52"            /* .Կ~fL96@LR */
	$"4E47 444C 5C69 706E 6764 6A74 7B7E 786F"            /* NGDL\ipngdjt{~xo */
	$"6A6F 7A88 9398 9999 9BA1 ABB4 B7B6 B2AA"            /* joz */
	$"A197 8C80 7365 574C 443D 3834 2F2E 323A"            /* seWLD=84/.2: */
	$"444D 5356 5A5F 656B 6F70 7071 7374 7576"            /* DMSVZ_ekoppqstuv */
	$"787E 858C 9398 9CA1 A8B1 BAC1 C8CD D3D9"            /* x~. */
	$"E0E6 E9E5 D9C3 AC9A 8F8B 897E 674C 3831"            /* .....ì~gL81 */
	$"3A4A 5456 514D 5262 737E 807A 7476 7F86"            /* :JTVQMRbs~ztv. */
	$"8882 776E 6E77 8491 9797 9596 9BA3 ADB2"            /* wnnw */
	$"B2AD A499 8E82 7567 594A 3F37 312D 2A28"            /* ugYJ?71-*( */
	$"292F 3A46 5159 5E63 6970 767B 7C7C 7C7D"            /* )/:FQY^cipv{|||} */
	$"7E7F 8083 888F 969B A0A4 AAB0 B8C0 C7CC"            /* ~. */
	$"D1D7 DEE4 E8E7 DFCC B49E 8F88 867F 6C51"            /* .....̴.lQ */
	$"392C 2F3C 4A51 4F4A 4C58 6977 7F7F 7C7D"            /* 9,/<JQOJLXiw..|} */
	$"8388 8886 8077 7376 8191 9C9D 9896 9AA4"            /* wsv */
	$"AFB5 B5B2 ABA1 9588 7B6E 6155 4A41 3931"            /* {naUJA91 */
	$"2B28 2B31 3A43 4B53 595E 6369 7076 7A7B"            /* +(+1:CKSY^cipvz{ */
	$"7B7A 797A 7B7F 848A 9197 9CA0 A4AB B3BB"            /* {zyz{. */
	$"C3CB D1D8 DFE5 E9E9 E2D0 B9A5 9690 8E87"            /* .....й */
	$"7457 3D30 3342 5056 524C 4C58 6A7A 8180"            /* tW=03BPVRLLXjz */
	$"7C7D 858D 918E 8379 767B 8691 9795 918F"            /* |}yv{ */
	$"9198 A2AA ACA9 A196 8A7E 7267 5D53 4A41"            /* ~rg]SJA */
	$"3832 2F30 343C 454E 5860 676D 7379 8085"            /* 82/04<ENX`gmsy */
	$"8786 837F 7D7D 7F81 8588 8C8F 9398 9EA6"            /* .}}. */
	$"AEB7 C0C7 CED6 DDE3 E5E0 D2BD A695 8C88"            /* ....ҽ */
	$"8274 5B41 2F2C 384A 5658 5452 5B6D 818F"            /* t[A/,8JVXTR[m */
	$"938F 8C8F 979D 9C92 847C 7C83 8E95 958F"            /* || */
	$"8A8A 909A A3A7 A49B 9084 796F 655B 5146"            /* yoe[QF */
	$"3C33 2D2B 2C30 3841 4C56 5F67 6E75 7D84"            /* <3-+,08ALV_gnu} */
	$"8A8E 8D89 8582 8183 878A 8D90 9295 9AA0"            /*  */
	$"A8B0 B8BF C6CD D5DD E3E4 DECF BAA5 968E"            /* ....Ϻ */
	$"8A82 7055 3B2B 2A37 4852 534D 4D58 6C82"            /* pU;+*7HRSMMXl */
	$"9195 9290 959E A3A0 9689 8182 8991 938F"            /*  */
	$"8883 848C 979F A09B 9186 7D75 6D64 584C"            /* }umdXL */
	$"4138 3331 3133 373E 4855 616A 7176 7C83"            /* A831137>HUajqv| */
	$"8A8F 8F8B 8580 7E7E 8082 8485 878B 8F95"            /* ~~ */
	$"9DA6 AEB6 BEC6 CED7 DEE2 E0D6 C4AE 9B8F"            /* ...Į */
	$"8A86 7A63 4831 282F 404F 5552 4F54 657C"            /* zcH1(/@OUROTe| */
	$"909A 9A98 9AA1 A7A8 A195 8A86 8A90 9491"            /*  */
	$"8981 7F83 8C95 9996 8E84 7B73 6C64 5A50"            /* .{sldZP */
	$"453D 3733 3132 363E 4854 5E67 6F76 7D84"            /* E=73126>HT^gov} */
	$"8B90 908E 8983 7E7B 7B7E 8082 8385 888D"            /* ~{{~ */
	$"949E A7B0 B8BF C6CE D6DD E0DD D0BC A796"            /* ...м */
	$"8C88 8274 5B3F 2C27 3142 4E51 4C4A 5368"            /* t[?,'1BNQLJSh */
	$"8194 9C9B 9A9F A7AE AFA6 9A90 8E92 9797"            /*  */
	$"9085 7E7D 838C 9190 8980 7771 6C67 6056"            /* ~}wqlg`V */
	$"4C43 3D3A 393A 3D41 4954 5E68 6F74 7A81"            /* LC=:9:=AIT^hotz */
	$"888D 8F8D 8781 7C79 797A 7C7E 7E80 8389"            /* |yyz|~~ */
	$"919A A3AC B4BC C4CB D3DA DEDF D8CA B6A2"            /* ...ʶ */
	$"9289 857D 6C54 3C2E 2D38 4650 524E 4F5B"            /* }lT<.-8FPRNO[ */
	$"7085 9499 999A 9FA7 ADAB A296 8F8E 9295"            /* p */
	$"938A 807B 7B81 898C 8880 7771 6E6C 665D"            /* {{wqnlf] */
	$"5249 4444 4545 4546 4B54 606C 757A 7E82"            /* RIDDEEEFKT`luz~ */
	$"888E 9190 8B84 7D79 797A 7B7A 7978 7B81"            /* }yyz{zyx{ */
	$"8992 9BA2 A8B0 B8C1 CAD2 D8DB D9D1 C2B0"            /* ..° */
	$"9F93 8C86 7A66 4E3A 3135 414D 5250 4F54"            /* zfN:15AMRPOT */
	$"6379 8C97 9A9A 9EA5 ADB1 ADA3 9892 9295"            /* cy */
	$"958F 857B 7576 7B80 7F78 6F67 6362 605C"            /* {uv{.xogcb`\ */
	$"564F 4B4B 4C4F 5153 575D 6771 7A7F 8183"            /* VOKKLOQSW]gqz. */
	$"8589 8C8C 8983 7D77 7576 787A 7A79 7A7E"            /* }wuvxzzyz~ */
	$"858E 979E A5AA B0B6 BCC3 C8CB CCC8 BEAF"            /* Ⱦ */
	$"9F93 8D89 8275 6351 4545 4C56 5D5D 5A5B"            /* ucQEELV]]Z[ */
	$"6473 838D 9191 9297 9EA3 A39C 948E 8C8E"            /* ds */
	$"908D 8780 7A79 7A7C 7D7A 7570 6C69 6662"            /* zyz|}zuplifb */
	$"5E59 5756 5757 5859 5B5F 676F 767B 7E7F"            /* ^YWVWWXY[_gov{~. */
	$"8082 8485 8482 7D79 7676 7778 797A 7B7F"            /* }yvvwxyz{. */
	$"848B 9298 9EA3 A8AE B4B9 BEC3 C6C9 C9C4"            /*  */
	$"B9AA 9D93 8E89 8173 6150 4849 5058 5B5A"            /* saPHIPX[Z */
	$"585A 6371 808A 8F91 9499 A0A5 A6A1 9B95"            /* XZcq */
	$"9292 918D 867D 756F 6D6C 6B68 625C 5755"            /* }uomlkhb\WU */
	$"5557 595A 5B5C 5E62 676D 7377 7B7F 8386"            /* UWYZ[\^bgmsw{. */
	$"8888 8684 8381 807D 7A77 7675 7679 7B7E"            /* }zwvuvy{~ */
	$"8083 888E 959C A2A7 AAAE B2B6 BCC1 C5C4"            /*  */
	$"BFB5 A99E 9792 8F88 7D6D 5D53 5156 5D60"            /* }m]SQV]` */
	$"5E5A 595D 6671 7C82 8689 8D93 999C 9D9C"            /* ^ZY]fq| */
	$"9A98 9796 938E 8780 7A76 7370 6C66 5F58"            /* zvsplf_X */
	$"5452 5254 5657 5758 5B60 676E 767C 8082"            /* TRRTVWWX[`gnv| */
	$"8586 8788 8887 8481 7E7A 7776 7576 7778"            /* ~zwvuvwx */
	$"7A7B 7E81 868C 9399 9EA2 A5A9 ADB3 B8BC"            /* z{~ */
	$"BEBE BCB6 ADA3 9A94 8F89 8074 675C 5756"            /* tg\WV */
	$"5A5F 6262 6162 6871 7B84 8A8F 9293 9597"            /* Z_bbabhq{ */
	$"9897 9592 8E8B 8783 7E78 726D 6A68 6664"            /* ~xrmjhfd */
	$"615D 5957 585B 5F63 6566 676A 6F76 7C80"            /* a]YWX[_cefgjov| */
	$"8282 8282 8383 8382 7F7B 7774 7373 7373"            /* .{wtssss */
	$"7374 7578 7B80 8489 8E93 969A 9EA1 A4A6"            /* stux{ */
	$"A9AB ABAB ACAD ABA5 9E97 8F8A 8784 7F75"            /* .u */
	$"6C65 6263 686C 6D6B 696B 717A 8187 898A"            /* lebchlmkikqz */
	$"8B8D 9193 9391 8E8A 8887 847F 7871 6C68"            /* .xqlh */
	$"6766 6460 5B58 575A 5F64 6769 6A6C 7075"            /* gfd`[XWZ_dgijlpu */
	$"7A7E 8080 8080 8182 8180 7C79 7676 7675"            /* z~|yvvvu */
	$"7372 7172 7477 7B7F 8286 8A8E 9398 9DA0"            /* srqrtw{. */
	$"A2A3 A4A5 A5A4 A3A2 A19F 9C98 918A 8480"            /*  */
	$"7D7A 7570 6B67 6769 6D71 7374 7577 7C82"            /* }zupkggimqstuw| */
	$"878A 8D8E 8E8F 8F8F 8F8E 8B87 837F 7A76"            /* .zv */
	$"726E 6A66 6361 605F 5E5F 6062 6568 6C70"            /* rnjfca`_^_`behlp */
	$"7274 7679 7C7E 8080 7F7E 7D7B 7A79 7775"            /* rtvy|~.~}{zywu */
	$"7271 7070 7071 7476 787B 7F83 878C 9194"            /* rqpppqtvx{. */
	$"979A 9D9E 9E9E 9E9D 9D9D 9C9B 9896 9592"            /*  */
	$"8E8A 8682 7F7D 7B78 7470 6E6F 7276 797A"            /* .}{xtpnorvyz */
	$"7A7A 7C80 858A 8C8D 8C8C 8C8D 8D8C 8883"            /* zz| */
	$"7F7A 7774 706C 6764 6160 6162 6364 6567"            /* .zwtplgda`abcdeg */
	$"6A6D 7173 7576 787B 7D7E 7E7D 7B79 7877"            /* jmqsuvx{}~~}{yxw */
	$"7674 7270 6F6E 6E6F 7275 787B 7E81 8589"            /* vtrponnorux{~ */
	$"8D90 9396 9899 9896 9595 9593 918F 8E8C"            /*  */
	$"8B8D 8E8E 8D8B 8987 8382 8281 7E7B 7877"            /* ~{xw */
	$"7676 7779 7A7A 7B7E 8185 888B 8C8D 8D8D"            /* vvwyzz{~ */
	$"8C8A 8784 807C 7773 706C 6865 6261 6264"            /* |wsplhebabd */
	$"6668 6969 6A6D 7175 787A 7A79 7879 7979"            /* fhiijmquxzzyxyyy */
	$"7876 7473 7271 7172 7375 7677 7A7D 8082"            /* xvtsrqqrsuvwz} */
	$"8486 898C 8F90 9192 9292 9191 9291 8F8D"            /*  */
	$"8C8D 8C8B 8B8C 8D8E 8F8F 9090 8F8C 8A89"            /*  */
	$"8988 8582 807E 7E7E 7F80 8182 8384 8688"            /* ~~~. */
	$"8989 8989 8A89 8784 807D 7B79 7775 726F"            /* }{ywuro */
	$"6D6C 6C6D 6E6E 6E6E 6F70 7274 7576 7777"            /* mllmnnnnoprtuvww */
	$"7676 7575 7575 7575 7575 7576 7778 7B7D"            /* vvuuuuuuuuuvwx{} */
	$"7E7E 7F81 8385 8687 8889 8989 898B 8C8C"            /* ~~. */
	$"8A88 8889 8A89 898A 8B8B 8B8C 8F90 9192"            /*  */
	$"9393 9392 918E 8C8A 8987 8583 817F 7D7D"            /* .}} */
	$"7F80 8181 8181 8183 8586 8584 8280 7D7C"            /* .}| */
	$"7B79 7774 716E 6D6C 6C6C 6C6C 6C6B 6C6D"            /* {ywtqnmllllllklm */
	$"6F70 7172 7272 7374 7575 7576 787A 7A7B"            /* opqrrrstuuuvxzz{ */
	$"7B7C 7D7E 7F80 8080 7F7E 7F80 8182 8283"            /* {|}~..~. */
	$"8484 8485 8687 8788 8787 888A 8A89 898A"            /*  */
	$"8B8B 8D8E 8E8E 8F91 9394 9697 9795 9391"            /*  */
	$"908D 8A88 8684 817F 7D7C 7D7E 7E7E 7E7F"            /* .}|}~~~~. */
	$"8081 8181 807F 7D7C 7B7A 7876 7370 6E6D"            /* .}|{zxvspnm */
	$"6C6C 6B6A 696A 6A6B 6D6F 7172 7476 7779"            /* llkjijjkmoqrtvwy */
	$"7A7A 7979 7A7B 7B7A 7A7B 7B7B 7B7D 7F80"            /* zzyyz{{zz{{{{}. */
	$"8080 8082 8383 8384 8484 8484 8586 8787"            /*  */
	$"8686 8788 898A 8B8C 8C8D 8E90 9394 9494"            /*  */
	$"9697 9797 9798 9794 918E 8C8B 8885 8381"            /*  */
	$"7F7C 7B7C 7C7B 7A7B 7C7C 7C7B 7C7C 7C7A"            /* .|{||{z{|||{|||z */
	$"7978 7775 7372 7170 6F6E 6D6C 6C6D 6E6E"            /* yxwusrqponmllmnn */
	$"6F6F 6F70 7173 7474 7576 7676 7778 7979"            /* ooopqsttuvvvwxyy */
	$"7A7C 7D7D 7E7E 7D7E 8080 8080 8180 7E7E"            /* z|}}~~}~~~ */
	$"7F80 8182 8384 8383 8588 8A8B 8D8E 8D8C"            /* . */
	$"8D90 9292 9191 9192 9292 9191 9192 9191"            /*  */
	$"9190 8F8C 8A87 8583 817F 7C7A 7775 7575"            /* .|zwuuu */
	$"7575 7574 7474 7576 7879 7978 7777 7677"            /* uuutttuvxyyxwwvw */
	$"7777 7572 706F 6E6D 6D6D 6D6D 6C6D 6E6F"            /* wwurponmmmmmlmno */
	$"7172 7475 7778 7878 797A 7C7D 7F7F 7D7C"            /* qrtuwxxxyz|}..}| */
	$"7C7C 7C7D 7D7C 7A7A 7B7D 7E80 8182 8284"            /* |||}}|zz{}~ */
	$"878A 8B8B 8D8E 8F8E 8E8F 9192 9190 8F8E"            /*  */
	$"8E8E 8D8C 8B8B 8A89 8685 8586 8584 8281"            /*  */
	$"807F 7D7D 7D7D 7B79 7979 7877 7777 7777"            /* .}}}}{yyyxwwwww */
	$"7777 7776 7676 7675 7474 7473 7271 7272"            /* wwwvvvvutttsrqrr */
	$"7271 7273 7474 7475 7677 7878 7777 7778"            /* rqrstttuvwxxwwwx */
	$"7879 7978 7879 7A7A 7B7C 7C7B 7C7E 7E7F"            /* xyyxxyzz{||{|~~. */
	$"8182 8282 8486 8686 888B 8B8A 8B8D 8D8C"            /*  */
	$"8C8C 8C8C 8D8E 8D8B 8B8B 8B89 8889 8A89"            /*  */
	$"8685 8586 8686 8787 8585 8686 8585 8685"            /*  */
	$"8381 8180 7F7D 7C7C 7A79 7878 7877 7676"            /* .}||zyxxxwvv */
	$"7778 7979 7A7B 7C7C 7C7C 7D7D 7C7B 7A7A"            /* wxyyz{||||}}|{zz */
	$"7978 7777 7675 7576 7777 7879 7A7B 7C7E"            /* yxwwvuuvwwxyz{|~ */
	$"7F80 8183 8484 8587 8988 8786 8788 8887"            /* . */
	$"8787 8686 8686 8788 8785 8587 8887 8788"            /*  */
	$"8989 8989 8A8A 8A8A 8989 8989 8888 8888"            /*  */
	$"8988 8889 8887 8686 8788 8887 8585 8584"            /*  */
	$"8383 8383 8281 8181 8181 8181 8080 807E"            /* ~ */
	$"7D7E 7E7D 7B7B 7C7C 7C7B 7C7D 7D7D 7E7E"            /* }~~}{{|||{|}}}~~ */
	$"7E7E 7F80 8080 8182 8181 8182 8384 8585"            /* ~~. */
	$"8584 8484 8688 8887 8585 8584 8283 8484"            /*  */
	$"817F 7F81 8382 8282 8384 8485 8789 8988"            /* .. */
	$"8888 8888 8988 8888 8989 8786 8888 8685"            /*  */
	$"8688 8785 8486 8887 8686 8584 8382 8180"            /*  */
	$"8080 807E 7D7D 7E7F 8081 8180 7F7F 8080"            /* ~}}~... */
	$"807F 7E7D 7C7C 7D7E 7E7F 807F 7E7F 8182"            /* .~}||}~~..~. */
	$"8181 8281 807F 7F80 807F 7E7D 7C7B 7A7B"            /* ...~}|{z{ */
	$"7B7B 7B7A 7A7A 7A7B 7B7C 7C7D 7D7D 7D7D"            /* {{{zzzz{{||}}}}} */
	$"7E7F 8080 8080 8080 8080 8181 8080 7F80"            /* ~.. */
	$"8080 8181 8080 8081 8282 8181 8181 8281"            /*  */
	$"807F 7F7F 7E7F 7F7F 7E7D 7E7F 8080 8181"            /* ...~...~}~. */
	$"8080 8080 8181 8180 8080 8081 8180 8081"            /*  */
	$"8080 8081 807F 7E7E 7E7E 7E7E 7D7C 7C7C"            /* .~~~~~~}||| */
	$"7C7B 7A7A 7A79 7979 7979 797A 7B7B 7C7C"            /* |{zzzyyyyyyz{{|| */
	$"7C7C 7C7D 7D7D 7D7B 7A7B 7D7D 7C7B 7B7B"            /* |||}}}}{z{}}|{{{ */
	$"7B7A 7B7C 7C7C 7B7B 7C7E 7F7F 7F80 8080"            /* {z{|||{{|~... */
	$"807E 7D7C 7C7C 7C7B 7A7A 7B7C 7C7D 7E7E"            /* ~}||||{zz{||}~~ */
	$"7E7D 7F81 8281 8080 8081 8282 8283 8382"            /* ~}. */
	$"8180 8081 8180 7F80 807F 7E7E 7E7E 7D7C"            /* ..~~~~}| */
	$"7C7C 7D7E 7E7E 7D7D 7E7F 7E7D 7D7D 7D7C"            /* ||}~~~}}~.~}}}}| */
	$"7D7D 7D7C 7B7B 7C7C 7C7C 7B7C 7D7E 7F7F"            /* }}}|{{||||{|}~.. */
	$"7F7E 7D7E 7F80 807F 7E7E 7E7E 7E7E 7F7E"            /* .~}~..~~~~~~.~ */
	$"7D7C 7B7C 7C7B 7A7A 7B7C 7C7C 7C7D 7E80"            /* }|{||{zz{||||}~ */
	$"807F 7E7F 7F7F 7F80 8080 807F 7F80 8081"            /* .~...... */
	$"8080 8080 8181 8080 8080 8080 8182 8181"            /*  */
	$"8181 8181 8182 8281 8080 8081 8181 8181"            /*  */
	$"8080 8080 8081 8181 8181 8282 8283 8484"            /*  */
	$"8282 8384 8381 8180 8080 7F7F 7F7F 8080"            /* .... */
	$"8081 8181 8281 8181 807F 7E7E 7E7E 7D7D"            /* .~~~~}} */
	$"7D7D 7D7E 7F7F 8080 8181 8282 8282 8283"            /* }}}~.. */
	$"8383 8382 8180 8080 8080 807F 7F80 8080"            /* .. */
	$"8181 8080 8080 8081 8281 8080 8183 8484"            /*  */
	$"8585 8585 8586 8685 8381 8181 8181 8080"            /*  */
	$"8080 8181 8182 8382 8181 8182 8281 8181"            /*  */
	$"8181 8181 8181 8181 807F 7E7F 8080 8080"            /* .~. */
	$"8080 8082 8383 8382 8283 8586 8584 8383"            /*  */
	$"8282 8282 8282 8282 8181 8181 8281 8181"            /*  */
	$"8283 8383 8384 8483 8282 8282 8281 8181"            /*  */
	$"8282 8282 8282 8282 8181 8181 8181 8080"            /*  */
	$"8081 8181 8181 8282 8282 8383 8483 8383"            /*  */
	$"8382 8181 8181 8080 7F7F 8080 8180 807F"            /* ... */
	$"8080 807F 7F7F 7E7D 7E7F 8080 8080 8080"            /* ...~}~. */
	$"8080 807F 7F7E 7E7E 7E7E 7E7F 8081 8182"            /* ..~~~~~~. */
	$"8281 8181 8282 8180 7F80 8081 8180 807F"            /* .. */
	$"7F80 8181 8080 8081 8182 8384 8381 8181"            /* . */
	$"8282 8281 8181 8182 8282 8282 8282 8282"            /*  */
	$"8382 8281 8180 8080 8081 8181 8080 8080"            /*  */
	$"8283 8382 8181 8181 8182 8180 8080 8080"            /*  */
	$"8080 7F7F 7E7D 7D7E 7E7E 7E7E 7E7E 7F80"            /* ..~}}~~~~~~~. */
	$"8182 8180 8080 8182 8281 8080 8080 8080"            /*  */
	$"7F7E 7E7F 8081 8281 8080 8182 8383 8281"            /* .~~. */
	$"8080 8181 8283 8280 807F 8080 8080 7F7E"            /* ..~ */
	$"7E7F 8081 8281 8080 8080 8180 8080 8080"            /* ~. */
	$"8080 8081 8080 8080 7F7E 7F7F 7E7E 7E7E"            /* .~..~~~~ */
	$"7E7E 7E7F 7F7F 8080 8181 8080 8081 8282"            /* ~~~... */
	$"8180 807F 7E7D 7C7C 7B7A 7A7B 7C7D 7D7D"            /* .~}||{zz{|}}} */
	$"7C7D 7E7F 7F7F 7F7F 7F7F 8080 8080 807F"            /* |}~........ */
	$"7E7D 7C7C 7C7D 7E7E 7E7D 7D7E 8080 8080"            /* ~}|||}~~~}}~ */
	$"8080 8181 8281 8181 8180 807F 7E7E 7E7E"            /* .~~~~ */
	$"7E7E 7D7C 7D7E 7F80 807F 7F80 8283 8483"            /* ~~}|}~... */
	$"8282 8180 8081 807F 7E7D 7D7E 8080 7F7E"            /* .~}}~.~ */
	$"7D7D 7F80 8080 807F 7F80 8081 8180 8080"            /* }}... */
	$"807F 7F7F 7F7E 7E7D 7C7C 7D7E 7F7F 7E7F"            /* ....~~}||}~..~. */
	$"8080 8080 8080 8180 8080 8080 7E7D 7D7C"            /* ~}}| */
	$"7C7C 7C7C 7C7B 7B7C 7D7E 7E7E 7D7D 7E7F"            /* |||||{{|}~~~}}~. */
	$"8080 8080 8080 8080 8180 8080 8080 807F"            /* . */
	$"7E7F 7F7E 7E7D 7E7F 8080 8080 8080 8080"            /* ~..~~}~. */
	$"8081 8180 8080 8080 7F7F 7F7F 7D7C 7C7C"            /* ....}||| */
	$"7D7E 7E7E 7E7F 7F7F 8080 807F 7E7D 7E7E"            /* }~~~~....~}~~ */
	$"7F7F 7F7F 8080 8081 8080 8080 8080 807F"            /* ..... */
	$"7E7D 7E7F 8080 7E7D 7D7E 7F7F 7F7E 7D7D"            /* ~}~.~}}~...~}} */
	$"7E7E 7E7F 7F7F 7E7E 7F7F 7F7F 8080 7F7E"            /* ~~~...~~.....~ */
	$"7E7E 7E7E 7E7E 7D7D 7D7E 7F7F 7F7E 7F80"            /* ~~~~~~}}}~...~. */
	$"8182 8180 8080 7F7E 7E7D 7D7D 7E7E 7E7E"            /* .~~}}}~~~~ */
	$"7E7E 7F80 807F 7E7D 7E7F 8080 807E 7E7F"            /* ~~..~}~.~~. */
	$"8182 8180 8080 8081 8181 807F 7E7E 7E7E"            /* .~~~~ */
	$"7E7D 7C7C 7D7D 7D7D 7C7D 7E7F 8080 8080"            /* ~}||}}}}|}~. */
	$"7F7F 8080 8080 7F7E 7E7E 7E7F 7F7F 7F7F"            /* ...~~~~..... */
	$"7F80 8080 807F 7E7E 7F7F 8080 8080 8081"            /* ..~~.. */
	$"8180 8080 8080 7F7E 7D7D 7D7E 7E7D 7D7D"            /* .~}}}~~}}} */
	$"7E7F 8080 7F80 8080 8080 8080 8080 8080"            /* ~.. */
	$"807F 8080 8080 807F 7E7F 7F7F 8080 8080"            /* ..~... */
	$"8080 8181 8181 8080 8080 8080 7F7F 7F7E"            /* ...~ */
	$"7E7E 7E7E 7E7E 7E7D 7E80 8080 7F7E 7E7F"            /* ~~~~~~~}~.~~. */
	$"8080 8080 807F 8081 8282 8181 8181 8282"            /* . */
	$"8181 8180 807F 7F7F 7F7E 7E7E 7E7E 7F80"            /* ....~~~~~. */
	$"8080 8080 8080 8080 8180 807F 7E7F 8080"            /* .~. */
	$"8080 8080 8080 8081 8180 8080 8181 8080"            /*  */
	$"8080 8182 8180 8080 8080 8181 8180 7F7E"            /* .~ */
	$"7E7E 7E7E 7D7D 7E7E 7F80 8080 8181 8181"            /* ~~~~}}~~. */
	$"8181 8180 8080 7F7F 8080 8081 8180 807F"            /* ... */
	$"8080 8180 807F 7E7F 8080 8080 8080 8080"            /* .~. */
	$"8080 7F80 8080 8180 8080 8080 807F 7E7E"            /* ..~~ */
	$"7F80 8080 807F 7E7F 8080 8080 8080 8080"            /* ..~. */
	$"8182 8181 8080 8081 8080 7F7F 7F7F 7F7E"            /* .....~ */
	$"7E7E 7E7E 7F80 8080 8080 8081 8080 807F"            /* ~~~~.. */
	$"7E7D 7D7D 7D7D 7D7D 7D7E 7F7F 8080 8080"            /* ~}}}}}}}}~.. */
	$"8080 8181 8180 8080 807F 7E7E 7F7F 7F7F"            /* .~~.... */
	$"7F7E 7E7F 7F7F 7F7E 7D7D 7E7E 7E7E 7F7F"            /* .~~....~}}~~~~.. */
	$"7F80 8080 8080 8081 8181 8180 8080 8080"            /* . */
	$"807F 7E7E 7F80 8080 8080 8080 8182 8282"            /* .~~. */
	$"8281 8181 8181 8080 8080 8080 7F7F 7F7F"            /* .... */
	$"8080 8080 8080 8080 8080 8080 8080 807F"            /* . */
	$"7F80 8080 7F7F 7F7F 7E7F 8080 8080 8080"            /* .....~. */
	$"7F7F 7E7E 7E7E 7E7E 7D7E 7F80 8080 8080"            /* ..~~~~~~}~. */
	$"8081 8181 8080 7F7F 7F7F 7E7E 7D7D 7D7D"            /* ....~~}}}} */
	$"7D7D 7E7F 8080 8080 8080 8081 8080 8080"            /* }}~. */
	$"8080 8080 7F7E 7F80 8080 7F7E 7F7F 8080"            /* .~..~.. */
	$"807F 7F7F 7F7F 7E7E 7E7F 7F7F 7F80 8080"            /* .....~~~.... */
	$"8080 8080 8081 8181 8080 7F7F 7F7F 7F7E"            /* .....~ */
	$"7E7D 7D7E 7E7E 7E7E 7F80 8080 8080 8080"            /* ~}}~~~~~. */
	$"807F 7F7F 7F7F 7E7E 7D7D 7D7D 7D7D 7D7D"            /* .....~~}}}}}}}} */
	$"7D7E 7F80 8080 8080 8080 8080 8080 807F"            /* }~.. */
	$"8080 8080 8080 8081 8181 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 807F 7F80 8080"            /* .. */
	$"8080 8080 8081 8181 8181 8181 8282 8181"            /*  */
	$"8181 8180 807F 7F7F 7F80 8080 8080 8080"            /* .... */
	$"7F7F 7E7E 7E7E 7E7E 7F80 8080 8080 807F"            /* ..~~~~~~.. */
	$"7F7E 7E7E 7E7E 7E7E 7E7E 7E7E 7F7F 7F7F"            /* .~~~~~~~~~~~.... */
	$"8080 8080 8080 8080 8080 8080 8080 7F7F"            /* .. */
	$"7F7F 7F7F 7E7E 7D7D 7D7D 7D7E 7E7E 7F7F"            /* ....~~}}}}}~~~.. */
	$"8080 8081 8181 8181 8181 8080 8080 8080"            /*  */
	$"8080 8080 7F80 8080 8181 8181 8180 8080"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 807F"            /* . */
	$"7F7F 7F7F 7F7F 7E7F 7F80 8080 8080 8081"            /* ......~.. */
	$"8181 8181 8181 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 7F7F 7F7F 7E7E 7E7E"            /* ....~~~~ */
	$"7E7E 7E7F 8080 8080 8181 8080 8080 8081"            /* ~~~. */
	$"8181 8181 8181 8282 8282 8181 8181 8281"            /*  */
	$"807F 7E7E 7E7E 7E7D 7C7D 7D7E 7F7F 7F7E"            /* .~~~~~}|}}~...~ */
	$"7F80 8080 8080 7F80 8080 8080 7F7F 8080"            /* .... */
	$"807F 7F7F 7F7F 7F7F 7F7F 8080 8080 8080"            /* ......... */
	$"8080 8080 8080 7F7F 7E7E 7E7E 7F7F 7F7F"            /* ..~~~~.... */
	$"7F7F 7F80 8080 8080 8080 8080 8081 8181"            /* ... */
	$"8181 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 7F7F 7F7F 7F7F 7F7E 7E7E 7E7F 7F7E"            /* .......~~~~..~ */
	$"7E7E 7E7F 7F7F 7F7F 7F7F 7F7F 7F80 8080"            /* ~~~.......... */
	$"8081 8180 8080 807F 7F80 8080 8080 7F7F"            /* .... */
	$"8080 8080 8080 7F7F 7F7E 7E7E 7E7E 7E7E"            /* ...~~~~~~~ */
	$"7E7E 7E7E 7E7F 7F7F 7F7F 7F7F 7F7F 8080"            /* ~~~~~......... */
	$"8080 8080 8081 8180 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 7F7F 7E7D 7D7D 7D7D"            /* ..~}}}}} */
	$"7D7D 7D7D 7E7E 7F80 8080 8080 8080 8080"            /* }}}}~~. */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 7F7F 7F7E 7E7E 7E7E 7E7E 7E7E"            /* ...~~~~~~~~~ */
	$"7E7E 7E7E 7E7E 7F7F 7F7F 7F7F 7F80 8080"            /* ~~~~~~....... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 807F 7F80 8080"            /* .. */
	$"8080 8080 8080 8080 8080 8080 8080 8081"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8282 8181 8181 8181 8080 8080"            /*  */
	$"8080 8080 8080 8080 8181 8181 8282 8282"            /*  */
	$"8283 8282 8282 8282 8282 8282 8282 8281"            /*  */
	$"8181 8182 8282 8281 8181 8181 8181 8180"            /*  */
	$"8081 8181 8181 8181 8282 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8282 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8281 8181 8181 8181"            /*  */
	$"8180 8080 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8282 8281 8181 8181 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8281 8181 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8081 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8281 8181 8181 8181 8181 8080 8080 8181"            /*  */
	$"8181 8180 8080 8080 8081 8181 8181 8181"            /*  */
	$"8181 8181 8181 8182 8282 8282 8282 8282"            /*  */
	$"8282 8281 8181 8181 8181 8180 8080 8080"            /*  */
	$"7F7F 8080 8080 8080 8081 8181 8180 8080"            /* .. */
	$"8080 8080 8180 8080 8080 8081 8181 8180"            /*  */
	$"8080 8081 8181 8181 8181 8180 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 807F 7F7F"            /* ... */
	$"7F80 8080 7F7F 7F80 8080 8080 807F 7F7F"            /* ....... */
	$"7F7F 7F7F 7F80 8080 8080 7F7F 8080 8080"            /* ....... */
	$"7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F"            /* ................ */
	$"7F7F 8080 807F 7F7F 8080 8080 8080 8080"            /* ..... */
	$"8080 8080 807F 7F7F 7F7F 7F7F 7F7F 8080"            /* ......... */
	$"8080 8080 8080 8080 8080 8080 8080 807F"            /* . */
	$"7F7F 8080 7F7F 7F80 8080 8080 8080 8080"            /* ..... */
	$"8080 8080 8080 8080 8080 807F 7F7F 8080"            /* ... */
	$"8080 807F 7F7F 8080 8080 8080 8080 8080"            /* ... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"807F 7F80 8080 8080 8080 8080 8080 8080"            /* .. */
	$"8080 8080 8080 8080 8181 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 807F 7F80 8080 8080 8080 807F"            /* ... */
	$"7F7F 8080 8080 7F7F 7F7F 7F80 8080 8080"            /* ....... */
	$"7F7F 8080 8080 8080 807F 7F7F 8080 8080"            /* ..... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 7F7F 8080 8080 8080 8080 8080 8081"            /* .. */
	$"8180 8081 8181 8282 8181 8181 8182 8281"            /*  */
	$"8181 8181 8181 8181 8182 8281 8181 8080"            /*  */
	$"8181 8181 8080 8080 8080 8081 8180 8080"            /*  */
	$"8181 8181 8181 8181 8282 8181 8181 8282"            /*  */
	$"8281 8181 8181 8181 8181 8181 8281 8181"            /*  */
	$"8181 8181 8180 8080 8080 8080 8080 8181"            /*  */
	$"8080 8080 8080 8081 8180 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"7F7F 7F80 8080 807F 7F7F 7F80 8080 7F7F"            /* ......... */
	$"7F7F 8080 8080 8080 8080 8080 8080 8080"            /* .. */
	$"8080 8080 7F7F 7E7F 7F80 807F 7F7F 7F7F"            /* ..~....... */
	$"7F7F 7F7F 7F7F 7F7F 7F7E 7F7F 7F7F 7F7F"            /* .........~...... */
	$"7F7F 7F7F 7F7F 7F80 8080 8080 7F80 8080"            /* ........ */
	$"8080 807F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F"            /* ............. */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7D7E 7E7E 7E7E"            /* ~~~~~~~~~~}~~~~~ */
	$"7E7E 7E7E 7E7F 7F80 8080 807F 7F7E 7F7F"            /* ~~~~~....~.. */
	$"7F7F 7F7F 7F7E 7E7E 7E7F 7F7F 7E7E 7E7E"            /* .....~~~~...~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7D7D 7D7D 7D7D 7D7D"            /* ~~~~~~~~}}}}}}}} */
	$"7D7D 7D7D 7D7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* }}}}}~~~~~~~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7F7F 7E7E 7E7E 7E7E"            /* ~~~~~~~~..~~~~~~ */
	$"7E7D 7D7D 7D7D 7D7D 7D7C 7C7D 7D7C 7C7C"            /* ~}}}}}}}}||}}||| */
	$"7C7C 7C7C 7D7D 7D7D 7D7D 7D7D 7D7D 7D7D"            /* ||||}}}}}}}}}}}} */
	$"7D7D 7D7D 7D7D 7C7D 7D7D 7D7D 7D7D 7C7C"            /* }}}}}}|}}}}}}}|| */
	$"7D7D 7D7D 7C7D 7D7D 7D7C 7C7C 7C7C 7D7D"            /* }}}}|}}}}|||||}} */
	$"7D7C 7C7C 7C7C 7C7C 7C7C 7C7C 7C7C 7C7C"            /* }||||||||||||||| */
	$"7C7C 7C7C 7C7C 7C7C 7C7C 7C7C 7D7D 7C7C"            /* ||||||||||||}}|| */
	$"7C7C 7C7C 7C7C 7C7C 7C7C 7C7C 7C7C 7C7C"            /* |||||||||||||||| */
	$"7C7C 7C7C 7C7C 7C7C 7C7C 7C7C 7C7C 7C7D"            /* |||||||||||||||} */
	$"7D7D 7D7C 7C7C 7C7C 7C7C 7C7C 7D7D 7D7D"            /* }}}|||||||||}}}} */
	$"7C7C 7C7C 7C7C 7D7D 7D7D 7C7C 7C7C 7C7C"            /* ||||||}}}}|||||| */
	$"7C7C 7C7C 7C7C 7C7C 7D7D 7D7D 7D7D 7D7D"            /* ||||||||}}}}}}}} */
	$"7D7E 7E7E 7E7E 7E7E 7D7D 7E7E 7E7E 7E7E"            /* }~~~~~~~}}~~~~~~ */
	$"7D7D 7D7D 7E7E 7E7D 7D7D 7D7D 7D7D 7D7D"            /* }}}}~~~}}}}}}}}} */
	$"7D7D 7D7D 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* }}}}~~~~~~~~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7F 7F7F 7F7F"            /* ~~~~~~~~~~~..... */
	$"7F7F 7F80 807F 7F7F 7F80 807F 7F7F 7F7F"            /* ............ */
	$"8080 807F 7F7E 7F7F 8080 8080 807F 7F80"            /* ..~.... */
	$"8080 8080 807F 7F7F 7F80 8080 8080 8080"            /* .... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8081 8181 8080 8080"            /*  */
	$"8080 8181 8181 8181 8080 8181 8181 8181"            /*  */
	$"8181 8080 8081 8181 8180 8080 8080 8081"            /*  */
	$"8180 8081 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8180 8080 8181 8080 8080 8080"            /*  */
	$"8181 8080 8080 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8281 8181 8181 8181 8282 8181"            /*  */
	$"8182 8281 8181 8282 8282 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8080 8181 8182 8281 8181 8181 8282 8282"            /*  */
	$"8281 8181 8181 8181 8181 8181 8181 8182"            /*  */
	$"8282 8181 8181 8181 8282 8282 8282 8181"            /*  */
	$"8182 8282 8282 8181 8181 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8282 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8282 8282 8383 8382"            /*  */
	$"8282 8282 8383 8383 8282 8282 8282 8282"            /*  */
	$"8282 8181 8181 8282 8282 8281 8181 8181"            /*  */
	$"8182 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8282 8282 8282 8282 8282 8283 8383"            /*  */
	$"8282 8282 8282 8282 8282 8282 8282 8281"            /*  */
	$"8182 8282 8282 8181 8181 8282 8282 8282"            /*  */
	$"8282 8282 8282 8282 8282 8181 8282 8282"            /*  */
	$"8282 8181 8181 8182 8282 8181 8181 8282"            /*  */
	$"8281 8181 8182 8282 8281 8181 8181 8281"            /*  */
	$"8181 8181 8281 8181 8182 8282 8181 8181"            /*  */
	$"8182 8181 8181 8181 8181 8181 8182 8181"            /*  */
	$"8181 8182 8282 8181 8181 8182 8282 8281"            /*  */
	$"8181 8182 8282 8281 8181 8181 8182 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8282 8281 8181 8181 8282"            /*  */
	$"8281 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8281 8181 8181 8181 8181 8181 8281"            /*  */
	$"8181 8181 8181 8282 8282 8281 8181 8181"            /*  */
	$"8282 8281 8181 8181 8181 8281 8181 8181"            /*  */
	$"8181 8181 8180 8080 8181 8181 8181 8180"            /*  */
	$"8080 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8080 8081 8181"            /*  */
	$"8180 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 807F 7F80 8080 8080"            /* .. */
	$"8080 807F 8080 8080 8080 8080 8080 8080"            /* . */
	$"8080 8180 8080 7F80 8080 8080 8080 807F"            /* .. */
	$"7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7E7E 7E7F"            /* ............~~~. */
	$"7F7E 7E7E 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F"            /* .~~~............ */
	$"7F7F 8080 7F7F 7F7F 7F7F 7F80 8080 8080"            /* ......... */
	$"7F7F 7E7E 7F7F 7F7F 7F7F 7E7E 7E7F 7F7F"            /* ..~~......~~~... */
	$"7F7E 7E7E 7E7E 7F7F 7F7F 7F7F 7E7E 7E7E"            /* .~~~~~......~~~~ */
	$"7F7F 7F7E 7E7E 7D7E 7E7E 7E7E 7E7E 7E7E"            /* ...~~~}~~~~~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7D7E 7E7E 7E7E 7E7E"            /* ~~~~~~~~}~~~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~~~~~~~~~~~~~~~~ */
	$"7E7F 7F7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~..~~~~~~~~~~~~~ */
	$"7E7E 7E7E 7E7F 7F7F 7E7E 7D7E 7E7E 7E7E"            /* ~~~~~...~~}~~~~~ */
	$"7E7E 7D7D 7D7D 7E7E 7F7F 7E7E 7E7E 7E7F"            /* ~~}}}}~~..~~~~~. */
	$"7F7F 7F7F 7F7F 7F7E 7E7E 7E7F 7F7F 7E7E"            /* .......~~~~...~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7D 7D7E 7E7E"            /* ~~~~~~~~~~~}}~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7F7F 7F7F 7F7F 7F7F"            /* ~~~~~~~~........ */
	$"7F7F 7F7F 8080 7F7F 7F7F 8080 8080 8080"            /* ........ */
	$"8080 8080 8080 8080 8080 8080 7F7F 7F80"            /* ... */
	$"8080 807F 7E7F 7F80 8080 807F 7F7F 7F7F"            /* .~....... */
	$"7F7F 7F7F 7F7F 7F7F 7F7F 7F7E 7F7F 7F7F"            /* ...........~.... */
	$"7E7E 7E7E 7F7F 7F7F 7E7E 7E7F 7F7E 7E7E"            /* ~~~~....~~~..~~~ */
	$"7E7E 7E7E 7E7E 7D7E 7E7E 7E7E 7E7E 7E7E"            /* ~~~~~~}~~~~~~~~~ */
	$"7E7E 7E7E 7D7E 7E7E 7E7D 7D7E 7E7E 7E7E"            /* ~~~~}~~~~}}~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7F 7F7E"            /* ~~~~~~~~~~~~~..~ */
	$"7E7F 8080 7F7E 7E7F 8080 8080 8080 8080"            /* ~..~~. */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8081 8080 8080 8080 8080 8081 8180"            /*  */
	$"8080 8080 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8080"            /*  */
	$"8080 8181 8181 8181 8080 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8281 8181 8181 8181"            /*  */
	$"8181 8180 8080 8080 8080 8081 8080 8080"            /*  */
	$"8080 8080 8180 8080 8080 8080 8080 8180"            /*  */
	$"8080 8080 8080 8081 8181 8181 8080 8081"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8180 8080 8080 8181 8181"            /*  */
	$"8181 8181 8181 8180 8081 8181 8181 8180"            /*  */
	$"8080 8181 8180 8080 8080 8080 8080 8181"            /*  */
	$"8181 8080 8081 8181 8180 8081 8181 8181"            /*  */
	$"8181 8181 8080 8081 8181 8180 8080 8080"            /*  */
	$"8081 8180 8080 8080 8080 8181 8080 8080"            /*  */
	$"8080 8180 8080 8080 8080 8080 8080 8081"            /*  */
	$"8180 8081 8181 8181 8181 8181 8180 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8081 8080 8080 8080 8080"            /*  */
	$"8080 8181 8180 8080 8080 8081 8181 8180"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 807F 8080 8080 8080 8080 8080"            /* . */
	$"8080 8080 8080 7F7F 7F7F 8080 8080 8080"            /* .... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 7F7F 8080 7F80 8080 8080 7F80 8080"            /* .... */
	$"8080 8080 8080 807F 7F7F 8080 8080 807F"            /* .... */
	$"7F7F 7F80 8080 8080 7F7F 7F80 8080 8080"            /* ...... */
	$"8080 8080 8080 8080 8080 8080 7F7F 7F7F"            /* .... */
	$"8080 807F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7E"            /* ............~ */
	$"7E7E 7E7F 7F7F 7F7E 7E7F 7F7E 7E7E 7E7E"            /* ~~~....~~..~~~~~ */
	$"7F7F 7F7F 7E7E 7E7F 7F7F 7F7F 7F7E 7E7F"            /* ....~~~......~~. */
	$"7F7F 7F7F 7E7E 7E7E 7E7E 7E7E 7E7F 7F7F"            /* ....~~~~~~~~~... */
	$"7E7E 7E7E 7E7F 8080 7F7F 7E7E 7E7F 7F7F"            /* ~~~~~...~~~... */
	$"7F80 807F 7F7E 7E7E 7F7F 7F7F 7F7F 7F7F"            /* ...~~~........ */
	$"7F7E 7E7F 7F7F 7E7E 7E7F 7F7F 7F7F 7E7E"            /* .~~...~~~.....~~ */
	$"7E7F 7F7F 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~...~~~~~~~~~~~~ */
	$"7E7E 7E7E 7E7D 7D7D 7D7D 7D7E 7E7E 7D7D"            /* ~~~~~}}}}}}~~~}} */
	$"7D7D 7E7E 7E7E 7E7E 7D7D 7D7D 7E7E 7E7E"            /* }}~~~~~~}}}}~~~~ */
	$"7E7D 7D7D 7D7E 7E7E 7E7E 7D7D 7D7E 7E7E"            /* ~}}}}~~~~~}}}~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~~~~~~~~~~~~~~~~ */
	$"7E7E 7E7E 7E7E 7E7E 7E7E 7E7E 7D7D 7E7E"            /* ~~~~~~~~~~~~}}~~ */
	$"7E7E 7E7E 7D7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~~~~}~~~~~~~~~~~ */
	$"7E7F 7F7F 7F7F 7F7E 7F80 8080 807F 7F7F"            /* ~......~.... */
	$"7F7F 7F80 8080 7F7F 7F7F 7F7F 8080 7F7E"            /* ..........~ */
	$"7E7F 7F7F 7F7F 7F7E 7F80 8080 7F7E 7E7F"            /* ~......~..~~. */
	$"7F80 807F 7E7F 8080 807F 7F7E 7F7F 7F7F"            /* ..~...~.... */
	$"7E7E 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F80"            /* ~~............. */
	$"807F 7F7F 7F7F 7F7F 7F7F 7F7E 7E7E 7E7E"            /* ..........~~~~~ */
	$"7F7F 7F7F 7E7E 7E7E 7F7F 7F7F 7E7E 7E7E"            /* ....~~~~....~~~~ */
	$"7E7E 7E7F 7F80 807F 7F7E 7E7F 8080 8080"            /* ~~~....~~. */
	$"7F80 8080 7F7F 8080 8080 8080 8080 8080"            /* ... */
	$"8080 8080 8080 807F 7F80 8080 8080 8080"            /* .. */
	$"7F80 8080 8080 8080 8080 7F7F 7F80 8080"            /* .... */
	$"8080 8080 807F 7F7F 8080 8080 8080 8080"            /* ... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 807F 8080 8080"            /* . */
	$"8080 8080 8080 8080 8081 8080 8080 8080"            /*  */
	$"8080 8080 8080 8180 8080 8081 8180 8080"            /*  */
	$"8081 8080 8081 8181 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"7F80 8080 8080 807F 8080 8080 8080 8080"            /* .. */
	$"807F 8080 8080 8080 8080 8080 8080 8080"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8180 8080 8080 8080 8080 8080"            /*  */
	$"7F80 8080 7F80 8080 807F 7F7F 7F7F 7F7F"            /* ......... */
	$"7F7F 7F7F 7F7F 7F7F 8080 807F 8080 8080"            /* ......... */
	$"7F80 8080 8080 8080 8080 7F7F 8080 8080"            /* ... */
	$"807F 7F7F 7F80 807F 7F7F 7F7F 7F7F 7F7F"            /* ............. */
	$"7F7F 7F7F 7F7E 7F7F 7F7F 7F7F 7F7F 7E7F"            /* .....~........~. */
	$"7F80 8080 8080 8080 8080 8080 8080 8080"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"7F7F 7F80 8080 807F 7E7F 7F7F 7F7F 7E7E"            /* ....~.....~~ */
	$"7F7F 7F7F 7F7F 7F80 8080 7F7F 8080 8080"            /* ......... */
	$"807F 7F80 8080 8080 8080 8080 8080 8080"            /* .. */
	$"8180 8080 8080 8080 8080 8080 8080 807F"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 7F7F 8080 8080 8080 8080 8080 8080"            /* .. */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 7F7F 8080 8080 807F"            /* ... */
	$"8080 8080 7F7F 8080 8080 807F 7F7F 8080"            /* ..... */
	$"8080 7F7F 7F7F 7F7E 7E7F 7F7F 7E7F 7F7F"            /* .....~~...~... */
	$"7F7F 7F80 8080 8080 807F 8080 8080 8080"            /* .... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8181 8181 8181 8181 8080 8080"            /*  */
	$"8081 8181 8080 8080 8181 8181 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 80"                                            /*  */
};

data 'snd ' (258, "bonjour_out", purgeable) {
	$"0001 0001 0005 0000 0080 0001 8051 0000"            /* ...........Q.. */
	$"0000 0014 0000 0000 0000 32DB 56EE 8BA3"            /* ..........2.V. */
	$"0000 0000 0000 0000 003C 7B7C 7D7D 7E7E"            /* .........<{|}}~~ */
	$"7E7D 7C7C 7C7D 7D7D 7D7E 7E7D 7D7D 7D7D"            /* ~}|||}}}}~~}}}}} */
	$"7D7E 7F7F 7F7E 7D7D 7E7E 7F7F 7F7F 7E7F"            /* }~...~}}~~....~. */
	$"7F7E 7E7E 7E7F 8080 8080 7F7E 7E7E 7E7E"            /* .~~~~..~~~~~ */
	$"7E7F 8080 807F 7D7D 7E7F 8080 807F 7E7E"            /* ~..}}~..~~ */
	$"7F80 8080 8080 8080 807F 7F7F 7E7E 7F80"            /* ....~~. */
	$"8080 807F 7E7F 8080 8180 807F 7F80 8080"            /* .~... */
	$"807F 7F80 8080 8080 8080 8081 8181 8180"            /* .. */
	$"8080 8080 7F7F 7E7F 8182 817F 7E7F 8080"            /* ..~..~. */
	$"8080 8180 8080 8080 7F7E 7F80 8182 8180"            /* .~. */
	$"7E7E 7F80 8182 8180 8080 8080 807F 8080"            /* ~~.. */
	$"8182 8281 7F7E 7F80 8182 8383 8281 8181"            /* .~. */
	$"8182 8283 8383 8282 8181 8181 8282 8383"            /*  */
	$"8282 8282 8282 8384 8484 8484 8483 8383"            /*  */
	$"8484 8484 8383 8383 8384 8484 8483 8384"            /*  */
	$"8584 8383 8384 8485 8483 8383 8384 8484"            /*  */
	$"8484 8484 8483 8282 8283 8485 8584 8382"            /*  */
	$"8181 8183 8485 8483 8280 8080 8182 8383"            /*  */
	$"8382 8282 8181 8282 8283 8282 8180 8080"            /*  */
	$"8182 8282 8282 8180 8080 8181 8283 8281"            /*  */
	$"8080 8081 8182 8281 8180 8080 8181 8181"            /*  */
	$"8181 8180 8080 8080 8283 8382 8181 8182"            /*  */
	$"8383 8384 8383 8484 8383 8383 8484 8483"            /*  */
	$"8384 8484 8484 8484 8484 8584 8383 8384"            /*  */
	$"8484 8484 8484 8484 8484 8484 8585 8586"            /*  */
	$"8686 8584 8485 8686 8685 8585 8585 8585"            /*  */
	$"8483 8485 8685 8483 8384 8485 8686 8583"            /*  */
	$"8383 8383 8383 8382 8180 8080 8080 8080"            /*  */
	$"8080 7F7E 7E7E 7E7E 7F7F 7F7E 7D7C 7D7D"            /* .~~~~~...~}|}} */
	$"7D7D 7C7B 7C7C 7B7B 7A79 7A7B 7B7B 7A79"            /* }}|{||{{zyz{{{zy */
	$"7A7C 7C7B 7A79 7877 7778 7878 7879 7979"            /* z||{zyxwwxxxxyyy */
	$"797A 7A7A 7A7B 7B7B 7C7C 7D7D 7D7E 7E7F"            /* yzzzz{{{||}}}~~. */
	$"7F7F 7F7F 8080 8181 8080 8081 8282 8282"            /* .... */
	$"8282 8384 8484 8484 8585 8585 8585 8686"            /*  */
	$"8686 8686 8688 8989 8887 8788 898A 8A8A"            /*  */
	$"8989 898A 8A8A 8B8B 8B8B 8B8A 8989 898A"            /*  */
	$"8A8B 8B8B 8A89 8989 8A8B 8C8C 8B8B 8B8C"            /*  */
	$"8D8E 8D8C 8C8C 8B8B 8A8A 8989 8989 8988"            /*  */
	$"8786 8686 8686 8685 8484 8484 8381 8080"            /*  */
	$"8080 7E7D 7C7A 7978 7979 7877 7574 7372"            /* ~}|zyxyyxwutsr */
	$"7271 716F 6E6E 6E6E 6D6C 6A6A 6B6B 6B6A"            /* rqqonnnnmljjkkkj */
	$"6867 6768 6969 6968 6768 6869 696A 6B6B"            /* hgghiiihghhiijkk */
	$"6B6C 6D6D 6D6E 6F70 7070 7172 7474 7576"            /* klmmmnopppqrttuv */
	$"7879 7A7B 7C7E 7F80 8183 8485 8687 888A"            /* xyz{|~. */
	$"8B8C 8E8F 9091 9292 9394 9596 9798 9897"            /*  */
	$"9798 9999 9999 9A9A 9C9D 9E9F 9E9E A0A2"            /*  */
	$"A3A4 A5A6 A6A6 A6A7 A8A9 A9A9 AAAB ABAB"            /*  */
	$"ABAB ACAD ADAE AFAF AFB0 B1B2 B2B2 B3B2"            /*  */
	$"B1AF ADAA A7A4 A09C 9792 8E89 837E 7974"            /* ~yt */
	$"716E 6C6A 6764 6260 5F5E 5F60 6264 6566"            /* qnljgdb`_^_`bdef */
	$"6768 696A 6D6F 7173 7373 7474 7475 7677"            /* ghijmoqssstttuvw */
	$"7776 7575 7574 7372 7171 706F 6E6B 6865"            /* wvuuutsrqqponkhe */
	$"6463 6361 5E5B 5754 5252 5151 504F 5052"            /* dcca^[WTRRQQPOPR */
	$"5456 595C 5E61 666C 7074 7678 7B7D 7F80"            /* TVY\^aflptvx{}. */
	$"8182 8180 7F7D 7B79 7775 7372 716F 6D6B"            /* .}{ywusrqomk */
	$"6A6A 6B6C 6C6C 6C6D 6F72 7474 7576 787B"            /* jjkllllmorttuvx{ */
	$"7E80 8181 8283 8687 888A 8C8E 9092 9496"            /* ~ */
	$"9797 9799 9A9B 9B9C 9D9D 9C9C 9C9C 9D9D"            /*  */
	$"9D9E 9E9F A0A2 A4A5 A7A9 ACAE B0B2 B4B6"            /*  */
	$"B9BB BCBD BFC1 C3C5 C6C7 C7C7 C8CA CBCB"            /*  */
	$"CBCC CCCB C7C1 B9B3 ACA6 9F97 8E83 7A71"            /* zq */
	$"6A63 5C56 5351 5050 5051 5255 5A5F 656A"            /* jc\VSQPPPQRUZ_ej */
	$"6E72 777B 7D7F 8081 8281 807E 7B77 7471"            /* nrw{}.~{wtq */
	$"6E6B 6764 6260 5E5B 5958 5858 5959 5A5A"            /* nkgdb`^[YXXXYYZZ */
	$"5A5B 5C5E 5F60 6162 6466 6666 6667 6869"            /* Z[\^_`abdffffghi */
	$"6B6D 6E6E 6E6F 7070 6F6F 6D6B 6967 6462"            /* kmnnnoppoomkigdb */
	$"5F5C 5A58 5652 4F4D 4E4E 4E4D 4C4D 4F51"            /* _\ZXVROMNNNMLMOQ */
	$"5355 5759 5C5E 6062 6466 6768 696A 6A6A"            /* SUWY\^`bdfghijjj */
	$"6A6A 6968 6868 6868 6766 6665 6769 6B6C"            /* jjihhhhhgffegikl */
	$"6C6D 6E71 7375 7779 7B7D 8082 8486 8789"            /* lmnqsuwy{} */
	$"8B8E 9295 9798 999B 9FA4 A7A9 AAAB ACAE"            /*  */
	$"AFAF AFAE AEAF B0B2 B2B1 B0B0 B1B3 B6B7"            /*  */
	$"B9BA BBBD C0C3 C5C7 C9CD D0D3 D5D7 DBDF"            /* .. */
	$"E4E9 EDEF EEE8 E0D8 CFC6 BBAF 9F8E 7D6E"            /* .......ƻ}n */
	$"6053 4639 2F29 2727 282B 2F34 3C45 505B"            /* `SF9/)''(+/4<EP[ */
	$"6670 7A82 8A8F 9394 9595 9392 8F8C 8780"            /* fpz */
	$"7A73 6E6A 6766 6462 5F5E 5D5D 5D5E 5F60"            /* zsnjgfdb_^]]]^_` */
	$"6365 6768 6867 6767 6869 6A6C 6D6D 6C6C"            /* ceghhggghijlmmll */
	$"6E71 7579 7D81 8588 8C8F 9396 999C 9E9F"            /* nquy} */
	$"A09F 9D9A 9794 918C 8782 7C77 726D 6A67"            /* |wrmjg */
	$"6462 615F 5D5D 5E60 6264 6360 5B53 4B47"            /* dba_]]^`bdc`[SKG */
	$"4749 463D 2E23 2128 3030 2820 212D 3D47"            /* GIF=.#!(00( !-=G */
	$"4944 4249 5662 6767 6462 6366 6766 625E"            /* IDBIVbggdbcfgfb^ */
	$"5B5A 5857 5658 5A5C 5E60 656D 757C 8083"            /* [ZXWVXZ\^`emu| */
	$"858B 939A 9E9E 9D9C 9D9F A1A2 A19F 9D9E"            /*  */
	$"A0A4 A7A9 AAAB ADB1 B5B8 BBBF C2C6 CACE"            /*  */
	$"D2D5 D8DA DCDE E0E3 E5E8 E9E9 EBEE F2F7"            /* ............. */
	$"FAFD FFFF FFFF FFFF FFFF FFFE F7E8 D6C2"            /* .............. */
	$"AB94 7F6B 5742 2B17 0A05 0507 0A0E 141D"            /* .kWB+......... */
	$"2B3B 4B5B 6A79 8897 A3AC B2B4 B3B0 ADA9"            /* +;K[jy */
	$"A59F 978C 8076 6E68 635F 5A57 5556 585A"            /* vnhc_ZWUVXZ */
	$"5A5B 5C5F 6368 6C6D 6C6A 6766 6564 6362"            /* Z[\_chlmljgfedcb */
	$"6161 6263 6467 6A6E 747C 848C 9399 9EA2"            /* aabcdgjnt| */
	$"A7AB AEB0 B0AE ABA6 9F98 9088 8078 716B"            /* xqk */
	$"655E 5955 5353 5457 5B60 656A 6E71 757B"            /* e^YUSSTW[`ejnqu{ */
	$"8084 8683 7C70 6358 514F 4B41 301B 0D0A"            /* |pcXQOKA0.. */
	$"0E12 0E05 0006 1628 3335 3439 4658 666E"            /* .......(3549FXfn */
	$"7172 7376 7878 7775 7270 6C69 6867 6868"            /* qrsvxxwurplihghh */
	$"6766 676C 747C 8284 8485 8A90 9599 9A9A"            /* gfglt| */
	$"9A99 9898 9796 9492 9193 9699 9A9A 9B9D"            /*  */
	$"A2AA B1B7 BCC0 C4C9 CED3 D7DC E0E3 E4E6"            /* ..... */
	$"E8EA ECED EEEE EFF1 F5F8 FBFD FEFF FFFF"            /* ................ */
	$"FFFF FAEF E4DA D0C3 B098 7F6A 594B 3D2D"            /* ......ð.jYK=- */
	$"1E13 0D0E 1218 1E25 2F3A 4857 6675 828C"            /* ......%/:HWfu */
	$"949B A0A3 A6A6 A39D 9791 8B84 7D74 6C65"            /* }tle */
	$"6160 5F5E 5C5B 5B5C 5D5F 6061 6161 6060"            /* a`_^\[[\]_`aaa`` */
	$"5E5C 5956 5554 5455 5657 595C 6166 6D74"            /* ^\YVUTTUVWY\afmt */
	$"7C84 8B92 999E A3A6 A9AA A9A8 A5A0 9B94"            /* | */
	$"8D85 7E77 726D 6965 6261 6061 6366 6A6E"            /* ~wrmieba`acfjn */
	$"7175 787C 8082 817E 776E 655D 5A58 5245"            /* qux|~wne]ZXRE */
	$"321F 1517 1E21 1D14 0F16 2637 4142 4145"            /* 2....!....&7ABAE */
	$"505E 6A6F 6E6D 6C6B 6A69 6765 625E 5955"            /* P^jonmlkjigeb^YU */
	$"5659 5C5F 6061 646B 7580 878A 8A8B 8E93"            /* VY\_`adku */
	$"9799 9895 918D 8C8C 8C8B 8987 878A 8F94"            /*  */
	$"979A 9C9F A4AB B2B9 BDBF C1C3 C5C8 CDD1"            /*  */
	$"D4D5 D6D8 DCE0 E3E6 E8EC F0F4 F8FD FFFF"            /* ............ */
	$"FFFF FFFF FFFF F7E6 D4C4 B6A6 927D 6753"            /* ........Ķ}gS */
	$"4233 261D 1817 191C 2129 333E 4953 5C64"            /* B3&.....!)3>IS\d */
	$"6E79 8389 8A88 8583 8281 7F7C 7875 7270"            /* ny.|xurp */
	$"6F6E 6F6F 7072 7375 7777 7571 6D69 645F"            /* onooprsuwwuqmid_ */
	$"5953 4E49 443F 3B39 393C 4045 4B52 5A64"            /* YSNID?;99<@EKRZd */
	$"6E78 8088 8F96 9C9F A1A1 A09C 9792 8D87"            /* nx */
	$"827D 7873 6F6C 6968 6868 696B 6E70 7273"            /* }xsolihhhiknprs */
	$"7373 7272 7272 6F6B 655D 544B 4544 4440"            /* ssrrrroke]TKEDD@ */
	$"372A 1F1C 2128 2C2A 2626 2E39 4349 4948"            /* 7*..!(,*&&.9CIIH */
	$"4B50 565C 5F5F 5F5D 5A57 5657 595B 5C5B"            /* KPV\___]ZWVWY[\[ */
	$"5959 5D63 696E 7072 777E 868D 9192 9293"            /* YY]cinprw~ */
	$"9599 9D9F 9F9D 9A99 999A 9998 9796 9698"            /*  */
	$"999A 9B9C 9EA0 A4A8 ADB3 B9BE C3C7 CBD0"            /*  */
	$"D5DB E0E3 E4E4 E6E8 E9EA EAEA EBEC EEF0"            /* ............... */
	$"F2F5 F8FB FDFC F7EE E1D4 C6BA AD9F 907F"            /* .........ƺ. */
	$"6F60 5245 3A31 2B2A 2C2F 3439 4048 4E54"            /* o`RE:1+*,/49@HNT */
	$"5A60 676E 7479 7B7B 7A79 7877 7676 7779"            /* Z`gnty{{zyxwvvwy */
	$"7B7D 7F80 8181 8283 8483 8281 7E7A 746D"            /* {}.~ztm */
	$"655E 5954 514E 4C4B 4A49 4A4D 5257 5E66"            /* e^YTQNLKJIJMRW^f */
	$"6C72 787E 8386 898B 8D8E 8E8F 8E8D 8A88"            /* lrx~ */
	$"8685 8484 8484 8382 8282 8382 817F 7C7A"            /* .|z */
	$"7774 716D 6966 6362 615F 5D59 5249 413D"            /* wtqmifcba_]YRIA= */
	$"3F43 4542 3A33 3133 3738 3735 363A 4046"            /* ?CEB:31378756:@F */
	$"4B4D 5052 5455 575A 5F63 6667 6561 5E5C"            /* KMPRTUWZ_cfgea^\ */
	$"5E60 6161 6061 656A 6D6F 7173 787E 848A"            /* ^`aa`aejmoqsx~ */
	$"9196 999B 9C9D 9D9E 9F9F 9F9D 9B99 9797"            /*  */
	$"9798 9898 999B 9DA1 A4A7 ABAE B2B6 BABE"            /*  */
	$"C2C7 CBCE D1D3 D4D5 D6D5 D5D5 D5D4 D4D4"            /*  */
	$"D6D7 D8D9 DBDD E0E5 EAEE EEEA E2D8 CEC3"            /* .......... */
	$"B9AE A193 8578 6C63 5950 4741 3D3C 3E41"            /* xlcYPGA=<>A */
	$"464C 5155 5759 5B5D 5F60 6263 6363 6364"            /* FLQUWY[]_`bccccd */
	$"6566 6769 6A6D 7277 7C80 8589 8C8D 8C8B"            /* efgijmrw| */
	$"8A88 8580 7C77 736E 6A66 6360 5E5D 5D5E"            /* |wsnjfc`^]]^ */
	$"5F62 6569 6B6D 6F71 7375 7677 7878 7879"            /* _beikmoqsuvwxxxy */
	$"7B7C 7C7C 7C7D 7E80 8082 8485 8687 8685"            /* {||||}~ */
	$"8280 7E7D 7B78 7673 716E 6A66 625D 5853"            /* ~}{xvsqnjfb]XS */
	$"4F4B 4742 3F3E 3D3D 3D3C 3B3A 393A 3C3E"            /* OKGB?>===<;:9:<> */
	$"4042 4547 494B 4D4F 5255 5758 595A 5C5E"            /* @BEGIKMORUWXYZ\^ */
	$"6062 6364 6568 6B6D 6E71 7477 7A7D 8084"            /* `bcdehkmnqtwz} */
	$"888B 8D90 9295 989B 9EA0 A1A0 9F9F 9E9D"            /*  */
	$"9C9B 9A9A 9A9A 9B9D 9FA1 A3A6 AAAD AFB2"            /*  */
	$"B5B7 BABD BEBE BDBC BCBC BBB9 B7B6 B5B4"            /*  */
	$"B2B3 B4B5 B5B6 B8BA BDC0 C4C9 CDD0 D3D5"            /*  */
	$"D5D3 CFC9 C1B5 A99F 9A96 918A 827C 7773"            /* |ws */
	$"6D68 6463 615E 5B5A 5B5C 5A57 5758 5856"            /* mhdca^[Z[\ZWWXXV */
	$"5556 595D 5F60 6366 6A6D 6F70 7174 7779"            /* UVY]_`cfjmopqtwy */
	$"7B7D 7E7F 7F80 8080 8180 7F7E 7D7C 7C7B"            /* {}~...~}||{ */
	$"7A78 7776 7471 706E 6D6D 6D6C 6D6E 6F70"            /* zxwvtqpnmmmlmnop */
	$"7070 6F70 7173 7474 7474 7373 7373 7474"            /* ppopqsttttsssstt */
	$"7373 7373 7373 7474 7575 7472 706D 6965"            /* ssssssttuutrpmie */
	$"605A 5550 4C49 4643 4241 4142 4345 4749"            /* `ZUPLIFCBAABCEGI */
	$"4B4D 4F50 5253 5556 5758 5859 5A5B 5C5F"            /* KMOPRSUVWXXYZ[\_ */
	$"6266 6A6E 7276 797B 7E82 8588 8B8D 8F90"            /* bfjnrvy{~ */
	$"9193 9697 9695 969A 9EA0 9F9D 9EA2 A7A9"            /*  */
	$"A699 8882 8D97 8F80 8092 A2A0 9695 A3B3"            /*  */
	$"B6AC A4A9 B3B2 A7A3 A9AB A39D A5AE ADA6"            /*  */
	$"A6AE B7BC BDBC BCBF C3C6 C7C7 C3B8 ADAE"            /* ø */
	$"B9C0 B9AF B0BA C0BC B5B2 B1AD A69E 9998"            /*  */
	$"9793 8B80 7875 7473 6E69 6565 6667 6766"            /* xutsnieefggf */
	$"6767 645F 5D60 6362 5E5B 5C5F 605F 5F61"            /* ggd_]`cb^[\_`__a */
	$"6364 6467 6B6F 7274 7679 7C7D 7C7B 7B7D"            /* cddgkortvy|}|{{} */
	$"7D7D 7C7B 7B7B 7C7D 7E7E 7C7B 7A7A 7A79"            /* }}|{{{|}~~|{zzzy */
	$"7878 7877 7574 7372 7271 706E 6D6C 6C6C"            /* xxxwutsrrqpnmlll */
	$"6C6C 6D6D 6C6A 6969 6969 6765 6360 5C57"            /* llmmljiiiigec`\W */
	$"524F 4F4E 4C49 494B 4D4D 4F53 5758 5757"            /* ROONLIIKMMOSWXWW */
	$"585B 5F63 6666 6361 6266 6661 5E61 6A70"            /* X[_cffcabffa^ajp */
	$"6F6A 6B72 7877 747A 8586 7C77 8392 8D7B"            /* ojkrxwtz|w{ */
	$"737F 8F93 9090 8E89 91A6 A98B 6D77 9CB2"            /* s.mw */
	$"A591 8D94 9A9C 9A98 A0AC AA92 7A7E 99AD"            /* z~ */
	$"ADA8 ACB1 AEA2 9A9A 9B99 9CA3 A9A8 A29F"            /*  */
	$"A3AA ACA8 A2A7 B5BD B6AA AAB4 B5A9 A2AC"            /*  */
	$"B5AE A5AD C3CA BAAA ACB7 BBB2 A59E 9EA0"            /* ʺ */
	$"A19B 9189 8686 837F 7C7A 7570 7076 7871"            /* .|zuppvxq */
	$"6866 6C6F 6961 5F64 6865 5F5E 6061 5F5D"            /* hfloia_dhe_^`a_] */
	$"5F62 6362 6367 6D71 7170 7277 7C7C 7875"            /* _bcbcgmqqprw||xu */
	$"7679 7977 777A 7B7A 7776 797B 7B7A 7A7A"            /* vyywwz{zwvy{{zzz */
	$"7978 7A7B 7974 7173 7776 6F69 6D74 746A"            /* yxz{ytqswvoimttj */
	$"6266 6F6F 6459 5658 5854 5251 4F4B 4B50"            /* bfoodYVXXTRQOKKP */
	$"5554 4F4E 5157 5B5B 5D64 6B69 605C 656F"            /* UTONQW[[]dki`\eo */
	$"6D63 6370 776E 6365 7176 716A 6564 6B7B"            /* mccpwnceqvqjedk{ */
	$"8886 7770 7E92 9277 6275 A0B1 916A 6A8B"            /* wp~wbujj */
	$"9D89 6E68 7789 8E86 7D82 9CAF A288 8DAB"            /* nhw} */
	$"B59A 7F87 A4AE 9C86 8598 A6A2 98A2 C5DE"            /* .. */
	$"C996 809D C4C4 A28B 95AB AE9B 8F9B ADAC"            /* ɖĢ */
	$"A0A4 B7BF AF99 949E AAB0 AFA8 A1A3 ADB0"            /*  */
	$"A79D 9EA7 AEAF ACA6 9FA0 A9B1 AB9B 9194"            /*  */
	$"9C9D 9791 9091 8F87 807E 7F7E 7A77 797F"            /* ~.~zwy. */
	$"7F76 6B67 6B72 7470 6C6C 6F6E 6968 6D72"            /* .vkgkrtpllonihmr */
	$"7067 5F5C 5E62 6668 6A6D 6F6E 6E72 7A7E"            /* pg_\^bfhjmonnrz~ */
	$"7871 747B 7A70 696F 7B7E 766F 727A 7D79"            /* xqt{zpio{~vorz}y */
	$"7880 8884 756B 707C 7F76 6D6B 6C69 6058"            /* xukp|.vmkli`X */
	$"5657 5450 5258 5B5A 5A60 6868 6058 5A61"            /* VWTPRX[ZZ`hh`XZa */
	$"6054 4746 4D53 5457 5F68 6D6D 7177 756A"            /* `TGFMSTW_hmmqwuj */
	$"687A 8C80 5C4E 6781 7961 6582 8E7E 7893"            /* hz\Ngyae~x */
	$"AF9D 674F 709B A18D 858B 8A7D 716C 7690"            /* gOp}qlv */
	$"A597 6C5B 86C2 C186 6281 B2B9 9A7E 7981"            /* l[b~y */
	$"8C9D B2B7 AAA0 A4A3 9691 A3B9 B8A4 A0B9"            /*  */
	$"CDB9 8E83 A9D0 C79E 858B 989E A3AE B5B3"            /* ͹Ǟ */
	$"AFB6 C6D0 C5AA 918E 9DA4 9380 87A4 B4A6"            /* Ū */
	$"949E BDCA B9A6 A9B1 A68F 858E 9893 847D"            /* ʹ} */
	$"7F82 7E77 7479 8081 7F82 8988 7B6D 6A70"            /* .~wty.{mjp */
	$"7168 5D59 5D5E 5956 5C6A 7371 6B6D 777C"            /* qh]Y]^YV\jsqkmw| */
	$"7870 6E71 726C 6667 6D70 6E6A 6B74 7B78"            /* xpnqrlfgmpnjkt{x */
	$"7171 7B83 827A 7779 7976 7370 6D68 6567"            /* qq{zwyyvspmheg */
	$"665D 5355 6168 6053 535E 655D 5152 626C"            /* f]SUah`SS^e]QRbl */
	$"634F 4959 6A65 534F 6172 6D5E 5C6A 726B"            /* cOIYjeSOarm^\jrk */
	$"5D57 5D67 6D6F 6F6E 6D68 6269 8194 886C"            /* ]W]gmoonmhbil */
	$"5E6C 889D 9D88 7375 8788 6F5B 6989 937C"            /* ^lsuo[i| */
	$"6872 90A9 AE9E 8A83 8889 8384 8476 6774"            /* hrvgt */
	$"9CB9 AC8A 86A8 C3B4 948D 9C9E 8E8A 9CB2"            /* ô */
	$"B9B6 B5B4 A994 8FA7 C4C2 A69B B2CA C5AC"            /* ¦Ŭ */
	$"A5B9 CFCE BDB0 B0B7 B7AF A9B0 BCBE B4B3"            /* ν */
	$"BDBE AFA4 ACBA B9AA 9D9E A6A3 9281 7F81"            /* . */
	$"7D72 6E76 7D77 6E71 7F88 8272 686B 6F66"            /* }rnv}wnq.rhkof */
	$"544A 525D 5B50 4C56 6268 6969 6B6C 6C6D"            /* TJR][PLVbhiikllm */
	$"7070 6A63 6164 6664 6163 6B71 716F 737D"            /* ppjcadfdackqqos} */
	$"8688 827B 7677 7A7A 7771 685D 5656 5A5E"            /* {vwzzwqh]VVZ^ */
	$"615E 554C 494C 525C 6567 5E50 494C 504E"            /* a^ULILR\eg^PILPN */
	$"4741 4146 4C4F 4E50 5B6A 706C 676D 7B81"            /* GAAFLONP[jplgm{ */
	$"7866 616F 7C70 513E 4B6A 828C 8D89 8078"            /* xfao|pQ>Kjx */
	$"7C84 8A96 A397 6B45 5281 9C90 7C72 6A60"            /* |kER|rj` */
	$"6482 A4A3 816A 7E9E 9974 6A94 B89F 6E68"            /* dj~tjnh */
	$"8FAB 9978 7492 B4C7 C9B8 9E94 A1AF A799"            /* xtɸ */
	$"9CAC B0A3 9EB4 CFCD B7B4 CBD9 C5A8 A3BA"            /* ͷ.Ũ */
	$"CECA B4AA BAD2 D8CB C2C9 D6D9 CEBC ADA8"            /* ʴ.μ */
	$"ABAB 9F90 8B8F 8D83 7D81 8A89 7F75 7377"            /* }.usw */
	$"7872 6B66 625D 5752 5150 4C48 484C 4F4F"            /* xrkfb]WRQPLHHLOO */
	$"4F53 585C 5F64 6768 6666 696B 6C6B 6A6A"            /* OSX\_dghffiklkjj */
	$"6B6C 6E72 7678 7878 7A7C 7C79 7777 7877"            /* klnrvxxxz||ywwxw */
	$"726C 6865 605B 5651 4B49 4C4E 4A40 393C"            /* rlhe`[VQKILNJ@9< */
	$"4245 4242 4950 514A 4240 454B 4C47 454D"            /* BEBBIPQJB@EKLGEM */
	$"5B61 5B54 5C6D 7368 616F 7E74 5F5F 747E"            /* [a[T\mshao~t__t~ */
	$"716A 7D94 8E6F 5F74 8E83 6159 7692 9283"            /* qj}o_taYv */
	$"859F AD90 635F 8BAC 8F56 4872 9D9B 8489"            /* c_VHr */
	$"A7AC 8C7A 9BCC C58D 7699 B698 686D A7D2"            /* zōvhm */
	$"C6A9 ADC6 CAB9 B5CB E1DD C6BC C2C6 C2C4"            /* Ʃʹ..Ƽ */
	$"D2DF DED6 DAE9 F3EF E2D9 D7D4 CDC1 B3A9"            /* ........ */
	$"A39D 9287 8284 8683 7E79 7674 726E 6760"            /* ~yvtrng` */
	$"5953 4D47 423E 3A37 3739 3E43 494D 4F52"            /* YSMGB>:779>CIMOR */
	$"565B 6064 6768 6767 6A6D 6F72 767A 7C7F"            /* V[`dghggjmorvz|. */
	$"8184 888B 8D8D 8C8B 8987 8583 8079 706B"            /* ypk */
	$"6863 5C53 4C47 423D 3B3B 3A37 3230 3236"            /* hc\SLGB=;;:72026 */
	$"3938 3534 3434 3436 383A 3E44 4A4F 5357"            /* 985444468:>DJOSW */
	$"606C 7272 6F70 7476 7067 6973 746D 738C"            /* `lrroptvpgistms */
	$"A19E 9187 735C 6899 B7A0 7D7D 9392 786A"            /* s\h}}xj */
	$"7A8B 8884 8F97 8875 7B8E 907E 7A95 B3B5"            /* zu{~z */
	$"9E91 9EB5 C0B8 AFBD D3C8 A093 BDEC E6C0"            /* Ƞ.. */
	$"BCE5 FFF5 E1E8 FCFF FFFF FFFF FDEF E4ED"            /* ............... */
	$"EDD1 AFA6 B2B9 AC9D 9EA9 A78E 746E 797B"            /* .ѯtny{ */
	$"6A57 5255 4E3C 2F2E 312E 251F 1F23 272C"            /* jWRUN</.1.%..#', */
	$"343C 4245 474A 4E53 575B 6067 6E71 7479"            /* 4<BEGJNSW[`gnqty */
	$"818A 8D8E 9195 989A 9C9E A1A1 9F9B 9793"            /*  */
	$"8F89 8179 736E 6860 564D 443B 342F 2923"            /* ysnh`VMD;4/)# */
	$"1E1C 1C1C 1D1D 1E20 2224 262A 3037 3D44"            /* ....... "$&*07=D */
	$"4B52 585D 6266 6765 656C 7270 6F78 878E"            /* KRX]bfgeelrpox */
	$"8A86 8A91 9594 9395 9897 938F 8E92 9694"            /*  */
	$"8D8B 959B 8C73 697B 9194 8880 818A 94A0"            /* si{ */
	$"ACAD A4A1 AEBF BFB3 B0C3 DDE7 DED8 E4F7"            /* ..... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF F6E8 DCCF"            /* ............... */
	$"BFAD A099 9794 8E87 8079 726A 635C 564D"            /* yrjc\VM */
	$"4133 2519 100A 0401 0001 0712 1D27 313B"            /* A3%..........'1; */
	$"454C 5053 585E 6468 6C6F 7378 7D83 8A91"            /* ELPSX^dhlosx} */
	$"979D A3AB B1B5 B8B9 B9B6 B0A7 9F96 8E86"            /*  */
	$"7E75 695C 5046 3F37 3028 211C 1714 1110"            /* ~ui\PF?70(!..... */
	$"0F0E 0C0B 0D12 181E 252C 3339 4049 525A"            /* .......%,39@IRZ */
	$"5F63 686D 7277 7C80 8486 8788 8B90 9496"            /* _chmrw| */
	$"979A 9DA0 A2A5 A9AB A9A4 A1A0 A09F 9C98"            /*  */
	$"9693 9090 9294 918D 8E97 A4AE B2B6 C2D2"            /*  */
	$"DDDF DADA E2EF FAFF FFFF FFFF FFFF FFFF"            /* ................ */
	$"FFFC F5EA DECE BDAE A49D 9994 8C81 7366"            /* .....νsf */
	$"5F5D 5C57 5046 3B2E 2014 0C06 0200 0000"            /* _]\WPF;. ....... */
	$"0612 1D26 2E37 4047 4D53 5B66 6F74 797F"            /* ...&.7@GMS[foty. */
	$"8385 878B 9198 9DA1 A7AF B6BB BEBF BEB9"            /*  */
	$"B1A9 A39D 9790 877B 6D5E 5248 3F37 2E25"            /* {m^RH?7.% */
	$"1E1A 1715 1310 0C09 080A 0E14 1B21 282F"            /* ............!(/ */
	$"363D 444B 5155 5B62 696E 7277 7D81 8181"            /* 6=DKQU[binrw} */
	$"8389 8F92 9499 9EA1 A0A0 A2A5 A5A1 9E9E"            /*  */
	$"A0A2 A19F 9D9C 9B9B 9D9E 9F9F A1A4 A9AE"            /*  */
	$"B4BA C2CA D2DC E6F2 FCFF FFFF FFFF FFFF"            /* ........... */
	$"FFFF FDF0 E0D7 D2CB BDAC 9F99 9999 958C"            /* .....˽ */
	$"8073 6A66 6768 6458 442F 1D0F 0804 0304"            /* sjfghdXD/...... */
	$"060A 111D 2A36 3E43 484F 5860 6870 787F"            /* ....*6>CHOX`hpx. */
	$"8283 817F 7F83 8B94 9DA5 ACB3 BABF C1C1"            /* .. */
	$"BEB8 B0A8 A19B 9690 8679 6A5E 544D 4741"            /* yj^TMGA */
	$"3A31 2A23 1E1B 1712 0D09 0709 0D14 1C23"            /* :1*#.......# */
	$"292E 343C 4650 5960 666B 7176 7979 7879"            /* ).4<FPY`fkqvyyxy */
	$"797A 7C80 858A 8D8F 9499 9EA0 A1A2 A4A7"            /* yz| */
	$"A8A7 A7A7 A5A0 9A97 989A 9B9C 9EA0 A3A7"            /*  */
	$"ADB4 BDC5 CDD6 E0EB F7FE FFFF FFFF FFFF"            /* .......... */
	$"FFF3 DCCB C6C7 C4B8 A492 8888 8E91 8D81"            /* ...ĸ */
	$"7369 686E 7373 6A57 3F28 1912 1317 1818"            /* sihnssjW?(...... */
	$"181D 2732 3D46 4C52 5962 6B75 7E86 8B8C"            /* ..'2=FLRYbku~ */
	$"8A85 807F 838C 969E A3A6 A8AC B1B6 B9B9"            /* . */
	$"B5B0 AAA6 A4A1 9C92 816F 5E52 4D4B 4945"            /* o^RMKIE */
	$"3E37 3029 221C 1511 0F0F 1014 1B22 2729"            /* >70)"........"') */
	$"2A2E 3540 4D59 6268 6C70 7477 7775 7374"            /* *.5@MYbhlptwwust */
	$"787D 8184 8788 8989 8A8D 9295 989B 9EA1"            /* x} */
	$"A2A3 A3A1 9D98 9595 999C 9D9C 9C9E A1A3"            /*  */
	$"A7AF B8C1 CAD4 E0ED F9FF FFFF FFFF FFF9"            /* .......... */
	$"E4CC C2C4 C7C0 AC91 7C74 7A84 8882 756A"            /* .|tzuj */
	$"666C 757D 7A6B 533A 281F 1E21 221F 1B1A"            /* flu}zkS:(..!"... */
	$"1F28 323C 444B 545F 6B76 8089 9095 948E"            /* .(2<DKT_kv */
	$"8681 828A 959E A2A2 9F9E A1A8 B0B5 B6B3"            /*  */
	$"AFAD ADAD AAA0 907D 6C60 5B58 544D 4338"            /* }l`[XTMC8 */
	$"302A 2723 1F1A 1717 1A1E 2225 2625 2629"            /* 0*'#......"%&%&) */
	$"313B 4750 575B 6066 6C70 7272 7275 7980"            /* 1;GPW[`flprrruy */
	$"8588 8784 8283 8589 8E90 9193 979B 9D9D"            /*  */
	$"9D9C 9A98 989A 9D9D 9C9A 9897 979A 9FA6"            /*  */
	$"ACB3 BAC3 CFDA E5F0 FAFF FFFF FFFF F0D4"            /* .......... */
	$"C3BF C2C2 B59D 8374 737C 8484 7A6D 6568"            /* ÿµts|zmeh */
	$"7380 847C 6851 3D31 2E2E 2F2C 2825 2427"            /* s|hQ=1../,(%$' */
	$"2D35 3D45 4E59 6571 7A82 8B93 9591 8980"            /* -5=ENYeqz */
	$"7E84 8F9A 9F9D 9793 959D A7AE B1B0 AEAE"            /* ~ */
	$"B0B3 B2AB 9D8C 7D73 6E6B 665D 5044 3C38"            /* }snkf]PD<8 */
	$"3631 281F 1A1C 2329 2A27 2221 252C 343C"            /* 61(...#)*'"!%,4< */
	$"4248 4D53 5A60 6669 6A6A 6C70 767E 8384"            /* BHMSZ`fijjlpv~ */
	$"807C 7B7F 8488 8989 8A8E 9498 9998 9899"            /* |{. */
	$"9A9C 9FA1 A09D 9B9A 9999 999B 9EA1 A5AA"            /*  */
	$"B0B7 C0CA D4DF EDFA FFFF FFFF F7E1 C9BE"            /* .........ɾ */
	$"BEC1 BCAB 927A 6E6F 787F 7C71 6664 6C7B"            /* znox.|qfdl{ */
	$"8583 7562 5042 3935 3638 3833 2D2A 2C32"            /* ubPB956883-*,2 */
	$"3942 4B57 636D 767F 8993 9896 8F87 8387"            /* 9BKWcmv. */
	$"919D A3A0 978E 8C92 9CA4 A9AA AAAB AEB1"            /*  */
	$"B1AD A395 887F 7A79 766F 6355 463B 3430"            /* .zyvocUF;40 */
	$"2D27 201D 1E24 2929 2622 232A 3540 494E"            /* -' ..$))&"#*5@IN */
	$"5154 575C 6064 6668 6B6F 7377 7A7C 7C7A"            /* QTW\`dfhkoswz||z */
	$"797A 8087 8B8C 8C8E 9093 9698 9999 9A9C"            /* yz */
	$"A0A2 A19D 9998 9A9C 9D9E A0A4 A7AB B0B7"            /*  */
	$"BEC3 C9D1 DFF2 FDFF FFFF F8E1 C6B8 BAC2"            /* ........Ƹ */
	$"C2B3 977C 6D6D 767C 776A 6061 6D7B 8382"            /* ³|mmv|wj`am{ */
	$"7A6A 5849 403F 4245 433E 3833 3131 353E"            /* zjXI@?BEC>83115> */
	$"4B58 636D 757E 8790 9798 9187 8389 97A4"            /* KXcmu~ */
	$"A8A0 9388 858C 969F A4A5 A5A7 ABAF B0AB"            /*  */
	$"A196 8D87 8483 8078 6A58 4638 302D 2D2B"            /* xjXF80--+ */
	$"2620 1E23 292D 2C28 2932 404F 5758 5553"            /* & .#)-,()2@OWXUS */
	$"565C 6265 6667 696E 7478 7978 7778 7B80"            /* V\befgintxyxwx{ */
	$"888F 9392 8E8C 8F94 9796 9698 9B9D 9D9D"            /*  */
	$"9D9A 9695 9AA2 A7A6 A4A4 A9AE B2B4 B8BE"            /*  */
	$"C6D1 DEEF FBFF FFFD EED2 BDB8 BFC7 C3AE"            /* .......ҽî */
	$"8E75 6B6F 7675 6C62 5F64 6F7A 7F7C 7060"            /* ukovulb_doz.|p` */
	$"534A 4648 4B4E 4C46 3C33 2F31 3944 515E"            /* SJFHKNLF<3/19DQ^ */
	$"676E 737A 8692 9996 8D87 8B98 A6AC A798"            /* gnsz */
	$"8981 848E 999F A0A0 A1A4 A7A7 A5A0 9A94"            /*  */
	$"8F8C 8B87 7D6D 5947 3B36 3532 2D25 1E1E"            /* }mYG;652-%.. */
	$"2328 2A28 282D 3947 5156 5554 5458 5D62"            /* #(*((-9GQVUTTX]b */
	$"6668 6A6B 6E72 7576 7575 797F 858A 8F90"            /* fhjknruvuuy. */
	$"8E8C 8C8E 9193 9496 9798 9899 9A99 9796"            /*  */
	$"999E A2A4 A3A3 A3A5 A8AC B2B9 BEC4 CCD9"            /* . */
	$"E8F6 FEFF FCEE D4BD B4BC C9CA B695 796B"            /* ......Խʶyk */
	$"6C73 7672 6960 5F68 757C 796D 6056 504E"            /* lsvri`_hu|ym`VPN */
	$"4E51 5453 4C42 3833 353C 4856 6167 6A6D"            /* NQTSLB835<HVagjm */
	$"7480 8E96 9690 8B8E 99A6 AEA9 9A89 8184"            /* t */
	$"8F9A 9F9E 9B9A 9B9D 9F9F 9C99 9592 8F8B"            /*  */
	$"857C 6F5F 4F42 3C3B 3B38 3027 2223 292E"            /* |o_OB<;;80'"#). */
	$"3031 343C 4853 5856 5253 585F 6568 6869"            /* 014<HSXVRSX_ehhi */
	$"6A6C 6F71 7273 757A 8086 8A8C 8B89 8888"            /* jloqrsuz */
	$"8A8D 9293 918F 9092 9391 8F8E 9197 9EA2"            /*  */
	$"A3A2 A1A1 A3A8 AEB2 B4B7 BCC4 CFDB E8F5"            /* ... */
	$"FDFF F9E7 D0BF BDC5 CAC3 AD8E 766B 6E76"            /* ....пívknv */
	$"7870 635C 5F6A 7376 7168 5F57 5353 5557"            /* xpc\_jsvqh_WSSUW */
	$"5652 4A42 3A37 3942 4F5C 6467 686C 7684"            /* VRJB:79BO\dghlv */
	$"929A 9A94 9197 A3AE B1A8 988B 878D 979E"            /*  */
	$"9E9A 9695 979A 9B9A 9999 9895 918C 8780"            /*  */
	$"786C 5D4E 433D 3D3D 392F 241E 2028 3135"            /* xl]NC===9/$. (15 */
	$"3537 3E4A 555A 5855 575E 686E 706E 6C6C"            /* 57>JUZXUW^hnpnll */
	$"6D6F 7070 7276 7A7E 8083 8585 8483 8589"            /* mopprvz~ */
	$"8E92 928E 8A89 8B8E 8F8E 8C8E 949B 9F9D"            /*  */
	$"9A9B A0A7 ACAF B1B4 BAC0 C8D1 DBE7 F2FB"            /* .... */
	$"FFFA EAD1 BEBB C4CC C6B0 9178 6D70 7677"            /* ...Ѿưxmpvw */
	$"6D60 585B 6670 736E 645C 5755 5557 5958"            /* m`X[fpsnd\WUUWYX */
	$"554E 463F 3A3C 4450 5D65 6768 6C77 8796"            /* UNF?:<DP]eghlw */
	$"9E9E 9998 9FAC B8B9 AF9E 918E 939B 9F9E"            /*  */
	$"9994 9394 9596 9595 9696 948F 8983 7E78"            /* ~x */
	$"6F63 564C 443F 3B35 2E27 2324 272B 3035"            /* ocVLD?;5.'#$'+05 */
	$"3A41 4850 565B 6064 686C 7072 7372 706F"            /* :AHPV[`dhlprsrpo */
	$"6F70 7375 7778 797B 7E81 8282 8486 888A"            /* opsuwxy{~ */
	$"8C8C 8B8A 8786 878A 8B8A 8A8C 8E90 9193"            /*  */
	$"9599 9DA1 A5A9 AEB2 B6BC C2CB D6E2 EEF9"            /* ... */
	$"FFFE F4E0 CABD BEC8 CCC1 A788 736B 6F73"            /* ....ʽskos */
	$"6F64 5957 5F69 6E6C 655D 5958 5756 5556"            /* odYW_inle]YXWVUV */
	$"5654 4D42 3834 3945 5460 6566 6970 7D8B"            /* VTMB849ET`efip} */
	$"98A0 A1A0 A4AE B8BD B8AB 9D95 9499 9D9E"            /*  */
	$"9C98 9491 9190 8F8E 9093 9490 8981 7A73"            /* zs */
	$"6B61 554B 4441 3E3B 352D 2725 2930 363B"            /* kaUKDA>;5-'%)06; */
	$"4044 4950 575C 5F61 6468 6E73 7471 6E6C"            /* @DIPW\_adhnstqnl */
	$"6E72 7678 7A7B 7D7F 8082 8485 8583 8487"            /* nrvxz{}. */
	$"8987 837F 7D7D 8081 8182 8383 8589 8C8D"            /* .}} */
	$"8F92 969A 9EA3 A6A7 A9AE B6BD C4CA D1DA"            /* . */
	$"E6F4 FDFF FBED D7C4 BDC2 C8C5 B396 7C6C"            /* ......Ľų|l */
	$"686B 6A62 5854 575F 676A 6760 5A58 5758"            /* hkjbXTW_gjg`ZXWX */
	$"595A 5B5A 544B 403A 3B43 515F 686A 6B6E"            /* YZ[ZTK@:;CQ_hjkn */
	$"7886 96A0 A3A4 A7AD B7BD BBAF A095 9092"            /* x */
	$"9698 9690 8A84 807E 7E7F 8288 8B8A 857D"            /* ~~.} */
	$"756F 6B65 5D54 4C48 4543 3E37 2F2C 2F36"            /* uoke]TLHEC>7/,/6 */
	$"3F47 4C4E 5259 6167 6A6B 6D70 7477 7673"            /* ?GLNRYagjkmptwvs */
	$"6E6A 6869 6C6F 7172 7374 7679 7B7D 7D7D"            /* njhiloqrstvy{}}} */
	$"7E80 8383 807C 7876 7679 7D80 8183 8587"            /* ~|xvvy} */
	$"8A8D 8E90 959A 9FA2 A5A7 A9AA ACB0 B5BB"            /*  */
	$"C1C8 D0D9 E2EC F8FE FFFC F1DE CCC2 C2C3"            /* ......... */
	$"BDAA 8E74 6562 6363 5D56 5152 5A64 6968"            /* tebcc]VQRZdih */
	$"6460 5E5D 5B5A 5B5C 5B57 5048 4342 4855"            /* d`^][Z[\[WPHCBHU */
	$"636D 7376 7A83 909D A7AC ACAB AEB4 B9B9"            /* cmsvz */
	$"B0A0 9188 8687 8887 827C 7673 7272 7376"            /* |vsrrsv */
	$"7A7D 7D7A 746F 6B67 615A 534D 4A49 4946"            /* z}}ztokgaZSMJIIF */
	$"413C 3A3D 444D 5459 5D62 676D 7275 7675"            /* A<:=DMTY]bgmruvu */
	$"7679 7B7B 7872 6E6C 6D6E 6E6E 6F6F 7073"            /* vy{{xrnlmnnnoops */
	$"7577 7776 7576 7779 7976 7370 6F6F 7071"            /* uwwvuvwyyvspoopq */
	$"7375 777A 7E82 8587 898C 9197 9CA0 A0A0"            /* suwz~ */
	$"A1A4 A8AC AFB2 B6BA C0C6 CCD3 DAE3 EEF9"            /* .... */
	$"FFFF FDF2 DCCA C2C2 C3BB A68A 7061 5B5A"            /* .....ûpa[Z */
	$"5852 4A46 4B54 5D61 5F5C 5A5B 5D5E 5F62"            /* XRJFKT]a_\Z[]^_b */
	$"6465 615A 514C 4E56 626F 777A 7C80 8792"            /* deaZQLNVbowz| */
	$"9EA7 ABAC ADB1 B6B9 B5AA 9C8E 8583 8280"            /*  */
	$"7B73 6C67 625D 5B5E 646A 7072 6F6B 6765"            /* {slgb][^djprokge */
	$"6463 605B 5756 5655 524C 4644 4850 5A61"            /* dc`[WVVURLFDHPZa */
	$"6567 6A6F 767C 7F80 8081 8386 8681 7A71"            /* egjov|.zq */
	$"6C6B 6D6F 706E 6B6B 6D6F 7172 7170 7275"            /* lkmopnkkmoqrqpru */
	$"7879 7671 6D6B 6C6D 6E6F 6F70 7276 7A7E"            /* xyvqmklmnooprvz~ */
	$"8183 888F 969C 9E9F 9F9F A1A3 A5A8 A9AB"            /*  */
	$"AEB2 B6BA BEC2 C8D1 DCE8 F4FC FFFF FFF7"            /* ........ */
	$"E5D2 C6C2 C0B7 A58A 6E58 4D4B 4C4A 443F"            /* .nXMKLJD? */
	$"4048 525A 5E5E 5E60 6367 696A 6967 635E"            /* @HRZ^^^`cgijigc^ */
	$"5853 5154 5D68 7176 787C 828D 9AA6 AEB1"            /* XSQT]hqvx| */
	$"B0AE AFB1 AFA7 9A8B 7E76 7270 6B63 5C56"            /* ~vrpkc\V */
	$"5353 5558 5D63 696D 6E6D 6B6A 6969 6662"            /* SSUX]cimnmkjiifb */
	$"5D5A 5958 5856 5452 545A 636B 7276 7A7E"            /* ]ZYXXVTRTZckrvz~ */
	$"8287 8B8D 8D8C 8A89 8682 7B74 6F6B 6A6A"            /* {tokjj */
	$"6A69 6969 696A 6D6F 7171 7071 7273 726E"            /* jiiiijmoqqpqrsrn */
	$"6965 6465 6668 696A 6C6F 7277 7C80 8589"            /* iedefhijlorw| */
	$"8F94 999B 9B9A 9A9B 9D9F A0A1 A2A4 A6A8"            /*  */
	$"ACAF B3B8 BEC5 CDD4 DADF E5EC F4FC FFFC"            /* ........ */
	$"F1DC C5B3 ABA9 A395 7E62 4D43 4244 433F"            /* ..ų~bMCBDC? */
	$"3B3C 434D 565B 5C5D 5F62 6466 6768 6868"            /* ;<CMV[\]_bdfghhh */
	$"655F 5A57 585F 6A74 7B7E 8082 8A95 A1A9"            /* e_ZWX_jt{~ */
	$"ACAC A9A8 A7A5 A097 8A7D 736C 6763 5D57"            /* }slgc]W */
	$"524F 4E4E 5054 5A62 696D 6D6C 6D70 7375"            /* RONNPTZbimmlmpsu */
	$"7470 6D6B 6C6E 6F6E 6C6A 6B71 7880 8587"            /* tpmklnonljkqx */
	$"8789 8C90 9394 918D 8A88 8784 7E76 6E69"            /* ~vni */
	$"6767 6766 6361 6061 6466 6666 6769 6C6E"            /* gggfca`adfffgiln */
	$"6F6D 6B69 696B 6F73 7576 7879 7B80 8386"            /* omkiikosuvxy{ */
	$"888A 8D91 9494 918E 8D8D 8F91 9292 9292"            /*  */
	$"9395 989C A0A3 A7AB AFB2 B5B6 B8BA BEC2"            /*  */
	$"C7CA CDD0 D5DC E4EB EADF CDB9 A9A3 A3A1"            /* .....͹ */
	$"9781 674F 423F 4040 3B34 3135 3C45 4C50"            /* gOB?@@;415<ELP */
	$"5357 5D62 666A 6C6E 7070 6D69 6767 6A71"            /* SW]bfjlnppmiggjq */
	$"777C 7F7F 8084 8C96 9EA3 A3A0 9E9E 9F9D"            /* w|.. */
	$"988E 837A 736E 6963 5C56 5251 5051 5357"            /* zsnic\VRQPQSW */
	$"5D64 6A6D 7073 777D 8284 8483 8181 8181"            /* ]djmpsw} */
	$"807F 7E7E 7F81 8486 8889 8A8B 8C8D 8C8B"            /* .~~. */
	$"8987 8480 7B76 716C 6763 605E 5D5D 5D5D"            /* {vqlgc`^]]]] */
	$"5E5F 6164 676A 6E70 7274 7474 7475 7576"            /* ^_adgjnprttttuuv */
	$"7778 7878 7778 797B 7D7F 8183 8586 8686"            /* wxxxwxy{}. */
	$"8685 8483 8382 8282 8180 7F7F 8185 898D"            /* .. */
	$"9194 969A 9DA0 A3A5 A7A9 AAAB ABAC ACAE"            /*  */
	$"B0B2 B5B8 BBC0 C6CE D7DF E0DA CFBF AFA6"            /* ...Ͽ */
	$"A19E 9686 6F55 4239 3636 3531 2E2F 333B"            /* oUB96651./3; */
	$"444C 5258 6169 7178 7C7E 8080 807E 7C7B"            /* DLRXaiqx|~~|{ */
	$"7C7E 8082 8382 8284 8991 989E A1A1 A0A0"            /* |~ */
	$"A09F 9D98 8F85 7C74 6E68 6159 534F 4E4F"            /* |tnhaYSONO */
	$"5256 5A60 676F 767D 8389 8E93 9698 9897"            /* RVZ`gov} */
	$"9694 918E 8B88 8482 8181 8284 8585 8483"            /*  */
	$"8383 8586 8480 7B74 6D68 635F 5A56 5352"            /* {tmhc_ZVSR */
	$"5151 5152 5457 5D64 6A6F 7374 7576 7879"            /* QQQRTW]djostuvxy */
	$"7979 7876 7573 706F 6E6D 6E71 7478 7B7D"            /* yyxvusponmnqtx{} */
	$"7E7F 8082 8586 8685 8280 7D7A 7775 7271"            /* ~.}zwurq */
	$"7172 7476 787A 7D80 868B 9093 9597 9899"            /* qrtvxz} */
	$"9A9A 9A9A 9999 999A 9C9E A0A2 A6AB B1B6"            /*  */
	$"BBC1 C6CC D2DA E2E7 E6DE D1C1 B3A9 A29B"            /* ..... */
	$"8F7E 6853 453D 3A38 3635 3539 3F47 5058"            /* ~hSE=:86559?GPX */
	$"5F67 7078 8084 8788 8989 8887 8686 8686"            /* _gpx */
	$"8686 8889 8B8F 9397 9C9F A1A2 A2A1 A09E"            /*  */
	$"9B95 8E85 7C73 6C65 5E57 514E 4D4C 4D4F"            /* |sle^WQNMLMO */
	$"5257 5E65 6C73 797F 8387 8B8E 9091 908F"            /* RW^elsy. */
	$"8D8A 8886 8482 8282 8283 8485 8688 8A8C"            /*  */
	$"8E8F 8F8D 8881 7A75 716D 6860 564C 4747"            /* zuqmh`VLGG */
	$"494A 4947 494E 5760 6568 696D 747C 8080"            /* IJIGINW`ehimt| */
	$"7E7B 7A7B 7B78 7471 6E6D 6E6F 6F6F 6F70"            /* ~{z{{xtqnmnoooop */
	$"7174 777A 7C7D 7D7C 7B7C 7D7D 7B79 7676"            /* qtwz|}}|{|}}{yvv */
	$"787A 7C7C 7C7D 8084 898D 8F90 9294 9698"            /* xz|||} */
	$"9897 9696 9697 9695 9595 9595 9799 9C9D"            /*  */
	$"9FA0 A2A6 AAAD B0B1 B3B5 B7BA BCBD BEC0"            /*  */
	$"C2C6 C9C9 C5BD B3AA A5A1 9C95 897A 6C62"            /* Žzlb */
	$"5C57 534D 4743 4345 484B 4D50 555C 636B"            /* \WSMGCCEHKMPU\ck */
	$"7073 767A 7E81 8485 8686 8686 8686 8787"            /* psvz~ */
	$"8888 898A 8B8C 8C8C 8C8B 8B8A 8783 7F7A"            /* .z */
	$"7673 6F6B 6763 605E 5D5C 5B5C 5D60 6569"            /* vsokgc`^]\[\]`ei */
	$"6D71 7479 7E82 868A 8D90 9192 9190 908F"            /* mqty~ */
	$"8E8D 8C8A 8987 8584 8280 8080 807F 7E7D"            /* .~} */
	$"7B79 7775 7371 6F6D 6A68 6562 605F 5E5E"            /* {ywusqomjheb`_^^ */
	$"5F60 6163 6567 686A 6D71 7577 7778 7879"            /* _`aceghjmquwwxxy */
	$"7A7B 7B7A 7A79 7878 7877 7676 7778 7878"            /* z{{zzyxxxwvvwxxx */
	$"7879 7979 7878 797A 7B7B 7A7A 7B7C 7D7F"            /* xyyyxxyz{{zz{|}. */
	$"8081 8182 8385 8686 8787 8888 8888 8786"            /*  */
	$"8686 8686 8585 8585 8586 8788 898A 8B8D"            /*  */
	$"8F90 9192 9293 9494 9595 9696 9595 9696"            /*  */
	$"9797 9899 9999 9A9C 9D9F A0A2 A3A4 A5A7"            /*  */
	$"A9AB ACAD ACA9 A49F 9B97 938E 8880 7972"            /* yr */
	$"6B67 6462 5F5D 5C5B 5D60 6569 6C6F 7277"            /* kgdb_]\[]`eilorw */
	$"7C81 8486 8788 8A8B 8C8B 8A88 8684 8484"            /* | */
	$"8382 8180 7F7F 7F80 8080 7F7F 7E7C 7A78"            /* .....~|zx */
	$"7674 7371 706E 6C6B 6A6A 6B6C 6E71 7376"            /* vtsqpnlkjjklnqsv */
	$"787A 7B7C 7D80 8386 8786 8381 8182 8383"            /* xz{|} */
	$"817F 7C7B 7C7C 7C7A 7877 797B 7B7A 7672"            /* .|{|||zxwy{{zvr */
	$"7070 7173 7371 6E6D 6D6F 7274 7576 7778"            /* ppqssqnmmortuvwx */
	$"7A7C 7E7E 7D7C 7C7A 7876 7371 6F6D 6B69"            /* z|~~}||zxvsqomki */
	$"6867 6768 696A 6C6F 7173 7577 797A 7B7C"            /* hgghijloqsuwyz{| */
	$"7C7C 7B7A 7979 7776 7574 7576 7779 7A7B"            /* ||{zyywvutuvwyz{ */
	$"7C7D 8082 8385 8687 8787 8787 8685 8584"            /* |} */
	$"8483 8382 8282 8282 8384 8586 8788 8989"            /*  */
	$"8A8B 8C8D 8D8E 8F8F 8F8F 8F90 9091 9192"            /*  */
	$"9292 9393 9393 9494 9494 9393 9292 9191"            /*  */
	$"9190 908F 8F8E 8E8D 8D8D 8D8C 8B8B 8C8B"            /*  */
	$"8B8A 8A8A 8989 8989 8A89 8989 8A8B 8C8C"            /*  */
	$"8C8B 8B8B 8B8A 8A89 8785 8482 817F 7D7A"            /* .}z */
	$"7978 7776 7574 7473 7373 7475 7677 7878"            /* yxwvuttssstuvwxx */
	$"797A 7A7A 7A7A 7A7A 7979 7978 7877 7776"            /* yzzzzzzzyyyxxwwv */
	$"7575 7676 7778 7878 797A 7B7C 7E7F 8080"            /* uuvvwxxxyz{|~. */
	$"8080 807F 8080 807F 7E7D 7C7B 7B7A 7B7B"            /* ..~}|{{z{{ */
	$"7B7B 7B7C 7D7E 7E7F 8080 8080 8181 8181"            /* {{{|}~~. */
	$"8080 7F7F 7E7E 7E7D 7D7C 7C7C 7D7D 7E7E"            /* ..~~~}}|||}}~~ */
	$"7F80 8081 8283 8485 8687 8787 8786 8686"            /* . */
	$"8585 8483 8281 807F 7D7B 7A79 7776 7472"            /* .}{zywvtr */
	$"7170 7070 7070 7071 7273 7576 7778 797A"            /* qppppppqrsuvwxyz */
	$"7B7B 7C7C 7C7C 7C7C 7B7B 7B7B 7B7A 7A7B"            /* {{||||||{{{{{zz{ */
	$"7C7D 7E7E 7F80 8182 8384 8585 8585 8585"            /* |}~~. */
	$"8483 8282 8181 8080 7F7F 7E7E 7E7F 8080"            /* ..~~~. */
	$"807F 8080 8081 8282 8181 8282 8384 8484"            /* . */
	$"8485 8687 8889 898A 8A8A 8B8C 8C8B 8A8A"            /*  */
	$"8A8A 8988 8685 8585 8685 8483 8383 8485"            /*  */
	$"8584 8383 8484 8585 8483 8282 8282 8281"            /*  */
	$"8080 8080 8182 8282 8282 8485 8685 8585"            /*  */
	$"8586 8787 8685 8584 8483 8281 8181 8180"            /*  */
	$"807F 7E7E 7E7E 7F7F 8080 8080 8080 8181"            /* .~~~~.. */
	$"8281 8181 8080 8080 7F7E 7D7D 7C7C 7B7B"            /* .~}}||{{ */
	$"7B7B 7C7C 7B7B 7B7C 7D7E 7E7E 7E7E 7E7E"            /* {{||{{{|}~~~~~~~ */
	$"7F80 8080 807F 7F80 8080 8080 8080 7F7F"            /* ..... */
	$"7F7F 7F7F 7F7E 7E7F 7F7F 7E7D 7D7D 7E7E"            /* .....~~...~}}}~~ */
	$"7E7E 7D7C 7C7C 7C7C 7C7C 7B7A 7979 7979"            /* ~~}|||||||{zyyyy */
	$"7979 7979 7A7B 7B7C 7C7D 7F80 8081 8282"            /* yyyyz{{||}. */
	$"8282 8283 8383 8282 8181 8180 8080 7F7F"            /* .. */
	$"7F7E 7E7D 7C7C 7C7D 7D7D 7D7C 7C7C 7D7D"            /* .~~}|||}}}}|||}} */
	$"7D7D 7D7D 7D7D 7C7C 7C7C 7C7D 7D7D 7C7C"            /* }}}}}}|||||}}}|| */
	$"7C7D 7E7E 7F80 8080 8081 8181 8282 8384"            /* |}~~. */
	$"8484 8383 8383 8383 8282 8181 8181 8180"            /*  */
	$"807F 7E7E 7D7D 7D7E 7E7E 7E7E 7E7E 7F80"            /* .~~}}}~~~~~~~. */
	$"8081 8181 8181 8181 8181 8282 8282 8181"            /*  */
	$"8181 8182 8282 8282 8382 8282 8383 8383"            /*  */
	$"8281 8181 8182 8282 8282 8283 8383 8485"            /*  */
	$"8585 8586 8686 8585 8584 8485 8584 8383"            /*  */
	$"8384 8484 8585 8586 8788 8786 8686 8686"            /*  */
	$"8584 8381 8080 8080 8080 7F80 8081 8180"            /* . */
	$"8081 8181 8282 8281 8181 8281 8180 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 807F 7E7E"            /* .~~ */
	$"7D7D 7D7C 7C7C 7C7C 7B7B 7B7C 7C7D 7D7D"            /* }}}|||||{{{||}}} */
	$"7D7D 7D7E 7F7F 7F7E 7E7F 8080 807F 7E7D"            /* }}}~...~~..~} */
	$"7D7E 7E7D 7C7C 7B7B 7C7C 7C7C 7C7D 7E7F"            /* }~~}||{{|||||}~. */
	$"8080 8080 7F80 8080 8080 8080 8080 8080"            /* . */
	$"7F80 8080 8080 7F80 8080 8080 7F7E 7E7F"            /* ...~~. */
	$"7F7F 7E7E 7E7D 7D7E 7F7F 7F7F 7E7F 8080"            /* ..~~~}}~....~. */
	$"8080 807F 7E7E 7F7F 7F7E 7D7C 7C7D 7D7D"            /* .~~...~}||}}} */
	$"7D7D 7D7E 7E7E 7E7E 7E7E 7E7E 7E7E 7D7D"            /* }}}~~~~~~~~~~~}} */
	$"7C7B 7B7C 7C7B 7B7B 7B7B 7B7B 7C7D 7D7E"            /* |{{||{{{{{{{|}}~ */
	$"7E7E 7E7E 7F80 8080 8080 8080 8080 8080"            /* ~~~~. */
	$"7F7F 7F80 8080 8080 7F7F 8080 8180 807F"            /* ...... */
	$"7F80 8081 8181 8181 8182 8383 8382 8282"            /* . */
	$"8282 8180 7F7E 7E7E 7D7D 7C7B 7B7B 7C7C"            /* .~~~}}|{{{|| */
	$"7D7E 7F80 8081 8282 8282 8383 8382 8180"            /* }~. */
	$"8080 7F7E 7D7D 7D7D 7D7D 7D7D 7D7E 7E7E"            /* .~}}}}}}}}}~~~ */
	$"7F80 8080 8080 8080 8080 8080 807F 7E7E"            /* ..~~ */
	$"7E7F 7F7F 7F80 8081 8181 8282 8282 8281"            /* ~.... */
	$"8080 8080 7E7D 7C7C 7C7B 7B7B 7C7C 7D7D"            /* ~}|||{{{||}} */
	$"7E7E 7E7F 8080 8182 8181 8181 8181 8080"            /* ~~~. */
	$"807F 7F7F 8080 8080 8080 8081 8180 807F"            /* .... */
	$"7E7E 7E7D 7C7B 7A79 7978 7878 7878 7979"            /* ~~~}|{zyyxxxxxyy */
	$"7A7A 7B7C 7D7D 7D7E 7E7E 7E7E 7D7D 7D7D"            /* zz{|}}}~~~~~}}}} */
	$"7D7D 7D7D 7D7D 7D7E 7E7E 7E7F 7F7F 7F7E"            /* }}}}}}}~~~~....~ */
	$"7E7E 7E7E 7D7B 7A7A 7A7A 7A7A 7979 7A7B"            /* ~~~~}{zzzzzzyyz{ */
	$"7D7E 7E7F 8080 8182 8383 8383 8384 8483"            /* }~~. */
	$"8282 8181 8283 8382 8282 8282 8282 8281"            /*  */
	$"8080 8080 807F 7E7E 7D7E 7E7E 7E7E 7D7E"            /* .~~}~~~~~}~ */
	$"7F80 8081 8181 8181 8182 8282 8181 8181"            /* . */
	$"8181 8080 8080 8080 7F7F 7F7F 7F80 8080"            /* ..... */
	$"7F7F 7F7F 7F7F 7F7E 7F7F 7F7E 7E7E 7E7F"            /* .......~...~~~~. */
	$"7F7F 7F7F 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ....~~~~~~~~~~~~ */
	$"7E7D 7D7D 7C7D 7D7D 7D7C 7D7D 7D7D 7D7E"            /* ~}}}|}}}}|}}}}}~ */
	$"7E7E 7E7E 7F80 8080 7F7F 8080 8080 8181"            /* ~~~~... */
	$"8181 8181 8282 8282 8282 8282 8281 8181"            /*  */
	$"8181 8181 8180 8080 8081 8182 8282 8282"            /*  */
	$"8283 8384 8483 8382 8283 8383 8383 8383"            /*  */
	$"8383 8484 8585 8484 8484 8483 8383 8282"            /*  */
	$"8181 8181 8080 8181 8181 8281 8182 8282"            /*  */
	$"8282 8281 8181 8080 8080 7F7F 7F7E 7E7E"            /* ...~~~ */
	$"7E7F 7F7F 7F7E 7E7F 8080 8080 8080 8080"            /* ~....~~. */
	$"807F 7F7F 7F7F 7F7F 7E7E 7E7D 7D7D 7D7D"            /* .......~~~}}}}} */
	$"7D7D 7D7D 7D7C 7D7D 7D7E 7E7E 7E7E 7E7E"            /* }}}}}|}}}~~~~~~~ */
	$"7E7F 7F80 8080 8080 807F 8080 8080 8081"            /* ~... */
	$"8180 8080 8181 8080 8080 807F 7F7F 7E7D"            /* ...~} */
	$"7D7D 7D7D 7D7D 7C7D 7D7E 7E7E 7E7E 7F7F"            /* }}}}}}|}}~~~~~.. */
	$"8080 8181 8182 8282 8282 8282 8282 8282"            /*  */
	$"8181 8181 8180 8080 8080 8081 8181 8181"            /*  */
	$"8181 8181 8181 8080 8080 8080 8080 8080"            /*  */
	$"8081 8181 8181 8282 8282 8382 8282 8181"            /*  */
	$"8181 8080 8080 8080 7F7F 7F7F 7F7F 8080"            /* ...... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 7F7F 7F7F 7E7E 7E7E 7E7E"            /* ....~~~~~~ */
	$"7E7E 7E7E 7F80 8080 8181 8181 8181 8181"            /* ~~~~. */
	$"8281 8181 8180 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 7F7F 7E7E 7E7E 7E7E"            /* ..~~~~~~ */
	$"7E7E 7E7E 7E7E 7F80 8080 8080 8081 8181"            /* ~~~~~~. */
	$"8181 8181 8181 8181 8180 8080 8181 8180"            /*  */
	$"8081 8181 8282 8282 8181 8181 8180 8080"            /*  */
	$"7F7E 7E7E 7E7D 7D7C 7D7D 7D7D 7D7D 7E7E"            /* .~~~~}}|}}}}}}~~ */
	$"7E7E 7F80 8080 8080 8080 8080 8080 7F7E"            /* ~~..~ */
	$"7E7E 7E7E 7D7D 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~~~~}}~~~~~~~~~~ */
	$"7E7F 7F7F 7F7E 7D7D 7D7E 7E7D 7D7C 7C7C"            /* ~....~}}}~~}}||| */
	$"7C7D 7D7D 7D7D 7E7F 7F7F 7F80 8080 8081"            /* |}}}}}~.... */
	$"8180 8080 8081 8181 8180 8080 8080 8080"            /*  */
	$"8080 8080 8080 8081 8080 8081 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8282 8282"            /*  */
	$"8282 8282 8282 8282 8281 8181 8282 8181"            /*  */
	$"8080 8080 8080 8080 7F7E 7F7F 7F7F 7F7F"            /* .~...... */
	$"7F80 8080 807F 7F7F 8080 8080 8080 7F7E"            /* .....~ */
	$"7E7F 7F7F 7F7F 7E7E 7E7F 7F80 8080 8080"            /* ~.....~~~.. */
	$"8080 807F 7E7E 7E7E 7E7E 7D7D 7D7C 7C7C"            /* .~~~~~~}}}||| */
	$"7D7D 7E7E 7E7E 7E7F 8080 8181 8281 8182"            /* }}~~~~~. */
	$"8282 8282 8282 8282 8282 8281 8182 8283"            /*  */
	$"8282 8282 8181 8182 8281 8181 8180 8080"            /*  */
	$"8080 807F 7F80 807F 7E7E 7F7F 7F7F 7F7F"            /* ...~~...... */
	$"7F7F 7F7F 7F80 8080 8080 8080 8080 8181"            /* ..... */
	$"8181 8181 8181 8181 8181 8181 8181 8281"            /*  */
	$"8181 8181 8181 8181 8180 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8081 8181 8181 8181"            /*  */
	$"8182 8282 8281 8181 8181 8181 8181 8180"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 7F7F"            /* .. */
	$"7F7F 7F7F 7F7F 7F7E 7E7E 7F7F 7F7F 7F7E"            /* .......~~~.....~ */
	$"7E7F 7F80 8080 8080 8080 8081 8080 8080"            /* ~.. */
	$"8080 8080 8080 807F 7F7F 7F80 8080 8080"            /* .... */
	$"8080 8080 8081 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8080 8080 8181 8281 8181 8182"            /*  */
	$"8181 8182 8181 8181 8181 8080 8181 8181"            /*  */
	$"8181 8080 8080 8081 8180 8080 8080 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8080 8181 8181 8180 8080 8080 8080 8080"            /*  */
	$"8080 7F80 8080 7F7F 7F7F 7E7E 7E7E 7E7E"            /* .....~~~~~~ */
	$"7E7F 7F7F 7F7F 8080 807F 8080 8080 8080"            /* ~...... */
	$"807F 7F80 8080 7F7E 7F7F 7F7F 7F7F 7F7F"            /* ...~........ */
	$"7F80 8080 807F 7F7F 8080 8080 807F 7E7F"            /* .....~. */
	$"7F80 807F 7F80 807F 8080 8080 7F7F 7F7F"            /* ........ */
	$"7F7F 7F7F 7F7F 7F80 807F 7F7F 7F7F 7F7F"            /* .............. */
	$"8080 8080 7F7F 8080 8080 8080 7F7F 7F80"            /* ..... */
	$"8080 7F7E 7E7E 7E7F 7F7F 7E7E 7E7F 7F7F"            /* .~~~~...~~~... */
	$"7F7E 7E7E 7F7F 7F7F 7F7F 8080 8080 8080"            /* .~~~...... */
	$"8080 8081 8281 8080 7F7E 7E7F 8080 8182"            /* .~~. */
	$"8281 8180 807F 7E7F 8080 8182 8181 8181"            /* .~. */
	$"8080 8080 8080 8081 8180 8081 8181 8180"            /*  */
	$"8080 8181 8181 8181 8181 8180 807F 8080"            /* . */
	$"8081 8181 8180 8080 8080 8081 8181 8181"            /*  */
	$"8181 8180 8080 8081 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8281 8181 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8080 8080 8080"            /*  */
	$"8080 7F7F 7F7F 8080 807F 7F7F 7F7F 7F7E"            /* ..........~ */
	$"7E7E 7F7F 7F7F 7E7E 7E7E 7E7F 7F7F 7F7F"            /* ~~....~~~~~..... */
	$"7E7F 7F7F 8080 7F7F 7F7F 7F80 8080 807F"            /* ~......... */
	$"7F7F 7F7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ...~~~~~~~~~~~~~ */
	$"7E7D 7D7E 7E7E 7E7E 7E7E 7E7E 7E7E 7E7E"            /* ~}}~~~~~~~~~~~~~ */
	$"7E7E 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F80"            /* ~~............. */
	$"8080 8080 7F80 8080 8080 8080 8080 8081"            /* . */
	$"8180 8080 8181 8181 8181 8181 8281 8181"            /*  */
	$"8181 8182 8282 8181 8181 8181 8181 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8080"            /*  */
	$"8181 8180 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 7F7F 7F7F"            /* .... */
	$"8080 8080 7F7F 7F7F 7F7F 7F7F 7F7E 7F7F"            /* .........~.. */
	$"7F7F 8080 8080 7F7F 8080 8080 8080 8080"            /* .... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 807F 8080 8080 8080"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8181 8181 8181 8181 8181 8281 8181"            /*  */
	$"8181 8282 8181 8080 8081 8181 8181 8181"            /*  */
	$"8181 8181 8180 8080 8180 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8180 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8081 8080 8080 7F80 8080"            /* . */
	$"8080 807F 8080 8080 7F7F 7F7F 7F7F 7F7E"            /* ........~ */
	$"7E7E 7E7F 7F7F 8080 7F7E 7E7F 8080 8080"            /* ~~~....~~. */
	$"8080 7F80 8080 8080 7F80 8080 8080 8080"            /* .. */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"7F7F 7F7F 8080 7F7E 7F7F 7F7F 7F7E 7E7F"            /* .....~.....~~. */
	$"7F7F 8080 7F7F 7F7F 7F80 8080 8080 7F7F"            /* ......... */
	$"8080 8080 7F80 8080 8080 8080 8080 8080"            /* . */
	$"8080 8080 8080 8080 8080 7F7E 7F80 8080"            /* .~. */
	$"8080 7F7F 7F80 8080 7F80 8080 8080 8080"            /* .... */
	$"8080 8080 8080 8080 8080 8181 8181 8181"            /*  */
	$"8080 8080 8081 8080 8080 8080 8080 8080"            /*  */
	$"8080 7F80 8080 8080 8080 8080 8080 8080"            /* . */
	$"7F80 8080 8080 7F80 8080 8080 8080 8080"            /* .. */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8181 8180 8080 8080 8081 8181 8181 8180"            /*  */
	$"8080 8080 8080 8080 8080 8080 8080 807F"            /* . */
	$"7F7E 7E7E 7F7F 7F7F 7E7E 7F7F 7F7F 7E7E"            /* .~~~....~~....~~ */
	$"7E7E 7F7F 7F7F 7E7E 7F7F 7F7F 7F7F 7E7E"            /* ~~....~~......~~ */
	$"7F7F 7F7F 8080 8080 807F 7F80 8080 8080"            /* ...... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8180 8080 8081"            /*  */
	$"8181 8080 8080 8081 8181 8080 8080 8181"            /*  */
	$"8181 8181 8080 8081 8181 8180 8080 8080"            /*  */
	$"8080 8080 8080 7F7F 7F7F 7F7F 7F80 8080"            /* ....... */
	$"807F 7F80 8080 8080 807F 8080 8080 8080"            /* ... */
	$"8080 8080 8080 807F 8080 8080 807F 7F7F"            /* .... */
	$"7F7F 7F80 8080 7F7E 7E7E 7F7F 8080 7F7F"            /* ....~~~.... */
	$"7F7F 7F80 8080 8080 7F7F 7F7F 7F80 8080"            /* ........ */
	$"8080 8080 8080 7F80 8080 8080 8080 7F7F"            /* ... */
	$"8080 8080 807F 7F7F 7F7F 7F7F 7F7E 7F7F"            /* ........~.. */
	$"7F7F 7E7F 8080 8080 8080 807F 7F80 8080"            /* ..~... */
	$"8080 8080 8080 8081 8080 8080 8081 8180"            /*  */
	$"8080 8081 8080 8080 8080 8080 8080 8180"            /*  */
	$"8080 8080 8080 8181 8180 8080 8081 8181"            /*  */
	$"8181 8181 8181 8180 8080 8180 8080 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8180 8080"            /*  */
	$"8080 8080 8080 7F80 8080 8080 807F 7F80"            /* ... */
	$"8080 8080 7F80 8080 8080 8080 8080 8080"            /* . */
	$"807F 7F7F 7F7F 7F7F 7E7F 7F7F 7F7F 7F7F"            /* .......~....... */
	$"7F7F 7F7F 7F7F 7E7F 7F7F 7F7E 7F7F 7F7F"            /* ......~....~.... */
	$"7F7F 7F7F 7E7F 8080 807F 7F7F 7F7F 8080"            /* ....~...... */
	$"8080 7F7F 8080 8080 7F7F 8080 8080 807F"            /* ..... */
	$"7F7F 8080 8080 8080 8080 8080 7F7F 8080"            /* .... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8081 8181 8180 8080 8081 8181 8080"            /*  */
	$"8081 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 807F 7F80 8080 807F 8080 8080"            /* ... */
	$"7F7F 7E7F 8080 8080 7F7F 7F7F 7F80 8080"            /* ..~...... */
	$"8080 807F 7F7F 8080 8080 807F 7F7F 8080"            /* ...... */
	$"8080 8080 8080 8080 7F7F 8080 8080 807F"            /* ... */
	$"7F7E 7F7F 7F7F 7F7F 7F7F 7F7F 8080 8080"            /* .~.......... */
	$"8080 8080 807F 8080 8080 8080 8080 7F80"            /* .. */
	$"8080 8080 8080 7F7F 7F80 8080 8080 807F"            /* .... */
	$"7F7F 8080 8080 7F7E 7E7F 7F7F 7F7E 7E7F"            /* ...~~....~~. */
	$"7F7F 7F7E 7E7E 7F7F 8080 7F7E 7E7E 7F7F"            /* ...~~~...~~~.. */
	$"7F7F 7F7F 7E7F 7F7F 7F7F 7F7F 7F7F 7F7F"            /* ....~........... */
	$"7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 7F7F 8080"            /* .............. */
	$"7F7F 7F7F 7F7F 8080 8080 7F7F 7E7F 7F7F"            /* ........~... */
	$"7F7F 7F7E 7E7F 7F7F 7E7E 7F80 807F 7F7F"            /* ...~~...~~.... */
	$"7E7E 7F80 8080 7F7F 7E7F 7F7F 7F7F 7F7E"            /* ~~...~......~ */
	$"7F7F 7F7F 7F7F 8080 8080 8080 8080 7F80"            /* ....... */
	$"8080 8080 8080 7F80 8080 807F 7F7F 7F7F"            /* ...... */
	$"7F7F 7F80 8080 807F 7F7F 7F80 807F 7F80"            /* ......... */
	$"8080 8080 807F 8080 8080 8080 8080 8080"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 7F7F 7F80 8080 8080 7F7F 7F80 8080"            /* ...... */
	$"807F 7F7F 8080 807F 7F7F 8080 8080 7F7E"            /* .......~ */
	$"7F80 8080 8180 8080 8080 8080 8080 8081"            /* . */
	$"8080 8080 8080 8181 8080 8080 8080 8080"            /*  */
	$"8080 8080 8080 7F7F 7F80 8080 8080 7F80"            /* .... */
	$"8080 8081 8080 8080 8081 8180 8080 8081"            /*  */
	$"8181 8080 8080 8081 8181 8080 8080 8181"            /*  */
	$"8181 8181 8181 8181 8181 8181 8181 8080"            /*  */
	$"8081 8181 8181 8080 8081 8181 8181 8080"            /*  */
	$"8080 8080 8181 8181 8181 8080 8081 8181"            /*  */
	$"8181 8181 8181 8080 8080 8080 8181 8080"            /*  */
	$"8080 8081 8180 8080 8080 8081 8181 8181"            /*  */
	$"8180 8080 8081 8181 8180 8080 8181 8181"            /*  */
	$"8181 8080 8080 8080 8080 8181 8180 8080"            /*  */
	$"8080 8181 8080 8080 8180 8080 8080 8181"            /*  */
	$"8181 8080 8080 8181 8181 8181 8080 8080"            /*  */
	$"8181 8181 8180 8080 8080 8080 8080 8080"            /*  */
	$"8080 8180 8080 8181 8080 8080 8080 8181"            /*  */
	$"8080 8080 8080 8080 8080 8080 8081 8080"            /*  */
	$"8080 8080 8080 8080 8080 8081 8080 8080"            /*  */
	$"8080 8080 8180 8080 8080 8080 8080 8080"            /*  */
	$"807F 7F7F 7F7F 7E7F 8080 807F 7F7F 7F7F"            /* .....~...... */
	$"8080 8080 8080 8080 8080 8080 8080 7F7F"            /* .. */
	$"8080 8080 8080 8080 8080 807F 7F80 8080"            /* .. */
	$"8080 7F7F 7F80 8080 8080 7F7F 7F80 8080"            /* ...... */
	$"807F 7F7F 7F7F 7E7F 8080 8080 8080 8080"            /* .....~. */
	$"7F80 8080 8080 8080 8080 8080 8080 8080"            /* . */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 807F 7F7F 7F7F 8080 8080 807F"            /* ...... */
	$"7F7F 7F80 8080 8080 8080 8080 8080 8080"            /* ... */
	$"8080 807F 7F7F 8080 8080 8080 807F 7F80"            /* ..... */
	$"8080 8080 807F 8080 8080 7F80 8080 807F"            /* ... */
	$"7E7E 7E7F 8080 8080 7F7F 7E7F 8080 807F"            /* ~~~...~.. */
	$"8080 807F 7E7F 8080 8080 8080 807F 8080"            /* .~.. */
	$"8080 8080 8080 807F 7F80 8080 8080 8080"            /* .. */
	$"807F 7F80 8080 8080 807F 7F80 8080 8080"            /* .... */
	$"8080 8080 807F 7F7F 8080 8081 8080 8080"            /* ... */
	$"8080 8080 8080 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 8081 8180 8080 8181 8080 8181"            /*  */
	$"8080 8181 8181 8181 8181 8181 8181 8080"            /*  */
	$"8181 8180 8081 8181 8180 8080 8080 8181"            /*  */
	$"8180 8080 8080 8181 8080 8080 8081 8181"            /*  */
	$"8180 8080 8080 8080 8080 8181 8180 8080"            /*  */
	$"8080 8080 8080 8080 8080 8080 8181 8080"            /*  */
	$"8080 8080 8080 8180 8080 8080 8080 8080"            /*  */
	$"8080 8081 8080 8080 8081 8080 8080 8080"            /*  */
	$"8080 8181 8180 8080 8080 8080 8080 8080"            /*  */
	$"8080 8080 80"                                       /*  */
};

Type 'PROB' {		/* pour calcul de probabilit */
		array [12] {integer; array [16] {longint;};};};

Resource 'PROB' (128) {
	{0, {990, 980, 950, 900, 800, 700, 600, 500, 400, 300, 200, 100, 50, 20, 10, 1},		/* 0, {probabilits} */
	1, {16, 63, 39, 16, 64, 148, 275, 455, 71, 107, 164, 271, 384, 541, 664, 1083},			/* ndl, {chi2/ndl} */
	2, {1000, 2020, 515, 105, 223, 357, 511, 693, 92, 120, 161, 230, 300, 391, 461, 691},
	3, {3830, 6170, 1170, 195, 335, 475, 623, 789, 98, 122, 155, 208, 261, 328, 378, 542},
	4, {7420, 10700, 1780, 266, 412, 549, 688, 839, 101, 122, 150, 195, 237, 292, 332, 462},
	6, {14500, 18900, 2730, 367, 512, 638, 762, 891, 104, 121, 143, 177, 210, 251, 280, 374},
	8, {20600, 25400, 3420, 436, 574, 691, 803, 918, 104, 119, 138, 167, 194, 227, 251, 327},
	10, {25600, 30600, 3940, 487, 618, 727, 830, 934, 105, 118, 134, 160, 183, 212, 232, 296},
	15, {34900, 39900, 4840, 570, 687, 781, 869, 956, 105, 116, 129, 149, 167, 188, 204, 251},
	20, {41300, 46200, 5430, 622, 729, 813, 890, 967, 105, 114, 125, 142, 157, 175, 188, 227},
	30, {49800, 54400, 6160, 687, 779, 850, 915, 978, 104, 112, 121, 134, 146, 160, 170, 199},
	40, {55400, 59600, 6630, 726, 809, 872, 928, 983, 104, 110, 118, 130, 139, 151, 159, 184}}};
	
Resource 'SIZE' (-1) {
	saveScreen,								/* pour compatibilit avec Switcher */
	acceptSuspendResumeEvents,
	enableOptionSwitch,					/* pour compatibilit avec Switcher */
	cannotBackground,
	multiFinderAware,
	backgroundAndForeground,
	dontGetFrontClicks,					/* ne rcupre les clics qu'en actif */
	ignoreChildDiedEvents,				/* pour dbuguer */
	is32BitCompatible,
	reserved,									/* ? */
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,									/* ? */
	384 * 1024,							/*	384K	optimum*/
	384 * 1024};							/*	384K	minimum  (semble ignor par Rez)*/
	