UNIT MG_fonction;

INTERFACE

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf, PackIntf, MacPrint, SANE, ObjIntf,
	USLib_U1,
	MG_util, MG_points;

CONST
	MG_MPar = 20;
	MG_MaxBOper = 5;
	MG_MaxUOper = 22;
	
	MG_SetUpFoncDlgID = 1005;
	MG_MyListPDlgID = 1008;
	MG_MyVarDlgID = 1009;
	MG_MyFoncDlgID = 1010;
	
	MG_BadNameStopID = 1103;
	
	MG_FoncStrID = 264;

TYPE
	MG_PTitres = array[0..2] of STR255;
	TOperS = OBJECT(TObject)
		suivant1 : TOper;
		suivant2 : TOper;
		suivant3 : TOper;
		PROCEDURE free; OVERRIDE;
		FUNCTION clone : TObject; OVERRIDE;
		FUNCTION ExecOper (theParamS : TParamS; x : extended) : extended;
		FUNCTION FormulOper : STR255;
		END;
	TOper = OBJECT(TOperS)
		OperOuVar : STR255;
		OperCode : integer;
		ConstValue : extended;
		FUNCTION ExecOper (theParamS : TParamS; x : extended) : extended; OVERRIDE;
		FUNCTION FormulOper : STR255; OVERRIDE;
		END;
	TParamS = OBJECT(TObject)
		suivant : TParam;
		PROCEDURE free; OVERRIDE;
		FUNCTION clone : TObject; OVERRIDE;
		FUNCTION compte : integer;
		PROCEDURE extension (nombre : integer);
		FUNCTION ComptEff : integer;
		END;
	TParam = OBJECT(TParamS)
		aN : STR255;
		a, w : extended;
		FUNCTION compte : integer; OVERRIDE;
		FUNCTION ComptEff : integer; OVERRIDE;
		END;
	
VAR
	MG_BinOperName : array[1..MG_MaxBOper] of char;
	MG_UnOperName : array[1..MG_MaxUOper] of STR255;
	MG_UnOperVars : array[1..MG_MaxUOper] of integer;
	MG_Comments : integer;
	MG_theOperS : TOperS;
	MG_FoncWPtr : WindowPtr;
	MG_theParamS : TParamS;

PROCEDURE InitOper;
FUNCTION min (x, y : extended) : extended;
FUNCTION max (x, y : extended) : extended;
FUNCTION mdl (x, y : extended) : extended;
FUNCTION log (x : extended) : extended;
FUNCTION sign (x : extended) : extended;
FUNCTION atan (x : extended) : extended;
FUNCTION acos (x : extended) : extended;
FUNCTION asin (x : extended) : extended;
FUNCTION pH (ca, cb : extended) : extended;
FUNCTION pHaK (ca, pka, cb : extended) : extended;
FUNCTION pHbK (ca, cb, pka : extended) : extended;
FUNCTION DeleteBlancs (formule : STR255) : STR255;
FUNCTION FindRightPar (formule : STR255; index : integer) : integer;
FUNCTION FindLeftPar (formule : STR255; index : integer) : integer;
FUNCTION FindSeparateur (formule : STR255) : integer;
FUNCTION FindBinOper (oper : char; formule : STR255) : integer;
FUNCTION OperConst (formule : STR255) : TOper;
FUNCTION OperVar (formule : STR255) : TOper;
FUNCTION UnOper (formule : STR255) : TOper;
FUNCTION BinOper (oper : integer; formule : STR255) : TOper;
FUNCTION LireFonc(VAR FFic, aFonc, xN, yN : STR255; VAR theParamS : TParamS) : boolean;
FUNCTION SaveFonc (FFic, aFonc, xN, yN : STR255; theParamS : TParamS) : boolean;
FUNCTION ListeParams(titres : MG_PTitres; VAR theParamS : TParamS) : boolean;
PROCEDURE SetUpFonc (AsSet : boolean; VAR xN, yN : STR255; VAR theParamS : TParamS);

IMPLEMENTATION

{$S MG_fonction }

CONST
	theVar = -1;
	theConst = 0;
	theBOper1 = 1;		{+}
	theBOper2 = 2;		{-}
	theBOper3 = 3;		{*}
	theBOper4 = 4;		{/}
	theBOper5 = 5;		{$}
	theUOper3 = MG_MaxBOper + 3;		{-}
	theUOper4 = MG_MaxBOper + 4;		{}
	theUOper5 = MG_MaxBOper + 5;		{}
	theUOper6 = MG_MaxBOper + 6;		{abs}
	theUOper7 = MG_MaxBOper + 7;		{<}
	theUOper8 = MG_MaxBOper + 8;		{>}
	theUOper9 = MG_MaxBOper + 9;		{ent}
	theUOper10 = MG_MaxBOper + 10;		{mdl}
	theUOper11 = MG_MaxBOper + 11;		{exp}
	theUOper12 = MG_MaxBOper + 12;		{ln}
	theUOper13 = MG_MaxBOper + 13;		{log}
	theUOper14 = MG_MaxBOper + 14;		{sin}
	theUOper15 = MG_MaxBOper + 15;		{cos}
	theUOper16 = MG_MaxBOper + 16;		{tan}
	theUOper17 = MG_MaxBOper + 17;		{asin}
	theUOper18 = MG_MaxBOper + 18;		{acos}
	theUOper19 = MG_MaxBOper + 19;		{atan}
	theUOper20 = MG_MaxBOper + 20;		{pH}
	theUOper21 = MG_MaxBOper + 21;		{pHaK}
	theUOper22 = MG_MaxBOper + 22;		{pHbK}

PROCEDURE AboutBug(orig, terr : STR255); {1111111111111111111111111111111111111111111111111}

CONST
	MemSatStopID = 1104;

VAR
	MyZone : THZ;
	MyHeapEnd, HorsZoneFreeMem, FreeMemory : longint;
	confirmation : integer;
	
BEGIN
	MyZone := ApplicZone;
	MyHeapEnd := ord(MyZone^.BkLim);
	HorsZoneFreeMem := ord(GetApplLimit) - MyHeapEnd;	{distance entre fin de zone et maximum}
	FreeMemory := FreeMem + HorsZoneFreeMem;
	FreeMemory := (FreeMemory div 1024) - 10;		{10 K de marge : pas trop d'illusions sur la pile...}
	ParamText(orig, terr, RealToString(FreeMemory, 2), '');			{pour afficher la mmoire disponible}
	confirmation := StopAlert(MemSatStopID, nil);

END; {***** AboutBug *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE TOperS.free; {11111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant1 <> NIL) THEN suivant1.free;
	IF (suivant2 <> NIL) THEN suivant2.free;
	IF (suivant3 <> NIL) THEN suivant3.free;
	INHERITED free;

END; {***** TOperS.free *****111111111111111111111111111111111111111111111111111111111}

FUNCTION TOperS.clone; {1111111111111111111111111111111111111111111111111111111111111111}

VAR
	unOperS : TOperS;

BEGIN
	unOperS := TOperS(INHERITED clone);
	IF (suivant1 <> NIL) THEN unOperS.suivant1 := TOper(suivant1.clone);
	IF (suivant2 <> NIL) THEN unOperS.suivant2 := TOper(suivant2.clone);
	IF (suivant3 <> NIL) THEN unOperS.suivant3 := TOper(suivant3.clone);
	clone := unOperS;

END; {***** TOperS.clone *****11111111111111111111111111111111111111111111111111111111}

FUNCTION TOperS.ExecOper; {111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant1 = NIL) THEN ExecOper := 0
	ELSE ExecOper := suivant1.ExecOper(theParamS, x);

END; {***** TOperS.ExecOper *****11111111111111111111111111111111111111111111111111111}

FUNCTION TOperS.FormulOper; {11111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant1 = NIL) THEN FormulOper := ''
	ELSE FormulOper := suivant1.FormulOper ;

END; {***** TOperS.FormulOper *****111111111111111111111111111111111111111111111111111}

FUNCTION TOper.ExecOper; {1111111111111111111111111111111111111111111111111111111111111}

VAR
	i, pNum : integer;
	unParam : TParam;

BEGIN
	CASE OperCode OF
		theVar :	ExecOper := x;
		theConst :	ExecOper := ConstValue;
		theBOper1 :	ExecOper := suivant1.ExecOper(theParamS, x) + suivant2.ExecOper(theParamS, x);
		theBOper2 :	ExecOper := suivant1.ExecOper(theParamS, x) - suivant2.ExecOper(theParamS, x);
		theBOper3 :	ExecOper := suivant1.ExecOper(theParamS, x) * suivant2.ExecOper(theParamS, x);
		theBOper4 :	ExecOper := suivant1.ExecOper(theParamS, x) / suivant2.ExecOper(theParamS, x);
		theBOper5 :	ExecOper := XpwrY(suivant1.ExecOper(theParamS, x), suivant2.ExecOper(theParamS, x));
		theUOper3 :	ExecOper := -suivant1.ExecOper(theParamS, x);
		theUOper4 :	ExecOper := sqrt(suivant1.ExecOper(theParamS, x));
		theUOper5 :	ExecOper := sign(suivant1.ExecOper(theParamS, x));
		theUOper6 :	ExecOper := abs(suivant1.ExecOper(theParamS, x));
		theUOper7 :	ExecOper := min(suivant1.ExecOper(theParamS, x), suivant2.ExecOper(theParamS, x));
		theUOper8 :	ExecOper := max(suivant1.ExecOper(theParamS, x), suivant2.ExecOper(theParamS, x));
		theUOper9 :	ExecOper := trunc(suivant1.ExecOper(theParamS, x));
		theUOper10 :	ExecOper := mdl(suivant1.ExecOper(theParamS, x), suivant2.ExecOper(theParamS, x));
		theUOper11 :	ExecOper := exp(suivant1.ExecOper(theParamS, x));
		theUOper12 :	ExecOper := ln(suivant1.ExecOper(theParamS, x));
		theUOper13 :	ExecOper := log(suivant1.ExecOper(theParamS, x));
		theUOper14 :	ExecOper := sin(suivant1.ExecOper(theParamS, x));
		theUOper15 :	ExecOper := cos(suivant1.ExecOper(theParamS, x));
		theUOper16 :	ExecOper := tan(suivant1.ExecOper(theParamS, x));
		theUOper17 :	ExecOper := asin(suivant1.ExecOper(theParamS, x));
		theUOper18 :	ExecOper := acos(suivant1.ExecOper(theParamS, x));
		theUOper19 :	ExecOper := atan(suivant1.ExecOper(theParamS, x));
		theUOper20 :	ExecOper := pH(suivant1.ExecOper(theParamS, x), suivant2.ExecOper(theParamS, x));
		theUOper21 :	ExecOper := pHaK(suivant1.ExecOper(theParamS, x),
									suivant2.ExecOper(theParamS, x), suivant3.ExecOper(theParamS, x));
		theUOper22 :	ExecOper := pHbK(suivant1.ExecOper(theParamS, x),
									suivant2.ExecOper(theParamS, x), suivant3.ExecOper(theParamS, x));
		OTHERWISE		{paramtres}
			BEGIN
			unParam := theParamS.suivant;
			i := 1;
			pNum := -1 - OperCode;		{la variable prcde les paramtres}
			WHILE (i < pNum) DO
				BEGIN
				unParam := unParam.suivant;
				i := i + 1;
				END;
			ExecOper := unParam.a;
			END;
		END;  {CASE}

END; {***** TOper.ExecOper *****111111111111111111111111111111111111111111111111111111}

FUNCTION TOper.FormulOper; {111111111111111111111111111111111111111111111111111111111111}

VAR
	j : integer;
	aString, bString : STR255;

BEGIN
	CASE OperCode OF
		theBOper1, theBOper2, theBOper3, theBOper4, theBOper5 :	{oprateurs binaires}
							BEGIN
							aString := suivant1.FormulOper;
							j := suivant1.OperCode;			{si imbrication des oprateurs binaires}
							IF (j >=1) & (j <= MG_MaxBOper) & (j < OperCode) THEN aString := concat('(', aString, ')');
							bString := suivant2.FormulOper ;
							j := suivant2.OperCode;			{si imbrication des oprateurs binaires}
							IF (j >=1) & (j <= MG_MaxBOper) & (j < OperCode) THEN bString := concat('(', bString, ')');
							FormulOper := concat(aString, MG_BinOperName[OperCode], bString);
							END;											{parenthses seulement si ncessaire, selon priorits...}
		{theUOper1 & 2 n'apparaissent jamais dans la structure code}
		theUOper3 :	FormulOper := concat('(-', suivant1.FormulOper, ')');
		theUOper4, theUOper5 :														{ ; }
							BEGIN
							j := OperCode - MG_MaxBOper;
							FormulOper := concat(MG_UnOperName[j], suivant1.FormulOper);
							END;
		theUOper6, theUOper9, theUOper11, theUOper12, theUOper13, theUOper14, theUOper15,
		theUOper16, theUOper17, theUOper18, theUOper19 :			{autres fonctions  une variable}
							BEGIN
							j := OperCode - MG_MaxBOper;
							FormulOper := concat(MG_UnOperName[j], suivant1.FormulOper, ')');
							END;
		theUOper7, theUOper8, theUOper10, theUOper20 :				{fonctions  deux variables}
							BEGIN
							j := OperCode - MG_MaxBOper;
							FormulOper := concat(MG_UnOperName[j], suivant1.FormulOper, ';',
											suivant2.FormulOper, ')');
							END;
		theUOper21, theUOper22 :													{fonctions  trois variables}
							BEGIN
							j := OperCode - MG_MaxBOper;
							FormulOper := concat(MG_UnOperName[j], suivant1.FormulOper, ';',
											suivant2.FormulOper, ';', suivant3.FormulOper, ')');
							END;
		OTHERWISE	FormulOper := OperOuVar;								{variable, constante, paramtres}
		END;  {CASE}

END; {***** TOper.FormulOper *****1111111111111111111111111111111111111111111111111111}

PROCEDURE TParamS.free; {11111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.free;
	INHERITED free;

END; {***** TParamS.free *****1111111111111111111111111111111111111111111111111111111}

FUNCTION TParamS.clone; {11111111111111111111111111111111111111111111111111111111111111}

VAR
	unParamS : TParamS;

BEGIN
	unParamS := TParamS(INHERITED clone);
	IF (suivant <> NIL) THEN unParamS.suivant := TParam(suivant.clone);
	clone := unParamS;

END; {***** TParamS.clone *****1111111111111111111111111111111111111111111111111111111}

FUNCTION TParamS.compte; {1111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant = NIL) THEN compte := 0 ELSE compte := suivant.compte;

END; {***** TParamS.compte *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TParamS.extension; {1111111111111111111111111111111111111111111111111111111111}

VAR
	unParam : TParam;

BEGIN
	IF (nombre <= 0) THEN
		BEGIN
		IF (suivant <> NIL) THEN
			BEGIN
			suivant.free;
			suivant := NIL;
			END;
		END
	ELSE
		BEGIN
		IF (suivant = NIL) THEN			{on ajoute}
			BEGIN
			new(unParam);
			unParam.suivant := NIL;
			unParam.aN := '';
			unParam.a := 0;
			unParam.w := 0;
			suivant := unParam;
			END;
		suivant.extension(nombre - 1);
		END;

END; {***** TParamS.extension *****111111111111111111111111111111111111111111111111111}

FUNCTION TParamS.ComptEff; {11111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant = NIL) THEN ComptEff := 0 ELSE ComptEff := suivant.ComptEff;

END; {***** TParamS.ComptEff *****1111111111111111111111111111111111111111111111111111}

FUNCTION TParam.compte; {11111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant = NIL) THEN compte := 1 ELSE compte := suivant.compte + 1;

END; {***** TParam.compte *****111111111111111111111111111111111111111111111111111111}

FUNCTION TParam.ComptEff; {111111111111111111111111111111111111111111111111111111111111}

VAR
	nn : integer;

BEGIN
	IF (w <> 0) THEN nn := 1 ELSE nn := 0;
	IF (suivant = NIL) THEN ComptEff := nn ELSE ComptEff := suivant.ComptEff + nn;

END; {***** TParam.ComptEff *****1111111111111111111111111111111111111111111111111111}

PROCEDURE InitOper; {111111111111111111111111111111111111111111111111111111111111111111}

VAR
	i, jVars : integer;
	aString : STR255;

BEGIN
	MG_xN := 'x';
	MG_yN := 'y';
	MG_BinOperName[1] := '+';
	MG_BinOperName[2] := '-';
	MG_BinOperName[3] := '*';
	MG_BinOperName[4] := '/';
	GetIndString(aString, MG_FoncStrID, 1);
	MG_BinOperName[5] := aString[1]; 	{utiliser '$' si l'oprateur '^' provoque un plantage sur powerPC avec systme 8}

	MG_UnOperName[1] := '(';			{operateur unaire sans effet}
	MG_UnOperVars[1] := 1;
	MG_UnOperName[2] := '+';		{+ unaire sans effet}
	MG_UnOperVars[2] := 1;
	MG_UnOperName[3] := '-';			{- unaire}
	MG_UnOperVars[3] := 1;

	FOR i := 4 TO MG_MaxUOper DO
		BEGIN
		GetIndString(aString, MG_FoncStrID, i-2);
		jVars := 1;
		IF (aString[length(aString)] = ')') THEN aString := copy(aString, 1, length(aString)-1);
		WHILE (aString[length(aString)] = ';') DO
			BEGIN
			aString := copy(aString, 1, length(aString)-1);
			jVars := jVars+1;
			END;
		MG_UnOperName[i] := aString;
		MG_UnOperVars[i] := jVars;
		END;

END; {***** InitOper *****111111111111111111111111111111111111111111111111111111111111}

FUNCTION min; {11111111111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (x < y) THEN min := x
	ELSE min := y;
 
END; {***** min *****111111111111111111111111111111111111111111111111111111111111111}

FUNCTION max; {1111111111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (x > y) THEN max := x
	ELSE max := y;
 
END; {***** max *****111111111111111111111111111111111111111111111111111111111111111}

FUNCTION mdl; {1111111111111111111111111111111111111111111111111111111111111111111111}

VAR
	yy, mm : extended;

BEGIN
	yy := abs(y);
	mm := x - yy*trunc(x/yy);
	IF (mm < 0) THEN mdl := mm + yy
	ELSE mdl := mm;
 
END; {***** mdl *****111111111111111111111111111111111111111111111111111111111111111}

FUNCTION log (x : extended) : extended; {1111111111111111111111111111111111111111111111111111}

BEGIN
 	log := ln(x)/ln(10);
 
END; {***** log *****1111111111111111111111111111111111111111111111111111111111111111}

FUNCTION sign (x : extended) : extended; {111111111111111111111111111111111111111111111111111}

BEGIN
	IF (x < 0) THEN sign := -1
	ELSE sign := 1;
 
END; {***** sign *****111111111111111111111111111111111111111111111111111111111111111}

FUNCTION atan (x : extended) : extended; {111111111111111111111111111111111111111111111111111}

BEGIN
	atan := arctan(x);
 
END; {***** atan *****111111111111111111111111111111111111111111111111111111111111111}

FUNCTION acos (x : extended) : extended; {111111111111111111111111111111111111111111111111111}

BEGIN
	IF (x >= 0) THEN acos := atan(sqrt(1-x*x)/x)
	ELSE acos := atan(sqrt(1-x*x)/x)+PI;			{acos entre 0 et pi}
 
END; {***** acos *****11111111111111111111111111111111111111111111111111111111111111}

FUNCTION asin (x : extended) : extended; {111111111111111111111111111111111111111111111111111}

BEGIN
	asin := atan(x/sqrt(1-x*x));
 
END; {***** asin *****111111111111111111111111111111111111111111111111111111111111111}

FUNCTION pH (ca, cb : extended) : extended; {1111111111111111111111111111111111111111111111111}

VAR
	ke, xi, hh : extended;

BEGIN
	ke := 1.0E-14;
	xi := ca - cb;
	hh := (xi + sqrt(xi*xi + 4*ke))/2;
	pH := - log(hh);
 
END; {***** pH *****1111111111111111111111111111111111111111111111111111111111111111}

FUNCTION pHaK (ca, pka, cb : extended) : extended; {1111111111111111111111111111111111111111111}

VAR
	ka, ke, a, b, c, al, be, hh : extended;

BEGIN
	ka := XpwrY(10, -pka);
	ke := 1.0E-14;
	a := ka + cb;
	b := - ke + (cb-ca) * ka;
	c := - ke * ka;
	IF ((cb > ca*(1-pka/12)) AND (cb > 0.002)) THEN				{on simplifie si possible ...}
		hh := (- b + sqrt(b*b - 4*a*c))/(2*a)				{...car 20 chiffres significatifs ne suffisent pas}
	ELSE
		BEGIN
		al := abs(b/3 - a*a/9);
		be := c/2 - (b/2 - a*a/9)*a/3;
		hh := acos(be/XpwrY(al, 3/2))/3;
		hh := sqrt(al)*(cos(hh) + sqrt(3)*sin(hh));
		hh := hh - a/3;
		END;
	pHaK := - log(hh);
 
END; {***** pHaK *****11111111111111111111111111111111111111111111111111111111111111}

FUNCTION pHbK (ca, cb, pka : extended) : extended; {1111111111111111111111111111111111111111111}

VAR
	ka, ke, a, b, c, al, be, hh : extended;

BEGIN
	ka := XpwrY(10, -pka);
	ke := 1.0E-14;
	a := ka - ca + cb;
	b := - ke - ca * ka;
	c := - ke * ka;
	IF ((ca < cb*((pka-2)/12)) AND (cb > 0.002)) THEN				{on simplifie si possible ...}
		hh := (- b + sqrt(b*b - 4*a*c))/(2*a)				{...car 20 chiffres significatifs ne suffisent pas}
	ELSE IF ((ca > cb*(26-pka)/12) AND (ca > 0.002)) THEN
		hh := (- a + sqrt(a*a - 4*b))/2
	ELSE
		BEGIN
		al := abs(b/3 - a*a/9);
		be := c/2 - (b/2 - a*a/9)*a/3;
		hh := acos(be/XpwrY(al, 3/2))/3;
		hh := sqrt(al)*(cos(hh) + sqrt(3)*sin(hh));
		hh := hh - a/3;
		END;
	pHbK := - log(hh);
 
END; {***** pHbK *****11111111111111111111111111111111111111111111111111111111111111}

FUNCTION DeleteBlancs (formule : STR255) : STR255; {11111111111111111111111111111111111111111}

VAR
	i, L : integer;
	form : STR255;

BEGIN
	i := 1;
	form := formule;
	L := length(form);
	WHILE (i <= L) DO
		IF (form[i] = ' ') THEN
			BEGIN
			form := concat(copy(form, 1, i - 1), copy(form, i + 1, L - i));
			L := L - 1;
			END
		ELSE i := i + 1;
	DeleteBlancs := form;

END; {***** DeleteBlancs *****11111111111111111111111111111111111111111111111111111111}

FUNCTION FindRightPar (formule : STR255; index : integer) : integer; {111111111111111111111111111111}

VAR
	i, j, NPar, L : integer;
	a : char;

BEGIN
	i := index;
	j := 256;
	NPar := 1;
	L := length(formule);
	WHILE ((i <= L) and (j = 256)) DO
		BEGIN
		a := formule[i];
		IF (a = '(') THEN NPar := NPar + 1
		ELSE IF (a = ')') THEN NPar := NPar - 1;
		IF (NPar = 0) THEN j := i
		ELSE i := i + 1;
		END;
	FindRightPar := j;					{position de la fermeture}

END; {***** FindRightPar *****11111111111111111111111111111111111111111111111111111111}

FUNCTION FindLeftPar (formule : STR255; index : integer) : integer; {111111111111111111111111111111}

VAR
	i, j, NPar, L : integer;
	a : char;

BEGIN
	i := index;
	j := 0;
	NPar := 1;
	L := length(formule);
	WHILE ((i > 0) and (j = 0)) DO
		BEGIN
		a := formule[i];
		IF (a = ')') THEN NPar := NPar + 1
		ELSE IF (a = '(') THEN NPar := NPar - 1;
		IF (NPar = 0) THEN j := i
		ELSE i := i - 1;
		END;
	FindLeftPar := j;					{position de l'ouverture}

END; {***** FindLeftPar *****111111111111111111111111111111111111111111111111111111111}

FUNCTION FindSeparateur (formule : STR255) : integer; {1111111111111111111111111111111111111111}

VAR
	i, j, L : integer;
	a : char;

BEGIN
	j := 0;
	L := length(formule);
	i := L;
	WHILE ((i > 0) and (j = 0)) DO
		BEGIN
		a := formule[i];
		IF (a = ';') THEN j := i
		ELSE IF (a = ')') THEN i := FindLeftPar(formule, i - 1);	{on continue a chercher avant l'ouverture}
		i := i - 1;
		END;
	FindSeparateur := j;

END; {***** FindSeparateur *****111111111111111111111111111111111111111111111111111111}

FUNCTION FindBinOper; {11111111111111111111111111111111111111111111111111111111111111111}

VAR
	i, j, L, lk : integer;
	a, a1 : char;
	unParam : TParam;
	aString : STR255;

BEGIN
	j := 0;
	L := length(formule);
	i := L;
	WHILE ((i > 0) AND (j = 0)) DO
		BEGIN
		a := formule[i];
		IF (a = oper) THEN
			BEGIN
			IF ((oper = '+') OR (oper = '-')) THEN
				BEGIN
				IF (i > 1) THEN			{liminer les signes unaires}
					BEGIN
					a1 := formule[i-1];
					IF ((a1 = 'E') OR (a1 = 'e')) THEN			{'E' ou 'e' d'exposant ?}
						BEGIN
						unParam := MG_theParamS.suivant;
						WHILE (unParam <> NIL) DO
							BEGIN
							aString := unParam.aN;
							lk := length(aString);			{si paramtre "E" ou "e"... on ignore !}
							IF ((lk > 1) & (i > lk) & (copy(formule, i-lk, lk) = aString)) THEN
								BEGIN
								j := i;
								LEAVE;
								END;
							unParam := unParam.suivant;
							END;	{WHILE}
						END
					ELSE j := i;
					END;
				END
			ELSE j := i;
			END
		ELSE IF (a = ')') THEN i := FindLeftPar(formule, i - 1);	{on continue a chercher avant l'ouverture}
		i := i - 1;
		END;
	FindBinOper := j;

END; {***** FindBinOper *****111111111111111111111111111111111111111111111111111111111}

FUNCTION OperConst; {111111111111111111111111111111111111111111111111111111111111111111}

VAR
	i, j, L : integer;
	theOper : TOper;
	box : rect;
	OptType : integer;
	MyItemHdl : handle;
	aString : STR255;
	a : char;

BEGIN
	L := length(formule);
	i := 1;
	j := L + 1;
	WHILE ((i <= L) AND (j > L)) DO
		BEGIN			{(formule[i] in ['0'..'9']) n'est pas digr par TML Pascal...}
		a := formule[i];
		IF (((a < '0') | (a > '9')) &
			(a <> 'e') & (a <> 'E') & (a <> '+') & (a <> '-') & (a <> '.') & (a <> ',')) THEN
				j := i;			{ce n'est pas un entier et a contient des caractres curieux pour un rel...}
		i := i + 1;
		END;
	IF ((L > 0) and (j > L)) THEN
		BEGIN
		new(theOper);
		IF (HeapResult = 0) THEN
			BEGIN
			theOper.OperOuVar := RealToString(StringToReal(formule), -9);
			theOper.OperCode := 0;
			theOper.ConstValue := StringToReal(formule);
			theOper.suivant1 := NIL;
			theOper.suivant2 := NIL;
			theOper.suivant3 := NIL;
			END
		ELSE
			BEGIN
			AboutBug('OperConst', RealToString(HeapResult, 2));
			theOper := NIL;
			END;
		OperConst := theOper;
		END
	ELSE
		BEGIN
		OperConst := NIL;				{pas de constante : c'est considr comme une erreur}
		sysbeep(1);
		SelIText(MG_FoncWPtr, MG_Comments, 0, 0);				{sinon les '^' taient mal affichs}
		GetDItem(MG_FoncWPtr, MG_Comments, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		IF (aString = '') THEN SetIText(MyItemHdl, concat('OperConst "', formule, '"'))
		ELSE SetIText(MyItemHdl, concat(aString, chr(13), 'OperConst "', formule, '"'));
		END;

END; {***** OperConst *****1111111111111111111111111111111111111111111111111111111111}

FUNCTION OperVar; {1111111111111111111111111111111111111111111111111111111111111111111}

VAR
	theOper : TOper;
	found : boolean;
	aString : STR255;
	box : rect;
	pNum, OptType : integer;
	MyItemHdl : handle;
	unParam : TParam;

BEGIN
	found := false;
	IF (formule = MG_xN) THEN
		BEGIN
		new(theOper);
		IF (HeapResult = 0) THEN
			BEGIN
			theOper.OperOuVar := formule;
			theOper.OperCode := -1;
			theOper.ConstValue := 0;
			theOper.suivant1 := NIL;
			theOper.suivant2 := NIL;
			theOper.suivant3 := NIL;
			END
		ELSE
			BEGIN
			AboutBug('OperVar', RealToString(HeapResult, 2));
			theOper := NIL;
			END;
		OperVar := theOper;
		found := true;
		END;
	unParam := MG_theParamS.suivant;
	pNum := 1;
	WHILE (unParam <> NIL) AND NOT found DO
		BEGIN
		IF (formule = unParam.aN) THEN
			BEGIN
			new(theOper);
			IF (HeapResult = 0) THEN
				BEGIN
				theOper.OperOuVar := formule;
				theOper.OperCode := -1 - pNum;		{la variable prcde les paramtres}
				theOper.ConstValue := 0;
				theOper.suivant1 := NIL;
				theOper.suivant2 := NIL;
				theOper.suivant3 := NIL;
				END
			ELSE
				BEGIN
				AboutBug('OperVar', RealToString(HeapResult, 2));
				theOper := NIL;
				END;
			OperVar := theOper;
			found := true;
			END
		ELSE
			BEGIN
			unParam := unParam.suivant;
			pNum := pNum + 1;
			END;  {IF formule}
		END;  {WHILE}
	IF NOT found THEN OperVar := OperConst(formule);	{pas de variable : on cherche les constantes}

END; {***** OperVar *****11111111111111111111111111111111111111111111111111111111111}

FUNCTION UnOper; {11111111111111111111111111111111111111111111111111111111111111111111}

VAR
	i, i2, j, L, ia, ib : integer;
	theOper : TOper;
	box : rect;
	OptType : integer;
	MyItemHdl : handle;
	aString : STR255;

BEGIN
	L := length(formule);
	i := 1;
	j := MG_MaxUOper + 1;
	WHILE ((i <= MG_MaxUOper) AND (j > MG_MaxUOper)) DO
		BEGIN
		IF (pos(MG_UnOperName[i], formule) = 1) THEN
			BEGIN
			IF (pos('(', MG_UnOperName[i]) = 0) THEN
				 j := i								{+ ou - unaire ;  ; }
			ELSE
				BEGIN								{il faut chercher la fermeture}
				i2 := length(MG_UnOperName[i]) + 1;
				IF (FindRightPar(formule, i2) = L) THEN j := i;
				END;
			END;
		i := i + 1;
		END;
	IF (j <= MG_MaxUOper) THEN
		BEGIN				{on enleve operateur et/ou parentheses et on recommence}
		IF (j = 1) THEN UnOper := BinOper(1, copy(formule, 2, L - 2))	{parentheses}
		ELSE IF (j = 2) THEN UnOper := BinOper(1, copy(formule, 2, L - 1))	{+ unaire}
		ELSE
			BEGIN
			new(theOper);
			IF (HeapResult = 0) THEN
				BEGIN
				theOper.OperOuVar := MG_UnOperName[j];
				theOper.OperCode := MG_MaxBOper + j;
				theOper.ConstValue := 0;
				IF (MG_UnOperVars[j] = 1) THEN
					BEGIN														{fonctions  une variable}
					IF (pos('(', MG_UnOperName[j]) = 0) THEN
						theOper.suivant1 := BinOper(1, copy(formule, 2, L - 1))		{- unaire ;  ; }
					ELSE theOper.suivant1 := BinOper(1, copy(formule, i2, L - i2));
					theOper.suivant2 := NIL;
					theOper.suivant3 := NIL;
					END
				ELSE IF (MG_UnOperVars[j] = 2) THEN
					BEGIN														{fonctions  deux variables}
					ia := FindSeparateur(copy(formule, i2, L - i2));
					theOper.suivant2 := BinOper(1, copy(formule, i2 + ia, L - i2 - ia));
					IF (theOper.suivant2 = NIL) THEN theOper.suivant1 := NIL
					ELSE theOper.suivant1 := BinOper(1, copy(formule, i2, ia - 1));
					theOper.suivant3 := NIL;
					END
				ELSE IF (MG_UnOperVars[j] = 3) THEN
					BEGIN														{fonctions  trois variables}
					ia := FindSeparateur(copy(formule, i2, L - i2));
					theOper.suivant3 := BinOper(1, copy(formule, i2 + ia, L - i2 - ia));
					IF (theOper.suivant3 = NIL) THEN
						BEGIN
						theOper.suivant1 := NIL;
						theOper.suivant2 := NIL;
						END
					ELSE
						BEGIN
						ib := FindSeparateur(copy(formule, i2, ia - 1));
						theOper.suivant2 := BinOper(1, copy(formule, i2 + ib, ia - 1 - ib));
						IF (theOper.suivant2 = NIL) THEN
							BEGIN
							theOper.suivant1 := NIL;
							theOper.suivant3 := NIL;
							END
						ELSE
							BEGIN
							theOper.suivant1 := BinOper(1, copy(formule, i2, ib - 1));
							IF (theOper.suivant1 = NIL) THEN
								BEGIN
								theOper.suivant2 := NIL;
								theOper.suivant3 := NIL;
								END;
							END;
						END;
					END;
				IF (theOper.suivant1 = NIL) THEN
					BEGIN
					theOper.free;
					UnOper := NIL;
					SelIText(MG_FoncWPtr, MG_Comments, 0, 0);				{sinon les '^' taient mal affichs}
					GetDItem(MG_FoncWPtr, MG_Comments, OptType, MyItemHdl, box);
					GetIText(MyItemHdl, aString);
					IF (aString = '') THEN SetIText(MyItemHdl, concat('UnOper[', MG_UnOperName[j], '] "', formule, '"'))
					ELSE SetIText(MyItemHdl, concat(aString, chr(13), 'UnOper[', MG_UnOperName[j], '] "', formule, '"'));
					END
				ELSE UnOper := theOper;
				END
			ELSE
				BEGIN
				AboutBug('UnOper', RealToString(HeapResult, 2));
				theOper := NIL;
				END;
			END;
		END
	ELSE UnOper := OperVar(formule);				{pas d'operateur : on cherche les variables}

END; {***** UnOper *****111111111111111111111111111111111111111111111111111111111111}

FUNCTION BinOper; {11111111111111111111111111111111111111111111111111111111111111111111}

VAR
	i : integer;
	theOper : TOper;
	box : rect;
	OptType : integer;
	MyItemHdl : handle;
	aString : STR255;

BEGIN
	i := FindBinOper(MG_BinOperName[oper], formule);
	IF (i > 0) THEN
		BEGIN				{on coupe en deux et on recommence avec les morceaux}
		new(theOper);
		IF (HeapResult = 0) THEN
			BEGIN
			theOper.OperOuVar := MG_BinOperName[oper];
			theOper.OperCode := oper;
			theOper.ConstValue := 0;
			theOper.suivant3 := NIL;
			theOper.suivant1 := BinOper(oper, copy(formule, 1, i - 1));	{y a-t-il un "oper" avant ?}
			IF (oper < MG_MaxBOper) THEN theOper.suivant2 := BinOper(oper + 1, copy(formule, i + 1, length(formule) - i))
			ELSE theOper.suivant2 := UnOper(copy(formule, i + 1, length(formule) - i));
			IF ((theOper.suivant1 = NIL) or (theOper.suivant2 = NIL)) THEN
				BEGIN
				theOper.free;
				BinOper := NIL;
				SelIText(MG_FoncWPtr, MG_Comments, 0, 0);				{sinon les '^' taient mal affichs}
				GetDItem(MG_FoncWPtr, MG_Comments, OptType, MyItemHdl, box);
				GetIText(MyItemHdl, aString);
				IF (aString = '') THEN SetIText(MyItemHdl, concat('BinOper[', MG_BinOperName[oper], '] "', formule, '"'))
				ELSE SetIText(MyItemHdl, concat(aString, chr(13), 'BinOper[', MG_BinOperName[oper], '] "', formule, '"'));
				END
			ELSE BinOper := theOper;
			END
		ELSE
			BEGIN
			AboutBug('BinOper', RealToString(HeapResult, 2));
			theOper := NIL;
			END;
		END
	ELSE
		BEGIN
		IF (oper < MG_MaxBOper) THEN BinOper := BinOper(oper + 1, formule)
		ELSE BinOper := UnOper(formule);
		END;

END; {***** BinOper *****111111111111111111111111111111111111111111111111111111111111}

FUNCTION LireFonc; {1111111111111111111111111111111111111111111111111111111111111111111}

VAR
	where : point;
	reply : SFReply;
	TypeList : SFTypeList;
	MyFl : text;					{formule dclare en type texte}
	MFic, aString, bString : STR255;
	nPar, ll : integer;
	startParamS, lastParamS : TParamS;
	unParam : TParam;

FUNCTION LireNombre : STR255; {222222222222222222222222222222222222222222222222222222222}

VAR
	cString : STR255;
	theChar, MyTab : char;

BEGIN
	cString := '';
	MyTab := chr(9);
	WHILE (NOT EOF(MyFl) & NOT EOLN(MyFl)) DO
		BEGIN
		read(MyFl, theChar);
		IF (theChar <> MyTab)  THEN cString := concat(cString, theChar)
		ELSE LEAVE;
		END;
	LireNombre := cString;

END; {***** LireNombre *****222222222222222222222222222222222222222222222222222222222}
		
BEGIN
	aFonc := '';
	xN := 'x';
	yN := 'y';
	IF (theParamS <> NIL) THEN theParamS.free;
	startParamS := NIL;
	where.v := 180;
	where.h := 95;
	TypeList[0] := 'TEXT';
	GetIndString(bString, MG_IOStrID, 6);
	SFGetFile(where, bString, nil,
								1, TypeList,		{slection de ce seul type}
								nil, reply);
	IF reply.good THEN
		BEGIN
		new(startParamS);
		startParamS.suivant := NIL;
		nPar := 0;
		SetCursor(MG_ClockCursor);
		MFic := GetPathName(reply.FName, reply.VRefNum);
		FFic := DeleteTrailing(reply.FName);				{mise en mmoire pour enregistrement ventuel}
		open(MyFl, MFic);
		reset(MyFl);
		IF EOF(MyFl) THEN aFonc := 'EOF'
		ELSE
			BEGIN
			readln(MyFl, aString);
			aString := DeleteBlancs(aString);
			ll := pos('=', aString);
			IF (ll > 0) THEN
				BEGIN
				bString := copy(aString, 1, ll-1);
				IF (bString <> '') THEN yN := bString;
				Delete(aString, 1, ll);
				END;
			aFonc := aString;
			lastParamS := startParamS;
			WHILE (NOT EOF(MyFl) AND (nPar < MG_MPar)) DO
				BEGIN
				bString := DeleteBlancs(LireNombre);
				IF ((length(bString) > 0) & (bString[1] = '!')) THEN
					BEGIN
					delete(bString, 1, 1);								{variable !...}
					IF (length(bString) > 0) THEN xN := bString;
					readln(MyFl);
					CYCLE;
					END;
				new(unParam);
				IF ((length(bString) = 0) | (bString[1] < 'A') | (bString[1] > 'z') |
														((bString[1] > 'Z') & (bString[1] < 'a'))) THEN
					BEGIN
					unParam.a := StringToReal(bString);			{paramtre sans nom enregistr...}
					NumToString(nPar+1, bString);
					unParam.aN := concat('a', bString);				{...on impose un nom !}
					END
				ELSE
					BEGIN
					unParam.aN := bString;								{paramtre avec nom enregistr...}
					unParam.a := StringToReal(LireNombre);		{...la valeur numrique suit !}
					END;
				unParam.w := StringToReal(LireNombre);
				unParam.suivant := NIL;
				lastParamS.suivant := unParam;			{on accroche  la suite}
				lastParamS := lastParamS.suivant;		{on note la nouvelle teminaison}
				nPar := nPar + 1;
				readln(MyFl);
				END;	{WHILE}
			END;
		SetCreaType(reply.FName, reply.VRefNum, 'TEXT', 'MG01');	{on force le type et le crateur}
		close(MyFl);
		InitCursor;
		END;	{IF reply.good}
	theParamS := startParamS;
	LireFonc := reply.good;

END; {***** LireFonc *****11111111111111111111111111111111111111111111111111111111111}
		
FUNCTION SaveFonc; {111111111111111111111111111111111111111111111111111111111111111111}

VAR
	where : point;
	aString, bString : STR255;
	reply : SFReply;
	MyFl : text;					{formule et paramtres en type texte}
	MFic : STR255;
	MyDataLength : integer;
	MyTab : char;
	unParam : TParam;
	t1Ext, t2Ext : extended;

BEGIN
	where.v := 180;
	where.h := 95;
	GetIndString(bString, MG_IOStrID, 2);
	SFPutFile(where, bString, concat(FFic, '.F'), nil, reply);
	IF reply.good THEN
		BEGIN
		SetCursor(MG_ClockCursor);
		MFic := GetPathName(reply.FName, reply.VRefNum);
		open(MyFl, MFic);
		rewrite(MyFl);
		writeln(MyFl, yN, '=', aFonc);
		writeln(MyFl, '!', xN);
		MyTab := chr(9);
		unParam := theParamS.suivant;
		WHILE (unParam <> NIL) DO
			BEGIN
			aString := unParam.aN;
			t1Ext := unParam.a;
			t2Ext := unParam.w;
			writeln(MyFl, aString, MyTab, RealToString(t1Ext, 9), MyTab, RealToString(t2Ext, 9));
			unParam := unParam.suivant;
			END;
		SetCreaType(reply.FName, reply.VRefNum, 'TEXT', 'MG01');	{on force le type et le crateur}
		close(MyFl);
		MG_PbFic := DeleteTrailing(reply.FName);
		InitCursor;
		END;
	SaveFonc := reply.good;

END; {***** SaveFonc *****11111111111111111111111111111111111111111111111111111111111}
		
FUNCTION ListeParams; {1111111111111111111111111111111111111111111111111111111111111111}

CONST
	TheTextItem = 3;			{faire correspondre FermeTexte, ListeFilter, ListeValeurs, ListeParams}
	TheListItem = 4;
	HautLigne = 15;			{diffrent de MG_HautLigne pour forcer le cadrage}
	NCol = 3;

VAR
	n, nn, long : integer;
	RView, DataBounds : rect;
	CSize : point;
	MyString : STR255;
	TempPort : GrafPtr;
	MyListDialog : DialogPtr;
	MyItemHdl : Handle;
	ItemType, ItemHit, OpenHit : integer;
	ItemBox, ListBox : rect;
	nNLign, aRow : integer;
	unParam : TParam;
	tempExt : extended;

PROCEDURE PutNames(RView : rect); {222222222222222222222222222222222222222222222222222222}

VAR
	r : rect;
	n : integer;

BEGIN
	FOR n := 1 TO NCol DO
		BEGIN
		SetRect(r, RView.left+(n-1)*CSize.h, RView.top-26, RView.left+n*CSize.h, RView.top-8);
		FrameRoundRect(r, 10, 10);
		PutMessage(titres[n-1], r);
		END;

END; {***** PutNames *****2222222222222222222222222222222222222222222222222222222222}

FUNCTION ControlParam : boolean; {22222222222222222222222222222222222222222222222222222222}

VAR
	nn : integer;
	nNLign : integer;
	startParamS, lastParamS : TParamS;		{local pour vrifier...}
	unParam : TParam;

PROCEDURE AlerteParam; {33333333333333333333333333333333333333333333333333333333333333}

VAR
	confirmation : integer;

BEGIN
	ParamText(MyString, '', '', '');
	confirmation := StopAlert(MG_BadNameStopID, nil);
	startParamS.free;
	PutNames(ListBox);										{les titres des colonnes}
	EXIT (ControlParam);

END; {***** AlerteParam *****33333333333333333333333333333333333333333333333333333333}

BEGIN
	ControlParam := true;									{prsum coupable... (c'est ignoble !)}
	nNLign := MG_MyListHdl^^.dataBounds.bottom;
	IF (nNLign > MG_MPar) THEN						{nombre maximum de paramtres}
		BEGIN
		MG_MyCell.v := MG_MPar;
		LDelRow(nNLign - MG_MPar, MG_MyCell.v, MG_MyListHdl);
		nNLign := MG_MPar;
		sysbeep(1);
		PutNames(ListBox);										{les titres des colonnes}
		EXIT (ControlParam);
		END;
	new(startParamS);
	startParamS.suivant := NIL;
	lastParamS := startParamS;
	FOR nn := 1 TO nNLign DO
		BEGIN
		MG_MyCell.v := nn - 1;
		MG_MyCell.h := 0;
		long := 255;			{on transfre par une STR255 : aucun nom ne peut dpasser}
		LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
		MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
		IF ((MyString = 'E') OR (MyString = 'e')) THEN AlerteParam								{exposant}
		ELSE IF (MyString = MG_xN) THEN AlerteParam											{variable}
		ELSE IF (MyString = MG_yN) THEN AlerteParam											{fonction}
		ELSE
			BEGIN
			unParam := startParamS.suivant;
			WHILE (unParam <> NIL) DO
				BEGIN
				IF (MyString = unParam.aN) THEN AlerteParam;		{dja pris}
				unParam := unParam.suivant;
				END;
			END;
		new(unParam);
		unParam.aN := MyString;
		unParam.suivant := NIL;
		lastParamS.suivant := unParam;
		lastParamS := lastParamS.suivant;
		END;
	startParamS.free;
	ControlParam := false;									{OK, c'est vrifi}

END; {***** ControlParam *****222222222222222222222222222222222222222222222222222}
						
BEGIN
	GetPort(TempPort);
	MyListDialog := GetNewDialog(MG_MyListPDlgID, nil, POINTER(-1));
	SetPort(MyListDialog);

	GetDItem(MyListDialog, TheTextItem, ItemType, MyItemHdl, ItemBox);
	GetIText(MyItemHdl, MG_TheTexte);
	SetIText(MyItemHdl, MG_TheTexte);		{salet ! quelle bidouille pour initialiser correctement...}
	
	GetDItem(MyListDialog, TheListItem, ItemType, MyItemHdl, ListBox);	{liste et scroll barre}
	ListBox.right := ListBox.right - 15;				{place pour scroll}
	FrameRect(ListBox);										{pas ncessaire mais initialisation plus jolie}
	InsetRect(ListBox, 1, 1);								{intrieur}
	SetRect(DataBounds, 0, 0, NCol, 0);
	CSize.h := (ListBox.right - ListBox.left) div NCol;	{s'il te plait, dessine moi la taille d'une cellule...}
	CSize.v := HautLigne;										{...sinon le calcul automatique est parfois trs curieux}
	PutNames(ListBox);										{les titres des colonnes}
	MG_MyListHdl := LNew(ListBox,		{limites en pixels}
							DataBounds,					{limites en cells}
							CSize,							{taille de cellule par dfaut}
							0,									{liste standard}
							MyListDialog,				{dans ma fentre}
							true,							{visible}
							false,							{no grow}
							false,							{no hScroll}
							true);							{vScroll}
	MG_MyListHdl^^.selFlags := lOnlyOne;			{slection limite}
	MG_InEdit := false;		{il n'y a pas de cell ouverte (a commence  zro et il n'y en a pas encore)}
	unParam := theParamS.suivant;
	IF (unParam = NIL) THEN
		BEGIN
		MG_MyCell.h := 0;
		MG_MyCell.v := 0;		{pas un point ? on initialise MG_MyCell pour insertion ventuelle...}
		GetDItem(MyListDialog, OK, ItemType, MyItemHdl, ItemBox);
		HiliteControl(ControlHandle(MyItemHdl), CntlDisable);
		DoTheOK(MyListDialog, OK);
		END
	ELSE WHILE (unParam <> NIL) DO
		BEGIN						{on insre ici les points prpars en entre}
		MG_MyCell.v := MG_MyListHdl^^.dataBounds.bottom;
		aRow := LAddRow(1, MG_MyCell.v, MG_MyListHdl);
		MG_MyCell.h := 0;
		MyString := unParam.aN;
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		MG_MyCell.h := 1;
		tempExt := unParam.a;
		MyString := RealToString(tempExt, 9);
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		MG_MyCell.h := 2;
		tempExt := unParam.w;
		MyString := RealToString(tempExt, 9);
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		unParam := unParam.suivant;
		END;
		
	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	MG_filtre := false ;			{pour ne filter que les nombres}
	REPEAT
		ModalDialog(@ListeFilter, ItemHit);
		IF ((ItemHit = OK) & ControlParam) THEN ItemHit := 0;		{retour  la case dpart...}
	UNTIL ((ItemHit = OK) OR (ItemHit = cancel));		{les autres cas sont filtrs  la main}
	
	SetCursor(MG_ClockCursor);
	IF (ItemHit = OK) THEN
		BEGIN
		nNLign := MG_MyListHdl^^.dataBounds.bottom;
		theParamS.extension(nNLign);
		unParam := theParamS.suivant;
		FOR nn := 1 to nNLign DO
			BEGIN
			MG_MyCell.v := nn - 1;
			MG_MyCell.h := 0;
			long := 255;			{on transfre par une STR255 : aucun nom ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unParam.aN := MyString;
			MG_MyCell.h := 1;
			long := 255;			{on transfre par une STR255 : aucun nombre ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unParam.a := StringToReal(MyString);
			MG_MyCell.h := 2;
			long := 255;			{on transfre par une STR255 : aucun nombre ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unParam.w := StringToReal(MyString);
			unParam := unParam.suivant;
			END;
		END;
	LDispose(MG_MyListHdl);
	SetPort(TempPort);
	DisposDialog(MyListDialog);
	ListeParams := (ItemHit = OK);
	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	
END; {***** ListeParams *****11111111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpFonc; {1111111111111111111111111111111111111111111111111111111111111111}

CONST
	VarMenu = 264;
	ParMenu = 265;
	OperMenu = 266;
	FoncMenu = 267;
	
	TheVarM = 3;
	TheFoncM = 4;
	TheOperM = 5;
	TheParM = 6;
	OldFonc = 8;
	SauveFonc = 9;
	NewFonc = 10;
	TheCom = 11;
	TestFonc = 12;
	Comments = 13;
		
VAR
	TempPort : GrafPtr;
	FoncWPtr : DialogPtr;
	box : rect;
	TheItem, OptType : integer;
	SetFonc, RepListe : boolean;
	MyItemHdl : handle;
	MyVarMHdl, MyParMHdl, MyFoncMHdl, MyOperMHdl : MenuHandle;
	MyPopUpItem : longint;
	aString, formule, tempPbFic : STR255;
	titres : MG_PTitres;
	nOperS : TOperS;
	oParamS, nParamS, lParamS : TParamS;
	oxN, nxN, lxN : STR255;
	oyN, nyN, lyN : STR255;
	TexteHdl : TEHandle;
	TheDPeek : DialogPeek;

PROCEDURE UpDatePopUp; {22222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetDItem(FoncWPtr, TheVarM, OptType, MyItemHdl, box);
	FramePopUp(box);
	GetDItem(FoncWPtr, TheParM, OptType, MyItemHdl, box);
	FramePopUp(box);
	GetDItem(FoncWPtr, TheFoncM, OptType, MyItemHdl, box);
	FramePopUp(box);
	GetDItem(FoncWPtr, TheOperM, OptType, MyItemHdl, box);
	FramePopUp(box);

END; {***** UpDatePopUp *****22222222222222222222222222222222222222222222222222222222}

PROCEDURE GetVar; {2222222222222222222222222222222222222222222222222222222222222222222}

CONST
	TheVarItem = 4;

VAR
	MyString : STR255;
	TempPort : GrafPtr;
	MyVarDialog : DialogPtr;
	MyItemHdl : Handle;
	ItemType, ItemHit : integer;
	ItemBox : rect;

FUNCTION ControlVar : boolean; {3333333333333333333333333333333333333333333333333333333333}

VAR
	unParam : TParam;

PROCEDURE AlerteVar; {44444444444444444444444444444444444444444444444444444444444444444}

VAR
	confirmation : integer;

BEGIN
	ParamText(MyString, '', '', '');
	confirmation := StopAlert(MG_BadNameStopID, nil);
	EXIT (ControlVar);

END; {***** AlerteVar *****4444444444444444444444444444444444444444444444444444444444}

BEGIN
	ControlVar := true;									{prsum coupable... (c'est ignoble !)}

	GetDItem(MyVarDialog, TheVarItem, ItemType, MyItemHdl, ItemBox);
	GetIText(MyItemHdl, MyString);
	IF (MyString = '') THEN AlerteVar																	{incohrent}
	ELSE IF ((MyString = 'E') OR (MyString = 'e')) THEN AlerteVar						{exposant}
	ELSE IF (MyString = nyN) THEN AlerteVar														{fonction}
	ELSE
		BEGIN
		unParam := nParamS.suivant;
		WHILE (unParam <> NIL) DO
			BEGIN
			IF (MyString = unParam.aN) THEN AlerteVar;										{paramtres}
			unParam := unParam.suivant;
			END;
		END;

	ControlVar := false;									{OK, c'est vrifi}

END; {***** ControlVar *****333333333333333333333333333333333333333333333333333333333}
						
BEGIN
	GetPort(TempPort);
	MyVarDialog := GetNewDialog(MG_MyVarDlgID, nil, POINTER(-1));
	SetPort(MyVarDialog);
	
	GetDItem(MyVarDialog, TheVarItem, ItemType, MyItemHdl, ItemBox);
	SetIText(MyItemHdl, nxN);
	SelIText(MyVarDialog, TheVarItem, 0, 32767);

	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	REPEAT
		ModalDialog(@FilterForDialog, ItemHit);
		IF ((ItemHit = OK) & ControlVar) THEN ItemHit := 0;		{retour  la case dpart...}
	UNTIL ((ItemHit = OK) OR (ItemHit = cancel));		{les autres cas sont filtrs  la main}
	
	SetCursor(MG_ClockCursor);
	IF (ItemHit = OK) THEN
		BEGIN
		GetDItem(MyVarDialog, TheVarItem, ItemType, MyItemHdl, ItemBox);
		GetIText(MyItemHdl, MyString);
		nxN := MyString;
		END;
	SetPort(TempPort);
	DisposDialog(MyVarDialog);
	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	UpDatePopUp;
	
END; {***** GetVar *****222222222222222222222222222222222222222222222222222222222222}

PROCEDURE GetFonc; {222222222222222222222222222222222222222222222222222222222222222222}

CONST
	TheFoncItem = 4;

VAR
	MyString : STR255;
	TempPort : GrafPtr;
	MyFoncDialog : DialogPtr;
	MyItemHdl : Handle;
	ItemType, ItemHit : integer;
	ItemBox : rect;

FUNCTION ControlFonc : boolean; {333333333333333333333333333333333333333333333333333333333}

VAR
	unParam : TParam;

PROCEDURE AlerteFonc; {4444444444444444444444444444444444444444444444444444444444444444}

VAR
	confirmation : integer;

BEGIN
	ParamText(MyString, '', '', '');
	confirmation := StopAlert(MG_BadNameStopID, nil);
	EXIT (ControlFonc);

END; {***** AlerteFonc *****4444444444444444444444444444444444444444444444444444444444}

BEGIN
	ControlFonc := true;									{prsum coupable... (c'est ignoble !)}

	GetDItem(MyFoncDialog, TheFoncItem, ItemType, MyItemHdl, ItemBox);
	GetIText(MyItemHdl, MyString);
	IF (MyString = '') THEN AlerteFonc																{incohrent}
	ELSE IF ((MyString = 'E') OR (MyString = 'e')) THEN AlerteFonc						{exposant}
	ELSE IF (MyString = nxN) THEN AlerteFonc													{variable}
	ELSE
		BEGIN
		unParam := nParamS.suivant;
		WHILE (unParam <> NIL) DO
			BEGIN
			IF (MyString = unParam.aN) THEN AlerteFonc;										{paramtres}
			unParam := unParam.suivant;
			END;
		END;

	ControlFonc := false;									{OK, c'est vrifi}

END; {***** ControlFonc *****333333333333333333333333333333333333333333333333333333333}
						
BEGIN
	GetPort(TempPort);
	MyFoncDialog := GetNewDialog(MG_MyFoncDlgID, nil, POINTER(-1));
	SetPort(MyFoncDialog);
	
	GetDItem(MyFoncDialog, TheFoncItem, ItemType, MyItemHdl, ItemBox);
	SetIText(MyItemHdl, nyN);
	SelIText(MyFoncDialog, TheFoncItem, 0, 32767);

	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	REPEAT
		ModalDialog(@FilterForDialog, ItemHit);
		IF ((ItemHit = OK) & ControlFonc) THEN ItemHit := 0;		{retour  la case dpart...}
	UNTIL ((ItemHit = OK) OR (ItemHit = cancel));		{les autres cas sont filtrs  la main}
	
	SetCursor(MG_ClockCursor);
	IF (ItemHit = OK) THEN
		BEGIN
		GetDItem(MyFoncDialog, TheFoncItem, ItemType, MyItemHdl, ItemBox);
		GetIText(MyItemHdl, MyString);
		nyN := MyString;
		END;
	SetPort(TempPort);
	DisposDialog(MyFoncDialog);
	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	UpDatePopUp;

END; {***** GetFonc *****222222222222222222222222222222222222222222222222222222222222}

PROCEDURE GetParam; {22222222222222222222222222222222222222222222222222222222222222222}

VAR
	k : integer;

BEGIN
	oxN := MG_xN;		{GetParam appelle ListParam qui ne connait que le global}
	MG_xN := nxN;
	oyN := MG_yN;
	MG_yN := nyN;

	FOR k := 0 to 2 DO
		BEGIN
		GetIndString(aString, MG_IOStrID, 7+k);
		titres[k] := aString;
		END;
	RepListe := ListeParams(titres, nParamS);

	MG_xN := oxN;				{puis on restaure !}
	MG_yN := oyN;

END; {***** GetParam *****2222222222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthParam; {2222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetParam;
	theParamS.free;
	theParamS := nParamS;
	xN := nxN;
	yN := nyN;

END; {***** DealWthParam *****2222222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthModel; {22222222222222222222222222222222222222222222222222222222222222}

VAR
	k, confirmation : integer;
	unParam : TParam;

BEGIN
	GetPort(TempPort);
	tempPbFic := MG_PbFic;
	FoncWPtr := GetNewDialog(MG_SetUpFoncDlgID, nil, POINTER(-1));
	SetPort(FoncWPtr);
	MG_FoncWPtr := FoncWPtr;		{pour transmettre les commentaires de l'interprteur}
	MG_Comments := Comments;
	
	UpDatePopUp;

	nOperS := TOperS(MG_theOperS.clone);
	formule := nOperS.FormulOper;
	GetDItem(FoncWPtr, NewFonc, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, formule);
	
	SetFonc := false;
	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	REPEAT
		ModalDialog(@FilterForDialog, TheItem);
		CASE TheItem OF
			OK :	BEGIN		{on commence par tester...}
					GetDItem(FoncWPtr, NewFonc, OptType, MyItemHdl, box);
					GetIText(MyItemHdl, formule);
					GetDItem(FoncWPtr, Comments, OptType, MyItemHdl, box);
					SetIText(MyItemHdl, '');
					IF (nOperS.suivant1 <> NIL) THEN nOperS.suivant1.free;
					oParamS := MG_theParamS;		{BinOper appelle OperVar qui ne connait que le global}
					MG_theParamS := nParamS;
					oxN := MG_xN;
					MG_xN := nxN;
					nOperS.suivant1 := BinOper(1, DeleteBlancs(formule));	
					MG_theParamS := oParamS;				{puis on restaure !}
					MG_xN := oxN;
					IF (nOperS.suivant1 <> NIL) THEN
						BEGIN
						IF (MG_theOperS.suivant1 <> NIL) THEN MG_theOperS.suivant1.free;
						MG_theOperS.suivant1 := nOperS.suivant1;
						nOperS.suivant1 := NIL;						{il est accroch ailleurs, on le dcroche d'ici...}
						theParamS.free;
						theParamS := nParamS;
						xN := nxN;
						yN := nyN;
						SetFonc := true;		{test concluant}
						IF MG_DoneModif THEN
							BEGIN
							confirmation := CautionAlert(MG_QuitSansSaveAlrtID, nil);
							CASE confirmation OF
								1 : MG_DoneModif := false;			{on quitte}
								2 :	BEGIN										{on enregistre}
										formule := MG_theOperS.FormulOper;
										IF SaveFonc(tempPbFic, formule, xN, yN, theParamS) THEN
												MG_DoneModif := false
										ELSE SetFonc := false;
										END;
								3 : SetFonc := false;							{sortie annule}
								END;
							END;
						END;
					END;
			cancel :	BEGIN
							IF (nParamS <> NIL) THEN nParamS.free;
							END;
			TheVarM :	BEGIN
								MyVarMHdl := GetMenu(VarMenu);
								AppendMenu(MyVarMHdl, nxN);
								InsertMenu(MyVarMHdl, -1);
								GetDItem(FoncWPtr, TheVarM, OptType, MyItemHdl, box);
								LocalToGlobal(box.TopLeft);
								MyPopUpItem := PopUpMenuSelect(MyVarMHdl, box.top+1, box.left+1, 1);
								IF (MyPopUpItem <> 0) THEN
									BEGIN
									IF (LoWord(MyPopUpItem) = 1) THEN GetVar
									ELSE
										BEGIN
										aString := nxN;
										TheDPeek := pointer(FoncWPtr);
										TexteHdl := TheDPeek^.textH;
										TEDelete(TexteHdl);			{on fait le vide avant d'insrer  la place}
										TEInsert(pointer(ord(@aString)+1), length(aString), TexteHdl);
										MG_DoneModif := true;
										END;
									END;
								DeleteMenu(VarMenu);
								ReleaseResource(handle(MyVarMHdl));
								END;
			TheFoncM :	BEGIN
								MyFoncMHdl := GetMenu(FoncMenu);
								AppendMenu(MyFoncMHdl, nyN);
								InsertMenu(MyFoncMHdl, -1);
								GetDItem(FoncWPtr, TheFoncM, OptType, MyItemHdl, box);
								LocalToGlobal(box.TopLeft);
								MyPopUpItem := PopUpMenuSelect(MyFoncMHdl, box.top+1, box.left+1, 1);
								IF (MyPopUpItem <> 0) THEN
									BEGIN
									IF (LoWord(MyPopUpItem) = 1) THEN GetFonc;
									END;
								DeleteMenu(FoncMenu);
								ReleaseResource(handle(MyFoncMHdl));
								END;
			TheParM :	BEGIN
								MyParMHdl := GetMenu(ParMenu);
								unParam := nParamS.suivant;
								WHILE (unParam <> NIL) DO
									BEGIN
									aString := unParam.aN;
									AppendMenu(MyParMHdl, aString);
									unParam := unParam.suivant;
									END;
								InsertMenu(MyParMHdl, -1);
								GetDItem(FoncWPtr, TheParM, OptType, MyItemHdl, box);
								LocalToGlobal(box.TopLeft);
								MyPopUpItem := PopUpMenuSelect(MyParMHdl, box.top+1, box.left+1, 1);
								IF (MyPopUpItem <> 0) THEN
									BEGIN
									IF (LoWord(MyPopUpItem) = 1) THEN
										BEGIN
										GetParam;
										UpDatePopUp;
										END
									ELSE
										BEGIN
										unParam := nParamS.suivant;
										FOR k := 1 TO (LoWord(MyPopUpItem)-2) DO unParam := unParam.suivant;
										aString := unParam.aN;
										TheDPeek := pointer(FoncWPtr);
										TexteHdl := TheDPeek^.textH;
										TEDelete(TexteHdl);			{on fait le vide avant d'insrer  la place}
										TEInsert(pointer(ord(@aString)+1), length(aString), TexteHdl);
										MG_DoneModif := true;
										END;
									END;
								DeleteMenu(ParMenu);
								ReleaseResource(handle(MyParMHdl));
								END;
			TheOperM :	BEGIN
								MyOperMHdl := GetMenu(OperMenu);
								InsertMenu(MyOperMHdl, -1);
								GetDItem(FoncWPtr, TheOperM, OptType, MyItemHdl, box);
								LocalToGlobal(box.TopLeft);
								MyPopUpItem := PopUpMenuSelect(MyOperMHdl, box.top+1, box.left+1, 1);
								IF (MyPopUpItem <> 0) THEN IF (LoWord(MyPopUpItem) > 1) THEN
									BEGIN
									GetIndString(aString, MG_FoncStrID, LoWord(MyPopUpItem)-1);
									TheDPeek := pointer(FoncWPtr);
									TexteHdl := TheDPeek^.textH;
									TEDelete(TexteHdl);			{on fait le vide avant d'insrer  la place}
									TEInsert(pointer(ord(@aString)+1), length(aString), TexteHdl);
									MG_DoneModif := true;
									END;
								DeleteMenu(OperMenu);
								ReleaseResource(handle(MyOperMHdl));
								END;
			OldFonc :	BEGIN
							lParamS := NIL;	{LireFonc purge si  NIL en entre et transmet NIL si false}
							IF LireFonc(tempPbFic, aString, lxN, lyN, lParamS) THEN
								BEGIN
								formule := aString;
								nParamS.free;
								nParamS := lParamS;
								nxN := lxN;
								nyN := lyN;
								GetDItem(FoncWPtr, NewFonc, OptType, MyItemHdl, box);
								SetIText(MyItemHdl, formule);
								MG_PbFic := tempPbFic;
								MG_DoneModif := false;
								END;
							END;
			SauveFonc :	BEGIN
								GetDItem(FoncWPtr, NewFonc, OptType, MyItemHdl, box);
								GetIText(MyItemHdl, formule);
								IF SaveFonc(tempPbFic, formule, nxN, nyN, nParamS) THEN
									BEGIN
									MG_DoneModif := false;
									tempPbFic := MG_PbFic;
									END;
								END;
			TestFonc :	BEGIN
								GetDItem(FoncWPtr, NewFonc, OptType, MyItemHdl, box);
								GetIText(MyItemHdl, formule);
								GetDItem(FoncWPtr, Comments, OptType, MyItemHdl, box);
								SetIText(MyItemHdl, '');
								IF (nOperS.suivant1 <> NIL) THEN nOperS.suivant1.free;
								oParamS := MG_theParamS;		{BinOper appelle OperVar qui ne connait que le global}
								MG_theParamS := nParams;
								oxN := MG_xN;
								MG_xN := nxN;
								nOperS.suivant1 := BinOper(1, DeleteBlancs(formule));
								MG_theParamS := oParamS;				{puis on restaure !}
								MG_xN := oxN;
								IF (nOperS.suivant1 <> NIL) THEN
									BEGIN
									GetDItem(FoncWPtr, Comments, OptType, MyItemHdl, box);
									SelIText(FoncWPtr, Comments, 0, 0);				{sinon les '^' taient mal affichs}
									SetIText(MyItemHdl, nOperS.FormulOper);
									END;
								SelIText(FoncWPtr, NewFonc, 32767, 32767); 	{remise du curseur en place}
								END;
			NewFonc : 	MG_DoneModif := true;
			END;
	UNTIL (SetFonc AND NOT MG_DoneModif) OR (TheItem = cancel);
	
	IF (nOperS <> NIL) THEN nOperS.free;
	DisposDialog(FoncWPtr);
	SetPort(TempPort);

END; {***** DealWthModel *****2222222222222222222222222222222222222222222222222222222}

BEGIN	
	nParamS := TParamS(theParamS.clone);
	nxN := xN;
	nyN := yN;
	IF AsSet THEN DealWthParam ELSE DealWthModel;

END; {***** SetUpFonc *****1111111111111111111111111111111111111111111111111111111111}

END.