UNIT MG_graph;

INTERFACE

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf, PackIntf, MacPrint, SANE, ObjIntf,
	USLib_U1,
	MG_util, MG_points, MG_fonction, MG_minim;

CONST
	MG_SetUpGraphWindID = 1002;
	MG_SetUpGraphFormatDlgID = 1002;
	MG_SetUpGraphRectID = 1002;
	MG_SetUpGraphiqueDlgID = 1003;
	MG_PolGraphStrID = 1003;
	MG_SetUpPolGrDlgID = 1012;
	
	MG_SetUpGrCrID = 270;
	
	MG_SauvePictStopID = 1100;
	MG_InfSupStopID = 1105;

TYPE
	MG_FmPoints = (rond, carre, triup, tridown);
	MG_CrPoints = (noir, blanc, rouge, vert, bleu, cyan, magenta, jaune);
	MG_SbPoints = RECORD
		forme : MG_FmPoints;
		couleur : MG_CrPoints;
		END;
	MG_GP = RECORD
		FirstUse : boolean;
		xinf, xsup, yinf, ysup : extended;
		ScaleX, ScaleY, ErreurX, ErreurY, ScaleDX, ScaleDY : boolean;
		symbole : MG_SbPoints;
		LogX, LogY, ZeroX, ZeroY, DrawTh, ScaleThX, ScaleThY : boolean;
		Polar : boolean;
		ainf, asup : extended;
		ScaleA : boolean;
		END;

	TGraphSymb = OBJECT(TObject)
		SymbRect : rect;
		PROCEDURE draw(x, y : integer);
		END;
	TGraphRond = OBJECT(TGraphSymb)
		PROCEDURE draw(x, y : integer); OVERRIDE;
		END;
	TGraphCarre = OBJECT(TGraphSymb)
		PROCEDURE draw(x, y : integer); OVERRIDE;
		END;
	TGraphTriHaut = OBJECT(TGraphSymb)
		PROCEDURE draw(x, y : integer); OVERRIDE;
		END;
	TGraphTriBas = OBJECT(TGraphSymb)
		PROCEDURE draw(x, y : integer); OVERRIDE;
		END;

VAR
	MG_GParam : MG_GP;

PROCEDURE PrintPict(PictureH : PicHandle; PictRect : rect);
FUNCTION SauvePict(PictureH : PicHandle) : boolean;
PROCEDURE graphique (thePointS : TPointS; theParamS : TParamS;
        						xinf, xsup, yinf, ysup : extended;
        						ScaleX, ScaleY, ErreurX, ErreurY, ScaleDX, ScaleDY : boolean;
        						symbole : MG_SbPoints;
        						LogX, LogY, ZeroX, ZeroY, DrawTh, ScaleThY : boolean;
								FUNCTION fonc (theParamS : TParamS; xx : extended) : extended);
PROCEDURE RangerGraphWindow;
PROCEDURE SetUpGraphiques (AsSet : boolean; thePointS : TPointS; theParamS : TParamS;
											FUNCTION fonc (theParamS : TParamS; xx : extended) : extended);
PROCEDURE InitGraphique;
PROCEDURE SetUpGraphFormat;

IMPLEMENTATION

{$S MG_graph }

CONST
	g_XLeft = 65;						{chelle verticale plus marge}
	g_YUp = 10;							{marge}
	g_XLongMin = 120;
	g_YLongMin = 120;
	g_XLongStand = 410;			{65+410+10+20 = 505  512 = largeur de l'cran 9"}
	g_YLongStand = 235;			{20+20+10+235+20+10+20 = 335  342 = hauteur de l'cran 9"}
	g_XLongMaxV = 469;			{pour A4 vertical}
	g_YLongMaxV = 760;			{pour A4 vertical}
	g_XLongMaxH = 725;			{pour A4 horizontal}
	g_YLongMaxH = 504;			{pour A4 horizontal}

VAR
	g_XLong, g_YLong, g_XRight, g_YDown : integer;

PROCEDURE TGraphSymb.draw; {11111111111111111111111111111111111111111111111111111111111}

VAR
	unRect : rect;

BEGIN
	SetRect(unRect, x-2, y-2, x+3, y+3);
	SymbRect := unRect;

END; {***** TGraphSymb.draw *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TGraphRond.draw; {111111111111111111111111111111111111111111111111111111111111}

VAR
	unRect : rect;

BEGIN
	INHERITED draw(x, y);
	unRect := SymbRect;
	FillOval(unRect, white);
	FrameOval(unRect);

END; {***** TGraphRond.draw *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TGraphCarre.draw; {11111111111111111111111111111111111111111111111111111111111}

VAR
	unRect : rect;

BEGIN
	INHERITED draw(x, y);
	unRect := SymbRect;
	FillRect(unRect, white);
	FrameRect(unRect);

END; {***** TGraphCarre.draw *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TGraphTriHaut.draw; {1111111111111111111111111111111111111111111111111111111111}

VAR
	unRect : rect;
	sPolyH : PolyHandle;

BEGIN
	INHERITED draw(x, y);
	unRect := SymbRect;
	sPolyH := OpenPoly;
	MoveTo(unRect.left+2, unRect.top-2);
	LineTo(unRect.right, unRect.bottom-2);
	LineTo(unRect.left-1, unRect.bottom-2);
	LineTo(unRect.left+2, unRect.top-2);
	ClosePoly;
	FillPoly(sPolyH, white);
	FramePoly(sPolyH);
	KillPoly(sPolyH);

END; {***** TGraphTriHaut.draw *****111111111111111111111111111111111111111111111111111}

PROCEDURE TGraphTriBas.draw; {1111111111111111111111111111111111111111111111111111111111}

VAR
	unRect : rect;
	sPolyH : PolyHandle;

BEGIN
	INHERITED draw(x, y);
	unRect := SymbRect;
	sPolyH := OpenPoly;
	MoveTo(unRect.left-1, unRect.top+1);
	LineTo(unRect.right, unRect.top+1);
	LineTo(unRect.left+2, unRect.bottom+1);
	LineTo(unRect.left-1, unRect.top+1);
	ClosePoly;
	FillPoly(sPolyH, white);
	FramePoly(sPolyH);
	KillPoly(sPolyH);

END; {***** TGraphTriBas.draw *****1111111111111111111111111111111111111111111111111111}

FUNCTION getSymb(forme : MG_FmPoints) : TGraphSymb; {111111111111111111111111111111111111111}

VAR
	unRond : TGraphRond;
	unCarre : TGraphCarre;
	unTriHaut : TGraphTriHaut;
	unTriBas : TGraphTriBas;

BEGIN
	CASE forme OF
		rond : 	BEGIN
					new(unRond);
					getSymb := unRond;
					END;
		carre :	BEGIN
					new(unCarre);
					getSymb := unCarre;
					END;
		triup :	BEGIN
					new(unTriHaut);
					getSymb := unTriHaut;
					END;
		tridown :	BEGIN
						new(unTriBas);
						getSymb := unTriBas;
						END;
		OTHERWISE getSymb := NIL;				{en principe impossible...}
		END;

END; {***** getSymb *****111111111111111111111111111111111111111111111111111111111111}

FUNCTION codeCouleur(theCouleur : MG_CrPoints) : integer; {1111111111111111111111111111111111111}

BEGIN
	CASE theCouleur OF
		noir : codeCouleur := blackColor;
		blanc : codeCouleur := whiteColor;
		rouge : codeCouleur := redColor;
		vert : codeCouleur := greenColor;
		bleu : codeCouleur := blueColor;
		cyan : codeCouleur := cyanColor;
		magenta : codeCouleur := magentaColor;
		jaune : codeCouleur := yellowColor;
		END;

END; {***** codeCouleur *****111111111111111111111111111111111111111111111111111111111}

PROCEDURE drawXBarre(x, y, db : integer); {1111111111111111111111111111111111111111111111111}

VAR
	ax : integer;

BEGIN
	IF (db > 0) THEN
		BEGIN
		ax := x - db;
		IF (ax < g_XRight) THEN
			BEGIN
			IF (ax >= g_XLeft) THEN
				BEGIN
				MoveTo(ax, y + 1);
				LineTo(ax, y - 1);
				MoveTo(ax, y);
				END
			ELSE MoveTo(g_XLeft, y);		{on clippe comme on peut !}
			ax := x + db;
			IF (ax >= g_XLeft) THEN
				BEGIN
				IF (ax < g_XRight) THEN
					BEGIN
					LineTo(ax, y);
					MoveTo(ax, y + 1);
					LineTo(ax, y - 1);
					END
				ELSE LineTo(g_XRight - 1, y);		{on clippe comme on peut !}
				END;
			END;
		END;

END; {***** drawXBarre *****111111111111111111111111111111111111111111111111111111111}

PROCEDURE drawYBarre(x, y, db : integer); {1111111111111111111111111111111111111111111111111}

VAR
	ay : integer;

BEGIN
	IF (db > 0) THEN
		BEGIN
		ay := y + db;
		IF (ay >= g_YUp) THEN
			BEGIN
			IF (ay < g_YDown) THEN
				BEGIN
				MoveTo(x - 1, ay);
				LineTo(x + 1, ay);
				MoveTo(x, ay);
				END
			ELSE MoveTo(x, g_YDown - 1);		{on clippe comme on peut !}
			ay := y - db;
			IF (ay < g_YDown) THEN
				BEGIN
				IF (ay >= g_YUp) THEN
					BEGIN
					LineTo(x, ay);
					MoveTo(x - 1, ay);
					LineTo(x + 1, ay);
					END
				ELSE LineTo(x, g_YUp);		{on clippe comme on peut !}
				END;
			END;
		END;

END; {***** drawYBarre *****111111111111111111111111111111111111111111111111111111111}

PROCEDURE PrintPict(PictureH : PicHandle; PictRect : rect); {1111111111111111111111111111111111111}

CONST
	theTPRID = 128;

VAR
	PrRecHdl : THPrint;
	aPrRecHdl : handle;
	PrValide : boolean;
	MyPrPort : TPPrPort;
	TempPort : GrafPtr;
	MyStatusRec : TPrStatus;
	
BEGIN
	PrOpen;
	PrRecHdl := THPrint(NewHandle(SizeOf(TPrint)));		{type coercion}
	PrValide := PrStlDialog(PrRecHdl);								{on ajuste le style}
	IF PrValide THEN
		BEGIN
		PrValide := PrJobDialog(PrRecHdl);							{on prcise les ordres}
		IF PrValide THEN
			BEGIN
			GetPort(TempPort);
			MyPrPort := PrOpenDoc(PrRecHdl, NIL, NIL);				{print GrafPort}
			IF (PrError = NoErr) THEN			{il n'y a qu'une page...}
				BEGIN												{...et le printing manager gre le nombre de copies}
				PrOpenPage(MyPrPort, NIL);
				IF (PrError = NoErr) THEN DrawPicture(PictureH, PictRect);
				PrClosePage(MyPrPort);
				END;
			PrCloseDoc(MyPrPort);
			IF ((PrRecHdl^^.PrJob.BJDocLoop = BSpoolLoop) and (PrError = NoErr)) THEN
				BEGIN
				{MySwapOutProc;}					{pas utile si on a de la place}
				PrPicFile(PrRecHdl, NIL, NIL, NIL, MyStatusRec);
				END;
			{IF (PrError <> NoErr) THEN MyPrErrAlertProc;}
			SetPort(TempPort);					{pour rcuprer aprs impression}
			END;
		END;
	DisposHandle(handle(PrRecHdl));		{type coercion}
	PrClose;

END; {***** PrintPict *****11111111111111111111111111111111111111111111111111111111111}

FUNCTION SauvePict(PictureH : PicHandle) : boolean; {111111111111111111111111111111111111111111}

VAR
	DoneSave : boolean;
	where : point;
	reply : SFReply;
	TheOSErr, MyOSErr : OSErr;
	MyRefNum, MyVRefNum : integer;
	MyFileName, aString, bString, MFic : STR255;
	MySize : longint;
	TheItem, p : integer;
	MyCrHdl : StringHandle;
	MyCreateur : OSType;

BEGIN
	DoneSave := false;
	REPEAT
		TheOSErr := noErr;
		where.v := 200;
		where.h := 95;
		MFic := concat(MG_PbFic, '.G');
		GetIndString(aString, MG_IOStrID, 2);
		SFPutFile(where, aString, MFic, nil, reply);
		IF reply.good THEN
			BEGIN
			MyFileName := reply.FName;
			MyVRefNum := reply.VRefNum;
			
			MyCrHdl := GetString(MG_SetUpGrCrID);
			aString := MyCrHdl^^;
			FOR p := 1 TO 4 DO MyCreateur[p] := aString[p];
			
			MyOSErr := create(MyFileName, MyVRefNum, MyCreateur, 'PICT');	{sans effet si duplicate}
			IF ((MyOSErr = noErr) or (MyOSErr = dupFNErr)) THEN
				BEGIN
				MyOSErr := FSOpen(MyFileName, MyVRefNum, MyRefNum);
				IF (MyOSErr = noErr) THEN
					BEGIN					
					MySize := 0; 				{nettoyage si duplicate}
					MyOSErr := SetEOF(MyRefNum, MySize);
					MySize := 513; 				{'MDRW' commence au 513e byte}
					MyOSErr := SetEOF(MyRefNum, MySize);
					IF (MyOSErr = noErr) THEN
						BEGIN
						MyOSErr := SetFPos(MyRefNum, FSFromStart, 512);
						HLock(Handle(PictureH));
						MySize := PictureH^^.picSize;
						MyOSErr := FSWrite(MyRefNum, MySize, Pointer(PictureH^));
						IF (MyOSErr = noErr) THEN DoneSave := true
						ELSE TheOSErr := MyOSErr;			{pas de place disponible}
						HUnlock(Handle(PictureH));
						MyOSErr := FSClose(MyRefNum);
						END
					ELSE TheOSErr := MyOSErr;			{pas de place disponible}
					MyOSErr := FSClose(MyRefNum);
					END
				ELSE TheOSErr := MyOSErr;			{ouverture impossible}
				END
			ELSE TheOSErr := MyOSErr;			{cration impossible}
			END
		ELSE DoneSave := true;
	IF (TheOSErr <> noErr) THEN
		BEGIN
		CASE TheOSErr OF
			vLckdErr, fLckdErr, wrPermErr, wPrErr : GetIndString(aString, MG_IOStrID, 3);
			dskFulErr : GetIndString(aString, MG_IOStrID, 4);
			OTHERWISE	BEGIN
							NumToString(TheOSErr, aString);
							GetIndString(bString, MG_IOStrID, 5);
							aString := concat(bString, aString);
							END;
			END;
		ParamText(aString, '', '', '');
		TheItem := StopAlert(MG_SauvePictStopID, nil);
		END;
	UNTIL DoneSave;
	SauvePict := (reply.good AND (TheOSErr = noErr));
	
END; {***** SauvePict *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE graphique; {111111111111111111111111111111111111111111111111111111111111111111}

CONST
	EchLong = 45;
	picGroupLP = 140;	{= $8C}
	picGroupRP = 141;	{= $8D}

VAR
	{pour affichage}
	TempPort : GrafPtr;
	DebLigne, TheItem, OptType, confirmation : integer;
	GraphWRect, box : rect;
	DoTrace : boolean;
	MyItemHdl : handle;
	aString : STR255;

	{pour courbe}
	PolyH : PolyHandle;
	xt, yt : array[0..g_XLongMaxH] of extended;
	j, k, npts : integer;
	x, y, dx, dy : extended;
	unPoint : TPoint;
	nPointS : TPointS;
	XPixel, YPixel, XnPixelGrad, YnPixelGrad : extended;
	unParam : TParam;
	NPar : integer;
	a : MG_ExPar;
	tTx, tTy : extended;

PROCEDURE SetUpGraphWindow; {22222222222222222222222222222222222222222222222222222222222}

TYPE
	WStateData = RECORD
		userState : rect;
		stdState : rect;
		END;
	WSDPtr = ^WStateData;
	WSDHdl = ^WSDPtr;

VAR
	MyScrollRect, ZoomRect : rect;
	RefVal : longint;	{bidon pour transfert ventuel}
	largeur, hauteur : integer;
	TheWPeek : WindowPeek;
	MyWSDHdl : WSDHdl;

BEGIN
	MG_DragArea := screenBits.bounds;
	MG_DragArea.top := MG_DragArea.top + 20;		{pour la barre de menu}
	InsetRect(MG_DragArea, 4, 4);						{zone o on peut dplacer la fentre, en coordonnes globales}

	largeur := MG_DragArea.right - MG_DragArea.left + 1;
	hauteur := MG_DragArea.bottom - MG_DragArea.top + 1;
	SetRect(MG_GrowRect, 150, 100, largeur, hauteur);	{tailles limites de la fentre, en coordonnes locales}

	GetPort(TempPort);
	MG_GraphWPtr := GetNewWinDow(MG_SetUpGraphWindID, NIL, POINTER(-1));
	GraphWRect := MG_GraphWPtr^.portRect;

	ZoomRect := MG_DragArea;
	ZoomRect.top := ZoomRect.top + 20;		{pour la barre de menu}
	TheWPeek := Pointer(MG_GraphWPtr);
	MyWSDHdl := WSDHdl(TheWPeek^.dataHandle);
	MyWSDHdl^^.stdState := ZoomRect;			{tat standard de la fentre}
	SetPort(MG_GraphWPtr);

	largeur := GraphWRect.right - GraphWRect.left + 1;
	hauteur := GraphWRect.bottom - GraphWRect.top + 1;
		
	SetRect(MyScrollRect, largeur-16, -1, largeur, hauteur-15);	{Scroll vertical}
	MG_GraphVScrollHdl := NewControl(MG_GraphWPtr, MyScrollRect, 'vsb', true,
															0, 0, 0,		{curseur, min, max  (max = 0  car entier au dpart)}
															scrollBarProc,
															RefVal);
	SetRect(MyScrollRect, -1, hauteur-16, largeur-15, hauteur);		{Scroll horizontal}
	MG_GraphHScrollHdl := NewControl(MG_GraphWPtr, MyScrollRect, 'hsb', true,
															0, 0, 0,		{curseur, min, max  (max = 0  car entier au dpart)}
															scrollBarProc,
															RefVal);
	MG_TheOrigine.h := 0;
	MG_TheOrigine.v := 0;
	
	g_XRight := g_XLeft + g_XLong;
	g_YDown := g_YUp + g_YLong;

	SetRect(MG_GraphPictRect, 0, 0,				{coordonnes locales, stock pour le cadrage du dessin}
											g_XRight + 10,					{marge}
											g_YDown + 20 + 10);		{chelle horizontale plus marge}
		
	SetUpFonts(geneva, 9);				{pour commentaire si graphique impossible}
	DebLigne := 10;
	MoveTo(DebLigne, g_YUp + MG_HautLigne);
	MG_PictureH := NIL;					{tant qu'on n'a pas cr de picture}

END;{***** SetUpGraphWindow *****22222222222222222222222222222222222222222222222222222}

PROCEDURE RangerGraphique; {2222222222222222222222222222222222222222222222222222222222222}

BEGIN
	IF DoTrace THEN
		BEGIN
		IF DrawTh THEN	KillPoly(PolyH);		{temporaire pour tracer la picture}
		END;
	SetPort(TempPort);

END; {***** RangerGraphique *****222222222222222222222222222222222222222222222222222222}

PROCEDURE WriteLigne(m : STR255); {2222222222222222222222222222222222222222222222222222222}

VAR
	p : point;

BEGIN
	DrawString(m);
	GetPen(p);
	MoveTo(DebLigne, p.v + MG_HautLigne);

END;{***** WriteLigne *****22222222222222222222222222222222222222222222222222222222222}

PROCEDURE TraceX; {22222222222222222222222222222222222222222222222222222222222222222222}

VAR
	i, confirmation : integer;

PROCEDURE AjusteEchelle (Long : integer; GradCoef : extended;
											var inf, sup, pixel, NPixelGrad : extended); {3333333333333333333333333333}

VAR
	Large, GradLarge, pas : extended;

BEGIN
	Large := sup - inf;
	GradLarge := Large * GradCoef;
	pas := ln(GradLarge)/ln(10);		{plus grande puissance de 10 infrieure  GradLarge}
	IF (pas >= 0) THEN pas := 10**trunc(pas) ELSE pas := 1/(10**trunc(1-pas));
	IF ((GradLarge/pas) > 5) THEN pas := 5 * pas
	ELSE IF ((GradLarge/pas) > 2) THEN pas := 2 * pas;
	NPixelGrad := pas * Long / Large;
	pixel := pas / NPixelGrad;

END; {***** AjusteEchelle ***** 33333333333333333333333333333333333333333333333333333333}

PROCEDURE TraceY; {3333333333333333333333333333333333333333333333333333333333333333333}

VAR
	k, mx, my, ndx, ndy : integer;
	SymbRect : rect;
	unSymbole : TGraphSymb;
	sDt, nsDt, tSegment, pSegment : boolean;
	nmx, nmy, tmx : integer;
	oldClip : RgnHandle;

PROCEDURE DrawAxes; {44444444444444444444444444444444444444444444444444444444444444444}

VAR
	ZeroAxe, Grad, Last, tExt : extended;
	aString, XTitle, YTitle : STR255;

BEGIN
	ZeroAxe := xinf / XPixel;
	Grad := ZeroAxe/XnPixelGrad;
	IF (Grad > 0) THEN Grad := Grad+1;		{arrondi au suprieur algbrique !}
	Grad := trunc(Grad)*XnPixelGrad - ZeroAxe;
	Last := 0;
	REPEAT
		MoveTo(round(g_XLeft + Grad), g_YDown);
		LineTo(round(g_XLeft + Grad), g_YDown + 2);
		MoveTo(round(g_XLeft + Grad), g_YUp);
		LineTo(round(g_XLeft + Grad), g_YUp - 2);
		IF (((g_XLeft + Grad - Last) > EchLong) & ((g_XLong - Grad) > EchLong)) THEN
			BEGIN
			tExt := (ZeroAxe + Grad) * XPixel;
			IF LogX THEN tExt := 10 ** tExt
			ELSE IF (abs(tExt) < XPixel) THEN tExt := 0;		{amlioration de l'affichage des petites valeurs}
			aString := RealToString(tExt, 4);
			MoveTo(round(g_XLeft + Grad) - (StringWidth(aString) DIV 2), g_YDown + 15);
			DrawString(aString);
			Last := g_XLeft + Grad;
			END;
		Grad := Grad + XnPixelGrad;
	UNTIL (Grad > g_XLong);
	IF MG_GParam.Polar THEN XTitle := concat(MG_yN, '.cos(', MG_xN, ')')
	ELSE XTitle := MG_xN;
	MoveTo(round(g_XRight) - StringWidth(XTitle), g_YDown + 15);
	DrawString(XTitle);
	
	ZeroAxe := yinf / YPixel;
	Grad := ZeroAxe/YnPixelGrad;
	IF (Grad > 0) THEN Grad := Grad+1;		{arrondi au suprieur algbrique !}
	Grad := trunc(Grad)*YnPixelGrad - ZeroAxe;
	REPEAT
		MoveTo(g_XLeft, round(g_YDown - Grad));
		LineTo(g_XLeft - 2, round(g_YDown - Grad));
		MoveTo(g_XRight, round(g_YDown - Grad));
		LineTo(g_XRight + 2, round(g_YDown - Grad));
		IF ((g_YLong - Grad) > (2*MG_HautLigne)) THEN
			BEGIN
			tExt := (ZeroAxe + Grad) * YPixel;
			IF LogY THEN tExt := 10 ** tExt
			ELSE IF (abs(tExt) < YPixel) THEN tExt := 0;			{amlioration de l'affichage des petites valeurs}
			aString := RealToString(tExt, 4);
			MoveTo(g_XLeft - StringWidth(aString) - 8, round(g_YDown - Grad) + 2);
			DrawString(aString);
			END;
		Grad := Grad + YnPixelGrad;
	UNTIL (Grad > g_YLong);
	IF MG_GParam.Polar THEN YTitle := concat(MG_yN, '.sin(', MG_xN, ')')
	ELSE YTitle := MG_yN;
	MoveTo(g_XLeft - StringWidth(YTitle) - 8, round(g_YUp) + MG_FAsc - 2);
	DrawString(YTitle);

END; {***** DrawAxes ***** 4444444444444444444444444444444444444444444444444444444444}

PROCEDURE InitDessin; {444444444444444444444444444444444444444444444444444444444444444444}

VAR
	r : rect;

BEGIN
	oldClip := NewRgn;
	CopyRgn(MG_GraphWPtr^.clipRgn, oldClip);
	ClipRect(MG_GraphPictRect);						{limitation du GrafPort pour limiter la taille de la picture}
	MG_PictureH := OpenPicture (MG_GraphPictRect);
	MG_PictSaved := false;
	PicComment(picGroupLP, 0, nil);			{pour grouper le cadre}
	SetRect(r, g_XLeft, g_Yup, g_XRight + 1, g_YDown + 1);
	FrameRect(r);
	DrawAxes;
	PicComment(picGroupRP, 0, nil);			{pour grouper le cadre}

END; {***** InitDessin ***** 44444444444444444444444444444444444444444444444444444444444}

FUNCTION PointSuivant(theK : integer; var theMx, theMy : integer) : boolean; {444444444444444444444444}

BEGIN
	IF MG_GParam.Polar THEN
		BEGIN
		theMx := round((xt[theK] - xinf) / XPixel);
		IF (theMx > g_XLong) THEN theMx := g_XLong
		ELSE IF (theMx < 0) THEN theMx := 0;			{on clippe comme on peut !}
		END
	ELSE theMx := theK;											{inutile de recalculer dans ce cas, c'est tudi pour}
	
	theMy := round((yt[theK] - yinf) / YPixel);
	IF (theMy > g_YLong) THEN theMy := g_YLong
	ELSE IF (theMy < 0) THEN theMy := 0;				{on clippe comme on peut !}
	PointSuivant := (theMy < ((yt[theK] - yinf) / YPixel));	{arrondi par dfaut}

END; {***** PointSuivant ***** 444444444444444444444444444444444444444444444444444444444}

PROCEDURE FinSegment; {4444444444444444444444444444444444444444444444444444444444444444}

BEGIN
	IF NOT tSegment THEN
		BEGIN	{si rien trac, placer le milieu du segment (le plus proche ?)}
		mx := round((mx+nmx-1)/2);
		LineTo(g_XLeft + mx, g_YDown - my);
		tmx := mx;
		END;
	pSegment := false;
	IF (abs(nmy-my) > 1) THEN
		BEGIN
		pSegment := true;										{point anguleux si besoin}
		IF (tmx < nmx-1) THEN		{inutile si le mx correspondant est dj marqu}
			BEGIN
			LineTo(g_XLeft + nmx-1, g_YDown - my);		{point anguleux si besoin}
			tmx := nmx - 1;
			END;
		END;

END; {***** FinSegment ***** 4444444444444444444444444444444444444444444444444444444444}

PROCEDURE PointSegment; {444444444444444444444444444444444444444444444444444444444444444}

BEGIN
	IF (tmx < nmx-1) THEN		{inutile si le mx correspondant est dj marqu}
		BEGIN
		LineTo(g_XLeft + nmx-1, g_YDown - nmy);
		tmx := nmx - 1;
		sDt := nsDt;
		tSegment := true;
		pSegment := false;
		END;

END; {***** PointSegment ***** 44444444444444444444444444444444444444444444444444444444}

BEGIN
	DoTrace := true;
	AjusteEchelle(g_YLong, sqrt(0.15*35/g_YLong),		{moyenne de 1/6 et de la longueur standard de 1/6}
										yinf, ysup, YPixel, YnPixelGrad);
	InitDessin;
	PicComment(picGroupLP, 0, nil);			{pour grouper les points dessins}
	BackColor(codeCouleur(symbole.couleur));
	unSymbole := getSymb(symbole.forme);
	unPoint := nPointS.suivant;
	WHILE unPoint <> NIL DO
		BEGIN
		PicComment(picGroupLP, 0, nil);			{pour grouper chaque point dessin}		
		mx := round((unPoint.x - xinf) / XPixel);
		my := round((unPoint.y - yinf) / YPixel);
		IF ((symbole.couleur <> blanc) AND (symbole.couleur <> jaune)) THEN
			ForeColor(codeCouleur(symbole.couleur));
		IF ErreurX & (unPoint.y >= yinf) & (unPoint.y <= ysup) THEN	{on place l 'erreur experimentale}
			BEGIN
			ndx := round(unPoint.dx / XPixel);
			drawXBarre(g_XLeft + mx, g_YDown - my, ndx);
			END;
		IF ErreurY & (unPoint.x >= xinf) & (unPoint.x <= xsup) THEN	{on place l 'erreur experimentale}
			BEGIN
			ndy := round(unPoint.dy / YPixel);
			drawYBarre(g_XLeft + mx, g_YDown - my, ndy);
			END;
		ForeColor(blackColor);
		IF (unPoint.x >= xinf) & (unPoint.x <= xsup) & (unPoint.y >= yinf) & (unPoint.y <= ysup) THEN
			unSymbole.draw(g_XLeft + mx, g_YDown - my);
		PicComment(picGroupRP, 0, nil);			{pour grouper chaque point dessin}
		unPoint := unPoint.suivant;
		END;
	unSymbole.free;
	BackColor(whiteColor);
	PicComment(picGroupRP, 0, nil);			{pour grouper les points dessins}
	IF DrawTh THEN									{prparer la courbe thorique en polygone}
		BEGIN
		PolyH := OpenPoly;
		tSegment := true;
		pSegment := false;
		sDt := PointSuivant(0, mx, my);
		MoveTo(g_XLeft + mx, g_YDown - my);			{point initial}
		tmx := mx;
		FOR k := 1 TO g_XLong DO
			BEGIN
			nsDt := PointSuivant(k, nmx, nmy);
			IF (nmy <> my) | MG_GParam.Polar THEN							{fin de xSegment et dbut d'un autre}
				BEGIN																			{...mais sans filtrage en polaire}
				FinSegment;
				mx := nmx;
				my := nmy;
				sDt := nsDt;
				tSegment := false;
				END
			ELSE IF pSegment | (nsDt <> sDt) THEN			{point anguleux ou traverse de xSegment}
				BEGIN
				PointSegment;
				END;
			END;
		PointSegment;													{point final}
		ClosePoly;
		FramePoly(PolyH);						{tracer la courbe thorique en polygone}
		END;
	ClosePicture;
	CopyRgn(oldClip, MG_GraphWPtr^.clipRgn);
	DisposeRgn(oldClip);

END; {***** TraceY *****3333333333333333333333333333333333333333333333333333333333333}

BEGIN
	AjusteEchelle(g_XLong, sqrt(0.15*62/g_XLong),		{moyenne de 1/6 et de la longueur standard de 1/6}
										xinf, xsup, XPixel, XnPixelGrad);
	IF DrawTh THEN					{calcul des points theoriques}
		BEGIN
		IF NOT MG_GParam.Polar THEN		{calcul des points thoriques APRES cadrage en x dans ce cas}
			BEGIN										{car les limites en dpendent}
			FOR i := 0 TO g_XLong DO
				BEGIN
				xt[i] := xinf + i * XPixel;
				IF LogX THEN yt[i] := fonc(theParamS, 10 ** xt[i])
				ELSE yt[i] := fonc(theParamS, xt[i]);
				IF LogY THEN
					BEGIN
					IF (yt[i] > MG_LogMin) THEN yt[i] := ln(yt[i])/ln(10) ELSE yt[i] := ln(MG_LogMin)/ln(10);
					END;
				END;
			END;
		END;
	IF LogY THEN
		BEGIN
		nPointS.Logarithme(MG_ForY);
		IF (yinf > MG_LogMin) THEN yinf := ln(yinf)/ln(10) ELSE yinf := ln(MG_LogMin)/ln(10);
		IF (ysup > MG_LogMin) THEN ysup := ln(ysup)/ln(10) ELSE ysup := ln(MG_LogMin)/ln(10);
		END;
	IF (ScaleY AND (npts >= 1)) THEN
		BEGIN
		unPoint := nPointS.suivant;
		WHILE unPoint <> NIL DO					{initialisation : recherche d'un point sans forcer...}
			BEGIN
			IF ((unPoint.x >= xinf) & (unPoint.x <= xsup)) THEN	{...si pas de point on utilise les valeurs manuelles}
				BEGIN
				yinf := unPoint.y;
				ysup := unPoint.y;
				LEAVE;
				END;
			unPoint := unPoint.suivant;
			END;
		unPoint := nPointS.suivant;
		IF ScaleDY THEN							{cadrage en y avec dy}
			WHILE unPoint <> NIL DO
				BEGIN
				IF ((unPoint.x >= xinf) & (unPoint.x <= xsup)) THEN
					BEGIN
					IF ((unPoint.y + unPoint.dy) > ysup) THEN ysup := unPoint.y + unPoint.dy;
					IF ((unPoint.y - unPoint.dy) < yinf) THEN yinf := unPoint.y - unPoint.dy;
					END;
				unPoint := unPoint.suivant;
				END
		ELSE											{cadrage en y sans dy}
			WHILE unPoint <> NIL DO
				BEGIN
				IF ((unPoint.x >= xinf) & (unPoint.x <= xsup)) THEN
					IF (unPoint.y > ysup) THEN ysup := unPoint.y ELSE IF (unPoint.y < yinf) THEN yinf := unPoint.y;
				unPoint := unPoint.suivant;
				END;
		END;
	IF ScaleThY THEN							{cadrage en yt}
		FOR i := 0 TO g_XLong DO
			IF (yt[i] > ysup) THEN ysup := yt[i] ELSE IF (yt[i] < yinf) THEN yinf := yt[i];
	IF (ZeroY AND (ysup < 0.00)) THEN ysup := 0.00;		{cadrage en y avec zero}
	IF (ZeroY AND (yinf > 0.00)) THEN yinf := 0.00;
	IF (ysup > yinf) THEN TraceY
	ELSE
		BEGIN
		StopAnimatedCursor;
		confirmation := StopAlert(MG_InfSupStopID, nil);
		StartAnimatedCursor;
		RangerGraphWindow;
		END;

END; {***** TraceX *****2222222222222222222222222222222222222222222222222222222222222}

BEGIN

	NPar := theParamS.compte;			{bidouille "temporaire" (?) pour raccorder sans douleur}
	unParam := theParamS.suivant;
	FOR k := 1 to NPar DO
		BEGIN
		a[k] := unParam.a;
		unParam := unParam.suivant;
		END;

	nPointS := TPointS(thePointS.clone);
	npts := nPointS.compte;
	StartAnimatedCursor;	{graphique suppose que AnimatedCursor est initialis}
	SetUpGraphWindow;	{graphique suppose font, window, menu, TEdit et dialog initialiss}
	DoTrace := false;
	MG_PictSaved := true;		{pas de picture  sauver avant de l'avoir cre}
	IF LogX THEN						{jamais appel en coordonnes polaires}
		BEGIN
		nPointS.Logarithme(MG_ForX);
		IF (xinf > MG_LogMin) THEN xinf := ln(xinf)/ln(10) ELSE xinf := ln(MG_LogMin)/ln(10);
		IF (xsup > MG_LogMin) THEN xsup := ln(xsup)/ln(10) ELSE xsup := ln(MG_LogMin)/ln(10);
		END;
	IF MG_GParam.Polar THEN
		BEGIN
		IF (MG_GParam.ScaleA AND (npts >= 1)) THEN
			BEGIN
			unPoint := nPointS.suivant;
			MG_GParam.ainf := unPoint.x;		{on effectue le cadrage en a d'aprs x (angulaire dans ce cas)}
			MG_GParam.asup := unPoint.x;
			WHILE unPoint <> NIL DO
				BEGIN
				IF (unPoint.x > MG_GParam.asup) THEN MG_Gparam.asup := unPoint.x
				ELSE IF (unPoint.x < MG_GParam.ainf) THEN MG_Gparam.ainf := unPoint.x;
				unPoint := unPoint.suivant;
				END;
			END;
		nPointS.PolToCart;							{puis on traduit en cartsien}
		IF DrawTh THEN				{calcul des points thoriques AVANT cadrage en x dans ce cas}
			BEGIN									{car cela dcoule du cadrage en a}
			FOR j := 0 TO g_XLong DO			{intervalle  amliorer !...}
				BEGIN
				tTx := MG_GParam.ainf + j * (MG_GParam.asup - MG_GParam.ainf)/g_XLong;
				tTy := fonc(theParamS, tTx);
				xt[j] := tTy*cos(tTx);
				yt[j] := tTy*sin(tTx);
				END;
			END;
		END;
		
	IF (ScaleX AND (npts >= 1)) THEN
		BEGIN
		unPoint := nPointS.suivant;
		xinf := unPoint.x;						{on effectue le cadrage en x}
		xsup := unPoint.x;
		IF ScaleDX THEN
			BEGIN
			WHILE unPoint <> NIL DO
				BEGIN
				IF ((unPoint.x + unPoint.dx) > xsup) THEN xsup := unPoint.x + unPoint.dx;
				IF ((unPoint.x - unPoint.dx) < xinf) THEN xinf := unPoint.x - unPoint.dx;
				unPoint := unPoint.suivant;
				END;
			END
		ELSE
			BEGIN
			WHILE unPoint <> NIL DO
				BEGIN
				IF (unPoint.x > xsup) THEN xsup := unPoint.x ELSE IF (unPoint.x < xinf) THEN xinf := unPoint.x;
				unPoint := unPoint.suivant;
				END;
			IF (npts = 1) THEN ZeroX := true;
			END;
		END;
	
	IF DrawTh & MG_GParam.Polar & MG_GParam.ScaleThx THEN		{cadrage en xt}
		FOR j := 0 TO g_XLong DO								{inutile en cartsien car c'est cadr par dfinition}
			IF (xt[j] > xsup) THEN xsup := xt[j] ELSE IF (xt[j] < xinf) THEN xinf := xt[j];
	
	IF (ZeroX AND (xsup < 0.00)) THEN xsup := 0.00;
	IF (ZeroX AND (xinf > 0.00)) THEN xinf := 0.00;
	IF (xsup > xinf) THEN TraceX
	ELSE
		BEGIN
		StopAnimatedCursor;
		confirmation := StopAlert(MG_InfSupStopID, nil);
		StartAnimatedCursor;
		RangerGraphWindow;
		END;
	StopAnimatedCursor;
	FlushEvents(mDownMask+mUpMask,0);		{est-ce bien utile ?}
	RangerGraphique;
	nPointS.free;
 			
END; {***** graphique *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE RangerGraphWindow; {1111111111111111111111111111111111111111111111111111111111}

VAR
	confirmation : integer;

BEGIN
	IF NOT MG_PictSaved THEN
		BEGIN
		confirmation := CautionAlert(MG_QuitSansSaveAlrtID, NIL);
		CASE confirmation OF
			1 : MG_PictSaved := true;										{on quitte}
			2 : MG_PictSaved := SauvePict(MG_PictureH);		{on enregistre et on quitte}
			3 : ;																{sortie annule}
			END;
		END;
	IF MG_PictSaved THEN
		BEGIN
		IF (MG_PictureH <> NIL) THEN
			BEGIN
			KillPicture(MG_PictureH);
			MG_PictureH := NIL;
			END;
		IF (MG_GraphWPtr <> NIL) THEN
			BEGIN
			DisposeWindow(MG_GraphWPtr);
			MG_GraphWPtr := NIL;
			END;
		END;

END; {***** RangerGraphWindow *****111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpGraphiques; {111111111111111111111111111111111111111111111111111111111111}

CONST
	SymbFormeMenu = 260;
	SymbCouleurMenu = 261;

	Standard = 3;
	AutoX = 6;
	ManuX = 7;
	InfX = 9;
	SupX = 11;
	AutoY = 13;
	ManuY = 14;
	InfY = 16;
	SupY = 18;
	TBarX = 20;
	CBarX = 21;
	TBarY = 23;
	CBarY = 24;
	sForme = 26;
	sCouleur = 27;
	LgX = 29;
	LgY = 30;
	ZerX = 32;
	ZerY = 33;
	TTh = 35;		{trac de la courbe thorique}
	CTh = 36;		{cadrage vertical de la courbe thorique}
	CsTh = 37;		{...prcisions sur le cadrage}

VAR
	TempPort : GrafPtr;
	GraphWPtr : DialogPtr;
	box : rect;
	k, TheItem, OptType, npts : integer;
	DoTrace : boolean;
	MyItemHdl : handle;
	aString : STR255;
	GPar, GPF1, GPF2, GP : MG_GP;
	MyPopUpItem : longint;
	sFormeMHdl, sCouleurMHdl : MenuHandle;

PROCEDURE SetGP; {22222222222222222222222222222222222222222222222222222222222222222222}

BEGIN		{GP contient les paramtres finalement utiliss pour tracer le graphique}
	GP.ScaleX := GPar.ScaleX and GPF1.ScaleX;
	GP.ScaleY := GPar.ScaleY and GPF1.ScaleY;
	GP.ErreurX := GPar.ErreurX and GPF1.ErreurX;
	GP.ScaleDX := GPar.ScaleDX and GPF1.ScaleDX;
	GP.ErreurY := GPar.ErreurY and GPF1.ErreurY;
	GP.ScaleDY := GPar.ScaleDY and GPF1.ScaleDY;
	GP.LogX := GPar.LogX and GPF1.LogX;
	GP.LogY := GPar.LogY and GPF1.LogY;
	GP.ZeroX := GPar.ZeroX and GPF1.ZeroX;
	GP.ZeroY := GPar.ZeroY and GPF1.ZeroY;
	GP.DrawTh := GPar.DrawTh and GPF1.DrawTh;
	GP.ScaleThX := GPar.ScaleThX and GPF1.ScaleThX;
	GP.ScaleThY := GPar.ScaleThY and GPF1.ScaleThY;
	GP.ScaleA := GPar.ScaleA and GPF1.ScaleA;

END; {***** SetGP *****22222222222222222222222222222222222222222222222222222222222222}
	
PROCEDURE SetParam; {222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	SetGP;
	GetDItem(GraphWPtr, AutoX, OptType, MyItemHdl, box);							{automatique}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleX));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ScaleX)*255);
	GetDItem(GraphWPtr, ManuX, OptType, MyItemHdl, box);							{manuel}
	SetCtlValue(ControlHandle(MyItemHdl), ord(NOT GP.ScaleX));
	
	GetDItem(GraphWPtr, AutoY, OptType, MyItemHdl, box);							{automatique}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleY));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ScaleY)*255);
	GetDItem(GraphWPtr, ManuY, OptType, MyItemHdl, box);							{manuel}
	SetCtlValue(ControlHandle(MyItemHdl), ord(NOT GP.ScaleY));

	GetDItem(GraphWPtr, TBarX, OptType, MyItemHdl, box);							{traces}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ErreurX));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ErreurX)*255);

	GetDItem(GraphWPtr, CBarX, OptType, MyItemHdl, box);							{cadres}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleDX));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT (GPF1.ScaleDX and GPF2.ScaleDX))*255);

	GetDItem(GraphWPtr, TBarY, OptType, MyItemHdl, box);							{traces}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ErreurY));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ErreurY)*255);

	GetDItem(GraphWPtr, CBarY, OptType, MyItemHdl, box);							{cadres}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleDY));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT (GPF1.ScaleDY and GPF2.ScaleDY))*255);

	GetDItem(GraphWPtr, sForme, OptType, MyItemHdl, box);						{symbole}
	GetItem(sFormeMHdl, ord(GPar.symbole.forme) + 1, aString);
	SetIText(MyItemHdl, concat('  ', aString));
	GetDItem(GraphWPtr, sCouleur, OptType, MyItemHdl, box);
	GetItem(sCouleurMHdl, ord(GPar.symbole.couleur) + 1, aString);
	SetIText(MyItemHdl, concat('  ', aString));

	GetDItem(GraphWPtr, LgX, OptType, MyItemHdl, box);							{horizontale}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.LogX));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.LogX)*255);

	GetDItem(GraphWPtr, LgY, OptType, MyItemHdl, box);							{verticale}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.LogY));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.LogY)*255);

	GetDItem(GraphWPtr, ZerX, OptType, MyItemHdl, box);							{horizontal}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ZeroX));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ZeroX)*255);

	GetDItem(GraphWPtr, ZerY, OptType, MyItemHdl, box);							{vertical}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ZeroY));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ZeroY)*255);

	GetDItem(GraphWPtr, TTh, OptType, MyItemHdl, box);							{trace}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.DrawTh));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.DrawTh)*255);

	GetDItem(GraphWPtr, CTh, OptType, MyItemHdl, box);							{cadre verticalement}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleThY));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT (GPF1.ScaleThY and GPF2.ScaleThY))*255);

	GetDItem(GraphWPtr, CsTh, OptType, MyItemHdl, box);							{polaire}
	HiliteControl(ControlHandle(MyItemHdl),
							ord(NOT (GPF1.DrawTh AND GPF2.ScaleThY AND MG_GParam.Polar))*255);

END; {***** SetParam *****22222222222222222222222222222222222222222222222222222222222}
	
PROCEDURE SetGPar; {2222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	IF MG_GParam.FirstUse THEN
		BEGIN
		GPar.ScaleX := true;
		GPar.xinf := 0;
		GPar.xsup := 100;
		GPar.yinf := 0;
		GPar.ysup := 100;
		GPar.ScaleY := true;
		GPar.ErreurX := true;
		GPar.ScaleDX := true;
		GPar.ErreurY := true;
		GPar.ScaleDY := true;
		GPar.symbole.forme := rond;
		GPar.symbole.couleur := blanc;
		GPar.LogX := false;
		GPar.LogY := false;
		GPar.ZeroX := true;
		GPar.ZeroY := true;
		GPar.DrawTh := true;
		GPar.ScaleThX := true;
		GPar.ScaleThY := true;
		GPar.Polar := MG_GParam.Polar;			{celui-ci : uniquement pour viter l'crasement plus tard}
		GPar.ainf := -pi;
		GPar.asup := pi;
		GPar.ScaleA := true;
		END
	ELSE GPar := MG_GParam;
	
	GPF1.ScaleX := (npts > 0);					{filtre pour conditions externes}
	GPF1.ScaleY := (npts > 0);
	GPF1.ErreurX := ((npts > 0) and MG_withDx);
	GPF1.ScaleDX := ((npts > 0) and MG_withDx);
	GPF1.ErreurY := ((npts > 0) and MG_withDy);
	GPF1.ScaleDY := ((npts > 0) and MG_withDy);
	GPF1.LogX := NOT MG_GParam.Polar;
	GPF1.LogY := NOT MG_GParam.Polar;			{ne supporte pas les logarithmes radiaux pour l'instant}
	GPF1.ZeroX := (npts > 0);
	GPF1.ZeroY := (npts > 0);
	GPF1.DrawTh := (MG_theOperS.suivant1 <> NIL);
	GPF1.ScaleThX := (MG_theOperS.suivant1 <> NIL);
	GPF1.ScaleThY := (MG_theOperS.suivant1 <> NIL);
	GPF1.ScaleA := (npts > 0);
	
	GPF2.ScaleDX := GPar.ScaleX;					{filtre pour conditions internes : aider les associations logiques}
	GPF2.ScaleDY := GPar.ScaleY;
	GPF2.ScaleThX := true;
	GPF2.ScaleThY := true;

END; {***** SetGPar *****222222222222222222222222222222222222222222222222222222222222}
	
PROCEDURE InitParam; {22222222222222222222222222222222222222222222222222222222222222222}

CONST
	nnDec = 9;

BEGIN
	SetGPar;
	GetDItem(GraphWPtr, InfX, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, RealToString(GPar.xinf, nnDec));
	GetDItem(GraphWPtr, SupX, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, RealToString(GPar.xsup, nnDec));
	GetDItem(GraphWPtr, InfY, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, RealToString(GPar.yinf, nnDec));
	GetDItem(GraphWPtr, SupY, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, RealToString(GPar.ysup, nnDec));

	SetParam;
	
END; {***** InitParam *****22222222222222222222222222222222222222222222222222222222222}
	
PROCEDURE GetScaleTh; {22222222222222222222222222222222222222222222222222222222222222222}

CONST
	AutoT = 4;			{tendue d'aprs les points...}
	ManuT = 5;			{...ou impose}
	InfT = 7;
	SupT = 9;
	CThX = 11;			{cadrage horizontal de la courbe thorique}
	CThY = 12;			{cadrage vertical de la courbe thorique}

VAR
	TempPort : GrafPtr;
	PGraphWPtr : DialogPtr;
	box : rect;
	TheItem, OptType : integer;
	MyItemHdl : handle;
	aString : STR255;

PROCEDURE SetPParam; {33333333333333333333333333333333333333333333333333333333333333333}

BEGIN
	SetGP;
	GetDItem(PGraphWPtr, AutoT, OptType, MyItemHdl, box);					{automatique}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleA));
	HiliteControl(ControlHandle(MyItemHdl), ord(NOT GPF1.ScaleA)*255);
	GetDItem(PGraphWPtr, ManuT, OptType, MyItemHdl, box);					{manuel}
	SetCtlValue(ControlHandle(MyItemHdl), ord(NOT GP.ScaleA));

	GetDItem(PGraphWPtr, CThX, OptType, MyItemHdl, box);					{cadre horizontalement}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleThX));

	GetDItem(PGraphWPtr, CThY, OptType, MyItemHdl, box);					{cadre verticalement}
	SetCtlValue(ControlHandle(MyItemHdl), ord(GP.ScaleThY));

END; {***** SetPParam *****33333333333333333333333333333333333333333333333333333333333}

PROCEDURE InitPParam; {33333333333333333333333333333333333333333333333333333333333333333}

CONST
	nnDec = 9;

BEGIN
	GetDItem(PGraphWPtr, InfT, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, RealToString(GPar.ainf, nnDec));
	GetDItem(PGraphWPtr, SupT, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, RealToString(GPar.asup, nnDec));

	SetPParam;
	
END; {***** InitPParam *****3333333333333333333333333333333333333333333333333333333333}

BEGIN
	GetPort(TempPort);
	PGraphWPtr := GetNewDialog(MG_SetUpPolGrDlgID, nil, POINTER(-1));
	SetPort(PGraphWPtr);
	
	InitPParam;
	
	FlushEvents(mDownMask+mUpMask,0);
	REPEAT
		ModalDialog(@FilterForDialog, TheItem);
		CASE TheItem OF
			OK :	BEGIN
					GetDItem(PGraphWPtr, InfT, OptType, MyItemHdl, box);
					GetIText(MyItemHdl, aString);
					GPar.ainf := StringToReal(aString);
					GetDItem(PGraphWPtr, SupT, OptType, MyItemHdl, box);
					GetIText(MyItemHdl, aString);
					GPar.asup := StringToReal(aString);
					{MG_GParam := GPar;}		{probablement non : temporaire en cas d'annulation}
					END;
			cancel : ;
			AutoT :	BEGIN
						GPar.ScaleA := true;
						SetPParam;
						SelIText(PGraphWPtr, InfT, 0, 0);
						END;
			ManuT :	BEGIN
							GPar.ScaleA := false;
							SetPParam;
							SelIText(PGraphWPtr, InfT, 0, 32767);
							END;
			InfT, SupT :	BEGIN
								GPar.ScaleA := false;
								SetPParam;
								END;
			CThX :	BEGIN
						GPar.ScaleThX := NOT GPar.ScaleThX;
						SetPParam;
						END;
			CThY :	BEGIN
						GPar.ScaleThY := NOT GPar.ScaleThY;
						SetPParam;
						END;
			END;
	UNTIL (TheItem = OK) OR (TheItem = cancel);
	
	DisposDialog(PGraphWPtr);
	SetPort(TempPort);

END; {***** GetScaleTh *****22222222222222222222222222222222222222222222222222222222222}

BEGIN
	npts := thePointS.compte;
	IF AsSet THEN
		BEGIN
		SetGPar;
		SetGP;
		DoTrace := true;
		MG_GParam := GPar;
		MG_GParam.FirstUse := false;
		END
	ELSE
		BEGIN
		GetPort(TempPort);
		GraphWPtr := GetNewDialog(MG_SetUpGraphiqueDlgID, nil, POINTER(-1));
		SetPort(GraphWPtr);
		GetDItem(GraphWPtr, sForme, OptType, MyItemHdl, box);						{symbole}
		FramePopUp(box);
		sFormeMHdl := GetMenu(SymbFormeMenu);
		InsertMenu(sFormeMHdl, -1);
		GetDItem(GraphWPtr, sCouleur, OptType, MyItemHdl, box);
		FramePopUp(box);
		sCouleurMHdl := GetMenu(SymbCouleurMenu);
		InsertMenu(sCouleurMHdl, -1);
		
		IF MG_GParam.Polar THEN																{nouveaux titres}
			BEGIN
			GetDItem(GraphWPtr, LgX, OptType, MyItemHdl, box);
			GetIndString(aString, MG_PolGraphStrID, 1);
			SetCTitle(ControlHandle(MyItemHdl), aString);
			GetDItem(GraphWPtr, LgY, OptType, MyItemHdl, box);
			GetIndString(aString, MG_PolGraphStrID, 2);
			SetCTitle(ControlHandle(MyItemHdl), aString);
			END;
		
		InitParam;
		
		DoTrace := false;
		FlushEvents(mDownMask+mUpMask,0);
		REPEAT
			ModalDialog(@FilterForDialog, TheItem);
			CASE TheItem OF
				OK :	BEGIN
						DoTrace := true;
						GetDItem(GraphWPtr, InfX, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						GPar.xinf := StringToReal(aString);
						GetDItem(GraphWPtr, SupX, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						GPar.xsup := StringToReal(aString);
						GetDItem(GraphWPtr, InfY, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						GPar.yinf := StringToReal(aString);
						GetDItem(GraphWPtr, SupY, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						GPar.ysup := StringToReal(aString);
						MG_GParam := GPar;
						MG_GParam.FirstUse := false;
						END;
				cancel :	;
				Standard :		BEGIN
									MG_GParam.FirstUse := true;
									InitParam;	{rinitialiser...}
									END;
				AutoX :	BEGIN
							GPar.ScaleX := true;
							GPar.ScaleDX := GPar.ErreurX;
							IF GPar.ErreurX THEN GPF2.ScaleDX := true;
							IF GPar.DrawTh THEN
								BEGIN
								GPar.ScaleThX := true;
								GPar.ScaleThY := true;
								END;
							SetParam;
							SelIText(GraphWPtr, InfX, 0, 0);
							END;
				ManuX :	BEGIN
							GPar.ScaleX := false;
							GPar.ScaleDX := false;
							GPF2.ScaleDX := false;
							GPar.ZeroX := false;
							GPar.ScaleThX := false;
							SetParam;
							SelIText(GraphWPtr, InfX, 0, 32767);
							END;
				InfX, SupX :	BEGIN
									GPar.ScaleX := false;
									GPar.ScaleDX := false;
									GPF2.ScaleDX := false;
									GPar.ZeroX := false;
									GPar.ScaleThX := false;
									SetParam;
									END;
				AutoY :	BEGIN
							GPar.ScaleY := true;
							GPar.ScaleDY := GPar.ErreurY;
							IF GPar.ErreurY THEN GPF2.ScaleDY := true;
							IF GPar.DrawTh THEN
								BEGIN
								GPar.ScaleThY := true;
								GPF2.ScaleThY := true;
								END;
							SetParam;
							SelIText(GraphWPtr, InfY, 0, 0);
							END;
				ManuY :	BEGIN
							GPar.ScaleY := false;
							GPar.ScaleDY := false;
							GPF2.ScaleDY := false;
							GPar.ZeroY := false;
							GPar.ScaleThY := false;
							SetParam;
							SelIText(GraphWPtr, InfY, 0, 32767);
							END;
				InfY, SupY :	BEGIN
									GPar.ScaleY := false;
									GPar.ScaleDY := false;
									GPF2.ScaleDY := false;
									GPar.ZeroY := false;
									GPar.ScaleThY := false;
									SetParam;
									END;
				TBarX :	BEGIN
							GPar.ErreurX := NOT GPar.ErreurX;
							IF GPar.ScaleX THEN
								BEGIN
								GPar.ScaleDX := GPar.ErreurX;
								GPF2.ScaleDX := GPar.ErreurX;
								END;
							SetParam;
							END;
				CBarX :	BEGIN
							GPar.ScaleDX := NOT GPar.ScaleDX;
							SetParam;
							END;
				TBarY :	BEGIN
							GPar.ErreurY := NOT GPar.ErreurY;
							IF GPar.ScaleY THEN
								BEGIN
								GPar.ScaleDY := GPar.ErreurY;
								GPF2.ScaleDY := GPar.ErreurY;
								END;
							SetParam;
							END;
				CBarY :	BEGIN
							GPar.ScaleDY := NOT GPar.ScaleDY;
							SetParam;
							END;
				sForme :	BEGIN
								GetDItem(GraphWPtr, sForme, OptType, MyItemHdl, box);
								LocalToGlobal(box.TopLeft);
								MyPopUpItem := PopUpMenuSelect(sFormeMHdl, box.top, box.left,
																											ord(GPar.symbole.forme) + 1);
								IF (MyPopUpItem <> 0) THEN
									BEGIN
									CASE LoWord(MyPopUpItem) OF
										1 :	GPar.symbole.forme := rond;
										2 :	GPar.symbole.forme := carre;
										3 :	GPar.symbole.forme := triup;
										4 :	GPar.symbole.forme := tridown;
										END;
									SetParam;
									END;
								END;
				sCouleur :	BEGIN
								GetDItem(GraphWPtr, sCouleur, OptType, MyItemHdl, box);
								LocalToGlobal(box.TopLeft);
								MyPopUpItem := PopUpMenuSelect(sCouleurMHdl, box.top, box.left,
																											ord(GPar.symbole.couleur) + 1);
								IF (MyPopUpItem <> 0) THEN
									BEGIN
									CASE LoWord(MyPopUpItem) OF
										1 :	GPar.symbole.couleur := noir;
										2 :	GPar.symbole.couleur := blanc;
										3 :	GPar.symbole.couleur := rouge;
										4 :	GPar.symbole.couleur := vert;
										5 :	GPar.symbole.couleur := bleu;
										6 :	GPar.symbole.couleur := cyan;
										7 :	GPar.symbole.couleur := magenta;
										8 :	GPar.symbole.couleur := jaune;
										END;
									SetParam;
									END;
								END;
				LgX :	BEGIN
							GPar.LogX := NOT GPar.LogX;
							SetParam;
							END;
				LgY :	BEGIN
							GPar.LogY := NOT GPar.LogY;
							SetParam;
							END;
				ZerX :	BEGIN
							GPar.ZeroX := NOT GPar.ZeroX;
							SetParam;
							END;
				ZerY :	BEGIN
							GPar.ZeroY := NOT GPar.ZeroY;
							SetParam;
							END;
				TTh :	BEGIN
							GPar.DrawTh := NOT GPar.DrawTh;
							GPar.ScaleThX := GPar.DrawTh;
							GPar.ScaleThY := GPar.DrawTh;
							GPF2.ScaleThX := GPar.DrawTh;
							GPF2.ScaleThY := GPar.DrawTh;
							SetParam;
							END;
				CTh :	BEGIN
							GPar.ScaleThY := NOT GPar.ScaleThY;
							GPar.ScaleThX := GPar.ScaleThY;				{sauf prcision, on impose les deux}
							SetParam;
							END;
				CsTh :	BEGIN														{pour prcisions ventuelles}
							GetScaleTh;
							SetParam;							{les paramtres polaires peuvent modifier le cadrage vertical}
							END;
				END;
		UNTIL (TheItem = OK) OR (TheItem = cancel);
			
		DeleteMenu(SymbCouleurMenu);
		ReleaseResource(handle(sCouleurMHdl));
		DeleteMenu(SymbFormeMenu);
		ReleaseResource(handle(sFormeMHdl));
		DisposDialog(GraphWPtr);
		SetPort(TempPort);
	END;

	IF DoTrace THEN
		BEGIN
		graphique(thePointS,										{points}
					theParamS, 										{paramtres}
					GPar.xinf, GPar.xsup, GPar.yinf, GPar.ysup,	{zone a dessiner}
					GP.ScaleX, GP.ScaleY,						{cadrage automatique}
					GP.ErreurX, GP.ErreurY,					{barres d'erreur...}
					GP.ScaleDX, GP.ScaleDY,					{...cadres}
					GPar.symbole,									{pour diffrencier les points}
					GP.LogX, GP.LogY,							{chelle logarithmique}
					GP.ZeroX, GP.ZeroY,						{cadrage du zro}
					GP.DrawTh, GP.ScaleThY,					{courbe ajuste, cadre}
					fonc);												{pour transmettre la fonction}
		END;

END; {***** SetUpGraphiques *****111111111111111111111111111111111111111111111111111111}

PROCEDURE InitGraphique; {111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	MG_GParam.Polar := FALSE;		{le graphique ventuel est cartsien a priori}
	MG_GraphWPtr := NIL;		{pas de graphique en cours}
	MG_PictureH := NIL;
	MG_PictSaved := true;		{pas de picture en cours}
	g_XLong := g_XLongStand;		{limitation standard du graphique (d'aprs la taille de la fentre)}
	g_YLong := g_YLongStand;		{valable si on n'impose pas le format du graphique}

END; {***** InitGraphique *****111111111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpGraphFormat; {11111111111111111111111111111111111111111111111111111111111}

CONST
	FormatMenu = 268;

	Format = 4;
	LargeX = 7;
	LargeY = 9;
	UnitPx = 11;
	UnitCm = 12;

	nnDec = 9;
	PixToCm = 0.0352777778;		{72 points par pouce}

TYPE
	TypFormat = (UsForm, StanForm, VertForm, HorForm);
	TypUnit = (PxUnit, CmUnit);
	RectPtr = ^rect;
	RectHdl = ^RectPtr;

VAR
	TempPort : GrafPtr;
	GraphWPtr : DialogPtr;
	box : rect;
	TheItem, OptType, nXLong, nYLong : integer;
	nForm : TypFormat;
	nUnit : TypUnit;
	MyItemHdl : handle;
	aString : STR255;
	MyPopUpItem : longint;
	FormatMenuHdl : MenuHandle;
	MyRectHdl : handle;
	uXLong, uYLong : integer;

PROCEDURE GetFormat; {2222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	CASE nUnit OF
		PxUnit :	BEGIN
						GetDItem(GraphWPtr, LargeX, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						nXLong := round(max(min(StringToReal(aString), g_XLongMaxH), g_XLongMin));
						SetIText(MyItemHdl, RealToString(nXLong, nnDec));
						GetDItem(GraphWPtr, LargeY, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						nYLong := round(max(min(StringToReal(aString), g_YLongMaxV), g_YLongMin));
						SetIText(MyItemHdl, RealToString(nYLong, nnDec));
						END;
		CmUnit :	BEGIN
						GetDItem(GraphWPtr, LargeX, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						nXLong := round(max(min(StringToReal(aString)/PixToCm, g_XLongMaxH), g_XLongMin));
						SetIText(MyItemHdl, RealToString(nXLong*PixToCm, nnDec));
						GetDItem(GraphWPtr, LargeY, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						nYLong := round(max(min(StringToReal(aString)/PixToCm, g_YLongMaxV), g_YLongMin));
						SetIText(MyItemHdl, RealToString(nYLong*PixToCm, nnDec));
						END;
		END;

END; {***** GetFormat *****22222222222222222222222222222222222222222222222222222222222}

PROCEDURE SetPopUp; {222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetItem(FormatMenuHdl, ord(nForm) + 1, aString);
	GetDItem(GraphWPtr, Format, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, concat(' ', aString));

END; {***** SetPopUp *****22222222222222222222222222222222222222222222222222222222222}

PROCEDURE SetFormat; {2222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetDItem(GraphWPtr, UnitPx, OptType, MyItemHdl, box);						{pixels}
	SetCtlValue(ControlHandle(MyItemHdl), (1-ord(nUnit))*255);
	GetDItem(GraphWPtr, UnitCm, OptType, MyItemHdl, box);						{cm}
	SetCtlValue(ControlHandle(MyItemHdl), ord(nUnit)*255);
	
	CASE nUnit OF
		PxUnit :	BEGIN
						GetDItem(GraphWPtr, LargeX, OptType, MyItemHdl, box);
						SetIText(MyItemHdl, RealToString(nXLong, nnDec));
						GetDItem(GraphWPtr, LargeY, OptType, MyItemHdl, box);
						SetIText(MyItemHdl, RealToString(nYLong, nnDec));
						END;
		CmUnit :	BEGIN
						GetDItem(GraphWPtr, LargeX, OptType, MyItemHdl, box);
						SetIText(MyItemHdl, RealToString(nXLong*PixToCm, nnDec));
						GetDItem(GraphWPtr, LargeY, OptType, MyItemHdl, box);
						SetIText(MyItemHdl, RealToString(nYLong*PixToCm, nnDec));
						END;
		END;

	SetPopUp;

END; {***** SetFormat *****22222222222222222222222222222222222222222222222222222222222}
	
BEGIN
	GetPort(TempPort);
	GraphWPtr := GetNewDialog(MG_SetUpGraphFormatDlgID, nil, POINTER(-1));
	SetPort(GraphWPtr);
	GetDItem(GraphWPtr, Format, OptType, MyItemHdl, box);		{format}
	FramePopUp(box);
	FormatMenuHdl := GetMenu(FormatMenu);
	InsertMenu(FormatMenuHdl, -1);

	MyRectHdl := GetResource('RECT', MG_SetUpGraphRectID);	{format usuel demand par dfaut}
	uXLong := RectHdl(MyRectHdl)^^.right;									{largeur usuelle}
	nXLong := uXLong;
	uYLong := RectHdl(MyRectHdl)^^.bottom;								{hauteur usuelle}
	nYLong := uYLong;
	
	nForm := UsForm;
	nUnit := PxUnit;
	
	SetFormat;
	
	SelIText(GraphWPtr, LargeX, 0, 32767);
	
	FlushEvents(mDownMask+mUpMask,0);
	REPEAT
		ModalDialog(@FilterForDialog, TheItem);
		CASE TheItem OF
			OK :	BEGIN
					CASE nUnit OF
						PxUnit :	BEGIN
										GetDItem(GraphWPtr, LargeX, OptType, MyItemHdl, box);
										GetIText(MyItemHdl, aString);
										g_XLong := round(max(min(StringToReal(aString), g_XLongMaxH),g_XLongMin));
										GetDItem(GraphWPtr, LargeY, OptType, MyItemHdl, box);
										GetIText(MyItemHdl, aString);
										g_YLong := round(max(min(StringToReal(aString), g_YLongMaxV), g_YLongMin));
										SetIText(MyItemHdl, RealToString(nYLong, nnDec));
										END;
						CmUnit :	BEGIN
										GetDItem(GraphWPtr, LargeX, OptType, MyItemHdl, box);
										GetIText(MyItemHdl, aString);
										g_XLong := round(max(min(StringToReal(aString)/PixToCm, g_XLongMaxH), g_XLongMin));
										GetDItem(GraphWPtr, LargeY, OptType, MyItemHdl, box);
										GetIText(MyItemHdl, aString);
										g_YLong := round(max(min(StringToReal(aString)/PixToCm, g_YLongMaxV), g_YLongMin));
										SetIText(MyItemHdl, RealToString(nYLong*PixToCm, nnDec));
										END;
						END;
					MyRectHdl := GetResource('RECT', MG_SetUpGraphRectID);
					HNoPurge(MyRectHdl);
					RectHdl(MyRectHdl)^^.right := g_XLong;
					RectHdl(MyRectHdl)^^.bottom := g_YLong;
					ChangedResource(MyRectHdl);
					WriteResource(MyRectHdl);
					HPurge(MyRectHdl);
					END;
			cancel :	;
			Format :	BEGIN
							GetDItem(GraphWPtr, Format, OptType, MyItemHdl, box);
							LocalToGlobal(box.TopLeft);
							MyPopUpItem := PopUpMenuSelect(FormatMenuHdl, box.top, box.left,
																										ord(nForm) + 1);
							IF (MyPopUpItem <> 0) THEN
								BEGIN
								CASE LoWord(MyPopUpItem) OF
									1 :	BEGIN
											nForm := UsForm;
											nXLong := uXLong;
											nYLong := uYLong;
											END;
									2 :	BEGIN
											nForm := StanForm;
											nXLong := g_XLongStand;
											nYLong := g_YLongStand;
											END;
									3 :	BEGIN
											nForm := VertForm;
											nXLong := g_XLongMaxV;
											nYLong := g_YLongMaxV;
											END;
									4 :	BEGIN
											nForm := HorForm;
											nXLong := g_XLongMaxH;
											nYLong := g_YLongMaxH;
											END;
									END;
								SetFormat;
								END;
							END;
			LargeX, LargeY :	BEGIN
										nForm := UsForm;
										SetPopUp;
										END;
			UnitPx :	BEGIN
							GetFormat;
							nUnit := PxUnit;
							SetFormat;
							SelIText(GraphWPtr, LargeX, 0, 32767);
							END;
			UnitCm :	BEGIN
							GetFormat;
							nUnit := CmUnit;
							SetFormat;
							SelIText(GraphWPtr, LargeX, 0, 32767);
							END;
			END;
	UNTIL (TheItem = OK) OR (TheItem = cancel);

	DeleteMenu(FormatMenu);
	ReleaseResource(handle(FormatMenuHdl));
	DisposDialog(GraphWPtr);
	SetPort(TempPort);

END; {***** SetUpGraphFormat *****1111111111111111111111111111111111111111111111111111}

END.