UNIT MG_minim;

INTERFACE

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf, PackIntf, MacPrint, SANE, ObjIntf,
	USLib_U1,
	MG_util, MG_points, MG_fonction;

CONST
	MG_MPar1 = MG_MPar + 1;

	MG_SetUpMinWDlgID = 1000;
	MG_SetUpMinimiDlgID = 1001;
	MG_WhenMinDlgID = 1007;

	MG_SetUpCreateurDlgID = 1011;
	MG_SetUpLsCrID = 269;

	MG_ListeStrID = 257;
	MG_ListeResStrID = 258;
	MG_ListeFcnStrID = 259;
	
TYPE
	MG_TPar = 1..MG_MPar;
	MG_TPar1 = 1..MG_MPar1;
	MG_ExPar = array[MG_TPar] of extended;
	MG_ExPar1 = array[MG_TPar1] of extended;
	MG_ExPPar1 = array[MG_TPar1, MG_TPar1] of extended;
	MG_TpMin = (NoChi2, YChi2, XYChi2);

VAR
	MG_MinScrollHdl : ControlHandle;
	MG_MyScroll, MG_NPEff : integer;
	MG_TypeMin : MG_TpMin;

FUNCTION DialogFilter (TheDialog : DialogPtr; var TheEvent : EventRecord; var ItemHit : integer) : boolean;
PROCEDURE MyDrawingProc(var page, index : integer; EOPage : integer);
PROCEDURE ImprimerFeuille;
FUNCTION SaveFeuille : boolean;
PROCEDURE SorInt (NSt : integer; theParamS : TParamS; AMin : extended);
PROCEDURE minimi (VAR theParamS : TParamS; stepp, epsi : extended; imp : integer; Errors : boolean;
							PROCEDURE FCN (VAR f : extended; theParamS : TParamS; print : boolean));
PROCEDURE SetUpMinimi(stand : boolean; VAR theParamS : TParamS;
							PROCEDURE FCN (VAR f : extended; theParamS : TParamS; print : boolean));

PROCEDURE SetUpCreateur(CreateurID : integer);

IMPLEMENTATION

{$S MG_minim }

FUNCTION DialogFilter; {111111111111111111111111111111111111111111111111111111111111111111}

VAR
	MyControl, PartCode : integer;
	MyControlHdl : controlHandle;
	c : point;

BEGIN
	DialogFilter := False;
	IF (TheEvent.what = MouseDown) THEN
		BEGIN
		c := TheEvent.where;
		GlobalToLocal(c);
		MyControl := FindControl(c, TheDialog, MyControlHdl);
		CASE MyControl OF
			InUpButton :	PartCode := trackControl(MyControlHdl, c, @ScrollUp);
			InDownButton :	PartCode := trackControl(MyControlHdl, c, @ScrollDown);
			InPageUp :	PageScroll(MyControlHdl, MyControl, -10);
			InPageDown :	PageScroll(MyControlHdl, MyControl, 10);
			InThumb :	BEGIN
							PartCode := trackControl(MyControlHdl, c, NIL);
							ScrollBits(MyControlHdl);
							END;
			END;
		END;
	
END; {***** DialogFilter *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE MyDrawingProc; {11111111111111111111111111111111111111111111111111111111111111}

VAR
	origine, CurLineStart : point;
	PackCharsHdl : CharsHandle;
	ThePackChars : Chars;
	IMax, DoPage, I, IM, J : integer;
	aString : STR255;
	
BEGIN
	SetUpFonts(monaco, 9);
	origine.h :=20;			{pour une marge de scurit}
	origine.v := MG_FAsc;		{pour commencer le plus haut possible sans tronquer}
	CurLineStart := origine;
	MoveTo(CurLineStart.h, CurLineStart.v);
	PackCharsHdl := TEGetText(MG_MinTextHdl);
	ThePackChars := PackCharsHdl^^;
	IMax := MG_MinTextHdl^^.TELength - 1;
	IF (index = 0) THEN
		BEGIN
		GetIndString(aString, MG_ListeResStrID, 1);			{on n'imprime que les rsultats}
		IM := length(aString);
		WHILE (index <= IMax) DO
			BEGIN
			J := 0;
			FOR I := 1 TO IM DO
				BEGIN
				IF (ThePackChars[index+I-1] <> aString[I]) THEN LEAVE;		{au suivant !}
				J := I;
				END;
			IF (J = IM) THEN LEAVE;		{c'est le bon !}
			index := index + 1;
			END;
		IF (page > 1) THEN														{on recherche la page}
			BEGIN
			DoPage := 1;
			WHILE ((index <= IMax) AND (DoPage < page)) DO
				IF (PrError = NoErr) THEN
					BEGIN
					IF (ThePackChars[index] = chr(13)) THEN
						BEGIN														{retour  la ligne}
						CurLineStart.v := CurLineStart.v + MG_HautLigne;
						IF (CurLineStart.v > EOPage) THEN
							BEGIN
							CurLineStart := origine;
							DoPage := DoPage + 1;
							END;
						END;
					index := index + 1;
					END;
				END;
		END;
	DoPage := page;
	WHILE ((index <= IMax) AND (DoPage = page)) DO
		IF (PrError = NoErr) THEN
			BEGIN
			IF (ThePackChars[index] = chr(13)) then
				BEGIN														{retour  la ligne}
				CurLineStart.v := CurLineStart.v + MG_HautLigne;
				IF (CurLineStart.v > EOPage) THEN DoPage := DoPage + 1
				ELSE MoveTo(CurLineStart.h, CurLineStart.v);
				END
			ELSE DrawChar(ThePackChars[index]);
			index := index + 1;
			END;
	IF (index > Imax) THEN DoPage := 129;
	page := DoPage
	
END; {***** MyDrawingProc *****1111111111111111111111111111111111111111111111111111111}

PROCEDURE ImprimerFeuille; {11111111111111111111111111111111111111111111111111111111111111}

VAR
	PrRecHdl : THPrint;
	UnPrRec : TPrint;				{bidon pour savoir la taille}
	MyPrPort : TPPrPort;
	TempPort : GrafPtr;
	MyStatusRec : TPrStatus;
	page, MinPage, MaxPage, index, EOPage : integer;
	
BEGIN
	PrOpen;
	PrRecHdl := THPrint(NewHandle(SizeOf(UnPrRec)));		{type coercion}
	IF (PrStlDialog(PrRecHdl) & PrJobDialog(PrRecHdl)) THEN
		BEGIN
		GetPort(TempPort);
		MyPrPort := PrOpenDoc(PrRecHdl, NIL, NIL);				{print GrafPort}
		MinPage := PrRecHdl^^.PrJob.IFstPage;
		MaxPage := PrRecHdl^^.PrJob.ILstPage;
		IF (MaxPage > 128) THEN MaxPage := 128;		{maximum autoris en une seule fois}
		page := MinPage;
		index := 0;
		EOPage := PrRecHdl^^.prInfo.rPage.bottom;
		WHILE page <= MaxPage DO				{le printing manager gre le nombre de copies}
			IF (PrError = NoErr) THEN
				BEGIN
				PrOpenPage(MyPrPort, NIL);
				IF (PrError = NoErr) THEN MyDrawingProc(page, index, EOPage);
				PrClosePage(MyPrPort);
				END;
		PrCloseDoc(MyPrPort);
		IF ((PrRecHdl^^.PrJob.BJDocLoop = BSpoolLoop) AND (PrError = NoErr)) THEN
			BEGIN
			{MySwapOutProc;}					{pas utile si on a de la place}
			PrPicFile(PrRecHdl, NIL, NIL, NIL, MyStatusRec);
			END;
		{IF (PrError <> NoErr) THEN MyPrErrAlertProc;}
		SetPort(TempPort);					{pour rcuprer aprs impression}
		END;
	DisposHandle(handle(PrRecHdl));		{type coercion}
	PrClose;

END; {***** ImprimerFeuille *****1111111111111111111111111111111111111111111111111111111}

FUNCTION SaveFeuille : boolean; {11111111111111111111111111111111111111111111111111111111111}

VAR
	where : point;
	reply : SFReply;
	MyOSErr : OSErr;
	MyFl : text;					{liste dclare en type texte}
	MFic, aString : STR255;
	p : integer;
	MyCrHdl : StringHandle;
	MyCreateur : OSType;

PROCEDURE MyWritingProc; {22222222222222222222222222222222222222222222222222222222222222}

VAR
	PackCharsHdl : CharsHandle;
	ThePackChars : Chars;
	index, IMax : integer;
	
BEGIN
	PackCharsHdl := TEGetText(MG_MinTextHdl);
	ThePackChars := PackCharsHdl^^;
	IMax := MG_MinTextHdl^^.TELength - 1;
	FOR index := 0 TO IMax DO
		IF (ThePackChars[index] = chr(13)) THEN writeln(MyFl)		{retour  la ligne}
		ELSE write(MyFl, ThePackChars[index]);
	
END; {***** MyWritingProc *****22222222222222222222222222222222222222222222222222222222}

BEGIN
	where.v := 180;
	where.h := 95;
	MFic := concat(MG_PbFic, '.L');
	GetIndString(aString, MG_IOStrID, 2);
	SFPutFile(where, aString, MFic, nil, reply);
	IF reply.good THEN
		BEGIN
		StartAnimatedCursor;	{SaveFeuille suppose que AnimatedCursor est initialis}
		MFic := GetPathName(reply.FName, reply.VRefNum);
		open(MyFl, MFic);
		rewrite(MyFl);
		
		MyWritingProc;
		
		MyCrHdl := GetString(MG_SetUpLsCrID);
		aString := MyCrHdl^^;
		FOR p := 1 TO 4 DO MyCreateur[p] := aString[p];
		
		SetCreaType(reply.FName, reply.VRefNum, 'TEXT', MyCreateur);			{on force le type et le crateur}
		close(MyFl);
		StopAnimatedCursor;
		END;
	SaveFeuille := reply.good;

END; {***** SaveFeuille *****11111111111111111111111111111111111111111111111111111111111}
		
PROCEDURE SorInt; {111111111111111111111111111111111111111111111111111111111111111111111}

VAR
	aString, bString : STR255;
	unParam : TParam;
	tempExt : extended;

BEGIN
	GetIndString(bString, MG_ListeStrID, 1);
	NumToString(NSt, aString);
	bString := TextParam(bString, aString, RealToString(AMin, 10), '', '');
	aString := concat(' ', chr(13), ' ', chr(13), bString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	unParam := theParamS.suivant;
	WHILE (unParam <> NIL) DO
		BEGIN
		bString := unParam.aN;
		tempExt := unParam.a;
		aString := concat(' ', chr(13), bString, ' : ', RealToString(tempExt, 10));
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		unParam := unParam.suivant;
		END;
	
END; {***** SorInt *****111111111111111111111111111111111111111111111111111111111111111}

PROCEDURE minimi; {111111111111111111111111111111111111111111111111111111111111111111111}

CONST
	al = 3.0;
	be = -0.4;
	NStepQ = 5;
	PrintButton = 3;
	ScrollBarre = 4;
	tab2 = 150;

VAR
	{pour affichage}
	TempPort : GrafPtr;
	MinWPtr : WindowPtr;
	MinTexte, EditRect, box : rect;
	aString, bString, cString : STR255;
	TextPixels, TheItem, OptType, confirmation : integer;
	MyItemHdl : handle;
	WhenMinDlg : DialogPtr;
	DoneModif : boolean;
	aParam : TParam;

	{pour minimiser}
	NPar : integer;
	x, wtt : MG_ExPar;
	wt, y : MG_ExPar;
	DirIn, d, p, s : MG_ExPar1;
	xs, et : MG_ExPPar1;
	e : array[1..2] of extended;
	impp, I, J, NEq, NFCN, NSt, NP, NP1, NPFN, JM, K, L, M : integer;
	ErrorsOK : boolean;
	AMin, step, f, a, avr, Y1, Y2, AM, av, ast, ame, dp : extended;
	ExitUser, ExitMin : boolean;
	yParamS : TParamS;
	unParam : TParam;

PROCEDURE SetUpMinWindow; {2222222222222222222222222222222222222222222222222222222222222}

{CONST}
	{PrintButton = 3;		dfini au niveau 1}
	{ScrollBarre = 4;		dfini au niveau 1}

VAR
	RefVal : longint;	{bidon pour transfert ventuel}

BEGIN
	GetPort(TempPort);
	MinWPtr := GetNewDialog(MG_SetUpMinWDlgID, nil, POINTER(-1));
	SetPort(MinWPtr);

	GetDItem(MinWPtr, ScrollBarre, OptType, MyItemHdl, box);	{scroll bar}
	MG_MinScrollHdl := NewControl(MinWPtr, box, 'vsb', true, 0, 0, 100, scrollBarProc + vAxisOnly, RefVal);
	MyItemHdl := Handle(MG_MinScrollHdl);		{pour transmettre l'accs au scroll pour FCN}
	SetDItem(MinWPtr, ScrollBarre, ctrlItem, MyItemHdl, box);

	MinTexte.top := box.top;
	MinTexte.left := 5;
	MinTexte.bottom := box.bottom;
	MinTexte.right := box.left + 1;
	EditRect.top := MinTexte.top + 2;
	EditRect.left := MinTexte.left + 2;
	EditRect.bottom := MinTexte.bottom - 2;
	EditRect.right := MinTexte.right - 2;
	MG_TheOrigine.h := 0;
	MG_TheOrigine.v := 0;
	FrameRect(MinTexte);
	SetUpFonts(monaco, 9);
	MG_MinTextHdl := TENew(EditRect, EditRect);
	GetIndString(aString, MG_ListeStrID, 2);
	TESetText(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	EraseRect(EditRect);
	TEUpdate(EditRect, MG_MinTextHdl);
	
END;{***** SetUpMinWindow *****2222222222222222222222222222222222222222222222222222222}

PROCEDURE RangerMinWindow; {222222222222222222222222222222222222222222222222222222222222}

BEGIN
	TEDispose(MG_MinTextHdl);
	DisposDialog(MinWPtr);
	SetPort(TempPort);

END; {***** RangerMinWindow *****222222222222222222222222222222222222222222222222222222}

PROCEDURE UpdateParamS (xy : MG_ExPar; VAR theParamS : TParamS); {22222222222222222222222222}

VAR
	unParam : TParam;
	i : integer;

BEGIN
	unParam := theParamS.suivant;
	i := 1;
	WHILE (unParam <> NIL) DO
		BEGIN
		unParam.a := xy[i];
		unParam := unParam.suivant;
		i := i+1;
		END;
	
END; {***** UpdateParamS *****22222222222222222222222222222222222222222222222222222222}

FUNCTION StopMinimi : boolean; {22222222222222222222222222222222222222222222222222222222222}

VAR
	TempPort : GrafPtr;
	Event : EventRecord;
	ProcessIt, Pause : boolean;
	MouseLoc : Point;
	WindowPointedTo : WindowPtr;
	ControlPointedTo : ControlHandle;
	WindowLoc, ControlLoc : integer;
	ItemType, ItemHit, ItemTest : integer;
	ItemBox : rect;
	ItemHdl : Handle;
	
BEGIN
		StopMinimi := false;
		GetPort(TempPort);
		Pause := false;
		REPEAT	
			ProcessIt := GetNextEvent(mDownMask, Event);
			IF ProcessIt then
				BEGIN
				MouseLoc := Event.Where;
				WindowLoc := FindWindow(MouseLoc, WindowPointedTo);
				IF (WindowLoc = InContent) then
					BEGIN
					IF (WindowPointedTo = WhenMinDlg) then
						BEGIN
						SetPort(WhenMinDlg);
						GlobalToLocal(MouseLoc);
						ControlLoc := FindControl(MouseLoc, WhenMinDlg, ControlPointedTo);
						IF (ControlLoc <> 0) then
							BEGIN
							ItemHit := 0;
							FOR ItemTest := 1 to 3 do
								BEGIN
								GetDItem(WhenMinDlg, ItemTest, ItemType, ItemHdl, ItemBox);
								IF (ControlHandle(ItemHdl) = ControlPointedTo) then ItemHit := ItemTest;
								END;
							CASE ItemHit of
								1 : BEGIN
									StopMinimi := true;
									Pause := false;
									END;
								2 : BEGIN
									GetDItem(WhenMinDlg, 1, ItemType, ItemHdl, ItemBox);
									HiliteControl(ControlHandle(ItemHdl), 0);
									GetDItem(WhenMinDlg, 2, ItemType, ItemHdl, ItemBox);
									HiliteControl(ControlHandle(ItemHdl), 255);
									GetDItem(WhenMinDlg, 3, ItemType, ItemHdl, ItemBox);
									HiliteControl(ControlHandle(ItemHdl), 0);
									Pause := true;
									END;
								3 : BEGIN
									GetDItem(WhenMinDlg, 1, ItemType, ItemHdl, ItemBox);
									HiliteControl(ControlHandle(ItemHdl), 255);
									GetDItem(WhenMinDlg, 2, ItemType, ItemHdl, ItemBox);
									HiliteControl(ControlHandle(ItemHdl), 0);
									GetDItem(WhenMinDlg, 3, ItemType, ItemHdl, ItemBox);
									HiliteControl(ControlHandle(ItemHdl), 255);
									Pause := false;
									END;
								END;
							END
						END
					ELSE SysBeep(3);
					END
				ELSE SysBeep(3);
				END;			
		UNTIL not Pause;
		SetPort(TempPort);
	
END; {***** StopMinimi *****22222222222222222222222222222222222222222222222222222222222}

PROCEDURE minimisation; {2222222222222222222222222222222222222222222222222222222222222222}

VAR
	I, J, K : integer;
	xn, dir : extended;

PROCEDURE serie; {3333333333333333333333333333333333333333333333333333333333333333333333}

VAR
	I, J : integer;

PROCEDURE descente; {4444444444444444444444444444444444444444444444444444444444444444444}

VAR
	NS1, NS2, NS3 : boolean;
	I, NStepD : integer;

BEGIN
	Y1 := 1.00;
	NS1 := false;
	NS2 := false;
	NS3 := false;
	NStepD := 0;
	d[J] := 0.00;
	REPEAT
		FOR I := 1 to NPar DO y[I] := x[I] + DirIn[J] * xs[J, I];
		
		UpdateParamS(y, yParamS);
		FCN(a, yParamS, false);
		
		NFCN := NFCN + 1;
		Y2 := AMin - a;
		IF (Y2 < 0.00) THEN
			BEGIN
			DirIn[J] := be * DirIn[J];
			NStepD := NStepD + 1;
			IF ((NS1 = true) or (NS3 = true)) THEN NS2 := true
			ELSE IF (NstepD >= NStepQ) THEN
				BEGIN
				Y1 := Y2;
				NS3 := true;
				END;
			END
		ELSE IF ((Y2 = 0.00) and (Y1 = 0.00)) THEN NS2 := true
		ELSE
			BEGIN
			AMin := a;
			Y1 := Y2;
			NS3 := false;
			NStepD := 0;
			NPFN := NFCN;
			FOR I := 1 TO NPar DO x[I] := y[I];
			d[J] := d[J] + DirIn[J];
			DirIn[J] := al * DirIn[J];
			NS1 := true;
			END;
	UNTIL NS2 = true;

END; {***** descente *****4444444444444444444444444444444444444444444444444444444444444}

PROCEDURE parabole (mieux : boolean); {444444444444444444444444444444444444444444444444444444}

VAR
	sss, stj : extended;
	I : integer;

BEGIN
	IF mieux THEN
		BEGIN
		sss := (al * al * Y1 + Y2) / (al * Y1 - Y2);
		stj := 0.5 * DirIn[J] * sss / (al * be);
		END
	ELSE
		BEGIN
		sss := (be * be * Y1 - Y2) / (be * Y1 - Y2);
		stj := 0.5 * DirIn[J] * sss / (be * be);
		END;
	IF (stj <> 0.00) THEN
		BEGIN
		FOR I := 1 to NPar DO y[I] := x[I] + stj * xs[J, I];
		
		UpdateParamS(y, yParamS);
		FCN(a, yParamS, false);
		
		NFCN := NFCN + 1;
		IF (a < AMin) THEN
			BEGIN
			AMin := a;
			NPFN := NFCN;
			FOR I := 1 to NPar DO x[I] := y[I];
			d[J] := d[J] + stj;
			END;
		END;
	
END; {***** parabole *****4444444444444444444444444444444444444444444444444444444444444}

BEGIN
	AM := 0.00;
	JM := 0;
	FOR J := 1 to NP1 DO
		BEGIN
		descente;
		IF ((Y1 < 0.00) and (Y2 < 0.00)) THEN parabole(false)
		ELSE IF not ((Y1 = 0.00) and (Y2 = 0.00)) THEN parabole(true);
		NSt := NSt + 1;
		av := avr - AMin;
		avr := AMin;
		IF (J < 2) THEN ast := AMin
		ELSE IF (av > AM) THEN
			BEGIN
			AM := av;
			JM := J;
			END;
		IF StopMinimi THEN
			BEGIN
			GetIndString(aString, MG_ListeStrID, 3);
			aString := concat(' ', chr(13), ' ', chr(13), aString, RealToString(AMin, 10));
			TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
			GetIndString(bString, MG_ListeStrID, 4);
			NumToString(NSt, aString);
			bString := TextParam(bString, aString, '', '', '');
			aString := concat(' ', chr(13), bString);
			TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
			
			ExitUser := true;
			ExitMin := true;
			EXIT(minimisation);				{exit : sortie de minimisation pour fin du run}
			
			END;
		IF (NSt mod impp = 0) THEN
			BEGIN

			UpdateParamS(x, theParamS);
			SorInt(NSt, theParamS, AMin);
			
			MG_MyScroll := MG_HautLigne * (NPar + 2) DIV 4;
			GetDItem(MinWPtr, ScrollBarre, OptType, MyItemHdl, box);
			SetCtlMax(ControlHandle(MyItemHdl), GetCtlMax(ControlHandle(MyItemHdl)) + MG_MyScroll);
			SetCtlValue(ControlHandle(MyItemHdl), GetCtlValue(ControlHandle(MyItemHdl)) + MG_MyScroll);
			ScrollBits(ControlHandle(MyItemHdl)); {ajouter de la place et avancer la scroll barre}
			END;
		END;{*****la serie est terminee, on agite les mains... }

END; {***** serie *****333333333333333333333333333333333333333333333333333333333333333}

BEGIN
	FOR I := 1 to NPar DO xs[NP1, I] := xs[1, I];
	DirIn[NP1] := DirIn[1];
	
	serie;{*****serie de NP1 steps, au travail !}

	ame := AMin - ast;
	IF (ame >= 0.00) THEN
		BEGIN
		GetIndString(aString, MG_ListeStrID, 5);
		aString := concat(' ', chr(13), ' ', chr(13), aString, RealToString(AMin, 10));
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		GetIndString(aString, MG_ListeStrID, 6);
		aString := concat(' ', chr(13), aString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		
		ExitMin := true;
		EXIT(minimisation);			{exit : sortie de minimisation pour fin du run}
		
		END;
	IF (epsi + ame < 0.00) THEN NEQ := -1;
	NEQ := NEQ + 1;
	IF (NEQ >= NStepQ) THEN
		BEGIN
		GetIndString(aString, MG_ListeStrID, 5);
		aString := concat(' ', chr(13), ' ', chr(13), aString, RealToString(AMin, 10));
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		GetIndString(bString, MG_ListeStrID, 7);
		NumToString(NStepQ, aString);
		bString := TextParam(bString, RealToString(epsi, 10), aString, '', '');
		aString := concat(' ', chr(13), ' ', chr(13), bString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	
		ExitMin := true;
		EXIT(minimisation);			{exit : sortie de minimisation pour fin du run}
		
		END;
	FOR K := 1 to NPar DO
		BEGIN
		p[K] := 0.00;
		FOR I := 2 to NP1 do p[K] := p[K] + d[I] * xs[I, K];
		END;
	dp := 1.00;
	FOR I := 1 to NPar DO y[I] := x[I] + p[I];

	UpdateParamS(y, yParamS);
	FCN(a, yParamS, false);

	NFCN := NFCN + 1;
	WHILE (a < AMin) DO
		BEGIN
		AMin := a;
		dp := 2.00 * dp;
		FOR I := 1 to NPar DO
			BEGIN
			x[I] := y[I];
			p[I] := 2.00 * p[I];
			y[I] := x[I] + p[I];
			END;

		UpdateParamS(y, yParamS);
		FCN(a, yParamS, false);

		NFCN := NFCN + 1;
		END;
	dp := (a + ast - 2.00 * AMin) / (2.00 * dp * dp);
	IF (dp <= am) THEN
		BEGIN
		IF (JM <= NP) THEN
			BEGIN
			FOR I := JM to NP DO
				BEGIN
				s[I] := s[I + 1];
				DirIn[I] := DirIn[I + 1];
				FOR J := 1 to NPar DO xs[I, J] := xs[I + 1, J];
				END;
			END;
		xn := 0.00;
		FOR K := 1 to NPar DO
			BEGIN
			xs[1, K] := p[K];
			xn := xn + xs[1, K] * xs[1, K];
			END;
		dir := sqrt(xn);
		DirIn[1] := dir;
		s[NP1] := 2.00 * dp;
		FOR K := 1 to NPar DO xs[1, K] := xs[1, K] / dir;
		END;{*****Retour au debut, et on recommence...}

END; {***** minimisation *****2222222222222222222222222222222222222222222222222222222222}

PROCEDURE erreurs; {22222222222222222222222222222222222222222222222222222222222222222222}

LABEL
	3560, 3590;

VAR
	I, J, K, L, M, NStepC : integer;
	ytemp : extended;		{pour aider le pauvre compilateur qui patine dans la choucroute}

BEGIN
	GetIndString(aString, MG_ListeStrID, 8);
	aString := concat(' ', chr(13), ' ', chr(13), aString, RealToString(AMin, 10));
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);

	s[1] := s[NP1];		{*****Calcul d'erreurs sans derivees (on fait ce qu'on peut)}
	FOR I := 1 to NP DO
		BEGIN
		IF (s[I] <= 0.00) THEN p[I] := 0.01			{en fonction des donnes accessibles...
		ELSE p[I] := 1.00 / sqrt(s[I]);
		IF (p[I] = 0.00) THEN p[I] := 0.0001; 		{...on initialise comme on peut}
		END;
	FOR L := 1 to 2 DO			{trait deux fois pour raffiner (pas plus : le processus converge rapidement)}
		BEGIN

3560 :	;

		FOR I := 1 to NP DO		{pour chacun des paramtres ajusts}
			BEGIN
			NStepC := 0;
			REPEAT

3590 :	;

				IF StopMinimi THEN
					BEGIN
					GetIndString(aString, MG_ListeStrID, 9);
					aString := concat(' ', chr(13), ' ', chr(13), aString);
					TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
					ExitUser := true;			{abandon... gnralement pour cause de cycle douteux}
					EXIT(erreurs);
					END;
				FOR K := 1 to 2 DO		{on teste de chaque ct pour estimer  f  AMin + p^2/(2*sigma^2)}
					BEGIN
					FOR J := 1 to NPar DO
						BEGIN
						ytemp := p[I] * xs[I, J];		{pour aider le pauvre compilateur...}
						y[J] := x[J] + ytemp;			{...qui patauge dans la choucroute}
						END;

					UpdateParamS(y, yParamS);
					FCN(f, yParamS, false);
					
					IF (f = +INF) THEN			{on est trop loign, semble-t-il...}
						BEGIN
						p[I] := be * p[I];
						GOTO 3590;	{***** testez  nouveau SVP}
						END
					ELSE IF (f > AMin) THEN
						BEGIN			{le test semble correct de ce ct}
						p[I] := -p[I];
						e[K] := f;
						END
					ELSE IF (f < AMin) THEN
						BEGIN			{on a trouv mieux (par hasard...) ; on recentre et on repart}
						FOR J := 1 to NPar DO x[J] := y[J];
						p[I] := al * p[I];
						AMin := f;
						GOTO 3560;	{*****Redemarrage  chaud}
						END
					ELSE IF (f = AMin) THEN
						BEGIN			{c'est plat, ou bien le pas est trop petit ; on va essayer plus loin}						
						NStepC := NStepC + 1;
						IF ((p[I] = 0.00) OR (NStepC > 5)) THEN p[I] := 0.0001	{viter une multiplication illusoire}
						ELSE p[I] := p[I] * (al ** NStepC);		{sans () TML foire la priorit !}
						GOTO 3590	{***** testez  nouveau SVP}
						END
					ELSE
						BEGIN			{a semble une espce de NAN}
						sysbeep(1);		{petit signal... pour reprer les cycles parasites}
						p[I] := be * p[I];
						GOTO 3590	{***** testez  nouveau SVP}
						END;
					END;
				s[I] := (e[1] + e[2] - 2.00 * AMin) / (p[I] * p[I]);
			UNTIL (s[I] > 0.00);
			s[I] := 1.00 / s[I];			{s  sigma^2  pour les paramtres ajusts}
			p[I] := sqrt(s[I]);
			END;
		END;
	FOR L := 1 to NPar DO
		FOR M := L to NPar DO
			BEGIN
			et[L, M] := 0.00;
			FOR I := 1 to NP DO et[L, M] := et[L, M] + xs[I, L] * xs[I, M] * s[I];
			et[L, M] := 2*et[L, M];
			et[M, L] := et[L, M];			{et  sigma^2  pour les paramtres rels}
			END;	{*****Calcul d'erreurs avec ou sans drives}
	FOR I := 1 to NPar DO
		BEGIN
		p[I] := 0.00;
		IF (et[I, I] > 0.00) THEN p[I] := sqrt(et[I, I]);
		END;
	ErrorsOK := True;

END;{***** erreurs *****22222222222222222222222222222222222222222222222222222222222222}

BEGIN
	StartAnimatedCursor;	{minimi suppose que AnimatedCursor est initialis}
	
	NPar := theParamS.compte;			{bidouille pour raccorder sans douleur}
	unParam := theParamS.suivant;
	FOR I := 1 to NPar DO
		BEGIN
		x[I] := unParam.a;
		wtt[I] := unParam.w;
		unParam := unParam.suivant;
		END;
	
	SetUpMinWindow;	{minimi suppose que QuickDraw, Fonts, Windows, Menus, TEdit et Dialogs sont initialiss}
	NumToString(NPar, aString);
	TextPixels := StringWidth(aString);
	GetIndString(bString, MG_ListeStrID, 10);
	aString := concat(' ', chr(13), ' ', chr(13), AjusteLongueur(bString, 200 - TextPixels, true), aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	NumToString(MG_NPEff, aString);
	TextPixels := StringWidth(aString);
	GetIndString(bString, MG_ListeStrID, 11);
	aString := concat(' ', chr(13), AjusteLongueur(bString, 200 - TextPixels, true), aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	aString := RealToString(stepp, 4);
	TextPixels := StringWidth(aString);
	GetIndString(bString, MG_ListeStrID, 12);
	aString := concat(' ', chr(13), AjusteLongueur(bString, 200 - TextPixels, true), aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	aString := RealToString(epsi, 4);
	TextPixels := StringWidth(aString);
	GetIndString(bString, MG_ListeStrID, 13);
	aString := concat(' ', chr(13), AjusteLongueur(bString, 200 - TextPixels, true), aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	IF Errors THEN
		BEGIN
		GetIndString(aString, MG_ListeStrID, 14);
		aString := concat(' ', chr(13), aString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		END;
	impp := imp;
	step := stepp;
	FOR I := 1 to NPar DO
		BEGIN
		wt[I] := wtt[I];
		DirIn[I] := wt[I];
		END;
	yParamS := TParamS(theParams.clone);
	
	NEq := 0;					{*****Initialisation, premier appel de FCN}
	GetIndString(aString, MG_ListeStrID, 15);
	TextPixels := StringWidth(aString);
	GetIndString(bString, MG_ListeStrID, 16);
	aString := concat(' ', chr(13), ' ', chr(13), AjusteLongueur(bString, 200 - TextPixels, true), aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	
	unParam := theParamS.suivant;			{bidouille "temporaire" (?) pour raccorder sans douleur}
	FOR I := 1 to NPar DO
		BEGIN
		aString := unParam.aN;
		bString := RealToString(wt[I], 5);
		TextPixels := StringWidth(bString);
		aString := concat(' ', chr(13), AjusteLongueur(concat(aString, ' : ', RealToString(x[I], 10)),
																				200 - TextPixels, true), bString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		unParam := unParam.suivant;
		END;
		
	UpdateParamS(x, theParamS);
	FCN(AMin, theParamS, false);
	
	GetIndString(aString, MG_ListeStrID, 17);
	aString := concat(' ', chr(13), ' ', chr(13), aString, RealToString(AMin, 10));
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	NFCN := 1;
	NPFN := NFCN;
	f := AMin;
	a := AMin;
	NSt := 0;
	avr := AMin;
	NP := 0;
	FOR I := 1 to NPar DO
		IF (wt[I] <> 0) THEN
			BEGIN
			NP := NP + 1;
			FOR J := 1 to NPar DO xs[NP, J] := 0.00;
			s[NP] := 0.00;
			xs[NP, I] := 1.00;
			IF (DirIn[I] = 0) THEN DirIn[I] := wt[I];
			DirIn[NP] := DirIn[I] * step;
			END;
	NP1 := NP + 1;			{NP = MG_NPEff  qui a dj t calcul dans SetUpMinimi...}
	s[NP1] := 0.00;		{...mais on laisse NP pour faciliter la compatibilit avec d'autres versions}
	
	ExitUser := false;
	ExitMin := false;
	WhenMinDlg := GetNewDialog(MG_WhenMinDlgID, nil, POINTER(-1));		{minimisation en cours}
	GetDItem(WhenMinDlg, 1, OptType, MyItemHdl, box);
	HiliteControl(ControlHandle(MyItemHdl), 255);
	GetDItem(WhenMinDlg, 3, OptType, MyItemHdl, box);
	HiliteControl(ControlHandle(MyItemHdl), 255);
	
	WHILE  NOT ExitMin DO minimisation;		{*****Debut du voyage, on y est pour un bout de temps...}
	
	GetDItem(MinWPtr, ScrollBarre, OptType, MyItemHdl, box);
	SetCtlMax(ControlHandle(MyItemHdl), GetCtlMax(ControlHandle(MyItemHdl)) + 20);
	SetCtlValue(ControlHandle(MyItemHdl), GetCtlValue(ControlHandle(MyItemHdl)) + 20);
	ScrollBits(ControlHandle(MyItemHdl)); {ajouter de la place et avancer la scroll barre}
	
	ErrorsOK := False;	{*****Minimisation terminee}
	IF (Errors AND NOT ExitUser AND (NST >= NPar * MG_NPEff)) THEN erreurs;
	
	DisposDialog(WhenMinDlg);
	FrameRect(MinTexte);			{UpDate du texte  la main}
	EraseRect(EditRect);
	TEUpdate(EditRect, MG_MinTextHdl);
	
	{*****Encore quelques impressions avant d'aller se coucher (la journee a t dure)}
	GetIndString(aString, MG_ListeResStrID, 1);
	aString := concat(' ', chr(13), ' ', chr(13), aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	GetIndString(bString, MG_ListeResStrID, 2);
	bString := TextParam(bString, RealToString(AMin, 10), '', '', '');
	NumToString(NPFN, aString);
	aString := concat(' ', chr(13), ' ', chr(13), bString, aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	IF NOT ErrorsOK THEN
		BEGIN
		GetIndString(aString, MG_ListeResStrID, 3);
		aString := concat(' ', chr(13), ' ', chr(13), aString);
		IF Errors THEN
			BEGIN
			IF ExitUser THEN GetIndString(bString, MG_ListeResStrID, 4)
			ELSE GetIndString(bString, MG_ListeResStrID, 5);
			aString := concat(aString, bString);
			END;
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);

		unParam := theParamS.suivant;			{bidouille "temporaire" (?) pour raccorder sans douleur}
		FOR I := 1 to NPar DO
			BEGIN
			bString := unParam.aN;
			aString := concat(' ', chr(13), bString, ' : ', RealToString(x[I], 10));
			TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
			unParam := unParam.suivant;
			END;

		END
	ELSE
		BEGIN
		GetIndString(aString, MG_ListeResStrID, 3);
		aString := concat(' ', chr(13), ' ', chr(13), AjusteLongueur(aString, tab2, true));
		GetIndString(bString, MG_ListeResStrID, 6);
		aString := concat(aString, bString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);

		unParam := theParamS.suivant;			{bidouille "temporaire" (?) pour raccorder sans douleur}
		FOR I := 1 TO NPar DO
			BEGIN
			bString := unParam.aN;
			aString := RealToString(p[I], 10);
			aString := concat(' ', chr(13), AjusteLongueur(concat(bString, ' : ', RealToString(x[I], 10)),
																													tab2, true), ' ', aString);
			TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);

			aParam := theParamS.suivant;			{bidouille "temporaire" (?) pour raccorder sans douleur}
			FOR J := 1 TO (I-1) DO
				BEGIN
				GetIndString(aString, MG_ListeResStrID, 7);
				cString := aParam.aN;
				aString := TextParam(aString, bString, cString, '', '');
				cString := RealToString(et[I, J], 10);
				aString := concat(' ', chr(13), aString, cString);
				TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
				aParam := aParam.suivant;
				END;
			unParam := unParam.suivant;
			END;
		END;
	GetIndString(bString, MG_ListeResStrID, 8);
	NumToString(NFCN, aString);
	bString := TextParam(bString, aString, '', '', '');
	NumToString(NST, aString);
	aString := concat(' ', chr(13), ' ', chr(13), bString, aString);
	TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
	MG_MyScroll := MG_HautLigne * (NPar + 2) DIV 4;
	GetDItem(MinWPtr, ScrollBarre, OptType, MyItemHdl, box);
	SetCtlMax(ControlHandle(MyItemHdl), GetCtlMax(ControlHandle(MyItemHdl)) + MG_MyScroll);
	SetCtlValue(ControlHandle(MyItemHdl), GetCtlValue(ControlHandle(MyItemHdl)) + MG_MyScroll);
	ScrollBits(ControlHandle(MyItemHdl)); {ajouter de la place et avancer la scroll barre}
	
	UpdateParamS(x, theParamS);
	FCN(AMin, theParamS, true);	{*****C'est fini, bonsoir...}
 
 	StopAnimatedCursor;	
	DoneModif := true;
	FlushEvents(mDownMask+mUpMask,0);
    	REPEAT
		ModalDialog(@DialogFilter, TheItem);
		CASE TheItem OF
			OK : DoneModif := NOT SaveFeuille;
			cancel : IF DoneModif THEN
							BEGIN
							confirmation := CautionAlert(MG_QuitSansSaveAlrtID, nil);
							CASE confirmation OF
								1 : DoneModif := false;						{on quitte}
								2 : DoneModif := NOT SaveFeuille;		{on enregistre et on quitte}
								3 : ;													{sortie annule}
								END;
							END;
			PrintButton :	ImprimerFeuille;
			END;
		FrameRect(MinTexte);			{UpDate du texte  la main}
		EraseRect(EditRect);
		TEUpdate(EditRect, MG_MinTextHdl);
		UNTIL ((TheItem = Cancel) AND NOT DoneModif);
	RangerMinWindow;
	yParamS.free;
 
END; {***** minimi *****11111111111111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpMinimi; {1111111111111111111111111111111111111111111111111111111111111111}

CONST
	Standard = 3;
	PasGlobal = 5;
	Precision = 7;
	Impression = 9;
	X2No = 11;
	X2Y = 12;
	X2XY = 13;
	Erreurs = 14;

VAR
    stepp, epsi : extended;
	imp : integer;
	Errors : boolean;
	TypeMin : MG_TpMin;
	TempPort : GrafPtr;
	MinWPtr : DialogPtr;
	box : rect;
	k, TheItem, OptType : integer;
	DoMin : boolean;
	MyItemHdl : handle;
	aString : STR255;
	aLong : longint;
	
PROCEDURE SetStand; {2222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	stepp := 1.0;
	epsi := 0.0001;
	imp := MG_NPEff+1;
	IF MG_withDX THEN MG_TypeMin := XYchi2 ELSE MG_TypeMin := Ychi2;
	TypeMin := MG_TypeMin;
	Errors := (TypeMin <> NoChi2);

END; {***** SetStand *****2222222222222222222222222222222222222222222222222222222222222}

PROCEDURE ShowStand; {222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetDItem(MinWPtr, PasGlobal, OptType, MyItemHdl, box);
	aString := RealToString(stepp, -2);
	SetIText(MyItemHdl, aString);
	GetDItem(MinWPtr, Precision, OptType, MyItemHdl, box);
	aString := RealToString(epsi, -2);
	SetIText(MyItemHdl, aString);
	GetDItem(MinWPtr, Impression, OptType, MyItemHdl, box);
	NumToString(imp, aString);
	SetIText(MyItemHdl, aString);
	GetDItem(MinWPtr, Erreurs, OptType, MyItemHdl, box);
	SetCtlValue(ControlHandle(MyItemHdl), ord(Errors));
	IF (TypeMin = NoChi2) THEN HiliteControl(ControlHandle(MyItemHdl), CntlDisable);
	GetDItem(MinWPtr, X2No, OptType, MyItemHdl, box);
	SetCtlValue(ControlHandle(MyItemHdl), ord(TypeMin = NoChi2));
	GetDItem(MinWPtr, X2Y, OptType, MyItemHdl, box);
	SetCtlValue(ControlHandle(MyItemHdl), ord(TypeMin = YChi2));
	GetDItem(MinWPtr, X2XY, OptType, MyItemHdl, box);
	SetCtlValue(ControlHandle(MyItemHdl), ord(TypeMin = XYChi2));
	IF NOT MG_withDX THEN HiliteControl(ControlHandle(MyItemHdl), CntlDisable);

END; {***** ShowStand *****22222222222222222222222222222222222222222222222222222222222}

BEGIN
	MG_NPEff := theParamS.ComptEff;
	SetStand;
	IF stand THEN DoMin := true
	ELSE
		BEGIN
		GetPort(TempPort);
		MinWPtr := GetNewDialog(MG_SetUpMinimiDlgID, nil, POINTER(-1));
		SetPort(MinWPtr);
		ShowStand;
		DoMin := false;
		InitCursor;
		FlushEvents(mDownMask+mUpMask,0);
		REPEAT
			ModalDialog(@FilterForDialog, TheItem);
			CASE TheItem OF
				OK :	DoMin := true;
				cancel :	;
				Standard :	BEGIN
								SetStand;
								ShowStand;
								END;
				X2No :	BEGIN
							TypeMin := NoChi2;
							GetDItem(MinWPtr, X2No, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							GetDItem(MinWPtr, X2Y, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							GetDItem(MinWPtr, X2XY, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							Errors := false;
							GetDItem(MinWPtr, Erreurs, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							HiliteControl(ControlHandle(MyItemHdl), CntlDisable);
							END;
				X2Y :	BEGIN
							TypeMin := YChi2;
							GetDItem(MinWPtr, X2No, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							GetDItem(MinWPtr, X2Y, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							GetDItem(MinWPtr, X2XY, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							Errors := true;
							GetDItem(MinWPtr, Erreurs, OptType, MyItemHdl, box);
							HiliteControl(ControlHandle(MyItemHdl), CntlEnable);
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							END;
				X2XY :	BEGIN
							TypeMin := XYChi2;
							GetDItem(MinWPtr, X2No, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							GetDItem(MinWPtr, X2Y, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							GetDItem(MinWPtr, X2XY, OptType, MyItemHdl, box);
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							Errors := true;
							GetDItem(MinWPtr, Erreurs, OptType, MyItemHdl, box);
							HiliteControl(ControlHandle(MyItemHdl), CntlEnable);
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							END;
				Erreurs :	BEGIN
								Errors := NOT Errors;
								GetDItem(MinWPtr, Erreurs, OptType, MyItemHdl, box);
								SetCtlValue(ControlHandle(MyItemHdl), ord(Errors));
								END;
				END;
		UNTIL (TheItem = OK) OR (TheItem = cancel);
		
		GetDItem(MinWPtr, PasGlobal, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		stepp := StringToReal(aString);
		GetDItem(MinWPtr, Precision, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		epsi := abs(StringToReal(aString));
		GetDItem(MinWPtr, Impression, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		StringToNum(aString, aLong);
		imp := abs(aLong);
	
		DisposDialog(MinWPtr);
		SetPort(TempPort);
	END;

	IF DoMin THEN
		BEGIN
		MG_TypeMin := TypeMin;			{pour transmettre  FCN}
		minimi(theParamS,	{parametres, pas relatifs}
					stepp,			{taille globale d'un pas}
					epsi,				{prcision}
					imp,				{impression tous les n pas : une  chaque tape}
					Errors,			{estimation des erreurs}
					FCN);			{pour transmettre la fonction}
		END;

END; {***** SetUpMinimi *****1111111111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpCreateur; {111111111111111111111111111111111111111111111111111111111111111}

CONST
	theCreateur = 4;
	AutreCreateur = 5;

VAR
	TempPort : GrafPtr;
	CrWPtr : DialogPtr;
	box : rect;
	TheItem, OptType : integer;
	MyItemHdl : handle;
	aString, theUString, theNString : STR255;
	MyPopUpItem : longint;
	CrMenuHdl : MenuHandle;
	MyCrHdl : StringHandle;
	MyCrItem : integer;

PROCEDURE SetPopUp; {2222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetItem(CrMenuHdl, MyCrItem, aString);
	GetDItem(CrWPtr, theCreateur, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, concat(' ', aString, ' : '));

END; {***** SetPopUp *****222222222222222222222222222222222222222222222222222222222222}

PROCEDURE SetCr; {222222222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetDItem(CrWPtr, AutreCreateur, OptType, MyItemHdl, box);
	SetIText(MyItemHdl, theNString);
	SetPopUp;

END; {***** SetCr *****222222222222222222222222222222222222222222222222222222222222222}

BEGIN
	GetPort(TempPort);
	CrWPtr := GetNewDialog(MG_SetUpCreateurDlgID, nil, POINTER(-1));
	SetPort(CrWPtr);
	GetDItem(CrWPtr, theCreateur, OptType, MyItemHdl, box);				{le crateur}
	FramePopUp(box);
	CrMenuHdl := GetMenu(CreateurID);
	InsertMenu(CrMenuHdl, -1);
	
	MyCrHdl := GetString(CreateurID);			{crateur usuel demand par dfaut}
	theUString := MyCrHdl^^;
	theNString := theUString;
	MyCrItem := 1;
	
	SetCr;
	SelIText(CrWPtr, AutreCreateur, 0, 32767);
	
	FlushEvents(mDownMask+mUpMask, 0);
	REPEAT
		ModalDialog(@FilterForDialog, TheItem);
		CASE TheItem OF
			OK :	BEGIN
					GetDItem(CrWPtr, AutreCreateur, OptType, MyItemHdl, box);
					GetIText(MyItemHdl, theNString);
					REPEAT																							{on force 4 caractres}
						IF (length(theNString) >= 4) THEN LEAVE;
						theNString := concat(theNString, ' ');
					UNTIL FALSE;
					MyCrHdl := GetString(CreateurID);
					HNoPurge(handle(MyCrHdl));
					SetString(MyCrHdl, copy(theNString, 1, 4));									{4 premiers caractres}
					ChangedResource(handle(MyCrHdl));
					WriteResource(handle(MyCrHdl));
					HPurge(handle(MyCrHdl));
					END;
				cancel : ;
				theCreateur :	BEGIN
										GetDItem(CrWPtr, theCreateur, OptType, MyItemHdl, box);
										LocalToGlobal(box.TopLeft);
										MyPopUpItem := PopUpMenuSelect(CrMenuHdl, box.top, box.left, MyCrItem);
										IF (MyPopUpItem <>0) THEN
											BEGIN
											MyCrItem := LoWord(MyPopUpItem);
											theNString := theUString;
											IF (MyCrItem > 1) THEN GetIndString(theNString, CreateurID, MyCrItem-1);
											SetCr;
											END;
										END;
				AutreCreateur :	BEGIN
											MyCrItem := 1;
											SetPopUp;
											END;
				END;
		UNTIL (TheItem = OK) OR (TheItem = cancel);
		
		DeleteMenu(CreateurID);
		ReleaseResource(handle(CrMenuHdl));
		DisposDialog(CrWPtr);
		SetPort(TempPort);

END; {***** SetUpCreateur *****111111111111111111111111111111111111111111111111111111111}

END.