UNIT MG_points;

INTERFACE

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf, PackIntf, SANE, ObjIntf,
	USLib_U1,
	MG_util;

CONST
	MG_SetUpPointsDlgID = 1004;
	MG_MyListVDlgID = 1006;

	RefSansDxyStopID = 263;
	MG_LireValeursAlrtID = 1101;
	MG_QuitSansSaveAlrtID = 1102;

	MG_IOStrID = 256;

	MG_LogMin = 1E-4000;		{pour chelle logarithmique}

	MG_ForX = true;					{pour slecteur XouY}
	MG_ForY = false;

TYPE
	MG_TNames = array[1..6] of STR255;

	TPointS = OBJECT(TObject)
		suivant : TPoint;
		PROCEDURE free; OVERRIDE;
		FUNCTION clone : TObject; OVERRIDE;
		FUNCTION compte : integer;
		PROCEDURE extension (nombre : integer);
		PROCEDURE Sequence (XorY : boolean; Deb, Pas : extended);
		PROCEDURE DRacine (XorY : boolean);
		PROCEDURE DPourcent (XorY : boolean; ValD : extended);
		PROCEDURE DPlusPourcent (XorY : boolean; ValD : extended);
		PROCEDURE DConstante (XorY : boolean; ValD : extended);
		PROCEDURE DPlusConstante (XorY : boolean; ValD : extended);
		PROCEDURE DFoisConstante (XorY : boolean; ValD : extended);
		PROCEDURE Logarithme (XorY : boolean);
		PROCEDURE PolToCart;
		END;
	TPoint = OBJECT(TPointS)
		x, y, dx, dy : extended;
		FUNCTION compte : integer; OVERRIDE;
		PROCEDURE Sequence (XorY : boolean; Deb, Pas : extended); OVERRIDE;
		PROCEDURE DRacine (XorY : boolean); OVERRIDE;
		PROCEDURE DPourcent (XorY : boolean; ValD : extended); OVERRIDE;
		PROCEDURE DPlusPourcent (XorY : boolean; ValD : extended); OVERRIDE;
		PROCEDURE DConstante (XorY : boolean; ValD : extended); OVERRIDE;
		PROCEDURE DPlusConstante (XorY : boolean; ValD : extended); OVERRIDE;
		PROCEDURE DFoisConstante (XorY : boolean; ValD : extended); OVERRIDE;
		PROCEDURE Logarithme (XorY : boolean); OVERRIDE;
		PROCEDURE PolToCart; OVERRIDE;
		END;

VAR
	MG_thePointS : TPointS;
	MG_ClockCursor : Cursor;
	MG_MyCell : point;
	MG_MyListHdl : ListHandle;
	MG_TheTexte : STR255;
	MG_InEdit : boolean;
	MG_filtre : boolean;					{filtre pour les nombres}
	MG_PbFic : STR255;					{nom du problme en cours}
	MG_DoneModif : boolean;			{indicateur de sauvegarde}
	MG_xN, MG_yN : STR255;
	MG_withDx, MG_withDy : boolean;

PROCEDURE PutMessage (m : STR255; r : rect);
PROCEDURE LireListe (VAR DFic : STR255);
PROCEDURE FermeTexte (theDialog : DialogPtr; filtre : boolean);
PROCEDURE LSetRow (theRow : integer; theSet : extended; filtre : boolean);
FUNCTION SaveListe (DFic : STR255; theDialog : DialogPtr) : boolean;
FUNCTION ListeFilter (theDialog : DialogPtr; VAR theEvent : EventRecord; VAR itemHit : integer) : boolean;
FUNCTION ListeValeurs (names : MG_TNames; VAR thePointS : TPointS) : boolean;
PROCEDURE SetUpPoints (AsSet : boolean; VAR thePointS : TPointS);

IMPLEMENTATION

{$S MG_points }

PROCEDURE TPointS.free; {111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.free;
	INHERITED free;

END; {***** TPointS.free *****11111111111111111111111111111111111111111111111111111111}

FUNCTION TPointS.clone; {111111111111111111111111111111111111111111111111111111111111111}

VAR
	unPointS : TPointS;

BEGIN
	unPointS := TPointS(INHERITED clone);
	IF (suivant <> NIL) THEN unPointS.suivant := TPoint(suivant.clone);
	clone := unPointS;

END; {***** TPointS.clone *****11111111111111111111111111111111111111111111111111111111}

FUNCTION TPointS.compte; {11111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant = NIL) THEN compte := 0 ELSE compte := suivant.compte;

END; {***** TPointS.compte *****111111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.extension; {11111111111111111111111111111111111111111111111111111111111}

VAR
	unPoint : TPoint;

BEGIN
	IF (nombre <= 0) THEN
		BEGIN
		IF (suivant <> NIL) THEN
			BEGIN
			suivant.free;
			suivant := NIL;
			END;
		END
	ELSE
		BEGIN
		IF (suivant = NIL) THEN			{on ajoute}
			BEGIN
			new(unPoint);
			unPoint.suivant := NIL;
			unPoint.x := 0;
			unPoint.y := 0;
			unPoint.dx := 0;
			unPoint.dy := 0;
			suivant := unPoint;
			END;
		suivant.extension(nombre - 1);
		END;

END; {***** TPointS.extension *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.Sequence; {11111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.Sequence(XorY, Deb, Pas);

END; {***** TPointS.Sequence *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.DRacine; {111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.DRacine(XorY);

END; {***** TPointS.DRacine *****1111111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.DPourcent; {11111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.DPourcent(XorY, ValD);

END; {***** TPointS.DPourcent *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.DPlusPourcent; {1111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.DPlusPourcent(XorY, ValD);

END; {***** TPointS.DPlusPourcent *****1111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.DConstante; {111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.DConstante(XorY, ValD);

END; {***** TPointS.DConstante *****111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.DPlusConstante; {111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.DPlusConstante(XorY, ValD);

END; {***** TPointS.DPlusConstante *****11111111111111111111111111111111111111111111111}

PROCEDURE TPointS.DFoisConstante; {111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.DFoisConstante(XorY, ValD);

END; {***** TPointS.DFoisConstante *****111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.Logarithme; {1111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.Logarithme(XorY);

END; {***** TPointS.Logarithme *****111111111111111111111111111111111111111111111111111}

PROCEDURE TPointS.PolToCart; {11111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant <> NIL) THEN suivant.PolToCart;

END; {***** TPointS.PolToCart *****11111111111111111111111111111111111111111111111111111}

FUNCTION TPoint.compte; {111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (suivant = NIL) THEN compte := 1 ELSE compte := suivant.compte + 1;

END; {***** TPoint.compte *****1111111111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.Sequence; {11111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN x := Deb ELSE y := Deb;
	INHERITED Sequence(XorY, Deb+Pas, Pas);

END; {***** TPoint.Sequence *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.DRacine; {111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN dx := sqrt(abs(x)+1) ELSE dy := sqrt(abs(y)+1);
	INHERITED DRacine(XorY);

END; {***** TPoint.DRacine *****1111111111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.DPourcent; {111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN dx := abs(x*ValD) ELSE dy := abs(y*ValD);
	INHERITED DPourcent(XorY, ValD);

END; {***** TPoint.DPourcent *****11111111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.DPlusPourcent; {11111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN dx := dx+x*ValD ELSE dy := dy+y*ValD;
	INHERITED DPlusPourcent(XorY, ValD);

END; {***** TPoint.DPlusPourcent *****1111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.DConstante; {1111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN dx := ValD ELSE dy := ValD;
	INHERITED DConstante(XorY, ValD);

END; {***** TPoint.DConstante *****111111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.DPlusConstante; {1111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN dx := dx+ValD ELSE dy := dy+ValD;
	INHERITED DPlusConstante(XorY, ValD);

END; {***** TPoint.DPlusConstante *****11111111111111111111111111111111111111111111111}

PROCEDURE TPoint.DFoisConstante; {1111111111111111111111111111111111111111111111111111111}

BEGIN
	IF XorY THEN dx := dx*ValD ELSE dy := dy*ValD;
	INHERITED DFoisConstante(XorY, ValD);

END; {***** TPoint.DFoisConstante *****111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.Logarithme; {111111111111111111111111111111111111111111111111111111111}

VAR
	tempExt : extended;

BEGIN
	IF XorY THEN
		BEGIN
		IF (x < MG_LogMin) THEN x := MG_LogMin;
		dx := dx/x;
		tempExt := x;
		x := ln(tempExt)/ln(10);
		END
	ELSE
		BEGIN
		IF (y < MG_LogMin) THEN y := MG_LogMin;
		dy := dy/y;
		tempExt := y;
		y := ln(tempExt)/ln(10);
		END;
	INHERITED Logarithme(XorY);

END; {***** TPoint.Logarithme *****11111111111111111111111111111111111111111111111111}

PROCEDURE TPoint.PolToCart; {11111111111111111111111111111111111111111111111111111111111}

VAR
	tX, tY, tDX, tDY : extended;

BEGIN
	tX := y*cos(x);
	tY := y*sin(x);
	tDX := sqrt((dy*cos(x))**2 + (y*sin(x)*dx)**2);
	tDY := sqrt((dy*sin(x))**2 + (y*cos(x)*dx)**2);
	x := tX;
	y := tY;
	dx := tDX;
	dy := tDY;
	INHERITED PolToCart;

END; {***** TPoint.PolToCart *****11111111111111111111111111111111111111111111111111111}

PROCEDURE PutMessage(m : STR255; r : rect); {11111111111111111111111111111111111111111111}

VAR
	h, v : integer;

BEGIN
	h := r.left + 5;
	v := r.top + (r.bottom - r.top - MG_HautLigne) div 2 + MG_FAsc - 1;
	MoveTo(h, v);
	DrawString(m);

END; {***** PutMessage *****111111111111111111111111111111111111111111111111111111}
		
PROCEDURE LireListe(VAR DFic : STR255); {1111111111111111111111111111111111111111111111}

VAR
	DoneLire : boolean;
	where : point;
	reply : SFReply;
	TypeList : SFTypeList;
	MyFl : text;					{liste dclare en type texte}
	MFic, aString : STR255;
	MyCell : cell;
	aRow : integer;

FUNCTION LireNombre : STR255; {22222222222222222222222222222222222222222222222222222}

VAR
	cString : STR255;
	theChar, MyTab : char;

BEGIN
	cString := '';
	MyTab := chr(9);
	WHILE (NOT EOF(MyFl) & NOT EOLN(MyFl)) DO
		BEGIN
		read(MyFl, theChar);
		IF (theChar <> MyTab)  THEN cString := concat(cString, theChar)
		ELSE LEAVE;
		END;
	LireNombre := cString;

END; {***** LireNombre *****22222222222222222222222222222222222222222222222222222}
		
BEGIN
	DoneLire := false;
	REPEAT
		where.v := 180;
		where.h := 95;
		TypeList[0] := 'TEXT';
		GetIndString(aString, MG_IOStrID, 1);
		SFGetFile(where, aString, nil,
									1, TypeList,		{slection de ce seul type}
									nil, reply);
		IF reply.good THEN
			BEGIN
			SetCursor(MG_ClockCursor);
			MFic := GetPathName(reply.FName, reply.VRefNum);
			DFic := DeleteTrailing (reply.FName);		{mise en mmoire pour enregistrement ventuel}
			open(MyFl, MFic);
			reset(MyFl);
			MyCell := MG_MyCell;
			MyCell.h := 0;
			WHILE (DoneLire = false) DO
				BEGIN
				IF EOF(MyFl) THEN DoneLire := true
				ELSE IF (EOLN(MyFl) or (MyCell.h >= MG_MyListHdl^^.dataBounds.right)) THEN
					BEGIN
					readln(MyFl);
					MyCell.h := 0;
					MyCell.v := MyCell.v + 1;
					END
				ELSE 
					BEGIN
					IF (MyCell.h = 0) THEN aRow := LAddRow(1, MyCell.v, MG_MyListHdl);
					aString := LireNombre;
					LSetCell(POINTER(ord(@aString)+1), length(aString), MyCell, MG_MyListHdl);
					MyCell.h := MyCell.h + 1;
					END;
				END;
			SetCreaType(reply.FName, reply.VRefNum, 'TEXT', 'MG01');	{on force le type et le crateur}
			close(MyFl);
			InitCursor;
			END
		ELSE DoneLire := true;
	UNTIL DoneLire;

END; {***** LireListe *****1111111111111111111111111111111111111111111111111111111}
		
PROCEDURE FermeTexte(theDialog : DialogPtr; filtre : boolean); {11111111111111111111111111111}

CONST
	TheTextItem = 3;			{faire correspondre FermeTexte, ListeFilter, ListeValeurs, ListeParams}

VAR
	itemType : integer;
	itemHandle : Handle;
	itemRect : rect;
	aString : STR255;

BEGIN
	GetDItem(theDialog, TheTextItem, itemType, itemHandle, itemRect);
	GetIText(itemHandle, MG_TheTexte);
	SetCursor(MG_ClockCursor);
	IF (filtre OR (MG_MyCell.h > 0)) THEN
		MG_TheTexte := RealToString(StringToReal(MG_TheTexte), 9)		{on filtre les nombres !}
	ELSE IF ((length(MG_TheTexte) = 0) | (MG_TheTexte[1] < 'A') |
			(MG_TheTexte[1] > 'z') | ((MG_TheTexte[1] > 'Z') & (MG_TheTexte[1] < 'a'))) THEN
		BEGIN
		NumToString(MG_MyCell.v+1, aString);	{on filtre les noms de paramtres !}
		MG_TheTexte := concat('a', aString);		{on impose un dbut par une lettre !}
		END;
	InitCursor;
	LSetCell(POINTER(ord(@MG_TheTexte)+1), length(MG_TheTexte),		{String to DataArray}
										MG_MyCell, MG_MyListHdl);
	SetIText(itemHandle, '');
	MG_InEdit := false;
	LSetSelect(false, MG_MyCell, MG_MyListHdl);

	GetDItem(theDialog, OK, itemType, itemHandle, itemRect);
	HiliteControl(ControlHandle(itemHandle), CntlEnable);
	DoTheOK(theDialog, OK);

END; {***** FermeTexte *****1111111111111111111111111111111111111111111111111111}

PROCEDURE LSetRow(theRow : integer; theSet : extended; filtre : boolean); {111111111111111111111}

VAR
	tempCell : point;
	aString : STR255;

BEGIN
	tempCell.v := theRow;
	tempCell.h := 0;
	IF NOT filtre THEN
		BEGIN
		NumToString(theRow+1, aString);
		aString := concat('a', aString);
		LSetCell(POINTER(ord(@aString)+1), length(aString),			{String to DataArray}
														tempCell, MG_MyListHdl);		
		tempCell.h := 1;
		END;
	aString := RealToString(theSet, 9);
	WHILE PtInRect(tempCell, MG_MyListHdl^^.dataBounds) DO
		BEGIN
		LSetCell(POINTER(ord(@aString)+1), length(aString),			{String to DataArray}
														tempCell, MG_MyListHdl);
		tempCell.h := tempCell.h + 1;
		END;

END; {***** LSetRow *****1111111111111111111111111111111111111111111111111111111}

FUNCTION SaveListe(DFic : STR255; theDialog : DialogPtr) : boolean; {1111111111111111111111111}

TYPE
	Troc = packed record
		CASE boolean of
			true : 		(i : integer);
			false :	(chr1, chr0 : char);
			END;

VAR
	TrocVar : Troc;
	where : point;
	reply : SFReply;
	MyFl : text;					{liste dclare en type texte}
	MFic, aString : STR255;
	MyCell : cell;
	aRow, aCol, MyDataLength : integer;
	MyTab : char;

BEGIN
	IF MG_InEdit THEN FermeTexte(theDialog, true);	{on filtre}
	where.v := 180;
	where.h := 95;
	GetIndString(aString, MG_IOStrID, 2);
	SFPutFile(where, aString, concat(DFic, '.D'), nil, reply);
	IF reply.good THEN
		BEGIN
		SetCursor(MG_ClockCursor);
		MFic := GetPathName(reply.FName, reply.VRefNum);
		open(MyFl, MFic);
		rewrite(MyFl);
		MyTab := chr(9);
		FOR aRow := 1 TO MG_MyListHdl^^.dataBounds.bottom DO
			BEGIN
			FOR aCol := 1 TO MG_MyListHdl^^.dataBounds.right DO
				BEGIN
				MyCell.h := aCol - 1;
				MyCell.v := aRow - 1;
				MyDataLength := 255;
				LGetCell(POINTER(ord(@aString)+1), MyDataLength, MyCell, MG_MyListHdl);
				TrocVar.i := MyDataLength;
				aString[0]   := TrocVar.chr0;		{ici on a besoin de length(aString)...}
				write(MyFl, aString, MyTab);
				END;
			writeln(MyFl);
			END;
		SetCreaType(reply.FName, reply.VRefNum, 'TEXT', 'MG01');	{on force le type et le crateur}
		close(MyFl);
		MG_PbFic := DeleteTrailing(reply.FName);
		InitCursor;
		END;
	SaveListe := reply.good;

END; {***** SaveListe *****111111111111111111111111111111111111111111111111111111}
		
FUNCTION ListeFilter (theDialog : DialogPtr; VAR theEvent : EventRecord;
									VAR itemHit : integer) : boolean; {11111111111111111111111111111111111}

CONST
	TheTextItem = 3;
	TheListItem = 4;
	TheOpenItem = 5;			{faire correspondre FermeTexte, ListeFilter, ListeValeurs, ListeParams}
	TheSaveItem = 6;

VAR
	itemType : integer;
	itemHandle : Handle;
	itemRect : rect;

PROCEDURE OuvreTexte; {22222222222222222222222222222222222222222222222222222222222}

VAR
	MyDataLength, milieu : integer;

BEGIN
	GetDItem(theDialog, OK, itemType, itemHandle, itemRect);
	HiliteControl(ControlHandle(itemHandle), CntlDisable);
	DoTheOK(theDialog, OK);

	LSetSelect(true, MG_MyCell, MG_MyListHdl);
	milieu := (MG_MyListHdl^^.visible.bottom + MG_MyListHdl^^.visible.top) div 2;
	LScroll (0, MG_MyCell.v - milieu, MG_MyListHdl);			{on recentre}
	MyDataLength := 255;		{on transfre par une STR255 : aucun nombre ne peut dpasser}
	LGetCell(POINTER(ord(@MG_TheTexte)+1), MyDataLength, MG_MyCell, MG_MyListHdl);
	MG_TheTexte[0]   := chr(MyDataLength);		{ici on a besoin de length(MG_TheTexte)...}
	GetDItem(theDialog, TheTextItem, itemType, itemHandle, itemRect);
	SetIText(itemHandle, MG_TheTexte);
	SelIText(theDialog, TheTextItem, 0, 32767);		{on slecte tout}
	MG_InEdit := true;
	MG_DoneModif := true;

END; {***** OuvreTexte *****22222222222222222222222222222222222222222222222222222}
		
PROCEDURE DealWthKeyDowns(Event : EventRecord); {22222222222222222222222222222222222222}

VAR
	CharCode : char;
	aRow : integer;
	
PROCEDURE InEditCmdKey; {3333333333333333333333333333333333333333333333333333333333}

VAR
	MyOSErr : OSErr;
	dummy : longint;

BEGIN
	CASE CharCode OF		{commande menu par clavier}
		'X', 'x' :	BEGIN
						DlgCut(theDialog);
						dummy := ZeroScrap;
						MyOSErr := TEToScrap;
						END;
		'C', 'c' :	BEGIN
						DlgCopy(theDialog);
						dummy := ZeroScrap;
						MyOSErr := TEToScrap;
						END;
		'V', 'v' :	BEGIN
						MyOSErr := TEFromScrap;
						DlgPaste(theDialog);
						END;
		chr(8), chr(27) :	BEGIN							{suppression, effacement}
						FermeTexte(theDialog, MG_filtre);
						LDelRow (1, MG_MyCell.v, MG_MyListHdl);
						IF PtInRect(MG_MyCell, MG_MyListHdl^^.dataBounds) THEN OuvreTexte;
						END;
		chr(13) :	BEGIN							{Retour Chariot}
						FermeTexte(theDialog, MG_filtre);
						IF (BitAnd(Event.modifiers, ShiftKey) <> ShiftKey) THEN
																					MG_MyCell.v := MG_MyCell.v + 1;
						aRow := LAddRow(1, MG_MyCell.v, MG_MyListHdl);
						LSetRow(MG_MyCell.v, 1, MG_filtre);
						OuvreTexte;
						END;
		chr(3) :	BEGIN							{touche Enter}
						FermeTexte(theDialog, MG_filtre);
						ItemHit := OK;
						END;
		END;	{case}
	ListeFilter := true;			{aucune autre commande n'est accepe}

END; {***** InEditCmdKey *****333333333333333333333333333333333333333333333333333}
		
PROCEDURE NoEditCmdKey; {3333333333333333333333333333333333333333333333333333333333}

BEGIN
	CASE CharCode OF		{commande menu par clavier}
		chr(13) :	IF (MG_MyListHdl^^.dataBounds.bottom < 1) THEN
							BEGIN							{Retour Chariot}
							aRow := LAddRow(1, MG_MyCell.v, MG_MyListHdl);
							LSetRow(MG_MyCell.v, 1, MG_filtre);
							OuvreTexte;
							END;
		chr(3) :	ItemHit := OK;							{touche Enter}
		END;	{case}
	ListeFilter := true;			{aucune autre commande n'est accepe}

END; {***** NoEditCmdKey *****333333333333333333333333333333333333333333333333333}
		
PROCEDURE InEditKey; {3333333333333333333333333333333333333333333333333333333333333}

VAR
	NoShiftKey : boolean;

BEGIN
	NoShiftKey := (BitAnd(Event.modifiers, ShiftKey) <> ShiftKey);
	CASE CharCode OF		{"ListeFilter := false"  pour les cas non filtrs}
		chr(27) :	BEGIN
						DlgDelete(theDialog);	{effacement}
						ListeFilter := true;
						END;
		chr(13) :	BEGIN							{Retour Chariot}
						FermeTexte(theDialog, MG_filtre);
						IF NoShiftKey THEN MG_MyCell.v := MG_MyCell.v + 1
						ELSE MG_MyCell.v := MG_MyCell.v - 1;
						IF NOT PtInRect(MG_MyCell, MG_MyListHdl^^.dataBounds) THEN
							BEGIN
							IF NoShiftKey THEN
								BEGIN															{on est au dessous...}
								MG_MyCell.v := 0;
								MG_MyCell.h := MG_MyCell.h + 1;			{...on teste la colone suivante}
								END
							ELSE
								BEGIN															{on est au dessus...}
								MG_MyCell.v := MG_MyListHdl^^.dataBounds.bottom-1;
								MG_MyCell.h := MG_MyCell.h - 1;			{...on teste la colone prcdente}
								END;
							IF NOT PtInRect(MG_MyCell, MG_MyListHdl^^.dataBounds) THEN
								IF NoShiftKey THEN MG_MyCell.h := 0		{retour au dbut/ la fin}
								ELSE MG_MyCell.h := MG_MyListHdl^^.dataBounds.right-1;
							END;
						OuvreTexte;
						ListeFilter := true;
						END;
		chr(3) :	BEGIN							{touche Enter}
						FermeTexte(theDialog, MG_filtre);
						ListeFilter := true;
						END;
		chr(9) :	BEGIN							{tabulation}
						FermeTexte(theDialog, MG_filtre);
						IF NoShiftKey THEN MG_MyCell.h := MG_MyCell.h + 1
						ELSE MG_MyCell.h := MG_MyCell.h - 1;
						IF NOT PtInRect(MG_MyCell, MG_MyListHdl^^.dataBounds) THEN
							BEGIN
							IF NoShiftKey THEN
								BEGIN															{on est  droite...}
								MG_MyCell.h := 0;
								MG_MyCell.v := MG_MyCell.v + 1;		{...on teste la ligne suivante}
								END
							ELSE
								BEGIN															{on est  gauche...}
								MG_MyCell.h := MG_MyListHdl^^.dataBounds.right-1;
								MG_MyCell.v := MG_MyCell.v - 1;		{...on teste la ligne prcdente}
								END;
							IF NOT PtInRect(MG_MyCell, MG_MyListHdl^^.dataBounds) THEN
								IF NoShiftKey THEN MG_MyCell.v := 0		{retour au dbut/ la fin}
								ELSE MG_MyCell.v := MG_MyListHdl^^.dataBounds.bottom-1;
							END;
						OuvreTexte;
						ListeFilter := true;
						END;
		END;	{case}

END; {***** InEditKey *****3333333333333333333333333333333333333333333333333333333}
		
PROCEDURE NoEditKey; {3333333333333333333333333333333333333333333333333333333333333}

BEGIN
	CASE CharCode OF							{il n'y a rien, on favorise l'insertion}
		chr(3), chr(13) :	BEGIN
						IF (MG_MyListHdl^^.dataBounds.bottom < 1) THEN
							BEGIN
							aRow := LAddRow(1, MG_MyCell.v, MG_MyListHdl);
							LSetRow(MG_MyCell.v, 1, MG_filtre);
							OuvreTexte;
							END
						ELSE ItemHit := OK;
						ListeFilter := true;
						END;
		END;	{case}

END; {***** NoEditKey *****333333333333333333333333333333333333333333333333333333}
		
BEGIN
	CharCode := chr(BitAnd(Event.message, charCodeMask));
	IF (BitAnd(Event.modifiers, CmdKey) = CmdKey) THEN
		BEGIN 
		IF MG_InEdit THEN InEditCmdKey ELSE NoEditCmdKey;
		END
	ELSE
		BEGIN
		IF MG_InEdit THEN InEditKey ELSE NoEditKey;
		END;
	
END; {***** DealWthKeyDowns *****222222222222222222222222222222222222222222222222}

PROCEDURE DealWthMouseDowns(Event : EventRecord); {222222222222222222222222222222222222}

VAR
	mouseloc : point;
	ControlLoc : integer;
	GetIt : boolean;
	
PROCEDURE InOKMDwn; {333333333333333333333333333333333333333333333333333333333333}

BEGIN
	ListeFilter := true;
	IF ((NOT MG_InEdit) & (MG_MyListHdl^^.dataBounds.bottom >= 1)) THEN
		BEGIN
		ControlLoc := TrackControl(ControlHandle(itemHandle), mouseloc, nil);
		IF (ControlLoc <> 0) THEN itemHit := OK;
		END;

END; {***** InOKMDwn *****333333333333333333333333333333333333333333333333333333}
		
PROCEDURE InListMDwn; {33333333333333333333333333333333333333333333333333333333333}

BEGIN
	ListeFilter := true;
	itemHit := TheListItem;
	IF MG_InEdit THEN FermeTexte(theDialog, MG_filtre);
	GetIt := LClick(mouseloc, 0, MG_MyListHdl);

	SetPt(MG_MyCell, 0, 0);			{ne serait-il pas intressant de protger MyCell ?}
	
	IF LGetSelect(true, MG_MyCell, MG_MyListHdl) THEN OuvreTexte;

END; {***** InListMDwn *****33333333333333333333333333333333333333333333333333333}
		
BEGIN
	mouseloc := theEvent.where;
	GlobalToLocal(mouseloc);

	GetDItem(theDialog, OK, itemType, itemHandle, itemRect);
	IF PtInRect(mouseloc, itemRect) THEN InOKMDwn;

	GetDItem(theDialog, TheListItem, itemType, itemHandle, itemRect);
	IF PtInRect(mouseloc, itemRect) THEN InListMDwn;
	
END; {***** DealWthMouseDowns *****2222222222222222222222222222222222222222222222}

PROCEDURE DealWthUpdates; {22222222222222222222222222222222222222222222222222222222}

BEGIN
	BeginUpdate(theDialog);

	DoTheOK(theDialog, OK);

	GetDItem(theDialog, TheListItem, itemType, itemHandle, itemRect);
	itemRect.right := itemRect.right - 15;				{place pour scroll}
	FrameRect(itemRect);
	LUpDate(theDialog^.visRgn, MG_MyListHdl);

	EndUpdate(theDialog);
	
END; {***** DealWthUpdates *****22222222222222222222222222222222222222222222222222}

BEGIN
	ListeFilter := false;
	CASE theEvent.what OF
		mouseDown :	DealWthMouseDowns(theEvent);		{cas filtrs pour limiter les arguments externes}
		KeyDown, AutoKey : DealWthKeyDowns(theEvent);
		UpDateEvt : DealWthUpdates;
		END; {CASE}

END; {***** ListeFilter *****111111111111111111111111111111111111111111111111111111}

FUNCTION ListeValeurs; {111111111111111111111111111111111111111111111111111111111111}

CONST
	NCol = 4; 
	TheTextItem = 3;
	TheListItem = 4;
	TheOpenItem = 5;			{faire correspondre FermeTexte, ListeFilter, ListeValeurs, ListeParams}
	TheSaveItem = 6;
	HautLigne = 15;			{diffrent de MG_HautLigne pour forcer le cadrage}

VAR
	n, nn, long, p : integer;
	RView, DataBounds : rect;
	CSize : point;
	MyString, tempPbFic, dummyPbFic : STR255;
	TempPort : GrafPtr;
	MyListDialog : DialogPtr;
	MyItemHdl : Handle;
	ItemType, ItemHit, OpenHit : integer;
	ItemBox : rect;
	nNLign, aRow, confirmation : integer;
	unPoint : TPoint;
	tempExt : extended;

PROCEDURE PutNames(RView : rect); {22222222222222222222222222222222222222222222222222}

VAR
	r : rect;
	n : integer;

BEGIN
	FOR n := 1 to NCol DO
		BEGIN
		SetRect(r, RView.left+(n-1)*CSize.h, RView.top-26, RView.left+n*CSize.h, RView.top-8);
		FrameRoundRect(r, 10, 10);
		PutMessage(names[n], r);
		END;

END; {***** PutNames *****222222222222222222222222222222222222222222222222222222}
				
PROCEDURE OuvreListe; {222222222222222222222222222222222222222222222222222222222222}

BEGIN
	IF MG_InEdit THEN FermeTexte(MyListDialog, true);			{on filtre}
	IF (MG_MyListHdl^^.dataBounds.bottom < 1) THEN OpenHit := 4			{on remplace le vide}
	ELSE OpenHit := Alert(MG_LireValeursAlrtID, nil);
	CASE OpenHit OF
		1 :	BEGIN																				{annexer}
				MG_MyCell.v := MG_MyListHdl^^.dataBounds.bottom;
				LireListe(dummyPbFic);
				END;
		2 :	;																						{ouverture annule}
		3 :	LireListe(dummyPbFic);														{insrer}
		4 :	BEGIN																				{remplacer}
				LDelRow(0, 0, MG_MyListHdl);		{delete express}
				MG_MyCell.v := 0;
				LireListe(tempPbFic);
				MG_PbFic := tempPbFic;
				END;
		END;
	GetDItem(MyListDialog, OK, ItemType, MyItemHdl, ItemBox);
	IF (MG_MyListHdl^^.dataBounds.bottom < 1) THEN
		HiliteControl(ControlHandle(MyItemHdl), CntlDisable)
	ELSE HiliteControl(ControlHandle(MyItemHdl), CntlEnable);
	DoTheOK(MyListDialog, OK);

END; {***** OuvreListe *****222222222222222222222222222222222222222222222222222222}
		
BEGIN
	GetPort(TempPort);
	MyListDialog := GetNewDialog(MG_MyListVDlgID, nil, POINTER(-1));
	SetPort(MyListDialog);

	GetDItem(MyListDialog, TheTextItem, ItemType, MyItemHdl, ItemBox);
	GetIText(MyItemHdl, MG_TheTexte);
	SetIText(MyItemHdl, MG_TheTexte);		{salet ! quelle bidouille pour initialiser correctement...}
	
	GetDItem(MyListDialog, TheListItem, ItemType, MyItemHdl, ItemBox);	{liste et scroll barre}
	ItemBox.right := ItemBox.right - 15;				{place pour scroll}
	FrameRect(ItemBox);										{pas ncessaire mais initialisation plus jolie}
	InsetRect(ItemBox, 1, 1);								{intrieur}
	SetRect(DataBounds, 0, 0, NCol, 0);
	CSize.h := (ItemBox.right - ItemBox.left) div NCol;	{s'il te plait, dessine moi la taille d'une cellule...}
	CSize.v := HautLigne;										{...sinon le calcul automatique est parfois trs curieux}
	PutNames(ItemBox);										{les titres des colonnes}
	MG_MyListHdl := LNew(ItemBox,		{limites en pixels}
							DataBounds,					{limites en cells}
							CSize,							{taille de cellule par dfaut}
							0,									{liste standard}
							MyListDialog,				{dans ma fentre}
							true,							{visible}
							false,							{no grow}
							false,							{no hScroll}
							true);							{vScroll}
	MG_MyListHdl^^.selFlags := lOnlyOne;			{slection limite}
	MG_InEdit := false;		{il n'y a pas de cell ouverte (a commence  zro et il n'y en a pas encore)}
	tempPbFic := MG_PbFic;
	unPoint := thePointS.suivant;
	IF (unPoint = NIL) THEN
		BEGIN
		MG_MyCell.h := 0;
		MG_MyCell.v := 0;		{pas un point ? on initialise MG_MyCell pour insertion ventuelle...}
		GetDItem(MyListDialog, OK, ItemType, MyItemHdl, ItemBox);
		HiliteControl(ControlHandle(MyItemHdl), CntlDisable);
		DoTheOK(MyListDialog, OK);
		END
	ELSE WHILE (unPoint <> NIL) DO
		BEGIN						{on insre ici les points prpars en entre}
		MG_MyCell.v := MG_MyListHdl^^.dataBounds.bottom;
		aRow := LAddRow(1, MG_MyCell.v, MG_MyListHdl);
		MG_MyCell.h := 0;
		tempExt := unPoint.x;
		MyString := RealToString(tempExt, 9);
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		MG_MyCell.h := 1;
		tempExt := unPoint.y;
		MyString := RealToString(tempExt, 9);
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		MG_MyCell.h := 2;
		tempExt := unPoint.dx;
		MyString := RealToString(tempExt, 9);
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		MG_MyCell.h := 3;
		tempExt := unPoint.dy;
		MyString := RealToString(tempExt, 9);
		LSetCell(POINTER(ord(@MyString)+1), length(MyString), MG_MyCell, MG_MyListHdl);
		unPoint := unPoint.suivant;
		END;
	
	InitCursor;
	FlushEvents(mDownMask+mUpMask,0);
	MG_filtre := true;					{pour filtrer les nombres}
	REPEAT
		ModalDialog(@ListeFilter, ItemHit);
		CASE ItemHit OF										{la plupart des cas sont filtrs  la main}
			OK : IF MG_DoneModif THEN
						BEGIN
						confirmation := CautionAlert(MG_QuitSansSaveAlrtID, nil);
						CASE confirmation OF
							1 : MG_DoneModif := false;														{on quitte}
							2 : MG_DoneModif := NOT SaveListe(tempPbFic, MyListDialog);	{on enregistre}
							3 : ;																								{sortie annule}
							END;
						END;
			TheOpenItem :	OuvreListe;
			TheSaveItem :	IF SaveListe(tempPbFic, MyListDialog) THEN
										BEGIN
										MG_DoneModif := false;
										tempPbFic := MG_PbFic;
										END;
			END;	{CASE ItemHit}
	UNTIL (((ItemHit = OK) AND NOT MG_DoneModif) OR (ItemHit = cancel));
	
	SetCursor(MG_ClockCursor);
	IF (ItemHit = OK) THEN
		BEGIN
		nNLign := MG_MyListHdl^^.dataBounds.bottom;
		thePointS.extension(nNLign);
		unPoint := thePointS.suivant;
		FOR nn := 1 to nNLign DO
			BEGIN
			MG_MyCell.v := nn - 1;
			MG_MyCell.h := 0;
			long := 255;			{on transfre par une STR255 : aucun nombre ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unPoint.x := StringToReal(MyString);
			MG_MyCell.h := 1;
			long := 255;			{on transfre par une STR255 : aucun nombre ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unPoint.y := StringToReal(MyString);
			MG_MyCell.h := 2;
			long := 255;			{on transfre par une STR255 : aucun nombre ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unPoint.dx := StringToReal(MyString);
			MG_MyCell.h := 3;
			long := 255;			{on transfre par une STR255 : aucun nombre ne peut dpasser}
			LGetCell(POINTER(ord(@MyString)+1), long, MG_MyCell, MG_MyListHdl);
			MyString[0]   := chr(long);		{ici on a besoin de length(MyString)...}
			unPoint.dy := StringToReal(MyString);
			unPoint := unPoint.suivant;
			END;
		END;
	LDispose(MG_MyListHdl);
	SetPort(TempPort);
	DisposDialog(MyListDialog);
	ListeValeurs := (ItemHit = OK);
	
END; {***** ListeValeurs *****1111111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpPoints; {1111111111111111111111111111111111111111111111111111111111111111}

CONST
	DxTypeMenu = 262;
	DyTypeMenu = 263;

	theNPointsItem = 5;
	theXSeqItem = 6;
	theXDebutItem = 8;
	theXPasItem = 10;
	theYSeqItem = 11;
	theYDebutItem = 13;
	theYPasItem = 15;
	theXBarTypeItem = 17;
	theDxValItem = 18;
	theYBarTypeItem = 20;
	theDyValItem = 21;
	
TYPE
	DType = (DNo, DVar, DSqrt, DPourc, DpPourc, DConst, DpConst, DfConst);
		
VAR
	TempPort : GrafPtr;
	PointsWPtr : DialogPtr;
	box : rect;
	TheItem, OptType : integer;
	MyItemHdl : handle;
	aString : STR255;
	aLong : longint;
	names : MG_TNames;
	nPointS : TPointS;
	nNPts, NPts : integer;
	RepListe, XSequence, YSequence : boolean;
	DxType, DyType : DType;
	DebX, DebY, PasX, PasY, ValDx, ValDy : extended;
	MyPopUpItem : longint;
	DxMHdl, DyMHdl : MenuHandle;

PROCEDURE DealWthOK; {222222222222222222222222222222222222222222222222222222222222}

VAR
	confirmation : integer;

PROCEDURE UpDatePopUp; {3333333333333333333333333333333333333333333333333333333333}

BEGIN
	GetDItem(PointsWPtr, theXBarTypeItem, OptType, MyItemHdl, box);
	FramePopUp(box);
	GetDItem(PointsWPtr, theYBarTypeItem, OptType, MyItemHdl, box);
	FramePopUp(box);

END; {***** UpDatePopUp *****3333333333333333333333333333333333333333333333333333}

BEGIN
	GetDItem(PointsWPtr, theNPointsItem, OptType, MyItemHdl, box);
	GetIText(MyItemHdl, aString);
	StringToNum(aString, aLong);
	IF ((abs(aLong) > nNPts) & ((DxType = DpPourc) | (DxType = DpPourc) | (DxType = DpPourc) |
			(DyType = DpPourc) | (DyType = DpPourc) | (DyType = DpPourc))) THEN
				BEGIN				{pas de nouveaux points si on a besoin de rfrences antrieures}
				ParamText(MG_xN, MG_yN, '', '');
				confirmation := StopAlert(RefSansDxyStopID, nil);
				UpDatePopUp;
				exit(DealWthOK);
				END
	ELSE nNPts := abs(aLong);
	nPointS := TPointS(thePointS.clone);
	IF (nNPts >  NPts) THEN MG_DoneModif := true;
	nPointS.extension(nNPts);
	IF XSequence THEN
		BEGIN
		GetDItem(PointsWPtr, theXDebutItem, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		DebX := StringToReal(aString);
		GetDItem(PointsWPtr, theXPasItem, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		PasX := StringToReal(aString);
		MG_DoneModif := true;
		nPointS.Sequence(MG_ForX, DebX, PasX);
		END;
	IF YSequence THEN
		BEGIN
		GetDItem(PointsWPtr, theYDebutItem, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		DebY := StringToReal(aString);
		GetDItem(PointsWPtr, theYPasItem, OptType, MyItemHdl, box);
		GetIText(MyItemHdl, aString);
		PasY := StringToReal(aString);
		MG_DoneModif := true;
		nPointS.Sequence(MG_ForY, DebY, PasY);
		END;
	CASE DxType OF
		DNo : IF MG_withDx THEN
					BEGIN
					MG_DoneModif := true;
					nPointS.DConstante(MG_ForX, 0);
					END;
		DVar : IF NOT MG_withDx THEN MG_DoneModif := true;
		DSqrt :	BEGIN
					MG_DoneModif := true;
					nPointS.DRacine(MG_ForX);
					END;
		DPourc :	BEGIN
						GetDItem(PointsWPtr, theDxValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDx := StringToReal(aString)/100;
						MG_DoneModif := true;
						nPointS.DPourcent(MG_ForX, ValDx);
						END;
		DpPourc :	BEGIN
						GetDItem(PointsWPtr, theDxValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDx := StringToReal(aString)/100;
						MG_DoneModif := true;
						nPointS.DPlusPourcent(MG_ForX, ValDx);
						END;
		DConst :	BEGIN
						GetDItem(PointsWPtr, theDxValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDx := abs(StringToReal(aString));
						MG_DoneModif := true;
						nPointS.DConstante(MG_ForX, ValDx);
						END;
		DpConst :	BEGIN
						GetDItem(PointsWPtr, theDxValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDx := StringToReal(aString);
						MG_DoneModif := true;
						nPointS.DPlusConstante(MG_ForX, ValDx);
						END;
		DfConst :	BEGIN
						GetDItem(PointsWPtr, theDxValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDx := StringToReal(aString);
						MG_DoneModif := true;
						nPointS.DFoisConstante(MG_ForX, ValDx);
						END;
		END;
	CASE DyType OF
		DNo : IF MG_withDy THEN
					BEGIN
					MG_DoneModif := true;
					nPointS.DConstante(MG_ForY, 0);
					END;
		DVar : IF NOT MG_withDy THEN MG_DoneModif := true;
		DSqrt :	BEGIN
					MG_DoneModif := true;
					nPointS.DRacine(MG_ForY);
					END;
		DPourc :	BEGIN
						GetDItem(PointsWPtr, theDyValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDy := StringToReal(aString)/100;
						MG_DoneModif := true;
						nPointS.DPourcent(MG_ForY, ValDy);
						END;
		DpPourc :	BEGIN
						GetDItem(PointsWPtr, theDyValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDy := StringToReal(aString)/100;
						MG_DoneModif := true;
						nPointS.DPlusPourcent(MG_ForY, ValDy);
						END;
		DConst :	BEGIN
						GetDItem(PointsWPtr, theDyValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDy := abs(StringToReal(aString));
						MG_DoneModif := true;
						nPointS.DConstante(MG_ForY, ValDy);
						END;
		DpConst :	BEGIN
						GetDItem(PointsWPtr, theDyValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDy := StringToReal(aString);
						MG_DoneModif := true;
						nPointS.DPlusConstante(MG_ForY, ValDy);
						END;
		DfConst :	BEGIN
						GetDItem(PointsWPtr, theDyValItem, OptType, MyItemHdl, box);
						GetIText(MyItemHdl, aString);
						ValDy := StringToReal(aString);
						MG_DoneModif := true;
						nPointS.DFoisConstante(MG_ForY, ValDy);
						END;
		END;
	RepListe := ListeValeurs(names, nPointS);
	IF NOT RepListe THEN	
		BEGIN
		UpDatePopUp;
		IF (thePointS.suivant = NIL) THEN SelIText(PointsWPtr, theNPointsItem, 0, 32767)
		ELSE SelIText(PointsWPtr, theNPointsItem, 32767, 32767);
		InitCursor;
		END;

END; {***** DealWthOK *****222222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthXBarTypeItem; {222222222222222222222222222222222222222222222222222}

BEGIN
	GetDItem(PointsWPtr, theNPointsItem, OptType, MyItemHdl, box);
	GetIText(MyItemHdl, aString);
	StringToNum(aString, aLong);
	IF (abs(aLong) > NPts) THEN		{pas de rfrences  des Dx non encore crs}
		BEGIN
		DisableItem(DxMHdl, ord(DpPourc)+1);
		DisableItem(DxMHdl, ord(DpConst)+1);
		DisableItem(DxMHdl, ord(DfConst)+1);
		END;
	GetDItem(PointsWPtr, theXBarTypeItem, OptType, MyItemHdl, box);
	LocalToGlobal(box.TopLeft);
	MyPopUpItem := PopUpMenuSelect(DxMHdl, box.top, box.left, ord(DxType) + 1);
	IF (abs(aLong) > NPts) THEN		{rfrences ventuellement utiles plus tard}
		BEGIN
		EnableItem(DxMHdl, ord(DpPourc)+1);
		EnableItem(DxMHdl, ord(DpConst)+1);
		EnableItem(DxMHdl, ord(DfConst)+1);
		END;
	IF (MyPopUpItem <> 0) THEN
		BEGIN
		CASE LoWord(MyPopUpItem) OF
			1 :	BEGIN
					DxType := DNo;
					SelIText(PointsWPtr, theNPointsItem, 0, 0);
					END;
			2 :	BEGIN
					DxType := DVar;
					SelIText(PointsWPtr, theNPointsItem, 0, 0);
					END;
			3 :	BEGIN
					DxType := DSqrt;
					SelIText(PointsWPtr, theNPointsItem, 0, 0);
					END;
			4 :	BEGIN
					SelIText(PointsWPtr, theDxValItem, 0, 32767);
					DxType := DPourc;
					END;
			5 :	BEGIN
					SelIText(PointsWPtr, theDxValItem, 0, 32767);
					DxType := DpPourc;
					END;
			6 :	BEGIN
					SelIText(PointsWPtr, theDxValItem, 0, 32767);
					DxType := DConst;
					END;
			7 :	BEGIN
					SelIText(PointsWPtr, theDxValItem, 0, 32767);
					DxType := DpConst;
					END;
			8 :	BEGIN
					SelIText(PointsWPtr, theDxValItem, 0, 32767);
					DxType := DfConst;
					END;
			END;
		GetItem(DxMHdl, ord(DxType) + 1, aString);
		SetIText(MyItemHdl, concat('  ', aString));
		END;
	
END; {***** DealWthXBarTypeItem *****222222222222222222222222222222222222222222222}

PROCEDURE DealWthYBarTypeItem; {222222222222222222222222222222222222222222222222222}

BEGIN
	GetDItem(PointsWPtr, theNPointsItem, OptType, MyItemHdl, box);
	GetIText(MyItemHdl, aString);
	StringToNum(aString, aLong);
	IF (abs(aLong) > NPts) THEN		{pas de rfrences  des Dy non encore crs}
		BEGIN
		DisableItem(DyMHdl, ord(DpPourc)+1);
		DisableItem(DyMHdl, ord(DpConst)+1);
		DisableItem(DyMHdl, ord(DfConst)+1);
		END;
	GetDItem(PointsWPtr, theYBarTypeItem, OptType, MyItemHdl, box);
	LocalToGlobal(box.TopLeft);
	MyPopUpItem := PopUpMenuSelect(DyMHdl, box.top, box.left, ord(DyType) + 1);
	IF (abs(aLong) > NPts) THEN		{rfrences ventuellement utiles plus tard}
		BEGIN
		EnableItem(DyMHdl, ord(DpPourc)+1);
		EnableItem(DyMHdl, ord(DpConst)+1);
		EnableItem(DyMHdl, ord(DfConst)+1);
		END;
	IF (MyPopUpItem <> 0) THEN
		BEGIN
		CASE LoWord(MyPopUpItem) OF
			1 :	BEGIN
					DyType := DNo;
					SelIText(PointsWPtr, theNPointsItem, 0, 0);
					END;
			2 :	BEGIN
					DyType := DVar;
					SelIText(PointsWPtr, theNPointsItem, 0, 0);
					END;
			3 :	BEGIN
					DyType := DSqrt;
					SelIText(PointsWPtr, theNPointsItem, 0, 0);
					END;
			4 :	BEGIN
					SelIText(PointsWPtr, theDyValItem, 0, 32767);
					DyType := DPourc;
					END;
			5 :	BEGIN
					SelIText(PointsWPtr, theDyValItem, 0, 32767);
					DyType := DpPourc;
					END;
			6 :	BEGIN
					SelIText(PointsWPtr, theDyValItem, 0, 32767);
					DyType := DConst;
					END;
			7 :	BEGIN
					SelIText(PointsWPtr, theDyValItem, 0, 32767);
					DyType := DpConst;
					END;
			8 :	BEGIN
					SelIText(PointsWPtr, theDyValItem, 0, 32767);
					DyType := DfConst;
					END;
			END;
		GetItem(DyMHdl, ord(DyType) + 1, aString);
		SetIText(MyItemHdl, concat('  ', aString));
		END;
	
END; {***** DealWthYBarTypeItem *****222222222222222222222222222222222222222222222}

BEGIN	
	names[1] := MG_xN;
	names[2] := MG_yN;
	names[3] := concat('', MG_xN);
	names[4] := concat('', MG_yN);
	nPointS := NIL;								{a priori pas indispensable, mais par scurit...}
	IF AsSet THEN									{initialisation simplifie pour accs direct}
		BEGIN
		IF NOT MG_withDx THEN DxType := DNo ELSE DxType := DVar;
		IF NOT MG_withDy THEN DyType := DNo ELSE DyType := DVar;
		nPointS := TPointS(thePointS.clone);
		RepListe := ListeValeurs(names, nPointS);
		END
	ELSE
		BEGIN
		GetPort(TempPort);
		PointsWPtr := GetNewDialog(MG_SetUpPointsDlgID, nil, POINTER(-1));
		SetPort(PointsWPtr);
		DxMHdl := GetMenu(DxTypeMenu);						{barres}
		InsertMenu(DxMHdl, -1);
		DyMHdl := GetMenu(DyTypeMenu);						{barres}
		InsertMenu(DyMHdl, -1);
		
		GetDItem(PointsWPtr, theXSeqItem, OptType, MyItemHdl, box);		{x en squence}
		SetCtlValue(ControlHandle(MyItemHdl), 0);
		GetDItem(PointsWPtr, theYSeqItem, OptType, MyItemHdl, box);		{y en squence}
		SetCtlValue(ControlHandle(MyItemHdl), 0);
		IF NOT MG_withDx THEN DxType := DNo ELSE DxType := DVar;
		GetDItem(PointsWPtr, theXBarTypeItem, OptType, MyItemHdl, box);		{barres}
		FramePopUp(box);
		GetItem(DxMHdl, ord(DxType) + 1, aString);
		SetIText(MyItemHdl, concat('  ', aString));
		IF NOT MG_withDy THEN DyType := DNo ELSE DyType := DVar;
		GetDItem(PointsWPtr, theYBarTypeItem, OptType, MyItemHdl, box);		{barres}
		FramePopUp(box);
		GetItem(DyMHdl, ord(DyType) + 1, aString);
		SetIText(MyItemHdl, concat('  ', aString));
		NPts := thePointS.compte;
		NumToString(NPts, aString);
		GetDItem(PointsWPtr, theNPointsItem, OptType, MyItemHdl, box);
		SetIText(MyItemHdl, aString);
		IF (NPts > 0) THEN SelIText(PointsWPtr, theNPointsItem, 0, 32767)
		ELSE SelIText(PointsWPtr, theNPointsItem, 32767, 32767);
		
		XSequence := false;
		YSequence := false;
		RepListe := false;
		nNPts := NPts;
		InitCursor;
		FlushEvents(mDownMask+mUpMask,0);
	
		REPEAT
			ModalDialog(@FilterForDialog, TheItem);
			CASE TheItem OF
				OK : DealWthOK;
				cancel :	;
				theXSeqItem :	BEGIN
						GetDItem(PointsWPtr, theXSeqItem, OptType, MyItemHdl, box);
						IF XSequence THEN
							BEGIN
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							SelIText(PointsWPtr, theNPointsItem, 0, 0);
							END
						ELSE
							BEGIN
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							SelIText(PointsWPtr, theXDebutItem, 0, 32767);
							END;
						XSequence := NOT XSequence;
						END;
				theXDebutItem, theXPasItem :	BEGIN
									GetDItem(PointsWPtr, theXSeqItem, OptType, MyItemHdl, box);
									SetCtlValue(ControlHandle(MyItemHdl), 1);
									XSequence := true;
									END;
				theYSeqItem :	BEGIN
						GetDItem(PointsWPtr, theYSeqItem, OptType, MyItemHdl, box);
						IF YSequence THEN
							BEGIN
							SetCtlValue(ControlHandle(MyItemHdl), 0);
							SelIText(PointsWPtr, theNPointsItem, 0, 0);
							END
						ELSE
							BEGIN
							SetCtlValue(ControlHandle(MyItemHdl), 1);
							SelIText(PointsWPtr, theYDebutItem, 0, 32767);
							END;
						YSequence := NOT YSequence;
						END;
				theYDebutItem, theYPasItem :	BEGIN
										GetDItem(PointsWPtr, theYSeqItem, OptType, MyItemHdl, box);
										SetCtlValue(ControlHandle(MyItemHdl), 1);
										YSequence := true;
										END;
				theXBarTypeItem : DealWthXBarTypeItem;
				theDxValItem :	IF (DxType IN [DNo..DSqrt]) THEN
								BEGIN
								DxType := DConst;
								GetDItem(PointsWPtr, theXBarTypeItem, OptType, MyItemHdl, box);
								GetItem(DxMHdl, ord(DxType) + 1, aString);
								SetIText(MyItemHdl, concat('  ', aString));
								END;
				theYBarTypeItem : DealWthYBarTypeItem;
				theDyValItem :	IF (DyType IN [DNo..DSqrt]) THEN
								BEGIN
								DyType := DConst;
								GetDItem(PointsWPtr, theYBarTypeItem, OptType, MyItemHdl, box);
								GetItem(DyMHdl, ord(DyType) + 1, aString);
								SetIText(MyItemHdl, concat('  ', aString));
								END;
				END;
		UNTIL RepListe OR (TheItem = cancel);
		
		DeleteMenu(DxTypeMenu);
		DeleteMenu(DyTypeMenu);
		DisposDialog(PointsWPtr);
		SetPort(TempPort);
		END;

	IF RepListe THEN
		BEGIN
		thePointS.free;
		thePointS := nPointS;
		MG_withDx := (DxType <> DNo);
		MG_withDy := (DyType <> DNo);
		END
	ELSE IF (nPointS <> NIL) THEN nPointS.free;

	InitCursor;

END; {***** SetUpPoints *****11111111111111111111111111111111111111111111111111111}
	
END.