UNIT MG_util;

INTERFACE

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf, PackIntf, MacPrint, SANE,
	USLib_U1;

VAR
	MG_SousMultiF : boolean;
	MG_FAsc, MG_FDesc, MG_FLead, MG_HautLigne : integer;
	MG_GraphWPtr : WindowPtr;
	MG_TheOrigine : point;
	MG_DragArea, MG_GrowRect : rect;
	MG_MinTextHdl : TEHandle;
	MG_GraphHScrollHdl, MG_GraphVScrollHdl : ControlHandle;
	MG_PictureH : PicHandle;
	MG_GraphPictRect : rect;
	MG_PictSaved : boolean;

FUNCTION RealToString (r : extended; ns : integer) : STR255;
FUNCTION StringToReal(m : STR255) : extended;
FUNCTION AjusteLongueur (m : STR255; NPixels : integer; trailing : boolean) : STR255;
FUNCTION DeleteTrailing (m : STR255) : STR255;
PROCEDURE SetUpFonts(font, size : integer);
FUNCTION FilterForDialog(TheDialog : DialogPtr; var TheEvent : EventRecord;
									var ItemHit : integer) : boolean;
FUNCTION Proba(ndl : integer; chi2 : extended) : extended;
PROCEDURE MoveScrollBars;
PROCEDURE UpdateMyWindows (UpDateWindow : WindowPtr);
PROCEDURE ScrollBits(MyControlHdl : ControlHandle);
PROCEDURE ScrollUp(MyControlHdl : ControlHandle; TheCode : integer);
PROCEDURE ScrollDown(MyControlHdl : ControlHandle; TheCode : integer);
PROCEDURE PageScroll(MyControlHdl : ControlHandle; TheCode, combien : integer);
PROCEDURE ReSizeWindow (WindowPointedTo : WindowPtr; MouseLoc : point);

IMPLEMENTATION

{$S MG_util }

FUNCTION RealToString; {111111111111111111111111111111111111111111111111111111111111}

VAR
	ns1, i, p : integer;	
	mm : DecStr;		{STR255;}
	f : DecForm;
	d : Decimal;
	IntHdl : Intl0Hndl;
	decimal : char;
	aString : STR255;

BEGIN
	ns1 := abs(ns);
	IF ns1 < 1 THEN ns1 := 1
	ELSE IF ns1 > 17 THEN ns1 := 17;
	f.style := FloatDecimal;
	f.digits := ns1;
	Num2Dec(f, r, d);
	IF (d.sig = '0') THEN mm := '0'
	ELSE
		BEGIN
		WHILE ((d.exp < 0) AND (length(d.sig) > 1) AND (d.sig[length(d.sig)] = '0')) DO	{trailing zros inutiles}
			BEGIN
			delete(d.sig, length(d.sig), 1);
			d.exp := d.exp + 1;
			END;
		i := 0;
		IF (d.exp <= -length(d.sig)) THEN i := 1 - d.exp - length(d.sig);		{leading zros}
		IF (((d.exp >= 0) AND (d.exp <= 5+ns1-length(d.sig)))
		OR ((d.exp < 0) AND (length(d.sig) <= 5+ns1-i))) THEN
			BEGIN
			f.style := FixedDecimal;
			IF (d.exp < 0) THEN f.digits := - d.exp
			ELSE f.digits := 0;
			END
		ELSE
			BEGIN
			WHILE ((length(d.sig) > 1) AND (d.sig[length(d.sig)] = '0')) DO		{trailing zros inutiles}
				BEGIN
				delete(d.sig, length(d.sig), 1);
				d.exp := d.exp + 1;
				END;
			f.digits := length(d.sig);
			END;
		Dec2Str(f, d, mm);
		END;
	IntHdl := Intl0Hndl(IUGetIntl(0));		{Dec2Str semble ne pas tenir compte du format intl !}
	decimal := IntHdl^^.decimalPt;
	IF (decimal <> '.') THEN
		BEGIN
		p := pos('.', mm);
		IF (p <> 0) THEN
			BEGIN
			delete(mm, p, 1);
			aString := decimal;								{la routine du pascal MPW...}
			insert(aString, mm, p);			{...ne sait pas insrer un char dans une string !}
			END;
		END;
	RealToString := mm;

END; {***** RealToString ***** 111111111111111111111111111111111111111111111111111}

FUNCTION StringToReal(m : STR255) : extended; {1111111111111111111111111111111111111111}

VAR
	mm, me : STR255;
	rr : extended;
	i, l, np, ne, p : integer;
	n : longint;
	a, decimal : char;
	s, se : boolean;
	IntHdl : Intl0Hndl;

BEGIN
	IntHdl := Intl0Hndl(IUGetIntl(0));		{Str2Num semble ne pas tenir compte du format intl !}
	decimal := IntHdl^^.decimalPt;

	mm := '';				{maintenant on filtre les caractres}
	me := '';
	l := length(m);
	np := 0;
	ne := 0;
	s := true;		{signe +}
	se := true;
	FOR i := 1 to l DO
		BEGIN
		IF (ne = 0) THEN
			BEGIN
			IF((m[i] = '-') and (mm = '')) THEN s := false
			ELSE IF ((m[i] = 'E') or (m[i] = 'e')) THEN
				BEGIN
				IF (i = 1) THEN mm := '1';
				ne := ne + 1;
				END
			ELSE IF (((m[i] = '.') or (m[i] = decimal)) and (np = 0)) THEN
				BEGIN
				IF (i = 1) THEN mm := '0';
				mm := concat(mm,'.');
				np := np + 1;
				END
			ELSE IF ((m[i] >= '0') and (m[i] <= '9')) THEN mm := concat(mm, m[i]);
			END
		ELSE
			BEGIN
			IF((m[i] = '-') and (me = '')) THEN se := false
			ELSE IF ((m[i] = 'E') or (m[i] = 'e')) THEN ne := ne + 1
			ELSE IF ((m[i] >= '0') and (m[i] <= '9')) THEN me := concat(me, m[i]);
			END;
		END;
	IF (mm = '') THEN mm := '0';
	IF (me <> '') THEN
		BEGIN
		IF NOT se THEN me := concat('-', me);
		me := concat('e', me);
		END;
	mm := concat(mm, me);	
	IF NOT s THEN mm := concat('-', mm);
	StringToReal := Str2Num(mm);

END; {***** StringToReal *****111111111111111111111111111111111111111111111111111}

FUNCTION AjusteLongueur (m : STR255; NPixels : integer; trailing : boolean) : STR255; {11111111111}

VAR
	mm : STR255;

BEGIN
	mm := m;
	IF trailing THEN WHILE (StringWidth(mm) < NPixels) DO mm := concat(mm, ' ')
	ELSE WHILE (StringWidth(mm) < NPixels) DO mm := concat(' ', mm);
	AjusteLongueur := mm;

END; {***** AjusteLongueur ***** 11111111111111111111111111111111111111111111111111}

FUNCTION DeleteTrailing (m : STR255) : STR255; {1111111111111111111111111111111111111111}

VAR
	p : integer;

BEGIN
		p := pos('.D', m);
		IF (p = 0) THEN p := pos('.d', m);
		IF (p = 0) THEN p := pos('.F', m);
		IF (p = 0) THEN p := pos('.f', m);
		IF (p = 0) THEN DeleteTrailing := m ELSE DeleteTrailing := copy(m, 1, p-1);

END; {***** DeleteTrailing ***** 11111111111111111111111111111111111111111111111111}

PROCEDURE SetUpFonts(font, size : integer); {11111111111111111111111111111111111111111111}

VAR
	f : FontInfo;

BEGIN
	TextFont(font);
	TextSize(size);
	GetFontInfo(f);
	MG_FAsc := f.ascent;
	MG_FDesc := f.descent;
	MG_FLead := f.leading;
	MG_HautLigne := f.ascent + f.descent + f.leading;

END; {***** SetUpFonts *****11111111111111111111111111111111111111111111111111111}

FUNCTION FilterForDialog(TheDialog : DialogPtr; var TheEvent : EventRecord;
									var ItemHit : integer) : boolean; {111111111111111111111111111111111111}

VAR
	CharCode : char;

BEGIN
	FilterForDialog := false;		{a priori c'est ModalDialog qui est maitre}
	ItemHit := 0;						{et on ne lui impose rien...}
	CASE TheEvent.what OF
		KeyDown, AutoKey :
			BEGIN
			CharCode := chr(BitAnd(TheEvent.message, charCodeMask));
			IF (BitAnd(TheEvent.modifiers, CmdKey) = CmdKey) THEN
				BEGIN					{commande menu par clavier : on traite si dition}
				CASE CharCode OF
					'Z', 'z' :	BEGIN				{annuler}
								FilterForDialog := true;
								END;
					'X', 'x' :	BEGIN
								DlgCut(TheDialog);
								FilterForDialog := true;
								END;
					'C', 'c' :	BEGIN
								DlgCopy(TheDialog);
								FilterForDialog := true;
								END;
					'V', 'v' :	BEGIN
								DlgPaste(TheDialog);
								FilterForDialog := true;
								END;
					END;	{case}
				END
			ELSE 
				BEGIN					{touches particulires du clavier : on traite si dition}
				CASE CharCode OF
					chr(27) :	BEGIN						{touche d'effacement}
									DlgDelete(TheDialog);
									FilterForDialog := true;
									END;
					chr(3), chr(13) :	BEGIN							{enter et return pour OK}
												ItemHit := 1;			{l'utilisation d'un filtre empche...}
												FilterForDialog := true;	{...le traitement en standard}
												END;
					END;
				END; {if}
			END; {keydown}
		UpDateEvt : DoTheOK(theDialog, OK);
		END; {case}

END; {***** FilterForDialog *****11111111111111111111111111111111111111111111111111}

FUNCTION Proba(ndl : integer; chi2 : extended) : extended; {111111111111111111111111111111111}

CONST
	ProbData = 128;		{ressource pour proba}

TYPE
	TypPData = RECORD
		ndl : integer;
		chi2 : array[1..16] of longint;
		END;
	TPData = array[0..11] of TypPData;
	TPDatPtr = ^TPData;
	TPDatHdl = ^TPDatPtr;
	TypPchi2 = RECORD
		ndl : integer;
		chi2 : array[0..16] of extended;
		END;
	TPchi2 = array[1..11] of TypPchi2;

VAR
	PData : TPDatHdl;						{handle de ressource pour proba}
	PProba : array[0..16] of extended;
	Pchi2 : TPchi2;
	tn, i, j, ninf, nsup, pinf, psup : integer;
	tc, csurn, tp, tpsup : extended;
	petit40 : boolean;

FUNCTION interc (csn : extended; nn, pinf, psup : integer) : extended; {2222222222222222222222222}

VAR
	tp : extended;

BEGIN
	tp := PProba[pinf];
	IF (psup = 17) THEN tp := 0.0				{dpassement de la limite traite ici...}
	ELSE IF (psup <> pinf) THEN						{interpollation linaire...}
		tp := tp + (PProba[psup] - PProba[pinf]) * (csn - Pchi2[nn].chi2[pinf])
																		/ (Pchi2[nn].chi2[psup] - Pchi2[nn].chi2[pinf]);
	interc := tp;

END; {***** interc *****222222222222222222222222222222222222222222222222222222222}

BEGIN
	PData := TPDatHdl(GetResource('PROB', ProbData));			{chargement des donnes...}
	PProba[0] := 1;
	FOR j := 1 to 16 DO PProba[j] := PData^^[0].chi2[j]/1000.0;
	FOR i := 1 to 11 DO
		BEGIN
		Pchi2[i].ndl := PData^^[i].ndl;
		Pchi2[i].chi2[0] := 0;
		FOR j := 1 to 2 DO Pchi2[i].chi2[j] := PData^^[i].chi2[j]/100000.0;
		Pchi2[i].chi2[3] := PData^^[i].chi2[3]/10000.0;
		FOR j := 4 to 8 DO Pchi2[i].chi2[j] := PData^^[i].chi2[j]/1000.0;
		FOR j := 9 to 16 DO Pchi2[i].chi2[j] := PData^^[i].chi2[j]/100.0;
		END;
		
	tn := ndl;								{calcul avec approximation ventuelle pour ndl > 40...}
	tc := chi2;
	IF (tc < 0) THEN tc := 0.0;
	petit40 := false;
	IF (ndl > 40) THEN				{loi d'approximation sur chi pour les grands ndl}
		BEGIN
		tn := 1;
		tc := sqrt(2*tc) - sqrt(2*ndl - 1);
		petit40 := (tc < 0);			{probabilits > 0,5   l'approximation utilise}
		tc := tc ** 2;
		END;
	csurn := tc/tn;
	
	ninf := 1;											{chercher ndl ou un encadrement}
	FOR i := 2 to 11 DO IF (Pchi2[i].ndl <= tn) THEN ninf := i ELSE LEAVE;
	nsup := ninf;
	IF (Pchi2[ninf].ndl < tn) THEN nsup := ninf+1;	{pour ndl > 40 on fait une approximation...}
																									{...  partir de ndl = 1}	
	pinf := 0;							{pour ndl chercher chi2/ndl ou un encadrement}
	FOR i := 1 to 16 DO IF (Pchi2[ninf].chi2[i] <= csurn) THEN pinf := i ELSE LEAVE;
	psup := pinf;
	IF (Pchi2[ninf].chi2[pinf] < csurn) THEN psup := pinf+1;
	
	tp := interc(csurn, ninf, pinf, psup);			{pour ndl et chi2/ndl chercher proba}
	
	IF (nsup > ninf) THEN			{ventuellement 2 fois si encadrement...}
		BEGIN
		pinf := 0;
		FOR i := 1 to 16 DO IF (Pchi2[nsup].chi2[i] <= csurn) THEN pinf := i ELSE LEAVE;
		psup := pinf;
		IF (Pchi2[nsup].chi2[pinf] < csurn) THEN psup := pinf+1;
		
		tpsup := interc(csurn, nsup, pinf, psup);

		tp := tp + (tpsup - tp)*(tn - Pchi2[ninf].ndl)/(Pchi2[nsup].ndl - Pchi2[ninf].ndl);		{interpoler}
		END;
	
	IF (ndl > 40) THEN
		BEGIN
		IF petit40 THEN tp := 1-tp/2 ELSE tp := tp/2;
		END;
	Proba := tp;
	
END; {***** Proba *****111111111111111111111111111111111111111111111111111111111}

PROCEDURE MoveScrollBars; {11111111111111111111111111111111111111111111111111111111}

VAR
	FondEcran, tRect : rect;
	marge, valeur : integer;

BEGIN
	tRect := MG_GraphWPtr^.portRect;
	tRect.top := tRect.top - 1;
	tRect.left := tRect.right - 15;
	tRect.bottom := tRect.bottom - 14;
	tRect.right := tRect.right + 1;
	MG_GraphVScrollHdl^^.contrlRect := tRect;			{on dplace sans redessiner, puis on update}
	valeur := GetCtlValue(MG_GraphVScrollHdl);
	FondEcran := MG_GraphPictRect;				{*****en attendant mieux*****}
	FondEcran.bottom := FondEcran.bottom + 15;
	FondEcran.right := FondEcran.right + 15;
	marge := round(((FondEcran.bottom - FondEcran.top) - (tRect.bottom - tRect.top) - 13)/4);
	IF (marge < valeur) THEN marge := valeur;
	SetCtlMax(MG_GraphVScrollHdl, marge);				{on ajuste la longueur du scroll}
	
	tRect := MG_GraphWPtr^.portRect;
	tRect.top := tRect.bottom - 15;
	tRect.left := tRect.left - 1;
	tRect.bottom := tRect.bottom + 1;
	tRect.right := tRect.right - 14;
	MG_GraphHScrollHdl^^.contrlRect := tRect;			{on dplace sans redessiner, puis on update}
	valeur := GetCtlValue(MG_GraphHScrollHdl);
	marge := round(((FondEcran.right - FondEcran.left) - (tRect.right - tRect.left) - 15)/4);
	IF (marge < valeur) THEN marge := valeur;
	SetCtlMax(MG_GraphHScrollHdl, marge);				{on ajuste la longueur du scroll}
	
END; {***** MoveScrollBars *****11111111111111111111111111111111111111111111111111}

PROCEDURE UpdateMyWindows; {1111111111111111111111111111111111111111111111111111111}

VAR
	tempRect : rect;
	tempRgn : RgnHandle;
	MyItemHdl : handle;
	OptType : integer;
	
BEGIN
	IF (UpDateWindow = MG_GraphWPtr) then
			BEGIN
			tempRgn := NewRgn;
			CopyRgn(MG_GraphWPtr^.clipRgn, tempRgn);

			tempRect := MG_GraphWPtr^.portRect;
			tempRect.right := tempRect.right - 15;
			tempRect.bottom := tempRect.bottom - 15;
			RectRgn(MG_GraphWPtr^.clipRgn, tempRect);		{pour ne pas dborder}

			DrawPicture(MG_PictureH, MG_GraphPictRect);

			CopyRgn(tempRgn, MG_GraphWPtr^.clipRgn);
			DisposeRgn(tempRgn);
			MoveScrollBars;
			DrawControls(MG_GraphWPtr);
			END; {MG_GraphWPtr}
	
END; {***** UpdateMyWindows *****1111111111111111111111111111111111111111111111}

PROCEDURE ScrollBits; {111111111111111111111111111111111111111111111111111111111111111111}

VAR
	OldOrigine : point;
	DH, DV : integer;
	
PROCEDURE LetScroll; {22222222222222222222222222222222222222222222222222222222222222}

VAR
	tempRect : rect;
	UpdateRegion : RgnHandle;
	
BEGIN
		tempRect := MG_GraphWPtr^.portRect;
		tempRect.right := tempRect.right - 15;
		tempRect.bottom := tempRect.bottom - 15;		{pour ne pas dborder sur les scrollbares}
		UpdateRegion := NewRgn;
		ScrollRect(tempRect, DH, DV, UpdateRegion);
		InvalRgn(UpdateRegion);
		DisposeRgn(UpdateRegion);
		SetOrigin(MG_TheOrigine.h, MG_TheOrigine.v);
		BeginUpdate(MG_GraphWPtr);								{car pas toujours passage dans Mainloop ! ?}
		EraseRect(MG_GraphWPtr^.VisRgn^^.rgnBBox);
		DrawGrowIcon(MG_GraphWPtr);
		UpdateMyWindows(MG_GraphWPtr);
		EndUpdate(MG_GraphWPtr);
	
END; {***** LetScroll *****22222222222222222222222222222222222222222222222222222222}

BEGIN
	IF (MyControlHdl = MG_GraphHScrollHdl) THEN
		BEGIN
		OldOrigine := MG_TheOrigine;
		MG_TheOrigine.h := 4 * GetCtlValue(MyControlHdl);
		DH := OldOrigine.h - MG_TheOrigine.h;
		DV := 0;
		LetScroll;
		END
	ELSE IF (MyControlHdl = MG_GraphVScrollHdl) THEN
		BEGIN
		OldOrigine := MG_TheOrigine;
		MG_TheOrigine.v := 4 * GetCtlValue(MyControlHdl);
		DH := 0;
		DV := OldOrigine.v - MG_TheOrigine.v;
		LetScroll;
		END
	ELSE
		BEGIN
		OldOrigine := MG_TheOrigine;
		MG_TheOrigine.v := 4 * GetCtlValue(MyControlHdl);
		DH := 0;
		DV := OldOrigine.v - MG_TheOrigine.v;
		TEScroll(DH, DV, MG_MinTextHdl);
		END;

END; {***** ScrollBits *****111111111111111111111111111111111111111111111111111111111111}

PROCEDURE ScrollUp; {1111111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (TheCode = InUpButton) THEN
		BEGIN
		SetCtlValue(MyControlHdl, GetCtlValue(MyControlHdl) - 1);
		ScrollBits(MyControlHdl);
		END;

END; {***** ScrollUp *****1111111111111111111111111111111111111111111111111111111111111}

PROCEDURE ScrollDown; {11111111111111111111111111111111111111111111111111111111111111111}

BEGIN
	IF (TheCode = InDownButton) THEN
		BEGIN
		SetCtlValue(MyControlHdl, GetCtlValue(MyControlHdl) + 1);
		ScrollBits(MyControlHdl);
		END;

END; {***** ScrollDown *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE PageScroll; {111111111111111111111111111111111111111111111111111111111111111111}

VAR
	c : point;

BEGIN
	REPEAT
		GetMouse(c);
		IF (TestControl(MyControlHdl, c) = TheCode) THEN
			BEGIN
			SetCtlValue(MyControlHdl, GetCtlValue(MyControlHdl) + combien);
			ScrollBits(MyControlHdl);
			END;
	UNTIL NOT StillDown;
	
END; {***** PageScroll *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE ReSizeWindow; {11111111111111111111111111111111111111111111111111111111111}

VAR
	LongResult : longint;
	height, width : integer;
	tRect : rect;

BEGIN
	LongResult := GrowWindow(WindowPointedTo, MouseLoc, MG_GrowRect);
	IF (LongResult <> 0) THEN
		BEGIN
		height := HiWord(LongResult);
		width := LoWord(LongResult);
		tRect := WindowPointedTo^.portRect;
		tRect.left := tRect.right - 16;
		InvalRect(tRect);			{pour updater la scroll-barre verticale si largissement}
		tRect := WindowPointedTo^.portRect;
		tRect.top := tRect.bottom - 16;
		InvalRect(tRect);			{pour updater la scroll-barre horizontale si largissement}
		SizeWindow(WindowPointedTo, width, height, true);
		tRect := WindowPointedTo^.portRect;
		tRect.left := tRect.right - 16;
		InvalRect(tRect);			{pour updater la scroll-barre verticale si rtrcissement}
		tRect := WindowPointedTo^.portRect;
		tRect.top := tRect.bottom - 16;
		InvalRect(tRect);			{pour updater la scroll-barre horizontale si rtrcissement}
		END;
	
END; {***** ReSizeWindow *****1111111111111111111111111111111111111111111111111111}

END.