PROGRAM MinGraph;

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf, PackIntf, MacPrint, SANE, ObjIntf,
	USLib_U1,
	MG_util, MG_points, MG_fonction, MG_minim, MG_graph;

{$S MG_Main }

CONST
	TCoorMenu = 59;
	AppleMenu = 256;
	FileMenu = 257;
	EditMenu = 258;
	MGMenu = 259;
	
	theData = 1;
	theGenData = 2;
	thePurgeData = 3;
	theFonc = 5;
	theParam = 6;
	thePurgeModel = 7;
	OnEnregistre = 9;
	OnImprime = 10;
	OnFerme = 12;
	OnQuitte = 13;
	
	OnCopie = 4;
	
	theMin = 1;
	theMinParam = 2;
	theLsCreateur = 3;
	theGraph = 5;
	theGraphParam = 6;
	theGraphFormat = 7;
	theTypeCoor = 8;
	theGrCreateur = 9;
	
	theCartesian = 1;
	thePolar = 2;
	
	JML1IconID = 261;
	JML2IconID = 262;
	PhotoSndID = 256;
	JML1SndID = 257;
	JML2SndID = 258;

	AboutMinGraphDlgID = 261;
	MinSansDyStopID = 262;

VAR
	AllDone : boolean;
	
PROCEDURE _DataInit; EXTERNAL;		{utilise par MPW... et  purger aprs initialisation}

PROCEDURE InitThings; {111111111111111111111111111111111111111111111111111111111111}

VAR
	iMM : integer;

BEGIN
	InitGraf(@thePort);

	FOR iMM := 1 to 20 do MoreMasters;		{extra 64 master pointers blocks at the bottom of the heap}

	MG_ClockCursor := GetCursor(watchCursor)^^;
	SetCursor(MG_ClockCursor);

	InitFonts;
	InitWindows;
	InitMenus;
	TEInit;
	InitDialogs(@ReturnToShell);	{startup the dialog manager avec procdure de rcupration d'erreurs}
	InitOper;
	InitAnimatedCursor;

	UnloadSeg(@_DataInit);		{pour mode de chargement spcial  MPW}
	
	new(MG_thePointS);
	MG_thePointS.suivant := NIL;
	
	new(MG_theOperS);
	MG_theOperS.suivant1 := NIL;
	MG_theOperS.suivant2 := NIL;
	MG_theOperS.suivant3 := NIL;

	new(MG_theParamS);
	MG_theParamS.suivant := NIL;

	InitGraphique;
	
	FlushEvents(everyEvent, 0);

END; {***** InitThings *****111111111111111111111111111111111111111111111111111111}

PROCEDURE SetUpMenus; {11111111111111111111111111111111111111111111111111111111111}

VAR
	MenuTopic : MenuHandle;
	
BEGIN
	MenuTopic := GetMenu(AppleMenu);		{get the apple desk accessories menu}
	AddResMenu(MenuTopic, 'DRVR');		{adds all names into item list}
	InsertMenu(MenuTopic, 0);				{put in list held by menu manager}
	MenuTopic := GetMenu(FileMenu);
	InsertMenu(MenuTopic, 0);
	MenuTopic := GetMenu(EditMenu);
	InsertMenu(MenuTopic, 0);
	MenuTopic := GetMenu(MGMenu);
	InsertMenu(MenuTopic, 0);
	MenuTopic := GetMenu(TCoorMenu);
	InsertMenu(MenuTopic, -1);					{sous menu}
	DrawMenuBar;
   
END; {***** SetUpMenus *****11111111111111111111111111111111111111111111111111111}

PROCEDURE AboutMinGraph; {111111111111111111111111111111111111111111111111111111111}

CONST
	MyIconItem = 2;

VAR
	MyOSErr : OSErr;
	TempPort : GrafPtr;
	AboutWPtr : DialogPtr;
	MyZone : THZ;
	MyHeapEnd, HorsZoneFreeMem, FreeMemory : longint;
	m0, m1 : STR255;
	confirmation : integer;
	box : rect;
	TheItem, OptType, MyIcon : integer;
	MyItemHdl, MySndHdl : handle;
	MyCIconHdl : CIconHandle;
	
BEGIN
	GetPort(TempPort);
	AboutWPtr := GetNewDialog(AboutMinGraphDlgID, nil, POINTER(-1));
	SetPort(AboutWPtr);
	
	m0 := StringHandle(GetResource('MG01', 0))^^;
	MyZone := ApplicZone;
	MyHeapEnd := ord(MyZone^.BkLim);
	HorsZoneFreeMem := ord(GetApplLimit) - MyHeapEnd;	{distance entre fin de zone et maximum}
	FreeMemory := FreeMem + HorsZoneFreeMem;
	FreeMemory := (FreeMemory div 1024) - 10;		{10 K de marge : pas trop d'illusions sur la pile...}
	NumToString(FreeMemory, m1);
	ParamText(m0, m1, '', '');									{pour afficher la mmoire disponible}
	MyIcon := JML1IconID;

	REPEAT
		ModalDialog(@FilterForDialog, TheItem);
		CASE TheItem OF
			MyIconItem :	BEGIN
									GetDItem(AboutWPtr, MyIconItem, OptType, MyItemHdl, box);
									IF (MyIcon = JML1IconID) THEN
										BEGIN
										MyCIconHdl := GetCIcon(JML2IconID);
										MyIcon := JML2IconID;
										MySndHdl := GetResource('snd ', JML1SndID);
										END
									ELSE
										BEGIN
										MyCIconHdl := GetCIcon(JML1IconID);
										MyIcon := JML1IconID;
										MySndHdl := GetResource('snd ', JML2SndID);
										END;
									PlotCIcon(box, MyCIconHdl);
									MyOSErr := SndPlay(NIL,			{standard ?}
																MySndHdl,
																FALSE);		{standard ?}
									END;
			END;
	UNTIL (TheItem = OK);
	
	DisposDialog(AboutWPtr);
	SetPort(TempPort);

END; {***** AboutMinGraph *****111111111111111111111111111111111111111111111111111}

FUNCTION fonc (theParamS : TParamS; xx : extended) : extended;{11111111111111111111111111111}

BEGIN
	fonc := MG_theOperS.ExecOper(theParamS, xx);

END; {***** fonc *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE FCN (var f : extended; theParamS : TParamS; print : boolean); {1111111111111111111111}

CONST
	tab1 = 75;

VAR
	NPts, nn : integer;
	aString, bString, cString : STR255;
	fitPointS : TPointS;								{inutile de crer un type spcial : on utilise des points...}
	xx, yy, dddd, x1, x2, dif, tempExt : extended;
	unPoint, tempPoint : TPoint;

BEGIN
	f := 0.00;										{calcul de fit et calcul de f}
	new(fitPointS);
	fitPointS.suivant := NIL;
	NPts := MG_thePointS.compte;
	fitPointS.extension(NPts);
	unPoint := MG_thePointS.suivant;
	tempPoint := fitPointS.suivant;
	WHILE unPoint <> NIL DO
		BEGIN
		xx := unPoint. x;
		tempPoint.y := fonc(theParamS, xx);
		yy := unPoint. y - tempPoint.y;
		dddd := unPoint. dy**2;
		IF (MG_TypeMin = XYchi2) THEN
			BEGIN
			x1 := xx + unPoint. dx;
			x2 := xx - unPoint. dx;
			dif := (fonc(theParamS, x1)-fonc(theParamS, x2))/2;
			dddd := dddd + dif**2;
			END;
		tempPoint.dy := (yy**2)/dddd;
		f := f + tempPoint.dy;
		unPoint := unPoint.suivant;
		tempPoint := tempPoint.suivant;
		END;
	IF print THEN								{impressions finales}
		BEGIN
		GetIndString(aString, MG_ListeFcnStrID, 1);
		aString := TextParam(aString, MG_yN, '', '', '');
		aString := concat(' ', chr(13), ' ', chr(13), aString, MG_theOperS.FormulOper);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		GetIndString(bString, MG_ListeFcnStrID, 2);
		nn := NPts - MG_NPEff;
		NumToString(nn, aString);
		IF (nn > 0) THEN
			BEGIN
			GetIndString(cString, MG_ListeFcnStrID, 3);
			aString := concat(aString, cString, RealToString(Proba(nn, f), 3));
			END;
		bString := TextParam(bString, aString, '', '', '');
		aString := concat(' ', chr(13), ' ', chr(13), bString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		aString := concat('*', MG_xN, '*');
		aString := concat(' ', chr(13), ' ', chr(13), AjusteLongueur(aString, tab1, true));
		IF MG_withDx THEN
			BEGIN
			bString := concat('*', MG_xN, '*');
			aString := concat(aString, AjusteLongueur(bString, tab1, true));
			END;
		bString := concat('*', MG_yN, '*');
		aString := concat(aString, AjusteLongueur(bString, tab1, true));
		bString := concat('*', MG_yN, '*');
		aString := concat(aString, AjusteLongueur(bString, tab1, true));
		GetIndString(bString, MG_ListeFcnStrID, 4);
		aString := concat(aString, AjusteLongueur(bString, tab1, true));
		GetIndString(bString, MG_ListeFcnStrID, 5);
		aString := concat(aString, bString);
		TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
		unPoint := MG_thePointS.suivant;
		tempPoint := fitPointS.suivant;
		WHILE (unPoint <> NIL) DO
			BEGIN
			tempExt := unPoint.x;
			aString := concat(' ', chr(13), AjusteLongueur(RealToString(tempExt, 5), tab1, true));
			tempExt := unPoint.dx;
			IF MG_withDx THEN
				BEGIN
				tempExt := unPoint.dx;
				aString := concat(aString, AjusteLongueur(RealToString(tempExt, 5), tab1, true));
				END;
			tempExt := unPoint.y;
			aString := concat(aString, AjusteLongueur(RealToString(tempExt, 5), tab1, true));
			tempExt := unPoint.dy;
			aString := concat(aString, AjusteLongueur(RealToString(tempExt, 5), tab1, true));
			tempExt := tempPoint.y;
			aString := concat(aString, AjusteLongueur(RealToString(tempExt, 5), tab1, true));
			tempExt := tempPoint.dy;
			aString := concat(aString, RealToString(tempExt, 5));
			TEInsert(POINTER(ord(@aString)+1), length(aString), MG_MinTextHdl);
			unPoint := unPoint.suivant;
			tempPoint := tempPoint.suivant;
			END;
		MG_MyScroll := MG_HautLigne * (NPts + 5) DIV 4;
		SetCtlMax(MG_MinScrollHdl, GetCtlMax(MG_MinScrollHdl) + MG_MyScroll);
		SetCtlValue(MG_MinScrollHdl, GetCtlValue(MG_MinScrollHdl) + MG_MyScroll);
		ScrollBits(MG_MinScrollHdl);	 {ajouter de la place et avancer la scroll barre}
		END;	{IF print}
	fitPointS.free;

END; {***** FCN *****11111111111111111111111111111111111111111111111111111111111}

PROCEDURE ProcessMenuIn(CodeWord : longint); {11111111111111111111111111111111111111111}

VAR
	MenuNo : integer;			{menu number that was selected}
	ItemNo : integer;			{item in menu that was selected}
	NameHolder : Str255;		{name holder for desk accessory or font}
	dummy : integer;			{OpenDA will never return 0, so don't care}
	MenuTopic : MenuHandle;
	TheFrontWindow : WindowPtr;		{pour trier mes actions et celles du systme}
	TheWPeek : WindowPeek;
	TempPort : GrafPtr;

PROCEDURE EnableData; {222222222222222222222222222222222222222222222222222222222222}

BEGIN
	MenuTopic := GetMHandle(MGMenu);
	IF (MG_thePointS.suivant <> NIL) THEN
		BEGIN
		EnableItem(MenuTopic, theGraph);			{accs aux graphiques}
		EnableItem(MenuTopic, theGraphParam);
		IF (MG_theOperS.suivant1 <> NIL) AND (MG_theParamS.suivant <> NIL) THEN
			BEGIN
			EnableItem(MenuTopic, theMin);			{accs aux ajustements}
			EnableItem(MenuTopic, theMinParam);
			END;
		END
	ELSE
		BEGIN
		DisableItem(MenuTopic, theMin);			{pas d'accs aux ajustements}
		DisableItem(MenuTopic, theMinParam);
		IF (MG_theOperS.suivant1 = NIL) THEN
			BEGIN
			DisableItem(MenuTopic, theGraph);			{pas d'accs aux graphiques}
			DisableItem(MenuTopic, theGraphParam);
			END;
		END;
	DrawMenuBar;

END; {***** EnableData *****22222222222222222222222222222222222222222222222222222}

PROCEDURE EnableFonc; {222222222222222222222222222222222222222222222222222222222222}

BEGIN
	MenuTopic := GetMHandle(MGMenu);
	IF (MG_theOperS.suivant1 <> NIL) THEN
		BEGIN
		EnableItem(MenuTopic, theGraph);			{accs aux graphiques}
		EnableItem(MenuTopic, theGraphParam);
		IF (MG_thePointS.suivant <> NIL) AND (MG_theParamS.suivant <> NIL) THEN
			BEGIN
			EnableItem(MenuTopic, theMin);			{accs aux ajustements}
			EnableItem(MenuTopic, theMinParam);
			END;
		END
	ELSE
		BEGIN
		DisableItem(MenuTopic, theMin);			{pas d'accs aux ajustements}
		DisableItem(MenuTopic, theMinParam);
		IF (MG_thePointS.suivant = NIL) THEN
			BEGIN
			DisableItem(MenuTopic, theGraph);		{pas d'accs aux graphiques}
			DisableItem(MenuTopic, theGraphParam);
			END;
		END;
	DrawMenuBar;

END; {***** EnableFonc *****222222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthFile; {22222222222222222222222222222222222222222222222222222222222}

BEGIN
	IF ((TheWPeek^.WindowKind > 0) OR (ItemNo = OnFerme)) THEN			{mes menus ne s'appliquent qu' mes fentres}
			CASE ItemNo OF											{ou pour fermer un desk accessoire}
			theData :	BEGIN	{ouvrir direct}
							SetUpPoints(true, MG_thePointS);		{standard : pas de rglages}
							EnableData;
							END;	{ouvrir direct}
			theGenData : BEGIN	{ouvrir indirect}
								SetUpPoints(false, MG_thePointS);			{rglages demands}
								EnableData;
								END;	{ouvrir indirect}
			thePurgeData :	BEGIN		{purge donnes}
									IF (MG_thePointS.suivant <> NIL) THEN
										BEGIN
										MG_thePointS.suivant.free;
										MG_thePointS.suivant := NIL;
										END;
									EnableData;
									END;		{purge donnes}
			theFonc :	BEGIN
							SetUpFonc(false, MG_xN, MG_yN, MG_theParamS);		{fonction demande}
							EnableFonc;
							END;
			theParam :	BEGIN				{paramtres seulement (s'il y a dja une fonction)}
								SetUpFonc((MG_theOperS.suivant1 <> NIL), MG_xN, MG_yN, MG_theParamS);
								EnableFonc;
								END;
			thePurgeModel :	BEGIN		{purge modle}
										IF (MG_theOperS.suivant1 <> NIL) THEN
											BEGIN
											MG_theOperS.suivant1.free;
											MG_theOperS.suivant1 := NIL;
											END;
										IF (MG_theParamS.suivant <> NIL) THEN
											BEGIN
											MG_theParamS.suivant.free;
											MG_theParamS.suivant := NIL;
											END;
										IF MG_GParam.Polar THEN
											BEGIN
											MG_xN := 'th';
											MG_yN := 'r';
											END
										ELSE
											BEGIN
											MG_xN := 'x';
											MG_yN := 'y';
											END;
										EnableFonc;
										END;		{purge modle}
			OnEnregistre :	BEGIN
									MG_PictSaved := SauvePict(MG_PictureH);
									{MenuTopic := GetMHandle(FileMenu);
									IF MG_PictSaved THEN DisableItem(MenuTopic, OnEnregistre)
									ELSE EnableItem(MenuTopic, OnEnregistre);}			{accs  l'enregistrement des graphiques}	
									END;
			OnImprime :		BEGIN
									PrintPict(MG_PictureH, MG_GraphPictRect);
									END;
			OnFerme :	IF (TheWPeek^.WindowKind < 0) THEN CloseDeskAcc(TheWPeek^.WindowKind)
							ELSE IF (TheFrontWindow = NIL) THEN			{purge des donnes ET du modle}
								BEGIN
								IF (MG_thePointS.suivant <> NIL) THEN
									BEGIN
									MG_thePointS.suivant.free;
									MG_thePointS.suivant := NIL;
									END;
								EnableData;
								IF (MG_theOperS.suivant1 <> NIL) THEN
									BEGIN
									MG_theOperS.suivant1.free;
									MG_theOperS.suivant1 := NIL;
									END;
								IF (MG_theParamS.suivant <> NIL) THEN
									BEGIN
									MG_theParamS.suivant.free;
									MG_theParamS.suivant := NIL;
									END;
								IF MG_GParam.Polar THEN
									BEGIN
									MG_xN := 'th';
									MG_yN := 'r';
									END
								ELSE
									BEGIN
									MG_xN := 'x';
									MG_yN := 'y';
									END;
								EnableFonc;
								END
							ELSE IF (TheFrontWindow = MG_GraphWPtr) THEN {fermeture du graphique}
								BEGIN
								RangerGraphWindow;
								MenuTopic := GetMHandle(FileMenu);
								IF (MG_PictureH <> NIL) THEN
									BEGIN
									EnableItem(MenuTopic, OnImprime);
									EnableItem(MenuTopic, OnEnregistre);
									END
								ELSE
									BEGIN
									DisableItem(MenuTopic, OnImprime);		{accs  l'impression des graphiques}
									DisableItem(MenuTopic, OnEnregistre);	{accs  l'enregistrement des graphiques}
									END;
								END;					{fermer}
			OnQuitte :	IF (TheFrontWindow <> NIL) & (TheFrontWindow = MG_GraphWPtr) THEN
								BEGIN				{fermeture du graphique}
								RangerGraphWindow;
								MenuTopic := GetMHandle(FileMenu);
								IF (MG_PictureH <> NIL) THEN
									BEGIN
									EnableItem(MenuTopic, OnImprime);
									EnableItem(MenuTopic, OnEnregistre);
									END
								ELSE
									BEGIN
									DisableItem(MenuTopic, OnImprime);		{accs  l'impression des graphiques}
									DisableItem(MenuTopic, OnEnregistre);	{accs  l'enregistrement des graphiques}
									AllDone := True;
									END;
								END
							ELSE AllDone := True;          {quit}
			END; {case ItemNo}

END; {***** DealWthFile *****22222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthEdit; {222222222222222222222222222222222222222222222222222222222222}

VAR
	MyErrCode : longint;
	MyOSErr : OSErr;
	MyPictPtr : PicPtr;
	MyLength : integer;
	MySndHdl : Handle;

BEGIN
	IF ((TheWPeek^.WindowKind > 0) OR (ItemNo = OnCopie)) THEN		{mes menus ne s'appliquent qu' mes fentres}
		CASE ItemNo OF																		{ou pour copier dans un desk accessoire ?}
			OnCopie :	IF (TheWPeek^.WindowKind < 0) THEN
				BEGIN
				{CopyDeskAcc(TheWPeek^.WindowKind);  dans la mesure o ceci existe ?}
				END
			ELSE IF (TheFrontWindow = NIL) THEN		{copie des donnes ET du modle ?}
				BEGIN
				END
			ELSE IF (TheFrontWindow = MG_GraphWPtr) THEN		{copie du graphique}
				BEGIN
				IF (MG_PictureH <> NIL) THEN
					BEGIN
					MyErrCode := ZeroScrap;
					HLock(Handle(MG_PictureH));
					MyPictPtr := MG_PictureH^;
					MyLength := MyPictPtr^.picSize;
					MyErrCode := PutScrap(MyLength, 'PICT', Ptr(MyPictPtr));
					HUnLock(Handle(MG_PictureH));
					IF (MyErrCode <> noErr) THEN sysbeep(3)
					ELSE
						BEGIN
						MySndHdl := GetResource('snd ', PhotoSndID);
						MyOSErr := SndPlay(NIL,			{standard ?}
													MySndHdl,
													FALSE);		{standard ?}
						END;
					END;
				END;				{copie}
			END;	{case ItemNo}

END; {***** DealWthEdit *****22222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthMG; {222222222222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthMin (standard : boolean); {33333333333333333333333333333333333333333333}

VAR
	unPoint : TPoint;
	confirmation : integer;

BEGIN
	confirmation := 0;
	unPoint := MG_thePointS.suivant;
	WHILE (unPoint <> NIL) DO
		BEGIN
		IF (unPoint.dy = 0) THEN
			BEGIN
			confirmation := 1;
			LEAVE;
			END;
		unPoint := unPoint.suivant;
		END;
	IF (confirmation > 0) THEN
		BEGIN
		ParamText(MG_yN, '', '', '');
		confirmation := StopAlert(MinSansDyStopID, nil);
		END
	ELSE SetUpMinimi(standard, MG_theParamS, FCN);

END; {***** DealWthMin *****33333333333333333333333333333333333333333333333333333}

BEGIN
	CASE ItemNo of
		theMin :	DealWthMin(true);				{standard : pas de rglages}
		theMinParam :	DealWthMin(false);			{rglages demands}
		theLsCreateur : SetUpCreateur(MG_SetUpLsCrID);
		theGraph :	BEGIN
							RangerGraphWindow;
							IF MG_PictSaved THEN
								BEGIN
								SetUpGraphiques (true,			{standard : pas de rglages}
															MG_thePointS, MG_theParamS, fonc);
								MenuTopic := GetMHandle(FileMenu);
								IF (MG_PictureH <> NIL) THEN
									BEGIN
									EnableItem(MenuTopic, OnImprime);
									EnableItem(MenuTopic, OnEnregistre);
									END
								ELSE
									BEGIN
									DisableItem(MenuTopic, OnImprime);			{accs  l'impression des graphiques}
									DisableItem(MenuTopic, OnEnregistre);		{accs  l'enregistrement des graphiques}
									END;
								END;
							END;
		theGraphParam :	BEGIN
									RangerGraphWindow;
									IF MG_PictSaved THEN
										BEGIN
										SetUpGraphiques (false,				{rglages demands}
																	MG_thePointS, MG_theParamS, fonc);
										MenuTopic := GetMHandle(FileMenu);
										IF (MG_PictureH <> NIL) THEN
											BEGIN
											EnableItem(MenuTopic, OnImprime);
											EnableItem(MenuTopic, OnEnregistre);
											END
										ELSE
											BEGIN
											DisableItem(MenuTopic, OnImprime);			{accs  l'impression des graphiques}
											DisableItem(MenuTopic, OnEnregistre);		{accs  l'enregistrement des graphiques}
											END;
										END;
									END;
		theGraphFormat : SetUpGraphFormat;
		theTypeCoor : ;						{jamais appel car gestion par sous menu}
		theGrCreateur : SetUpCreateur(MG_SetUpGrCrID);
		END; {case ItemNo}

END; {***** DealWthMG *****222222222222222222222222222222222222222222222222222222}

PROCEDURE DealWthTCoor; {2222222222222222222222222222222222222222222222222222222222}

BEGIN
	CASE ItemNo OF
		theCartesian :	BEGIN
								MG_GParam.Polar := FALSE;
								MenuTopic := GetMHandle(TCoorMenu);
								CheckItem(MenuTopic, thePolar, FALSE);
								CheckItem(MenuTopic, theCartesian, TRUE);
								IF (MG_theOperS.suivant1 = NIL)&(MG_xN = 'th')&(MG_yN = 'r') THEN
									BEGIN		{s'il y a un modle, ou des noms spciaux, on suppose qu'il faut laisser ainsi}
									MG_xN := 'x';
									MG_yN := 'y';
									END;
								END;
		thePolar :	BEGIN
						MG_GParam.Polar := TRUE;
						MenuTopic := GetMHandle(TCoorMenu);
						CheckItem(MenuTopic, theCartesian, FALSE);
						CheckItem(MenuTopic, thePolar, TRUE);
						IF (MG_theOperS.suivant1 = NIL)&(MG_xN = 'x')&(MG_yN = 'y') THEN
							BEGIN		{s'il y a un modle, ou des noms spciaux, on suppose qu'il faut laisser ainsi}
							MG_xN := 'th';
							MG_yN := 'r';
							END;
						sysbeep(3);
						END;
		END; {case ItemNo}

END; {***** DealWthTCoor *****222222222222222222222222222222222222222222222222222}

BEGIN
	IF (CodeWord <> 0) then
		BEGIN {go ahead and process the command}
		MenuNo := HiWord(CodeWord);
		ItemNo := LoWord(CodeWord);
		TheFrontWindow := FrontWindow;
		TheWPeek := pointer(TheFrontWindow);
		CASE MenuNo of
			AppleMenu :
				BEGIN
				IF (ItemNo = 1) THEN AboutMinGraph
				ELSE IF (ItemNo > 2) THEN
					BEGIN
					GetPort(TempPort);		{conseill par InsideMac pour se protger des DAs...}
					GetItem(GetMHandle(AppleMenu), ItemNo, NameHolder);
					dummy := OpenDeskAcc(NameHolder);
					SetPort(TempPort);
					END;
				END;
			FileMenu : DealWthFile;
			EditMenu : DealWthEdit;
			MGMenu : DealWthMG;
			TCoorMenu : DealWthTCoor;		{sous menu}
		END;{case of MenuNo}
	HiliteMenu(0);               {unhilite after processing menu}
     END; {IF}
	
END; {***** ProcessMenuIn *****111111111111111111111111111111111111111111111111111}

PROCEDURE DealWthMouseDowns(Event : EventRecord); {111111111111111111111111111111111111}

VAR
	WindowPointedTo : WindowPtr;
	MouseLoc : Point;
	WindoLoc : integer;
	TheFrontWindow : WindowPtr;		{pour trier mes actions et celles du systme}
	TheWPeek : WindowPeek;
	MyControl, PartCode : integer;
	MyControlHdl : controlHandle;
	MenuTopic : MenuHandle;

BEGIN
	MouseLoc := Event.Where;
	WindoLoc := FindWindow(MouseLoc, WindowPointedTo);
	TheFrontWindow := FrontWindow;
	TheWPeek := pointer(TheFrontWindow);
	CASE WindoLoc OF
		InMenuBar :	ProcessMenuIn(MenuSelect(MouseLoc));
		InSysWindow :	SystemClick(Event, WindowPointedTo);
		InContent :	IF (WindowPointedTo <> TheFrontWindow) THEN SelectWindow(WindowPointedTo)
							ELSE 
								BEGIN  {front window}
								IF (TheWPeek^.WindowKind > 0) then	{mes cases ne s'appliquent qu' mes fentres}
									BEGIN
									SetPort(WindowPointedTo);
									GlobalToLocal(MouseLoc);
									MyControl := FindControl(MouseLoc, WindowPointedTo, MyControlHdl);
									CASE MyControl OF
										InUpButton :	PartCode := trackControl(MyControlHdl, MouseLoc, @ScrollUp);
										InDownButton :	PartCode := trackControl(MyControlHdl, MouseLoc, @ScrollDown);
										InPageUp :	PageScroll(MyControlHdl, MyControl, -30);
										InPageDown :	PageScroll(MyControlHdl, MyControl, 30);
										InThumb :	BEGIN
														PartCode := trackControl(MyControlHdl, MouseLoc, NIL);
														ScrollBits(MyControlHdl);
														END;
										END; {case control}
									END; {IF thewpick}
								END; {front window et InContent}
		InGrow :	IF (WindowPointedTo <> FrontWindow) THEN SelectWindow(WindowPointedTo)
						ELSE ReSizeWindow(WindowPointedTo, MouseLoc);
		InZoomIn, InZoomOut :	IF (WindowPointedTo <> FrontWindow) THEN SelectWindow(WindowPointedTo)
											ELSE IF TrackBox(WindowPointedTo, MouseLoc, WindoLoc) THEN
												BEGIN
												SetPort(WindowPointedTo);
												ZoomWindow(WindowPointedTo, WindoLoc,
																false);		{dja slecte donc dja FrontWindow}
												END;
		InDrag :	DragWindow(WindowPointedTo, MouseLoc, MG_DragArea);
		InGoAway :	IF TrackGoAway(WindowPointedTo, MouseLoc) THEN
								BEGIN
								RangerGraphWindow;
								MenuTopic := GetMHandle(FileMenu);
								IF (MG_PictureH <> NIL) THEN
									BEGIN
									EnableItem(MenuTopic, OnImprime);
									EnableItem(MenuTopic, OnEnregistre);
									END
								ELSE
									BEGIN
									DisableItem(MenuTopic, OnImprime);			{accs  l'impression des graphiques}
									DisableItem(MenuTopic, OnEnregistre);		{accs  l'enregistrement des graphiques}
									END;
								END;
		END; {case}
	
END; {***** DealWthMouseDowns *****1111111111111111111111111111111111111111111111}

PROCEDURE DealWthKeyDowns(Event : EventRecord); {11111111111111111111111111111111111111}

VAR
	CharCode : char;
	TheFrontWindow : WindowPtr;		{pour trier mes actions et celles du systme}
	TheWPeek : WindowPeek;
	
BEGIN
	CharCode := chr(BitAnd(Event.message, charCodeMask));
	TheFrontWindow := FrontWindow;
	TheWPeek := pointer(TheFrontWindow);
	IF (BitAnd(Event.modifiers, CmdKey) = CmdKey) THEN	ProcessMenuIn(MenuKey(CharCode));
	
END; {***** DealWthKeyDowns *****111111111111111111111111111111111111111111111111}

PROCEDURE DealWthActivates(Event : EventRecord); {11111111111111111111111111111111111111}

VAR
	TargetWindow : WindowPtr;
	
BEGIN
	TargetWindow := WindowPtr(Event.message);
	DrawGrowIcon(TargetWindow);
	IF Odd(Event.modifiers) then
		BEGIN {then the window is becoming active}
		SetPort(TargetWindow);
		IF (TargetWindow = MG_GraphWPtr) THEN
			BEGIN
			HiliteControl(MG_GraphVScrollHdl, CntlEnable);
			HiliteControl(MG_GraphHScrollHdl, CntlEnable);
			END;
		{and activate whatever else you need}
		END
	ELSE
		BEGIN
		IF (TargetWindow = MG_GraphWPtr) THEN
			BEGIN
			HiliteControl(MG_GraphVScrollHdl, CntlDisable);
			HiliteControl(MG_GraphHScrollHdl, CntlDisable);
			END;
		{deactivate whatever you need}
		END;
		
END; {***** DealWthActivates *****111111111111111111111111111111111111111111111111}

PROCEDURE DealWthUpdates(Event : EventRecord); {111111111111111111111111111111111111111}

VAR
	UpDateWindow, TempPort : WindowPtr;
	
BEGIN
	UpDateWindow := WindowPtr(Event.message);
	GetPort(TempPort);				{Save the current port}
	SetPort(UpDateWindow);			{set the port to one in Evt.msg}
	BeginUpDate(UpDateWindow);
	EraseRect(UpDateWindow^.VisRgn^^.rgnBBox);	{on efface... il faut redessiner le contenu !}
	DrawGrowIcon(UpDateWindow);
	UpdateMyWindows(UpDateWindow);
	EndUpDate  (UpDateWindow);
	SetPort    (TempPort);			{restore to the previous port}
	
END; {***** DealWthUpdates *****1111111111111111111111111111111111111111111111111}

PROCEDURE BouclePrincipale; {1111111111111111111111111111111111111111111111111111111}

VAR
	Event : EventRecord;
	ProcessIt : Boolean;
	tempRect : rect;
	tempRgn : RgnHandle;
	WaitTime : longint;
	
BEGIN
	REPEAT
		IF MG_SousMultiF THEN
			BEGIN
			WaitTime := GetCaretTime div 5;		{raction un peu plus rapide que le clignotement}
			ProcessIt := WaitNextEvent(EveryEvent, Event, WaitTime, nil);
			END
		ELSE
			BEGIN
			SystemTask;		{pour les accessoires de bureau (automatique si WaitNextEvent)}
			ProcessIt := GetNextEvent(EveryEvent, Event);
			END;
		IF ProcessIt THEN  CASE Event.what of
				MouseDown : DealWthMouseDowns(Event);
				KeyDown, AutoKey  : DealWthKeyDowns(Event);
				ActivateEvt : DealWthActivates(Event);
				UpDateEvt : DealWthUpdates(Event);
				END; {Case}
	UNTIL AllDone;			{la promenade est termine, on agite le mouchoir...}
	
END; {***** BouclePrincipale *****1111111111111111111111111111111111111111111111111}

BEGIN {***** Main Program *****00000000000000000000000000000000000000000000000000}
	InitThings;
	MG_SousMultiF := (NGetTrapAddress($60, ToolTrap) <> NGetTrapAddress($9F, ToolTrap));
	AllDone := false;
	MG_PbFic := 'inconnu';					{nom du problme en cours}
	MG_DoneModif := false;		{indicateur de sauvegarde}
	MG_withDx := true;
	MG_withDy := true;
	MG_GParam.FirstUse := true;
	
	SetUpMenus;
	SetUpFonts(systemFont, 12);			{c'est simplement Chicago, mais on repre le calibre}
	InitCursor;

	BouclePrincipale;
	
END. {***** Main Program *****0000000000000000000000000000000000000000000000000000}