UNIT USLib_U1;

INTERFACE

USES
	MemTypes, QuickDraw, OSIntf, ToolIntf;

CONST
	CntlDisable = 255;			{codes de gestion des contrles}
	CntlEnable = 0;
	USLib_maxCursors = 32;

TYPE
	acur = RECORD
		numCursors : integer;
		cursors : array[1..USLib_maxCursors] OF cursHandle;
		END;
	acurPtr = ^acur;
	acurHandle = ^acurPtr;

PROCEDURE ReturnToShell;
FUNCTION NewLock (theHandle : Handle) : boolean;
FUNCTION GetPathName (MyFileName : STR255; MyVRefNum : integer) : STR255;
PROCEDURE FramePopUp (r : rect);
PROCEDURE DoTheOK(theWindow : WindowPtr; TheItem : Integer);
PROCEDURE SetCreaType(FName : STR63; VRefNum : Integer; theType, theCreator : OSType);
FUNCTION TextParam (MyText, pm0, pm1, pm2, pm3 : STR255) : STR255;
PROCEDURE InitAnimatedCursor;
PROCEDURE AnimateCursor;
PROCEDURE StartAnimatedCursor;
PROCEDURE StopAnimatedCursor;

VAR
	USLib_theCursor: integer;
	USLib_nbCursors : integer;
	USLib_acurList : acurHandle;
	USLib_cursVBL : VBLTask;

IMPLEMENTATION

{$S USL1 }

PROCEDURE ReturnToShell; {11111111111111111111111111111111111111111111111111111111}

BEGIN
	ExitToShell;

END; {***** ReturnToShell *****1111111111111111111111111111111111111111111111111}

FUNCTION NewLock (theHandle : Handle) : boolean; {11111111111111111111111111111111111111}

VAR
	theByte : SignedByte;

BEGIN
	theByte := HGetState(theHandle);
	IF (theByte < 0) THEN NewLock := false
	ELSE
		BEGIN
		HLock(theHandle);
		NewLock := true;
		END;

END; {***** NewLock ***** 111111111111111111111111111111111111111111111111111111}

FUNCTION GetPathName (MyFileName : STR255; MyVRefNum : integer) : STR255; {1111111111111111}

CONST
	FSFCBLen = $3F6;			{adresse de variable globale indiquant si HFS}

VAR
	MyVolName, MyDirName : STR255;
	MyOSErr : OSErr;			{code d'erreur des entres/sorties}
	HFSTest : ^integer;
	MyDirBlock : CInfoPBRec;
	DonePath : boolean;
	
BEGIN
	HFSTest := POINTER(FSFCBLen);
	IF (HFSTest^ > 0) THEN
		BEGIN									{format HFS}
		MyVolName := '';
		MyDirBlock.ioVRefNum := MyVRefNum;
		MyDirBlock.ioDrDirID := 0;
		DonePath := false;
		REPEAT
			MyDirName := ' ';
			MyDirBlock.ioNamePtr := @MyDirName;
			MyDirBlock.ioFDirIndex := -1;								{pour obtenir les informations du directory}
			MyOSErr := PBGetCatInfo(@MyDirBlock, false);
			MyDirName := MyDirBlock.ioNamePtr^;
			MyVolName := concat(MyDirName, ':', MyVolName);
			IF (MyDirBlock.ioDrDirID = 2) THEN DonePath := true			{root directory toujours 2}
			ELSE MyDirBlock.ioDrDirID := MyDirBlock.ioDrParID;
		UNTIL DonePath;
		GetPathName := concat(MyVolName, MyFileName);
		END
	ELSE
		BEGIN									{format MFS}
		MyOSErr := SetVol(nil, MyVRefNum);						{on impose ce volume par dfaut}
		MyVolName := ' ';
		MyOSErr := GetVol(@MyVolName, MyVRefNum);				{on rcupre le nom du volume}
		GetPathName := concat(MyVolName, ':', MyFileName);		{on reconstruit le "pathname" (MFS)}
		END;
	
END; {***** GetPathName *****111111111111111111111111111111111111111111111111111}

PROCEDURE FramePopUp (r : rect); {1111111111111111111111111111111111111111111111111}

VAR
	rr : rect;

BEGIN
	rr := r;
	InsetRect(rr, -1, -1);
	FrameRect(rr);
	MoveTo(rr.right, rr.top + 1);
	LineTo(rr.right, rr.bottom);
	LineTo(rr.left + 1, rr.bottom);

END; {***** FramePopUp *****11111111111111111111111111111111111111111111111111111}

PROCEDURE DoTheOK(theWindow : WindowPtr; TheItem : Integer);	{1111111111111111111111111111}

VAR
	theType : Integer;
	theHandle : Handle;
	TheBox : Rect;
	theCtrlHdl : ControlHandle;
	thePenState : PenState;

BEGIN
	GetDItem(theWindow, TheItem, theType, theHandle, TheBox);
	theCtrlHdl := ControlHandle(theHandle);
	GetPenState(thePenState);
	PenSize(3, 3);
	IF (theCtrlHdl^^.contrlHilite = CntlDisable) THEN PenPat(ltGray);
	InsetRect(TheBox, - 4, - 4);
	FrameRoundRect(TheBox, 16, 16);
	SetPenState(thePenState);

END; {***** DoTheOK *****1111111111111111111111111111111111111111111111111111111}

PROCEDURE SetCreaType(FName : STR63; VRefNum : Integer; theType, theCreator : OSType);	{111111}

VAR
	MyOSErr : OSErr;
	MyFndrInfo : FInfo;

BEGIN
		MyOSErr := GetFInfo(FName, VRefNum, MyFndrInfo);
		MyFndrInfo.FdType := theType;
		MyFndrInfo.FdCreator := theCreator;
		MyOSErr := SetFInfo(FName, VRefNum, MyFndrInfo);

END; {***** SetCreaType *****1111111111111111111111111111111111111111111111111111}

FUNCTION TextParam (MyText, pm0, pm1, pm2, pm3 : STR255) : STR255;	{11111111111111111111}

VAR
	p0, p1, p2, p3 : integer;
	m : STR255;

BEGIN
	m := MyText;
	p0 := pos('^0', m);
	IF (p0 <> 0) THEN	BEGIN
								delete(m, p0, 2);
								insert(pm0, m, p0);
								END;
	p1 := pos('^1', m);
	IF (p1 <> 0) THEN	BEGIN
								delete(m, p1, 2);
								insert(pm1, m, p1);
								END;
	p2 := pos('^2', m);
	IF (p2 <> 0) THEN	BEGIN
								delete(m, p2, 2);
								insert(pm2, m, p2);
								END;
	p3 := pos('^3', m);
	IF (p3 <> 0) THEN	BEGIN
								delete(m, p3, 2);
								insert(pm3, m, p3);
								END;
	TextParam := m;

END; {***** TextParam *****11111111111111111111111111111111111111111111111111111}

PROCEDURE InitAnimatedCursor; {11111111111111111111111111111111111111111111111111111}

{ Load 'acur' and 'CURS' resources. The resources in AnimateCursor.r are "Locked" because during the
execution of a VBL task, we cannot rely upon dereferencing unlocked handles.}

VAR
	cursorCt: Integer;

BEGIN
	USLib_acurList:= acurHandle(GetResource('acur', 128));
	WITH USLib_acurList^^ DO
		BEGIN
		USLib_theCursor := 1;
		USLib_nbCursors := numCursors;
		IF (numCursors > USLib_maxCursors) THEN USLib_nbCursors := USLib_maxCursors
		ELSE USLib_nbCursors := numCursors;
		FOR cursorCt := 1 TO USLib_nbCursors DO
			cursors[cursorCt] := GetCursor(LongInt(cursors[cursorCt]));
		END;

END; {***** InitAnimatedCursor *****11111111111111111111111111111111111111111111111}

PROCEDURE AnimateCursor; {111111111111111111111111111111111111111111111111111111111}

{ Change the cursor shape to the cursor specified in the next element of the 'acur' resource.
We are referencing variables which are global to the application ; therefore, we call SetUpA5.
The procedure does not have any paramters ; this is the required calling convention for VBL tasks.}

VAR
	myA5, oldA5 : longint;
  
BEGIN
	myA5 := SetCurrentA5;	{SetUpA5 est prim}
	
	USLib_theCursor:= USLib_theCursor + 1;
	IF (USLib_theCursor > USLib_nbCursors) THEN USLib_theCursor := 1;
	WITH USLib_acurList^^ DO
		SetCursor(cursors[USLib_theCursor]^^);
	USLib_cursVBL.vblCount:= 30;					{ re-execute the task in 30 60ths of a second }
	
	oldA5 := SetA5(myA5);	{RestoreA5 est prim}
	
END; {***** AnimateCursor *****11111111111111111111111111111111111111111111111111}

PROCEDURE StartAnimatedCursor; {1111111111111111111111111111111111111111111111111111}

{ Install AnimateCursor procedure by initializing VBL task and installing it into the vertical retrace queue.}

VAR
	err: OSErr;

BEGIN
	WITH USLib_cursVBL DO
		BEGIN
		qType := Integer(vType);
		vblAddr := @AnimateCursor;
		vblCount := 30;					{ execute the task in 30 60ths of a second }
		vblPhase	:= 0;
		END;
	err:= VInstall(@USLib_cursVBL);

END; {***** StartAnimatedCursor *****111111111111111111111111111111111111111111111}

PROCEDURE StopAnimatedCursor; {1111111111111111111111111111111111111111111111111111}

{ Remove our VBL task from the vetical retrace queue.}

VAR
	err: OSErr;
	
BEGIN
	err:= VRemove(@USLib_cursVBL);
	InitCursor;
	
END; {***** StopAnimatedCursor *****1111111111111111111111111111111111111111111111}

END.